/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.util;

import cn.handyplus.warp.constants.WarpConstants;
import cn.handyplus.warp.constants.WarpTypeEnum;
import cn.handyplus.warp.enter.WarpChannel;
import cn.handyplus.warp.enter.WarpPlayer;
import cn.handyplus.warp.event.WarpCreateSuccessEvent;
import cn.handyplus.warp.event.WarpTpEvent;
import cn.handyplus.warp.hook.MultiverseCoreUtil;
import cn.handyplus.warp.hook.PlaceholderApiUtil;
import cn.handyplus.warp.lib.BaseConstants;
import cn.handyplus.warp.lib.BaseUtil;
import cn.handyplus.warp.lib.BcUtil;
import cn.handyplus.warp.lib.CollUtil;
import cn.handyplus.warp.lib.DateUtil;
import cn.handyplus.warp.lib.ItemStackUtil;
import cn.handyplus.warp.lib.JsonUtil;
import cn.handyplus.warp.lib.MapUtil;
import cn.handyplus.warp.lib.MessageUtil;
import cn.handyplus.warp.lib.NumberUtil;
import cn.handyplus.warp.lib.RgbTextUtil;
import cn.handyplus.warp.lib.StrUtil;
import cn.handyplus.warp.lib.expand.adapter.HandyRunnable;
import cn.handyplus.warp.lib.expand.adapter.HandySchedulerUtil;
import cn.handyplus.warp.lib.expand.adapter.PlayerSchedulerUtil;
import cn.handyplus.warp.param.CreateFlagParam;
import cn.handyplus.warp.param.WarpLocationSpawn;
import cn.handyplus.warp.runnable.WarpTaskRunnable;
import cn.handyplus.warp.service.WarpChannelService;
import cn.handyplus.warp.service.WarpCollectionService;
import cn.handyplus.warp.service.WarpPlayerService;
import cn.handyplus.warp.service.WarpWhiteListService;
import cn.handyplus.warp.util.ConfigUtil;
import cn.handyplus.warp.util.WarpPermissionUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class WarpUtil {
    public static String getLocationDesc(String a) {
        WarpLocationSpawn warpLocationSpawn = JsonUtil.toBean(a, WarpLocationSpawn.class);
        return new StringBuilder().insert(0, MultiverseCoreUtil.getAlias(warpLocationSpawn.getWorld())).append(WarpCollectionService.yvIhFi("E")).append((int)warpLocationSpawn.getX()).append(RgbTextUtil.yvIhFi("n")).append((int)warpLocationSpawn.getY()).append(WarpCollectionService.yvIhFi("E")).append((int)warpLocationSpawn.getZ()).toString();
    }

    public static List<String> getDescription(String a) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (StrUtil.isEmpty(a)) {
            ArrayList<String> arrayList2 = arrayList;
            arrayList2.add(BaseUtil.getLangMsg(WarpCollectionService.yvIhFi("\u0007I\u001d")));
            return arrayList2;
        }
        ArrayList<String> arrayList3 = arrayList;
        arrayList3.addAll(StrUtil.strToStrList(a));
        return arrayList3;
    }

    public static void runTaskTp(Player a, WarpPlayer a2) {
        HandySchedulerUtil.runTask(() -> WarpUtil.b(a, a2));
    }

    public static String getWarpLocationSpawn(Player a) {
        WarpLocationSpawn warpLocationSpawn;
        Location location = a.getLocation();
        WarpLocationSpawn warpLocationSpawn2 = warpLocationSpawn = new WarpLocationSpawn();
        Location location2 = location;
        WarpLocationSpawn warpLocationSpawn3 = warpLocationSpawn;
        Location location3 = location;
        warpLocationSpawn.setX(location3.getX());
        warpLocationSpawn3.setY(location3.getY());
        warpLocationSpawn3.setZ(location.getZ());
        warpLocationSpawn.setYaw(location2.getYaw());
        warpLocationSpawn2.setPitch(location2.getPitch());
        warpLocationSpawn2.setWorld(Objects.requireNonNull(location.getWorld()).getName());
        return JsonUtil.toJson(warpLocationSpawn);
    }

    public static Map<String, List<String>> getDescriptionMap(String a) {
        return MapUtil.of(RgbTextUtil.yvIhFi("&@1F0L2Q+J,"), WarpUtil.getDescription(a));
    }

    public static boolean editPrice(Player a, String a2) {
        Optional<WarpPlayer> optional = WarpConstants.CHAT_CACHE_ID_MAP.get(a.getUniqueId());
        if (optional == null) {
            return true;
        }
        optional = WarpPlayerService.getInstance().findById((Integer)((Object)optional));
        if (!optional.isPresent()) {
            return true;
        }
        optional = (WarpPlayer)optional.get();
        if ((a2 = NumberUtil.isNumericToInt((String)a2)) == null || (Integer)a2 < 0) {
            MessageUtil.sendMessage(a, BaseUtil.getLangMsg(WarpCollectionService.yvIhFi("G\u0004I\u001cH\u001d`\bO\u0005S\u001bC$U\u000e")));
            return false;
        }
        int n = BaseConstants.CONFIG.getInt(RgbTextUtil.yvIhFi("H#]\u0012W+F'"), 0);
        if (n > 0 && (Integer)a2 > n) {
            MessageUtil.sendMessage(a, ConfigUtil.ADMIN_CONFIG.getString(WarpCollectionService.yvIhFi("K\b^9T\u0000E\f`\bO\u0005S\u001bC$U\u000e"), "").replace(RgbTextUtil.yvIhFi("\u00019U0L!@?"), n + ""));
            return false;
        }
        ((WarpPlayer)((Object)optional)).setPrice((Integer)a2);
        WarpPlayerService.getInstance().update((WarpPlayer)((Object)optional));
        MessageUtil.sendMessage(a, ConfigUtil.ADMIN_CONFIG.getString(WarpCollectionService.yvIhFi("\u0006M9T\u0000E\fd\u001cR\u001dI\u0007"), "").replace(RgbTextUtil.yvIhFi("\u00019U0L!@?"), ((Integer)a2).toString()));
        return true;
    }

    public static void runTaskTpWarpLocation(Player a, WarpPlayer a2) {
        HandySchedulerUtil.runTask(() -> WarpUtil.tpWarpLocation(a, a2));
    }

    private static /* synthetic */ void b(Player a, WarpPlayer a2) {
        Object object;
        Player player = a;
        WarpUtil.executionCommand(player, WarpCollectionService.yvIhFi("\nI\u0004K\bH\r"), a2.getName());
        long l = WarpPermissionUtil.getDelayTime(player);
        if (l > 0L) {
            object = BaseUtil.getLangMsg(RgbTextUtil.yvIhFi("&@.D;q+H'")).replace(WarpCollectionService.yvIhFi("\u0002\u0012B\fJ\b_=O\u0004C\u0014"), String.valueOf(l));
            MessageUtil.sendMessage(a, (String)object);
        }
        WarpConstants.DELAY_TIME.put(a.getUniqueId(), false);
        object = new WarpTaskRunnable(a, a2);
        HandySchedulerUtil.runTaskLater((HandyRunnable)object, l * 20L);
    }

    public static boolean check(Player a, String a2) {
        List<WarpPlayer> list;
        int n = ConfigUtil.CREATE_CONFIG.getInt(WarpCollectionService.yvIhFi("H\bK\fj\fH\u000eR\u0001"));
        if (ChatColor.stripColor((String)a2).length() > n) {
            String string = ConfigUtil.CREATE_CONFIG.getString(RgbTextUtil.yvIhFi("I'K%Q*c#L.P0@\u000fV%"), "").replace(WarpCollectionService.yvIhFi("M]\u0005C\u0007A\u001dN\u0014"), n + "");
            MessageUtil.sendMessage(a, string);
            return false;
        }
        if ((a2.contains(RgbTextUtil.yvIhFi("d")) || a2.contains(WarpCollectionService.yvIhFi("\u00ce"))) && !a.hasPermission(RgbTextUtil.yvIhFi("2I#\\'W\u0015D0UlF0@#Q'\u000b!J.J0"))) {
            String string = ConfigUtil.CREATE_CONFIG.getString(WarpCollectionService.yvIhFi("\nI\u0005I\u001b`\bO\u0005S\u001bC$U\u000e"), RgbTextUtil.yvIhFi("d\u0011\u4f22\u6c84\u674b\u0005dDbU.D;@0r#W2\u000b!W'D6@lF-I-Wb\u0003v\u6766\u9612\u6740\u5259\u5edf\u5f2b\u8257\u544f\u79d5\u76c6\u5715\u6845"));
            MessageUtil.sendMessage(a, string);
            return false;
        }
        Object object = ConfigUtil.CREATE_CONFIG.getStringList(WarpCollectionService.yvIhFi("\u0007G\u0004C+J\bE\u0002j\u0000U\u001d"));
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            if (!a2.contains((CharSequence)object)) continue;
            String string = ConfigUtil.CREATE_CONFIG.getString(RgbTextUtil.yvIhFi(",D/@\u0000I#F)i+V6c#L.P0@\u000fV%"), "").replace(WarpCollectionService.yvIhFi("M]\u0007G\u0004C\u0014"), (CharSequence)object);
            MessageUtil.sendMessage(a, string);
            return false;
        }
        object2 = BaseConstants.CONFIG.getStringList(RgbTextUtil.yvIhFi("K-Q\u0015J0I&"));
        if (CollUtil.isNotEmpty(object2) && CollUtil.contains((List<String>)object2, a.getWorld().getName())) {
            MessageUtil.sendMessage(a, ConfigUtil.CREATE_CONFIG.getString(WarpCollectionService.yvIhFi("\u0007I>I\u001bJ\rd\u001cR\u001dI\u0007")));
            return false;
        }
        boolean bl = BaseConstants.CONFIG.getBoolean(RgbTextUtil.yvIhFi("K#H'j,I;"), true);
        if (bl && CollUtil.isNotEmpty(list = WarpPlayerService.getInstance().findByName(a2))) {
            a2 = ConfigUtil.CREATE_CONFIG.getString(WarpCollectionService.yvIhFi("H\bK\fi\u0007J\u0010`\bO\u0005S\u001bC$U\u000e"), "").replace(RgbTextUtil.yvIhFi("f^,D/@?"), a2);
            MessageUtil.sendMessage(a, a2);
            return false;
        }
        return true;
    }

    public static boolean checkDescription(Player a, String a2) {
        int n = ConfigUtil.ADMIN_CONFIG.getInt(WarpCollectionService.yvIhFi("\rC\u001aE\u001bO\u0019R\u0000I\u0007j\fH\u000eR\u0001"), 16);
        if (ChatColor.stripColor((String)a2).length() > n) {
            String string = ConfigUtil.ADMIN_CONFIG.getString(RgbTextUtil.yvIhFi("&@1F0L2Q+J,i'K%Q*c#L.P0@\u000fV%"), "").replace(WarpCollectionService.yvIhFi("M]\u0005C\u0007A\u001dN\u0014"), n + "");
            MessageUtil.sendMessage(a, string);
            return false;
        }
        Object object = ConfigUtil.CREATE_CONFIG.getStringList(RgbTextUtil.yvIhFi(",D/@\u0000I#F)i+V6"));
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            if (!a2.contains((CharSequence)object)) continue;
            object = ConfigUtil.ADMIN_CONFIG.getString(WarpCollectionService.yvIhFi("\rC\u001aE\u001bO\u0019R\u0000I\u0007`\bO\u0005S\u001bC$U\u000e"), "").replace(RgbTextUtil.yvIhFi("f^,D/@?"), (CharSequence)object);
            MessageUtil.sendMessage(a, (String)object);
            return false;
        }
        return true;
    }

    public static boolean editDescription(Player a, String a2) {
        if (!WarpUtil.checkDescription(a, a2)) {
            return false;
        }
        Optional<WarpPlayer> optional = WarpConstants.CHAT_CACHE_ID_MAP.get(a.getUniqueId());
        if (optional == null) {
            return true;
        }
        optional = WarpPlayerService.getInstance().findById((Integer)((Object)optional));
        if (!optional.isPresent()) {
            return true;
        }
        optional = (WarpPlayer)optional.get();
        ((WarpPlayer)((Object)optional)).setDescription(a2);
        WarpPlayerService.getInstance().update((WarpPlayer)((Object)optional));
        MessageUtil.sendMessage(a, ConfigUtil.ADMIN_CONFIG.getString(RgbTextUtil.yvIhFi("-N\u0006@1F0L2Q+J,g7Q6J,"), ""));
        return true;
    }

    public static boolean editName(Player a, String a2) {
        if (!WarpUtil.check(a, a2)) {
            return false;
        }
        Optional<WarpPlayer> optional = WarpConstants.CHAT_CACHE_ID_MAP.get(a.getUniqueId());
        if (optional == null) {
            return true;
        }
        optional = WarpPlayerService.getInstance().findById((Integer)((Object)optional));
        if (!optional.isPresent()) {
            return true;
        }
        optional = (WarpPlayer)optional.get();
        ((WarpPlayer)((Object)optional)).setName(a2);
        WarpPlayerService.getInstance().update((WarpPlayer)((Object)optional));
        MessageUtil.sendMessage(a, ConfigUtil.ADMIN_CONFIG.getString(RgbTextUtil.yvIhFi("J)k#H'g7Q6J,"), "").replace(WarpCollectionService.yvIhFi("M]\u0007G\u0004C\u0014"), a2));
        return true;
    }

    private static /* synthetic */ Location iiiiii(Location a, String a22) {
        Material material;
        Material material2;
        Material material3;
        int n;
        if (StrUtil.isEmpty((CharSequence)a22)) {
            return a;
        }
        if ((a22 = a22.split(RgbTextUtil.yvIhFi("n"))).length != 2) {
            return a;
        }
        int a22 = Integer.parseInt(a22[0]);
        int n2 = Integer.parseInt(a22[1]);
        Random random = new Random();
        a22 = random.nextInt(a22 * 2 + 1) - a22;
        n2 = random.nextInt(n2 * 2 + 1) - n2;
        Location location = a;
        World world = location.getWorld();
        a22 = location.getBlockX() + a22;
        n2 = location.getBlockZ() + n2;
        int n3 = n = location.getBlockY();
        while (n3 < Objects.requireNonNull(world).getMaxHeight() - 1) {
            World world2 = world;
            material3 = world2.getBlockAt(a22, n, n2).getType();
            material2 = world2.getBlockAt(a22, n + 1, n2).getType();
            material = world2.getBlockAt(a22, n - 1, n2).getType();
            if (material3 == Material.AIR && material2 == Material.AIR && material != Material.AIR) {
                return new Location(world, (double)a22 + 0.5, (double)n, (double)n2 + 0.5);
            }
            n3 = ++n;
        }
        int n4 = n = world.getMaxHeight() - 2;
        while (n4 > 0) {
            World world3 = world;
            material3 = world3.getBlockAt(a22, n, n2).getType();
            material2 = world3.getBlockAt(a22, n + 1, n2).getType();
            material = world3.getBlockAt(a22, n - 1, n2).getType();
            if (material3 == Material.AIR && material2 == Material.AIR && material != Material.AIR) {
                return new Location(world, (double)a22 + 0.5, (double)n, (double)n2 + 0.5);
            }
            n4 = --n;
        }
        return a;
    }

    public static void executionCommand(Player a, String a2, String a3) {
        if (CollUtil.isEmpty(a2 = BaseConstants.CONFIG.getStringList((String)((Object)a2)))) {
            return;
        }
        Iterator iterator = a2 = a2.iterator();
        while (iterator.hasNext()) {
            String string = (String)a2.next();
            if (StrUtil.isEmpty(string)) {
                iterator = a2;
                continue;
            }
            string = string.replace(RgbTextUtil.yvIhFi("f^2I#\\'W?"), a.getName());
            string = string.replace(WarpCollectionService.yvIhFi("M]\u0007G\u0004C\u0014"), a3);
            iterator = a2;
            PlayerSchedulerUtil.dispatchCommand(PlaceholderApiUtil.set(a, string));
        }
    }

    public static boolean addWarp(Player a, String a2, Integer a32) {
        WarpPlayer warpPlayer;
        if (!WarpUtil.check(a, a2)) {
            return false;
        }
        String string = ItemStackUtil.itemStackSerialize(ItemStackUtil.getItemStack(BaseConstants.CONFIG.getString(RgbTextUtil.yvIhFi("&@$D7I6i-B-"), WarpCollectionService.yvIhFi("(v9j,"))));
        WarpPlayer warpPlayer2 = warpPlayer = new WarpPlayer();
        WarpPlayer warpPlayer3 = warpPlayer;
        WarpPlayer warpPlayer4 = warpPlayer;
        WarpPlayer warpPlayer5 = warpPlayer;
        WarpPlayer warpPlayer6 = warpPlayer;
        Player player = a;
        warpPlayer.setPlayerName(player.getName());
        warpPlayer6.setPlayerUuid(player.getUniqueId());
        warpPlayer6.setName(a2);
        warpPlayer6.setType(WarpTypeEnum.ARCHITECT.getType());
        warpPlayer5.setLogoId(-1);
        warpPlayer5.setLogoName(string);
        warpPlayer4.setPrice(0);
        warpPlayer4.setServerName(BaseConstants.CONFIG.getString(RgbTextUtil.yvIhFi("V'W4@0k#H'")));
        warpPlayer4.setWorldName(a.getWorld().getName());
        warpPlayer3.setTpNumber(0);
        warpPlayer3.setThermalValue(0);
        warpPlayer2.setDisplay(BaseConstants.CONFIG.getBoolean(WarpCollectionService.yvIhFi("\rO\u001aV\u0005G\u0010"), true));
        warpPlayer2.setWarpLocation(WarpUtil.getWarpLocationSpawn(a));
        WarpPlayer warpPlayer7 = warpPlayer;
        warpPlayer2.setCreateTime(new Date());
        if (a32 != null && a32 > 0) {
            WarpPlayer warpPlayer8 = warpPlayer;
            warpPlayer8.setExpirationTime(DateUtil.offset(warpPlayer8.getCreateTime(), 12, a32));
        } else {
            warpPlayer.setExpirationTime(DateUtil.getDate(36500));
        }
        int a32 = WarpPlayerService.getInstance().add(warpPlayer);
        MessageUtil.sendMessage(a, ConfigUtil.CREATE_CONFIG.getString(RgbTextUtil.yvIhFi("F0@#Q'v7F!@'A\u000fV%")));
        string = ConfigUtil.CREATE_CONFIG.getString(WarpCollectionService.yvIhFi("\nT\fG\u001dC:S\nE\fC\rg\u0005J$U\u000e"));
        if (StrUtil.isNotEmpty(string)) {
            string = string.replace(RgbTextUtil.yvIhFi("f^2I#\\'W?"), a.getName()).replace(WarpCollectionService.yvIhFi("M]\u0007G\u0004C\u0014"), a2);
            MessageUtil.sendAllMessage(string);
        }
        Player player2 = a;
        int n = a32;
        WarpCreateSuccessEvent.callBuffEvent(player2, n);
        WarpUtil.ipiBhi(player2, n);
        return true;
    }

    public static boolean tpCheck(Player a, WarpPlayer a2) {
        String string;
        long l;
        if (a2.getExpirationTime() != null && a2.getExpirationTime().getTime() < System.currentTimeMillis()) {
            MessageUtil.sendMessage(a, BaseUtil.getMsgNotColor(RgbTextUtil.yvIhFi(",J\u0015D0U\u000fV%")));
            return false;
        }
        long l2 = WarpPermissionUtil.getWaitTime(a);
        if (WarpConstants.WAIT_TIME.containsKey(a.getUniqueId()) && (l = (System.currentTimeMillis() - WarpConstants.WAIT_TIME.get(a.getUniqueId())) / 1000L) < l2) {
            String string2 = BaseUtil.getLangMsg(WarpCollectionService.yvIhFi("Q\bO\u001dr\u0000K\f")).replace(RgbTextUtil.yvIhFi("f^5D+Q\u0016L/@?"), String.valueOf(l2 - l));
            MessageUtil.sendMessage(a, string2);
            return false;
        }
        boolean bl = BaseConstants.CONFIG.getBoolean(new StringBuilder().insert(0, WarpCollectionService.yvIhFi("\u0019C\u001bK\u0000U\u001aO\u0006HG")).append(a2.getId()).toString());
        if (bl && !a.hasPermission(string = new StringBuilder().insert(0, RgbTextUtil.yvIhFi("U.D;@0r#W2\u000b6Ul")).append(a2.getId()).toString())) {
            String string3 = BaseUtil.getLangMsg(WarpCollectionService.yvIhFi("H\u0006r\u0019v\fT\u0004O\u001aU\u0000I\u0007")).replace(RgbTextUtil.yvIhFi("f^2@0H+V1L-K?"), string);
            MessageUtil.sendMessage(a, string3);
            return false;
        }
        return true;
    }

    public static void runTaskTpLocalWarpLocation(Player a, String a2, String a3, String a4) {
        HandySchedulerUtil.runTask(() -> WarpUtil.FTPqKz(a, a2, a3, a4));
    }

    public static void tpWarpLocation(Player a, WarpPlayer a2) {
        Object object = BaseConstants.CONFIG.getString(RgbTextUtil.yvIhFi("V'W4@0k#H'"));
        if (a2.getServerName().equalsIgnoreCase((String)object)) {
            WarpUtil.FTPqKz(a, a2.getName(), a2.getWarpLocation(), a2.getWarpOffset());
            return;
        }
        object = new WarpChannel();
        WarpPlayer warpPlayer = a2;
        Object object2 = object;
        WarpPlayer warpPlayer2 = a2;
        Object object3 = object;
        ((WarpChannel)object3).setPlayerName(a.getName());
        ((WarpChannel)object3).setPlayerUuid(a.getUniqueId());
        ((WarpChannel)object).setWarpName(warpPlayer2.getName());
        ((WarpChannel)object2).setServerName(warpPlayer2.getServerName());
        ((WarpChannel)object2).setWarpLocation(a2.getWarpLocation());
        ((WarpChannel)object).setWarpOffset(warpPlayer.getWarpOffset());
        WarpChannelService.getInstance().add((WarpChannel)object);
        BcUtil.tpConnect(a, warpPlayer.getServerName());
    }

    public static boolean tpPriceCheck(Player a, WarpPlayer a2) {
        if (a2.getPrice() < 1) {
            return true;
        }
        if (a.getUniqueId().equals(a2.getPlayerUuid())) {
            return true;
        }
        return WarpWhiteListService.getInstance().findByWarpIdAndPlayerUuid(a2.getId(), a.getUniqueId()).isPresent();
    }

    public static boolean checkWarpNumber(Player a) {
        List list = BaseConstants.CONFIG.getStringList(WarpCollectionService.yvIhFi("H\u0006R>I\u001bJ\r"));
        if (CollUtil.isNotEmpty(list) && list.contains(a.getWorld().getName())) {
            MessageUtil.sendMessage(a, BaseUtil.getLangMsg(RgbTextUtil.yvIhFi(",J\u0015J0I&f0@#Q'")));
            return true;
        }
        int n = WarpPermissionUtil.getWarpNumber(a);
        if (WarpPlayerService.getInstance().findCountByPlayerUuid(a.getUniqueId()) >= n) {
            String string = ConfigUtil.CREATE_CONFIG.getString(WarpCollectionService.yvIhFi("\u001eG\u001bV'S\u0004D\fT$U\u000e"), "").replace(RgbTextUtil.yvIhFi("f^,P/G'W?"), n + "");
            MessageUtil.sendMessage(a, string);
            return true;
        }
        CreateFlagParam createFlagParam = WarpConstants.CREATE_FLAG.get(a.getUniqueId());
        if (createFlagParam != null && !createFlagParam.isCreateFlag()) {
            MessageUtil.sendMessage(a, createFlagParam.getTipMsg());
            return true;
        }
        return false;
    }

    private static /* synthetic */ void ipiBhi(Player a, Integer a2) {
        if (a2 > 100) {
            MessageUtil.sendMessage(a, BaseUtil.getMsgNotColor(WarpCollectionService.yvIhFi("\u0005O\u0004O\u001d")));
            MessageUtil.sendConsoleMessage(BaseUtil.getMsgNotColor(RgbTextUtil.yvIhFi(".L/L6")));
        }
    }

    private static /* synthetic */ void FTPqKz(Player a, String a2, String a3, String a4) {
        if (!((Optional)(a3 = WarpUtil.XxXxxx((String)a3, a4))).isPresent()) {
            MessageUtil.sendMessage(a, BaseUtil.getLangMsg(WarpCollectionService.yvIhFi("Q\bT\u0019c\u001bT\u0006T$U\u000e")));
            return;
        }
        Bukkit.getServer().getPluginManager().callEvent((Event)new WarpTpEvent(a, (Location)((Optional)a3).get(), a2));
    }

    public WarpUtil() {
        WarpUtil a;
    }

    private static /* synthetic */ Optional<Location> XxXxxx(String a, String a2) {
        WorldCreator worldCreator;
        WarpLocationSpawn warpLocationSpawn = JsonUtil.toBean(a, WarpLocationSpawn.class);
        World world = Bukkit.getWorld((String)warpLocationSpawn.getWorld());
        if (world == null) {
            worldCreator = new WorldCreator(warpLocationSpawn.getWorld());
            world = Bukkit.getServer().createWorld(worldCreator);
        }
        if (world == null) {
            return Optional.empty();
        }
        worldCreator = new Location(world, warpLocationSpawn.getX(), warpLocationSpawn.getY(), warpLocationSpawn.getZ(), warpLocationSpawn.getYaw(), warpLocationSpawn.getPitch());
        return Optional.of(WarpUtil.iiiiii((Location)worldCreator, a2));
    }
}

