/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.event;

import cn.handyplus.warp.lib.BaseUtil;
import cn.handyplus.warp.lib.MessageUtil;
import cn.handyplus.warp.util.WarpUtil;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class WarpTpEvent
extends Event
implements Cancellable {
    private static final HandlerList HANDLERS = new HandlerList();
    private final Player player;
    private final Location location;
    private final String warpName;
    private boolean cancelled;

    public WarpTpEvent(Player player, Location location, String warpName) {
        super(!Bukkit.isPrimaryThread());
        this.player = player;
        this.location = location;
        this.warpName = warpName;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public void success() {
        String warpTpTitle = BaseUtil.getMsgNotColor("warpTpTitle", "${name}");
        warpTpTitle = warpTpTitle.replace("${name}", this.warpName);
        String welcomeTitle = BaseUtil.getMsgNotColor("welcomeTitle", "");
        welcomeTitle = welcomeTitle.replace("${player}", this.player.getName());
        welcomeTitle = welcomeTitle.replace("${name}", this.warpName);
        MessageUtil.sendTitle(this.player, warpTpTitle, welcomeTitle);
        WarpUtil.executionCommand(this.player, "tpAfterCommand", this.warpName);
    }

    @Generated
    public Player getPlayer() {
        return this.player;
    }

    @Generated
    public Location getLocation() {
        return this.location;
    }

    @Generated
    public String getWarpName() {
        return this.warpName;
    }
}

