/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.lib;

import cn.handyplus.warp.lib.BaseConstants;
import cn.handyplus.warp.lib.HandyHttpUtil;
import cn.handyplus.warp.lib.LotteryUtil;
import cn.handyplus.warp.lib.MessageUtil;
import cn.handyplus.warp.lib.VersionCheckEnum;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.GameRule;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.Biome;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;

public final class LegacyUtil {
    private static Class<?> B;
    private static Class<?> e;
    private static Class<?> wOeyoi;

    public static Enchantment getDurability() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Enchantment.UNBREAKING;
        }
        return LegacyUtil.getEnchantmentByName(LotteryUtil.PpppPp("-\u000e;\u001a+\u0012%\u0012=\u0002"));
    }

    public static String getEnchantmentKey(@NotNull Enchantment enchantment) {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_12.getVersionId()) {
            return enchantment.getKey().getKey();
        }
        return null;
    }

    public static void setGameRuleValue(@NotNull World world, @NotNull String ruleName, @NotNull Object value) {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_12.getVersionId()) {
            GameRule gameRule = GameRule.getByName((String)ruleName);
            if (gameRule == null) {
                MessageUtil.sendConsoleMessage(new StringBuilder().insert(0, LotteryUtil.PpppPp("\u4e7f\u7517\u89ad\u5242S{")).append(ruleName).append(HandyHttpUtil.PpppPp("C\u4e15\u5b3b\u5730M")).toString());
                return;
            }
            if (value instanceof Boolean) {
                world.setGameRule(gameRule, (Object)((Boolean)value));
                return;
            }
            if (value instanceof Integer) {
                world.setGameRule(gameRule, (Object)((Integer)value));
                return;
            }
        }
        world.setGameRuleValue(ruleName, String.valueOf(value));
    }

    public static List<String> getEnchantmentList() {
        return Arrays.stream(Enchantment.values()).map(Enchantment::getName).collect(Collectors.toList());
    }

    public static Attribute getAttribute(@NotNull String name) {
        if (wOeyoi == null) {
            return null;
        }
        if (wOeyoi.isEnum()) {
            try {
                Enum enum_ = Enum.valueOf(wOeyoi.asSubclass(Enum.class), name);
                return (Attribute)enum_;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(new StringBuilder().insert(0, HandyHttpUtil.PpppPp("\u6cc2\u6711\u621d\u5228\u76e7\u5c46\u6044\"C")).append(name).toString(), illegalArgumentException);
            }
        }
        try {
            Class[] classArray = new Class[1];
            classArray[0] = String.class;
            Method method = wOeyoi.getMethod(LotteryUtil.PpppPp("-\b7\u001c>&="), classArray);
            Object[] objectArray = new Object[1];
            objectArray[0] = name;
            return (Attribute)method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(new StringBuilder().insert(0, HandyHttpUtil.PpppPp("\u6cb9\u676a\u6266\u5253\u5c46\u6044\"C")).append(name).toString(), exception);
        }
    }

    public static Biome getBiome(@NotNull String name) throws Exception {
        if (e.isEnum()) {
            Enum enum_ = Enum.valueOf(e.asSubclass(Enum.class), name);
            return (Biome)enum_;
        }
        Class[] classArray = new Class[1];
        classArray[0] = String.class;
        Method method = e.getMethod(LotteryUtil.PpppPp("-\b7\u001c>&="), classArray);
        Object[] objectArray = new Object[1];
        objectArray[0] = name;
        return (Biome)method.invoke(null, objectArray);
    }

    public static List<String> getEntityTypeList() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_13_2.getVersionId()) {
            return Arrays.stream(EntityType.values()).filter(a2 -> a2 != EntityType.UNKNOWN).map(a2 -> a2.getKey().getKey()).collect(Collectors.toList());
        }
        return Arrays.stream(EntityType.values()).map(EntityType::getName).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static PotionEffectType getPotionEffectTypeByName(@NotNull String name) {
        return PotionEffectType.getByName((String)name);
    }

    public static Particle getFirework() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Particle.FIREWORK;
        }
        return Particle.valueOf((String)LotteryUtil.PpppPp("\u001d \t,\f&\t\"\b6\b9\u001a;\u0010"));
    }

    private /* synthetic */ LegacyUtil() {
        LegacyUtil a2;
    }

    public static String getEnchantmentName(@NotNull Enchantment enchantment) {
        return enchantment.getName();
    }

    public static Enchantment getArrowDamage() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Enchantment.POWER;
        }
        return LegacyUtil.getEnchantmentByName(HandyHttpUtil.PpppPp("Y1J,O<\\\"U\"_&"));
    }

    public static Sound getSound(@NotNull String sound) throws Exception {
        if (B.isEnum()) {
            Enum enum_ = Enum.valueOf(B.asSubclass(Enum.class), sound.toUpperCase());
            return (Sound)enum_;
        }
        Class[] classArray = new Class[1];
        classArray[0] = String.class;
        Method method = B.getMethod(HandyHttpUtil.PpppPp("\u0015y\u000fm\u0006W\u0005"), classArray);
        Object[] objectArray = new Object[1];
        objectArray[0] = sound.toUpperCase();
        return (Sound)method.invoke(null, objectArray);
    }

    public static AttributeModifier getAttributeModifier(@NotNull String name, double amount, @NotNull AttributeModifier.Operation operation, @NotNull EquipmentSlot a2) {
        UUID uUID = UUID.randomUUID();
        if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_21.getVersionId()) {
            return new AttributeModifier(uUID, name, amount, operation, a2);
        }
        return new AttributeModifier(NamespacedKey.fromString((String)uUID.toString()), amount, operation, a2.getGroup());
    }

    public static Particle getDripLava() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Particle.DRIPPING_LAVA;
        }
        return Particle.valueOf((String)HandyHttpUtil.PpppPp("'J*H<T\"N\""));
    }

    public static Particle getRedStone() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return Particle.DUST;
        }
        return Particle.valueOf((String)LotteryUtil.PpppPp(";\u001e-\b=\u0014'\u001e"));
    }

    public static Enchantment getEnchantmentByName(@NotNull String name) {
        return Enchantment.getByName((String)name);
    }

    public static String getEntityTypeName(@NotNull EntityType entityType) {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_13_2.getVersionId()) {
            return entityType.getKey().getKey();
        }
        return entityType.getName();
    }

    public static void setMaxHealth(@NotNull Player player, double maxHealth) {
        player.setMaxHealth(maxHealth);
    }

    public static EntityType getEntityTypeByName(@NotNull String name) {
        return EntityType.fromName((String)name);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void initClasses() {
        try {
            B = Class.forName(HandyHttpUtil.PpppPp("w\u0011\u007fMz\u0016s\bq\u001760w\u0016v\u0007"));
            wOeyoi = BaseConstants.VERSION_ID >= VersionCheckEnum.V_1_9.getVersionId() ? Class.forName(LotteryUtil.PpppPp("\u0006)\u000eu\u000b.\u00020\u0000/G:\u001d/\u001b2\u000b.\u001d>G\u001a\u001d/\u001b2\u000b.\u001d>")) : null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(LotteryUtil.PpppPp("\u65bb\u6cbc\u6225\u5259\u7c20"), classNotFoundException);
        }
        {
            e = Class.forName(HandyHttpUtil.PpppPp("w\u0011\u007fMz\u0016s\bq\u00176\u0001t\f{\b6!q\fu\u0006"));
            return;
        }
    }

    public static double getMaxHealth(@NotNull Player player) {
        return player.getMaxHealth();
    }

    public static PotionEffectType getIncreaseDamage() {
        if (BaseConstants.VERSION_ID > VersionCheckEnum.V_1_20_4.getVersionId()) {
            return PotionEffectType.getByName((String)HandyHttpUtil.PpppPp("k\u0017j\u0006v\u0004l\u000b"));
        }
        return PotionEffectType.getByName((String)LotteryUtil.PpppPp("2\u00078\u001b>\b(\f\u0004\r:\u0004:\u000e>"));
    }

    public static List<String> getPotionEffectTypeList() {
        return Arrays.stream(PotionEffectType.values()).map(PotionEffectType::getName).collect(Collectors.toList());
    }

    public static List<String> getEntityTypeAliveList() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = BaseConstants.VERSION_ID > VersionCheckEnum.V_1_13_2.getVersionId();
        EntityType[] entityTypeArray = EntityType.values();
        int n2 = entityTypeArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            EntityType entityType = entityTypeArray[n];
            if (entityType.isAlive() && entityType.isSpawnable()) {
                if (bl) {
                    arrayList.add(entityType.getKey().getKey());
                } else {
                    arrayList.add(entityType.getName());
                }
            }
            n3 = ++n;
        }
        return arrayList;
    }
}

