/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.warp.lib.expand.adapter;

public enum ServerTypeEnum {
    FOLIA("io.papermc.paper.threadedregions.RegionizedServerInitEvent"),
    PAPER("com.destroystokyo.paper.PaperConfig"),
    SPIGOT("org.spigotmc.SpigotConfig"),
    BUKKIT("org.bukkit.Bukkit");

    private final String className;

    private ServerTypeEnum(String className) {
        this.className = className;
    }

    public static ServerTypeEnum getServerType() {
        if (ServerTypeEnum.isClassPresent(ServerTypeEnum.FOLIA.className)) {
            return FOLIA;
        }
        if (ServerTypeEnum.isClassPresent(ServerTypeEnum.PAPER.className)) {
            return PAPER;
        }
        if (ServerTypeEnum.isClassPresent(ServerTypeEnum.SPIGOT.className)) {
            return SPIGOT;
        }
        return BUKKIT;
    }

    private static boolean isClassPresent(String className) {
        try {
            Class.forName(className, false, ServerTypeEnum.class.getClassLoader());
            return true;
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }
}

