/*
 * Decompiled with CFR 0.152.
 */
package dhyces.waxablecoral;

import dhyces.waxablecoral.Register;
import dhyces.waxablecoral.WaxableCoral;
import dhyces.waxablecoral.WaxableCoralAPI;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.registries.DeferredRegister;

@Mod(value="waxablecoral")
public class NeoForgeWaxableCoral {
    public static final DeferredRegister.Blocks BLOCK_REGISTER = DeferredRegister.createBlocks((String)"waxablecoral");
    public static final DeferredRegister.Items ITEM_REGISTER = DeferredRegister.createItems((String)"waxablecoral");
    public static final TagKey<Item> WAXES_BLOCKS = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"waxes_blocks"));

    public NeoForgeWaxableCoral(IEventBus modBus) {
        BLOCK_REGISTER.register(modBus);
        ITEM_REGISTER.register(modBus);
        WaxableCoral.init();
        modBus.addListener(this::onCommonLoad);
        modBus.addListener(this::addTabs);
        NeoForge.EVENT_BUS.addListener(this::onBlockRightClick);
        NeoForge.EVENT_BUS.addListener(this::onAxeWaxOffUsed);
    }

    private void onCommonLoad(FMLCommonSetupEvent event) {
        event.enqueueWork(WaxableCoralAPI::fillWaxingMap);
    }

    private void addTabs(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.NATURAL_BLOCKS) {
            event.insertAfter(Items.DEAD_HORN_CORAL_FAN.getDefaultInstance(), ((Block)Register.WAXED_HORN_CORAL_FAN.value()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.DEAD_HORN_CORAL_FAN.getDefaultInstance(), ((Block)Register.WAXED_FIRE_CORAL_FAN.value()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.DEAD_HORN_CORAL_FAN.getDefaultInstance(), ((Block)Register.WAXED_BUBBLE_CORAL_FAN.value()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.DEAD_HORN_CORAL_FAN.getDefaultInstance(), ((Block)Register.WAXED_BRAIN_CORAL_FAN.value()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.DEAD_HORN_CORAL_FAN.getDefaultInstance(), ((Block)Register.WAXED_TUBE_CORAL_FAN.value()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.DEAD_HORN_CORAL_FAN.getDefaultInstance(), ((Block)Register.WAXED_HORN_CORAL.value()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.DEAD_HORN_CORAL_FAN.getDefaultInstance(), ((Block)Register.WAXED_FIRE_CORAL.value()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.DEAD_HORN_CORAL_FAN.getDefaultInstance(), ((Block)Register.WAXED_BUBBLE_CORAL.value()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.DEAD_HORN_CORAL_FAN.getDefaultInstance(), ((Block)Register.WAXED_BRAIN_CORAL.value()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.DEAD_HORN_CORAL_FAN.getDefaultInstance(), ((Block)Register.WAXED_TUBE_CORAL.value()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.DEAD_HORN_CORAL_FAN.getDefaultInstance(), ((Block)Register.WAXED_HORN_CORAL_BLOCK.value()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.DEAD_HORN_CORAL_FAN.getDefaultInstance(), ((Block)Register.WAXED_FIRE_CORAL_BLOCK.value()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.DEAD_HORN_CORAL_FAN.getDefaultInstance(), ((Block)Register.WAXED_BUBBLE_CORAL_BLOCK.value()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.DEAD_HORN_CORAL_FAN.getDefaultInstance(), ((Block)Register.WAXED_BRAIN_CORAL_BLOCK.value()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.insertAfter(Items.DEAD_HORN_CORAL_FAN.getDefaultInstance(), ((Block)Register.WAXED_TUBE_CORAL_BLOCK.value()).asItem().getDefaultInstance(), CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    private void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
        Block waxed;
        BlockPos waxingPos = event.getHitVec().getBlockPos();
        BlockState state = event.getLevel().getBlockState(waxingPos);
        ItemStack usedStack = event.getItemStack();
        Level level = event.getLevel();
        if (usedStack.is(WAXES_BLOCKS) && (waxed = WaxableCoralAPI.getWaxed(state.getBlock())) != null) {
            BlockState waxedState = waxed.withPropertiesOf(state);
            level.setBlock(waxingPos, waxedState, 11);
            if (!event.getEntity().getAbilities().instabuild) {
                usedStack.shrink(1);
            }
            event.getEntity().awardStat(Stats.ITEM_USED.get((Object)usedStack.getItem()));
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, waxingPos, usedStack);
            }
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, waxingPos, GameEvent.Context.of((Entity)event.getEntity(), (BlockState)waxedState));
            level.levelEvent((Entity)event.getEntity(), 3003, waxingPos, 0);
            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    private void onAxeWaxOffUsed(BlockEvent.BlockToolModificationEvent event) {
        BlockState state;
        Block unwaxed;
        if (event.getItemAbility().equals(ItemAbilities.AXE_WAX_OFF) && (unwaxed = WaxableCoralAPI.getUnwaxed((state = event.getLevel().getBlockState(event.getContext().getClickedPos())).getBlock())) != null) {
            event.setFinalState(unwaxed.withPropertiesOf(state));
            event.getLevel().scheduleTick(event.getPos(), unwaxed, 60 + event.getLevel().getRandom().nextInt(40));
        }
    }
}

