/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.script.CarpetContext;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.Module;
import carpet.script.argument.FunctionArgument;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.utils.InputValidator;
import carpet.script.utils.RecipeHelper;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.FunctionValue;
import carpet.script.value.ListValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.ScreenValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import net.minecraft.class_10352;
import net.minecraft.class_10363;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3956;
import net.minecraft.class_3972;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7924;

public class Inventories {
    public static void apply(Expression expression) {
        expression.addContextFunction("stack_limit", 1, (c, t, lv) -> new NumericValue(NBTSerializableValue.parseItem(((Value)lv.get(0)).getString(), ((CarpetContext)c).registryAccess()).method_7914()));
        expression.addContextFunction("item_category", -1, (c, t, lv) -> {
            c.host.issueDeprecation("item_category in 1.19.3+");
            return Value.NULL;
        });
        expression.addContextFunction("item_list", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_2378 items = cc.registry(class_7924.field_41197);
            if (lv.isEmpty()) {
                return ListValue.wrap(items.method_42017().map(itemReference -> ValueConversions.of(itemReference.method_40237().method_29177())));
            }
            String tag = ((Value)lv.get(0)).getString();
            Optional itemTag = items.method_46733(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)InputValidator.identifierOf(tag)));
            return itemTag.isEmpty() ? Value.NULL : ListValue.wrap(((class_6885.class_6888)itemTag.get()).method_40239().map(b -> items.method_10221((Object)((class_1792)b.comp_349()))).filter(Objects::nonNull).map(ValueConversions::of));
        });
        expression.addContextFunction("item_tags", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_2378 blocks = cc.registry(class_7924.field_41197);
            if (lv.isEmpty()) {
                return ListValue.wrap(blocks.method_40272().map(ValueConversions::of));
            }
            class_1792 item = NBTSerializableValue.parseItem(((Value)lv.get(0)).getString(), cc.registryAccess()).method_7909();
            if (lv.size() == 1) {
                return ListValue.wrap(blocks.method_40272().filter(e -> e.method_40239().anyMatch(h -> h.comp_349() == item)).map(ValueConversions::of));
            }
            String tag = ((Value)lv.get(1)).getString();
            Optional tagSet = blocks.method_46733(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)InputValidator.identifierOf(tag)));
            return tagSet.isEmpty() ? Value.NULL : BooleanValue.of(((class_6885.class_6888)tagSet.get()).method_40239().anyMatch(h -> h.comp_349() == item));
        });
        expression.addContextFunction("recipe_data", -1, (c, t, lv) -> {
            List<class_1860<?>> recipes;
            CarpetContext cc = (CarpetContext)c;
            if (lv.size() < 1) {
                throw new InternalExpressionException("'recipe_data' requires at least one argument");
            }
            String recipeName = ((Value)lv.get(0)).getString();
            class_3956 type = class_3956.field_17545;
            if (lv.size() > 1) {
                String recipeType = ((Value)lv.get(1)).getString();
                type = (class_3956)cc.registry(class_7924.field_41217).method_63535(InputValidator.identifierOf(recipeType));
                if (type == null) {
                    throw new InternalExpressionException("Unknown recipe type: " + recipeType);
                }
            }
            if ((recipes = RecipeHelper.getRecipesForOutput(cc.server().method_3772(), type, InputValidator.identifierOf(recipeName), (class_1937)cc.level())).isEmpty()) {
                return Value.NULL;
            }
            ArrayList<Value> recipesOutput = new ArrayList<Value>();
            class_5455 regs = cc.registryAccess();
            class_10352 context = class_10363.method_65008((class_1937)cc.level());
            for (class_1860<?> recipe : recipes) {
                ListValue recipeSpec;
                ArrayList<Value> results = new ArrayList<Value>();
                recipe.method_64664().forEach(rd -> rd.comp_3258().method_64738(context).forEach(is -> results.add(ValueConversions.of(is, regs))));
                ArrayList<Value> ingredientValue = new ArrayList<Value>();
                IntListIterator intListIterator = recipe.method_61671().method_65800().iterator();
                while (intListIterator.hasNext()) {
                    int info = (Integer)intListIterator.next();
                    if (info == -1) {
                        ingredientValue.add(Value.NULL);
                        continue;
                    }
                    int ingredientIndex = info;
                    ArrayList<Value> alternatives = new ArrayList<Value>();
                    ((class_1856)recipe.method_61671().method_64675().get(ingredientIndex)).method_8105().forEach(item -> alternatives.add(ValueConversions.of((class_1792)item.comp_349(), regs)));
                    if (alternatives.isEmpty()) {
                        ingredientValue.add(Value.NULL);
                        continue;
                    }
                    ingredientValue.add(ListValue.wrap(alternatives));
                }
                if (recipe instanceof class_1869) {
                    class_1869 shapedRecipe = (class_1869)recipe;
                    recipeSpec = ListValue.of(new StringValue("shaped"), new NumericValue(shapedRecipe.method_8150()), new NumericValue(shapedRecipe.method_8158()));
                } else if (recipe instanceof class_1867) {
                    recipeSpec = ListValue.of(new StringValue("shapeless"));
                } else if (recipe instanceof class_1874) {
                    class_1874 abstractCookingRecipe = (class_1874)recipe;
                    recipeSpec = ListValue.of(new StringValue("smelting"), new NumericValue(abstractCookingRecipe.method_8167()), new NumericValue(abstractCookingRecipe.method_8171()));
                } else {
                    recipeSpec = recipe instanceof class_3972 ? ListValue.of(new StringValue("cutting")) : (recipe instanceof class_1852 ? ListValue.of(new StringValue("special")) : ListValue.of(new StringValue("custom")));
                }
                recipesOutput.add(ListValue.of(ListValue.wrap(results), ListValue.wrap(ingredientValue), recipeSpec));
            }
            return ListValue.wrap(recipesOutput);
        });
        expression.addContextFunction("crafting_remaining_item", 1, (c, t, v) -> {
            String itemStr = ((Value)v.get(0)).getString();
            class_2960 id = InputValidator.identifierOf(itemStr);
            CarpetContext cc = (CarpetContext)c;
            class_2378 registry = cc.registry(class_7924.field_41197);
            class_1792 item = (class_1792)registry.method_17966(id).orElseThrow(() -> new ThrowStatement(itemStr, Throwables.UNKNOWN_ITEM));
            class_1799 reminder = item.method_7858();
            return reminder.method_7960() ? Value.NULL : ValueConversions.of(reminder, cc.registryAccess());
        });
        expression.addContextFunction("inventory_size", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            return inventoryLocator == null ? Value.NULL : new NumericValue(inventoryLocator.inventory().method_5439());
        });
        expression.addContextFunction("inventory_has_items", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            return inventoryLocator == null ? Value.NULL : BooleanValue.of(!inventoryLocator.inventory().method_5442());
        });
        expression.addContextFunction("inventory_get", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            class_5455 regs = cc.registryAccess();
            if (lv.size() == inventoryLocator.offset()) {
                ArrayList<Value> fullInventory = new ArrayList<Value>();
                int maxi = inventoryLocator.inventory().method_5439();
                for (int i = 0; i < maxi; ++i) {
                    fullInventory.add(ValueConversions.of(inventoryLocator.inventory().method_5438(i), regs));
                }
                return ListValue.wrap(fullInventory);
            }
            int slot = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset())).getLong();
            return (slot = NBTSerializableValue.validateSlot(slot, inventoryLocator.inventory())) == inventoryLocator.inventory().method_5439() ? Value.NULL : ValueConversions.of(inventoryLocator.inventory().method_5438(slot), regs);
        });
        expression.addContextFunction("inventory_set", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            if (lv.size() < inventoryLocator.offset() + 2) {
                throw new InternalExpressionException("'inventory_set' requires at least slot number and new stack size, and optional new item");
            }
            int slot = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset())).getLong();
            if ((slot = NBTSerializableValue.validateSlot(slot, inventoryLocator.inventory())) == inventoryLocator.inventory().method_5439()) {
                return Value.NULL;
            }
            OptionalInt count = OptionalInt.empty();
            Value countVal = (Value)lv.get(inventoryLocator.offset() + 1);
            if (!countVal.isNull()) {
                count = OptionalInt.of((int)NumericValue.asNumber(countVal).getLong());
            }
            class_5455 regs = cc.registryAccess();
            if (count.isPresent() && count.getAsInt() == 0) {
                class_1799 removedStack = inventoryLocator.inventory().method_5441(slot);
                Inventories.syncPlayerInventory(inventoryLocator);
                return ValueConversions.of(removedStack, regs);
            }
            if (lv.size() < inventoryLocator.offset() + 3) {
                class_1799 previousStack = inventoryLocator.inventory().method_5438(slot);
                class_1799 newStack = previousStack.method_7972();
                count.ifPresent(arg_0 -> ((class_1799)newStack).method_7939(arg_0));
                inventoryLocator.inventory().method_5447(slot, newStack);
                Inventories.syncPlayerInventory(inventoryLocator);
                return ValueConversions.of(previousStack, regs);
            }
            class_2487 nbt = null;
            if (lv.size() > inventoryLocator.offset() + 3) {
                Value nbtValue = (Value)lv.get(inventoryLocator.offset() + 3);
                if (nbtValue instanceof NBTSerializableValue) {
                    NBTSerializableValue nbtsv = (NBTSerializableValue)nbtValue;
                    nbt = nbtsv.getCompoundTag();
                } else if (!nbtValue.isNull()) {
                    nbt = new NBTSerializableValue(nbtValue.getString()).getCompoundTag();
                }
            }
            class_1799 newitem = NBTSerializableValue.parseItem(((Value)lv.get(inventoryLocator.offset() + 2)).getString(), nbt, cc.registryAccess());
            count.ifPresent(arg_0 -> ((class_1799)newitem).method_7939(arg_0));
            class_1799 previousStack = inventoryLocator.inventory().method_5438(slot);
            inventoryLocator.inventory().method_5447(slot, newitem);
            Inventories.syncPlayerInventory(inventoryLocator);
            return ValueConversions.of(previousStack, regs);
        });
        expression.addContextFunction("inventory_find", -1, (c, t, lv) -> {
            Value secondArg;
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            class_1799 itemArg = null;
            if (lv.size() > inventoryLocator.offset() && !(secondArg = (Value)lv.get(inventoryLocator.offset())).isNull()) {
                itemArg = NBTSerializableValue.parseItem(secondArg.getString(), cc.registryAccess());
            }
            int startIndex = 0;
            if (lv.size() > inventoryLocator.offset() + 1) {
                startIndex = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset() + 1)).getLong();
            }
            int maxi = inventoryLocator.inventory().method_5439();
            for (int i = startIndex = NBTSerializableValue.validateSlot(startIndex, inventoryLocator.inventory()); i < maxi; ++i) {
                class_1799 stack = inventoryLocator.inventory().method_5438(i);
                if ((itemArg != null || !stack.method_7960()) && (itemArg == null || !itemArg.method_7909().equals(stack.method_7909()))) continue;
                return new NumericValue(i);
            }
            return Value.NULL;
        });
        expression.addContextFunction("inventory_remove", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            if (lv.size() <= inventoryLocator.offset()) {
                throw new InternalExpressionException("'inventory_remove' requires at least an item to be removed");
            }
            class_1799 searchItem = NBTSerializableValue.parseItem(((Value)lv.get(inventoryLocator.offset())).getString(), cc.registryAccess());
            int amount = 1;
            if (lv.size() > inventoryLocator.offset() + 1) {
                amount = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset() + 1)).getLong();
            }
            if (amount == 1 && !inventoryLocator.inventory().method_18862(Set.of(searchItem.method_7909())) || inventoryLocator.inventory().method_18861(searchItem.method_7909()) < amount) {
                return Value.FALSE;
            }
            int maxi = inventoryLocator.inventory().method_5439();
            for (int i = 0; i < maxi; ++i) {
                class_1799 stack = inventoryLocator.inventory().method_5438(i);
                if (stack.method_7960() || !stack.method_7909().equals(searchItem.method_7909())) continue;
                int left = stack.method_7947() - amount;
                if (left > 0) {
                    stack.method_7939(left);
                    inventoryLocator.inventory().method_5447(i, stack);
                    Inventories.syncPlayerInventory(inventoryLocator);
                    return Value.TRUE;
                }
                inventoryLocator.inventory().method_5441(i);
                Inventories.syncPlayerInventory(inventoryLocator);
                amount -= stack.method_7947();
            }
            if (amount > 0) {
                throw new InternalExpressionException("Something bad happened - cannot pull all items from inventory");
            }
            return Value.TRUE;
        });
        expression.addContextFunction("drop_item", -1, (c, t, lv) -> {
            class_1542 item;
            class_1799 droppedStack;
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            if (lv.size() == inventoryLocator.offset()) {
                throw new InternalExpressionException("Slot number is required for inventory_drop");
            }
            int slot = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset())).getLong();
            if ((slot = NBTSerializableValue.validateSlot(slot, inventoryLocator.inventory())) == inventoryLocator.inventory().method_5439()) {
                return Value.NULL;
            }
            int amount = 0;
            if (lv.size() > inventoryLocator.offset() + 1) {
                amount = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset() + 1)).getLong();
            }
            if (amount < 0) {
                throw new InternalExpressionException("Cannot throw negative number of items");
            }
            class_1799 stack = inventoryLocator.inventory().method_5438(slot);
            if (stack == null || stack.method_7960()) {
                return Value.ZERO;
            }
            if (amount == 0) {
                amount = stack.method_7947();
            }
            if ((droppedStack = inventoryLocator.inventory().method_5434(slot, amount)).method_7960()) {
                return Value.ZERO;
            }
            Object owner = inventoryLocator.owner();
            if (owner instanceof class_1657) {
                class_1657 player = (class_1657)owner;
                item = player.method_7329(droppedStack, false, true);
                if (item == null) {
                    return Value.ZERO;
                }
            } else if (owner instanceof class_1309) {
                class_1309 livingEntity = (class_1309)owner;
                double dropY = livingEntity.method_23318() - (double)0.3f + (double)livingEntity.method_5751();
                item = new class_1542(livingEntity.comp_4426(), livingEntity.method_23317(), dropY, livingEntity.method_23321(), droppedStack);
                class_243 vec3d = livingEntity.method_5828(1.0f).method_1029().method_1021(0.3);
                item.method_18799(vec3d);
                item.method_6988();
                cc.level().method_8649((class_1297)item);
            } else {
                class_243 point = class_243.method_24953((class_2382)inventoryLocator.position());
                item = new class_1542((class_1937)cc.level(), point.field_1352, point.field_1351, point.field_1350, droppedStack);
                item.method_6988();
                cc.level().method_8649((class_1297)item);
            }
            return new NumericValue(item.method_6983().method_7947());
        });
        expression.addContextFunction("create_screen", -1, (c, t, lv) -> {
            if (lv.size() < 3) {
                throw new InternalExpressionException("'create_screen' requires at least three arguments");
            }
            Value playerValue = (Value)lv.get(0);
            class_3222 player = EntityValue.getPlayerByValue(((CarpetContext)c).server(), playerValue);
            if (player == null) {
                throw new InternalExpressionException("'create_screen' requires a valid online player as the first argument.");
            }
            String type = ((Value)lv.get(1)).getString();
            class_2561 name = FormattedTextValue.getTextByValue((Value)lv.get(2));
            FunctionValue function = null;
            if (lv.size() > 3) {
                function = FunctionArgument.findIn((Context)c, (Module)expression.module, (List<Value>)lv, (int)3, (boolean)true, (boolean)false).function;
            }
            return new ScreenValue(player, type, name, function, (Context)c);
        });
        expression.addContextFunction("close_screen", 1, (c, t, lv) -> {
            Value value = (Value)lv.get(0);
            if (!(value instanceof ScreenValue)) {
                throw new InternalExpressionException("'close_screen' requires a screen value as the first argument.");
            }
            ScreenValue screenValue = (ScreenValue)value;
            if (!screenValue.isOpen()) {
                return Value.FALSE;
            }
            screenValue.close();
            return Value.TRUE;
        });
        expression.addContextFunction("screen_property", -1, (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'screen_property' requires at least a screen and a property name");
            }
            Object patt0$temp = lv.get(0);
            if (!(patt0$temp instanceof ScreenValue)) {
                throw new InternalExpressionException("'screen_property' requires a screen value as the first argument");
            }
            ScreenValue screenValue = (ScreenValue)patt0$temp;
            String propertyName = ((Value)lv.get(1)).getString();
            return lv.size() >= 3 ? screenValue.modifyProperty(propertyName, lv.subList(2, lv.size())) : screenValue.queryProperty(propertyName);
        });
    }

    private static void syncPlayerInventory(NBTSerializableValue.InventoryLocator inventory) {
        Object object = inventory.owner();
        if (object instanceof class_3222) {
            class_3222 player = (class_3222)object;
            if (!inventory.isEnder() && !(inventory.inventory() instanceof ScreenValue.ScreenHandlerInventory)) {
                player.field_7512.method_7623();
            }
        }
    }
}

