/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetSettings;
import carpet.fakes.ServerPlayerInterface;
import carpet.helpers.EntityPlayerActionPack;
import carpet.patches.EntityPlayerMPFake;
import carpet.utils.CommandHelper;
import carpet.utils.Messenger;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_11560;
import net.minecraft.class_1297;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2181;
import net.minecraft.class_2270;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3321;
import net.minecraft.class_3324;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_7157;
import net.minecraft.class_7918;
import net.minecraft.server.MinecraftServer;

public class PlayerCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"player").requires(player -> CommandHelper.canUseCommand(player, CarpetSettings.commandPlayer))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9265(PlayerCommand.getPlayerSuggestions((class_2168)c.getSource()), (SuggestionsBuilder)b)).then(class_2170.method_9247((String)"stop").executes(PlayerCommand.manipulation(EntityPlayerActionPack::stopAll)))).then(PlayerCommand.makeActionCommand("use", EntityPlayerActionPack.ActionType.USE))).then(PlayerCommand.makeActionCommand("jump", EntityPlayerActionPack.ActionType.JUMP))).then(PlayerCommand.makeActionCommand("attack", EntityPlayerActionPack.ActionType.ATTACK))).then(PlayerCommand.makeActionCommand("drop", EntityPlayerActionPack.ActionType.DROP_ITEM))).then(PlayerCommand.makeDropCommand("drop", false))).then(PlayerCommand.makeActionCommand("dropStack", EntityPlayerActionPack.ActionType.DROP_STACK))).then(PlayerCommand.makeDropCommand("dropStack", true))).then(PlayerCommand.makeActionCommand("swapHands", EntityPlayerActionPack.ActionType.SWAP_HANDS))).then(class_2170.method_9247((String)"hotbar").then(class_2170.method_9244((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)1, (int)9)).executes(c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, ap -> ap.setSlot(IntegerArgumentType.getInteger((CommandContext)c, (String)"slot"))))))).then(class_2170.method_9247((String)"kill").executes(PlayerCommand::kill))).then(class_2170.method_9247((String)"shadow").executes(PlayerCommand::shadow))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"mount").executes(PlayerCommand.manipulation(ap -> ap.mount(true)))).then(class_2170.method_9247((String)"anything").executes(PlayerCommand.manipulation(ap -> ap.mount(false)))))).then(class_2170.method_9247((String)"dismount").executes(PlayerCommand.manipulation(EntityPlayerActionPack::dismount)))).then(class_2170.method_9247((String)"sneak").executes(PlayerCommand.manipulation(ap -> ap.setSneaking(true))))).then(class_2170.method_9247((String)"unsneak").executes(PlayerCommand.manipulation(ap -> ap.setSneaking(false))))).then(class_2170.method_9247((String)"sprint").executes(PlayerCommand.manipulation(ap -> ap.setSprinting(true))))).then(class_2170.method_9247((String)"unsprint").executes(PlayerCommand.manipulation(ap -> ap.setSprinting(false))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"look").then(class_2170.method_9247((String)"north").executes(PlayerCommand.manipulation(ap -> ap.look(class_2350.field_11043))))).then(class_2170.method_9247((String)"south").executes(PlayerCommand.manipulation(ap -> ap.look(class_2350.field_11035))))).then(class_2170.method_9247((String)"east").executes(PlayerCommand.manipulation(ap -> ap.look(class_2350.field_11034))))).then(class_2170.method_9247((String)"west").executes(PlayerCommand.manipulation(ap -> ap.look(class_2350.field_11039))))).then(class_2170.method_9247((String)"up").executes(PlayerCommand.manipulation(ap -> ap.look(class_2350.field_11036))))).then(class_2170.method_9247((String)"down").executes(PlayerCommand.manipulation(ap -> ap.look(class_2350.field_11033))))).then(class_2170.method_9247((String)"at").then(class_2170.method_9244((String)"position", (ArgumentType)class_2277.method_9737()).executes(c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, ap -> ap.lookAt(class_2277.method_9736((CommandContext)c, (String)"position"))))))).then(class_2170.method_9244((String)"direction", (ArgumentType)class_2270.method_9717()).executes(c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, ap -> ap.look(class_2270.method_9716((CommandContext)c, (String)"direction").method_9709((class_2168)c.getSource()))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"turn").then(class_2170.method_9247((String)"left").executes(PlayerCommand.manipulation(ap -> ap.turn(-90.0f, 0.0f))))).then(class_2170.method_9247((String)"right").executes(PlayerCommand.manipulation(ap -> ap.turn(90.0f, 0.0f))))).then(class_2170.method_9247((String)"back").executes(PlayerCommand.manipulation(ap -> ap.turn(180.0f, 0.0f))))).then(class_2170.method_9244((String)"rotation", (ArgumentType)class_2270.method_9717()).executes(c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, ap -> ap.turn(class_2270.method_9716((CommandContext)c, (String)"rotation").method_9709((class_2168)c.getSource()))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"move").executes(PlayerCommand.manipulation(EntityPlayerActionPack::stopMovement))).then(class_2170.method_9247((String)"forward").executes(PlayerCommand.manipulation(ap -> ap.setForward(1.0f))))).then(class_2170.method_9247((String)"backward").executes(PlayerCommand.manipulation(ap -> ap.setForward(-1.0f))))).then(class_2170.method_9247((String)"left").executes(PlayerCommand.manipulation(ap -> ap.setStrafing(1.0f))))).then(class_2170.method_9247((String)"right").executes(PlayerCommand.manipulation(ap -> ap.setStrafing(-1.0f)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spawn").executes(PlayerCommand::spawn)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"in").requires(player -> player.method_9259(2))).then(class_2170.method_9244((String)"gamemode", (ArgumentType)class_7918.method_47383()).executes(PlayerCommand::spawn)))).then(class_2170.method_9247((String)"at").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"position", (ArgumentType)class_2277.method_9737()).executes(PlayerCommand::spawn)).then(class_2170.method_9247((String)"facing").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"direction", (ArgumentType)class_2270.method_9717()).executes(PlayerCommand::spawn)).then(class_2170.method_9247((String)"in").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(PlayerCommand::spawn)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"in").requires(player -> player.method_9259(2))).then(class_2170.method_9244((String)"gamemode", (ArgumentType)class_7918.method_47383()).executes(PlayerCommand::spawn)))))))))));
        dispatcher.register(command);
    }

    private static LiteralArgumentBuilder<class_2168> makeActionCommand(String actionName, EntityPlayerActionPack.ActionType type) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)actionName).executes(PlayerCommand.manipulation(ap -> ap.start(type, EntityPlayerActionPack.Action.once())))).then(class_2170.method_9247((String)"once").executes(PlayerCommand.manipulation(ap -> ap.start(type, EntityPlayerActionPack.Action.once()))))).then(class_2170.method_9247((String)"continuous").executes(PlayerCommand.manipulation(ap -> ap.start(type, EntityPlayerActionPack.Action.continuous()))))).then(class_2170.method_9247((String)"interval").then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, ap -> ap.start(type, EntityPlayerActionPack.Action.interval(IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks")))))));
    }

    private static LiteralArgumentBuilder<class_2168> makeDropCommand(String actionName, boolean dropAll) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)actionName).then(class_2170.method_9247((String)"all").executes(PlayerCommand.manipulation(ap -> ap.drop(-2, dropAll))))).then(class_2170.method_9247((String)"mainhand").executes(PlayerCommand.manipulation(ap -> ap.drop(-1, dropAll))))).then(class_2170.method_9247((String)"offhand").executes(PlayerCommand.manipulation(ap -> ap.drop(40, dropAll))))).then(class_2170.method_9244((String)"slot", (ArgumentType)IntegerArgumentType.integer((int)0, (int)40)).executes(c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, ap -> ap.drop(IntegerArgumentType.getInteger((CommandContext)c, (String)"slot"), dropAll))));
    }

    private static Collection<String> getPlayerSuggestions(class_2168 source) {
        LinkedHashSet<String> players = new LinkedHashSet<String>(List.of("Steve", "Alex"));
        players.addAll(source.method_9262());
        return players;
    }

    private static class_3222 getPlayer(CommandContext<class_2168> context) {
        String playerName = StringArgumentType.getString(context, (String)"player");
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        return server.method_3760().method_14566(playerName);
    }

    private static boolean cantManipulate(CommandContext<class_2168> context) {
        class_3222 player = PlayerCommand.getPlayer(context);
        class_2168 source = (class_2168)context.getSource();
        if (player == null) {
            Messenger.m(source, "r Can only manipulate existing players");
            return true;
        }
        class_3222 sender = source.method_44023();
        if (sender == null) {
            return false;
        }
        if (!source.method_9211().method_3760().method_14569(sender.method_72498()) && sender != player && !(player instanceof EntityPlayerMPFake)) {
            Messenger.m(source, "r Non OP players can't control other real players");
            return true;
        }
        return false;
    }

    private static boolean cantReMove(CommandContext<class_2168> context) {
        if (PlayerCommand.cantManipulate(context)) {
            return true;
        }
        class_3222 player = PlayerCommand.getPlayer(context);
        if (player instanceof EntityPlayerMPFake) {
            return false;
        }
        Messenger.m((class_2168)context.getSource(), "r Only fake players can be moved or killed");
        return true;
    }

    private static boolean cantSpawn(CommandContext<class_2168> context) {
        class_11560 profile;
        String playerName = StringArgumentType.getString(context, (String)"player");
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        class_3324 manager = server.method_3760();
        if (EntityPlayerMPFake.isSpawningPlayer(playerName)) {
            Messenger.m((class_2168)context.getSource(), "r Player ", "rb " + playerName, "r  is currently logging on");
            return true;
        }
        if (manager.method_14566(playerName) != null) {
            Messenger.m((class_2168)context.getSource(), "r Player ", "rb " + playerName, "r  is already logged on");
            return true;
        }
        UUID uuid = class_3321.method_14546((MinecraftServer)server, (String)playerName);
        if (uuid == null) {
            if (!CarpetSettings.allowSpawningOfflinePlayers) {
                Messenger.m((class_2168)context.getSource(), "r Player " + playerName + " is either banned by Mojang, or auth servers are down. Banned players can only be summoned in Singleplayer and in servers in off-line mode.");
                return true;
            }
            uuid = class_4844.method_43344((String)playerName);
        }
        if ((profile = (class_11560)server.method_73550().comp_4407().method_14512(uuid).orElse(null)) == null) {
            if (!CarpetSettings.allowSpawningOfflinePlayers) {
                Messenger.m((class_2168)context.getSource(), "r Player " + playerName + " is either banned by Mojang, or auth servers are down. Banned players can only be summoned in Singleplayer and in servers in off-line mode.");
                return true;
            }
            profile = new class_11560(class_4844.method_43344((String)playerName), playerName);
        }
        if (manager.method_14563().method_14650(profile)) {
            Messenger.m((class_2168)context.getSource(), "r Player ", "rb " + playerName, "r  is banned on this server");
            return true;
        }
        if (manager.method_14614() && manager.method_14587(profile) && !((class_2168)context.getSource()).method_9259(2)) {
            Messenger.m((class_2168)context.getSource(), "r Whitelisted players can only be spawned by operators");
            return true;
        }
        return false;
    }

    private static int kill(CommandContext<class_2168> context) {
        if (PlayerCommand.cantReMove(context)) {
            return 0;
        }
        class_3222 player = PlayerCommand.getPlayer(context);
        player.method_5768(player.method_51469());
        return 1;
    }

    private static <T> T getArgOrDefault(SupplierWithCSE<T> getter, T defaultValue) throws CommandSyntaxException {
        try {
            return getter.get();
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    private static int spawn(CommandContext<class_2168> context) throws CommandSyntaxException {
        if (PlayerCommand.cantSpawn(context)) {
            return 0;
        }
        class_2168 source = (class_2168)context.getSource();
        class_243 pos = PlayerCommand.getArgOrDefault(() -> class_2277.method_9736((CommandContext)context, (String)"position"), source.method_9222());
        class_241 facing = PlayerCommand.getArgOrDefault(() -> class_2270.method_9716((CommandContext)context, (String)"direction").method_9709(source), source.method_9210());
        class_5321 dimType = PlayerCommand.getArgOrDefault(() -> class_2181.method_9289((CommandContext)context, (String)"dimension").method_27983(), source.method_9225().method_27983());
        class_1934 mode = class_1934.field_9220;
        boolean flying = false;
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 sender = (class_3222)class_12972;
            mode = sender.field_13974.method_14257();
            flying = sender.method_31549().field_7479;
        }
        try {
            mode = class_7918.method_47385(context, (String)"gamemode");
        }
        catch (IllegalArgumentException sender) {
            // empty catch block
        }
        if (mode == class_1934.field_9219) {
            flying = true;
        } else if (mode.method_8388()) {
            flying = false;
        }
        String playerName = StringArgumentType.getString(context, (String)"player");
        if (playerName.length() > PlayerCommand.maxNameLength(source.method_9211())) {
            Messenger.m(source, "rb Player name: " + playerName + " is too long");
            return 0;
        }
        if (!class_1937.method_25953((class_2338)class_2338.method_49638((class_2374)pos))) {
            Messenger.m(source, "rb Player " + playerName + " cannot be placed outside of the world");
            return 0;
        }
        boolean success = EntityPlayerMPFake.createFake(playerName, source.method_9211(), pos, facing.field_1342, facing.field_1343, (class_5321<class_1937>)dimType, mode, flying);
        if (!success) {
            Messenger.m(source, "rb Player " + playerName + " doesn't exist and cannot spawn in online mode. Turn the server offline or the allowSpawningOfflinePlayers on to spawn non-existing players");
            return 0;
        }
        return 1;
    }

    private static int maxNameLength(MinecraftServer server) {
        return server.method_3756() >= 0 ? 16 : 40;
    }

    private static int manipulate(CommandContext<class_2168> context, Consumer<EntityPlayerActionPack> action) {
        if (PlayerCommand.cantManipulate(context)) {
            return 0;
        }
        class_3222 player = PlayerCommand.getPlayer(context);
        action.accept(((ServerPlayerInterface)player).getActionPack());
        return 1;
    }

    private static Command<class_2168> manipulation(Consumer<EntityPlayerActionPack> action) {
        return c -> PlayerCommand.manipulate((CommandContext<class_2168>)c, action);
    }

    private static int shadow(CommandContext<class_2168> context) {
        if (PlayerCommand.cantManipulate(context)) {
            return 0;
        }
        class_3222 player = PlayerCommand.getPlayer(context);
        if (player instanceof EntityPlayerMPFake) {
            Messenger.m((class_2168)context.getSource(), "r Cannot shadow fake players");
            return 0;
        }
        if (player.method_51469().method_8503().method_19466(player.method_72498())) {
            Messenger.m((class_2168)context.getSource(), "r Cannot shadow single-player server owner");
            return 0;
        }
        EntityPlayerMPFake.createShadow(player.method_51469().method_8503(), player);
        return 1;
    }

    @FunctionalInterface
    static interface SupplierWithCSE<T> {
        public T get() throws CommandSyntaxException;
    }
}

