/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.CarpetScriptHost;
import carpet.script.CarpetScriptServer;
import carpet.script.Context;
import carpet.script.exception.IntegrityException;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.InvalidCallbackException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.external.Vanilla;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.FunctionValue;
import carpet.script.value.MapValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import com.mojang.serialization.DynamicOps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1704;
import net.minecraft.class_1706;
import net.minecraft.class_1707;
import net.minecraft.class_1708;
import net.minecraft.class_1712;
import net.minecraft.class_1713;
import net.minecraft.class_1714;
import net.minecraft.class_1718;
import net.minecraft.class_1720;
import net.minecraft.class_1722;
import net.minecraft.class_1726;
import net.minecraft.class_1728;
import net.minecraft.class_1733;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3705;
import net.minecraft.class_3706;
import net.minecraft.class_3803;
import net.minecraft.class_3858;
import net.minecraft.class_3908;
import net.minecraft.class_3910;
import net.minecraft.class_3913;
import net.minecraft.class_3915;
import net.minecraft.class_3916;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import net.minecraft.class_3971;
import net.minecraft.class_4862;
import net.minecraft.class_5455;
import net.minecraft.class_747;
import net.minecraft.class_8786;

public class ScreenValue
extends Value {
    private class_1703 screenHandler;
    private ScreenHandlerInventory inventory;
    private final class_2561 name;
    private final String typestring;
    private final FunctionValue callback;
    private final String hostname;
    private final class_3222 player;
    private final CarpetScriptServer scriptServer;
    public static Map<String, ScarpetScreenHandlerFactory> screenHandlerFactories = new HashMap<String, ScarpetScreenHandlerFactory>();

    public ScreenValue(class_3222 player, String type, class_2561 name, @Nullable FunctionValue callback, Context c) {
        this.name = name;
        this.typestring = type.toLowerCase();
        if (callback != null) {
            callback.checkArgs(4);
        }
        this.callback = callback;
        this.hostname = c.host.getName();
        this.scriptServer = (CarpetScriptServer)c.host.scriptServer();
        this.player = player;
        class_3908 factory = this.createScreenHandlerFactory();
        if (factory == null) {
            throw new ThrowStatement(type, Throwables.UNKNOWN_SCREEN);
        }
        this.openScreen(factory);
        this.inventory = new ScreenHandlerInventory(this.screenHandler);
    }

    private class_3908 createScreenHandlerFactory() {
        if (!screenHandlerFactories.containsKey(this.typestring)) {
            return null;
        }
        return new class_747((i, playerInventory, playerEntity) -> {
            class_1703 screen = screenHandlerFactories.get(this.typestring).create(i, playerInventory);
            this.addListenerCallback(screen);
            this.screenHandler = screen;
            return screen;
        }, this.name);
    }

    private void openScreen(class_3908 factory) {
        if (this.player == null) {
            return;
        }
        OptionalInt optionalSyncId = this.player.method_17355(factory);
        if (optionalSyncId.isPresent() && this.player.field_7512.field_7763 == optionalSyncId.getAsInt()) {
            this.screenHandler = this.player.field_7512;
        }
    }

    public void close() {
        if (this.player.field_7512 != this.player.field_7498) {
            this.inventory = null;
            this.player.field_7512 = this.player.field_7498;
            this.player.method_7346();
            this.screenHandler = null;
        }
    }

    public boolean isOpen() {
        if (this.screenHandler == null) {
            return false;
        }
        if (this.player.field_7512.field_7763 == this.screenHandler.field_7763) {
            return true;
        }
        this.screenHandler = null;
        return false;
    }

    private boolean callListener(class_3222 player, String action, Map<Value, Value> data) {
        Value playerValue = EntityValue.of((class_1297)player);
        Value actionValue = StringValue.of(action);
        MapValue dataValue = MapValue.wrap(data);
        List<Value> args = Arrays.asList(this, playerValue, actionValue, dataValue);
        CarpetScriptHost appHost = this.scriptServer.getAppHostByName(this.hostname);
        if (appHost == null) {
            this.close();
            this.screenHandler = null;
            return false;
        }
        int runPermissionLevel = Vanilla.MinecraftServer_getRunPermissionLevel(player.method_51469().method_8503());
        class_2168 source = player.method_64396().method_9206(runPermissionLevel);
        CarpetScriptHost executingHost = appHost.retrieveForExecution(source, player);
        try {
            Value cancelValue = executingHost.callUDF(source, this.callback, args);
            return cancelValue.getString().equals("cancel");
        }
        catch (IntegrityException | InvalidCallbackException | NullPointerException error) {
            CarpetScriptServer.LOG.error("Got exception when running screen event call ", (Throwable)error);
            return false;
        }
    }

    private void addListenerCallback(class_1703 screenHandler) {
        if (this.callback == null) {
            return;
        }
        screenHandler.method_7596((class_1712)new ScarpetScreenHandlerListener(){

            @Override
            public boolean onSlotClick(class_3222 player, class_1713 actionType, int slot, int button) {
                HashMap<Value, Value> data = new HashMap<Value, Value>();
                data.put(StringValue.of("slot"), slot == -999 ? Value.NULL : NumericValue.of(slot));
                if (actionType == class_1713.field_7789) {
                    data.put(StringValue.of("quick_craft_stage"), NumericValue.of(class_1703.method_7594((int)button)));
                    button = class_1703.method_7620((int)button);
                }
                data.put(StringValue.of("button"), NumericValue.of(button));
                return ScreenValue.this.callListener(player, ScreenValue.actionTypeToString(actionType), data);
            }

            @Override
            public boolean onButtonClick(class_3222 player, int button) {
                HashMap<Value, Value> data = new HashMap<Value, Value>();
                data.put(StringValue.of("button"), NumericValue.of(button));
                return ScreenValue.this.callListener(player, "button", data);
            }

            @Override
            public void onClose(class_3222 player) {
                HashMap<Value, Value> data = new HashMap<Value, Value>();
                ScreenValue.this.callListener(player, "close", data);
            }

            @Override
            public boolean onSelectRecipe(class_3222 player, class_8786<?> recipe, boolean craftAll) {
                HashMap<Value, Value> data = new HashMap<Value, Value>();
                data.put(StringValue.of("recipe"), ValueConversions.of(recipe.comp_1932()));
                data.put(StringValue.of("craft_all"), BooleanValue.of(craftAll));
                return ScreenValue.this.callListener(player, "select_recipe", data);
            }

            public void method_7635(class_1703 handler, int slotId, class_1799 stack) {
                HashMap<Value, Value> data = new HashMap<Value, Value>();
                data.put(StringValue.of("slot"), NumericValue.of(slotId));
                data.put(StringValue.of("stack"), ValueConversions.of(stack, ScreenValue.this.player.method_51469().method_30349()));
                ScreenValue.this.callListener(ScreenValue.this.player, "slot_update", data);
            }

            public void method_7633(class_1703 handler, int property, int value) {
            }
        });
    }

    private class_3915 getPropertyForType(Class<? extends class_1703> screenHandlerClass, String requiredType, int propertyIndex, String propertyName) {
        if (screenHandlerClass.isInstance(this.screenHandler)) {
            return Vanilla.AbstractContainerMenu_getDataSlot(this.screenHandler, propertyIndex);
        }
        if (!this.isOpen()) {
            throw new InternalExpressionException("Screen property cannot be accessed, because the screen is already closed");
        }
        throw new InternalExpressionException("Screen property " + propertyName + " expected a " + requiredType + " screen.");
    }

    private class_3915 getProperty(String propertyName) {
        return switch (propertyName) {
            case "fuel_progress" -> this.getPropertyForType(class_1720.class, "furnace", 0, propertyName);
            case "max_fuel_progress" -> this.getPropertyForType(class_1720.class, "furnace", 1, propertyName);
            case "cook_progress" -> this.getPropertyForType(class_1720.class, "furnace", 2, propertyName);
            case "max_cook_progress" -> this.getPropertyForType(class_1720.class, "furnace", 3, propertyName);
            case "level_cost" -> this.getPropertyForType(class_1706.class, "anvil", 0, propertyName);
            case "page" -> this.getPropertyForType(class_3916.class, "lectern", 0, propertyName);
            case "beacon_level" -> this.getPropertyForType(class_1704.class, "beacon", 0, propertyName);
            case "primary_effect" -> this.getPropertyForType(class_1704.class, "beacon", 1, propertyName);
            case "secondary_effect" -> this.getPropertyForType(class_1704.class, "beacon", 2, propertyName);
            case "brew_time" -> this.getPropertyForType(class_1708.class, "brewing_stand", 0, propertyName);
            case "brewing_fuel" -> this.getPropertyForType(class_1708.class, "brewing_stand", 1, propertyName);
            case "enchantment_power_1" -> this.getPropertyForType(class_1718.class, "enchantment", 0, propertyName);
            case "enchantment_power_2" -> this.getPropertyForType(class_1718.class, "enchantment", 1, propertyName);
            case "enchantment_power_3" -> this.getPropertyForType(class_1718.class, "enchantment", 2, propertyName);
            case "enchantment_seed" -> this.getPropertyForType(class_1718.class, "enchantment", 3, propertyName);
            case "enchantment_id_1" -> this.getPropertyForType(class_1718.class, "enchantment", 4, propertyName);
            case "enchantment_id_2" -> this.getPropertyForType(class_1718.class, "enchantment", 5, propertyName);
            case "enchantment_id_3" -> this.getPropertyForType(class_1718.class, "enchantment", 6, propertyName);
            case "enchantment_level_1" -> this.getPropertyForType(class_1718.class, "enchantment", 7, propertyName);
            case "enchantment_level_2" -> this.getPropertyForType(class_1718.class, "enchantment", 8, propertyName);
            case "enchantment_level_3" -> this.getPropertyForType(class_1718.class, "enchantment", 9, propertyName);
            case "banner_pattern" -> this.getPropertyForType(class_1726.class, "loom", 0, propertyName);
            case "stonecutter_recipe" -> this.getPropertyForType(class_3971.class, "stonecutter", 0, propertyName);
            default -> throw new InternalExpressionException("Invalid screen property: " + propertyName);
        };
    }

    public Value queryProperty(String propertyName) {
        if (propertyName.equals("name")) {
            return FormattedTextValue.of(this.name);
        }
        if (propertyName.equals("open")) {
            return BooleanValue.of(this.isOpen());
        }
        class_3915 property = this.getProperty(propertyName);
        return NumericValue.of(property.method_17407());
    }

    public Value modifyProperty(String propertyName, List<Value> lv) {
        class_3915 property = this.getProperty(propertyName);
        int intValue = NumericValue.asNumber(lv.get(0)).getInt();
        property.method_17404(intValue);
        this.screenHandler.method_7623();
        return Value.TRUE;
    }

    public class_3222 getPlayer() {
        return this.player;
    }

    public class_1263 getInventory() {
        return this.inventory;
    }

    @Override
    public String getString() {
        return this.typestring + "_screen";
    }

    @Override
    public boolean getBoolean() {
        return this.isOpen();
    }

    @Override
    public String getTypeString() {
        return "screen";
    }

    @Override
    public class_2520 toTag(boolean force, class_5455 regs) {
        if (this.screenHandler == null) {
            return Value.NULL.toTag(true, regs);
        }
        class_2499 nbtList = new class_2499();
        for (int i = 0; i < this.screenHandler.field_7761.size(); ++i) {
            class_1799 itemStack = this.screenHandler.method_7611(i).method_7677();
            if (itemStack.method_7960()) {
                nbtList.add((Object)new class_2487());
                continue;
            }
            nbtList.add((Object)((class_2520)class_1799.field_24671.encodeStart((DynamicOps)regs.method_57093((DynamicOps)class_2509.field_11560), (Object)itemStack).getOrThrow(InternalExpressionException::new)));
        }
        return nbtList;
    }

    private static String actionTypeToString(class_1713 actionType) {
        return switch (actionType) {
            default -> throw new MatchException(null, null);
            case class_1713.field_7790 -> "pickup";
            case class_1713.field_7794 -> "quick_move";
            case class_1713.field_7791 -> "swap";
            case class_1713.field_7796 -> "clone";
            case class_1713.field_7795 -> "throw";
            case class_1713.field_7789 -> "quick_craft";
            case class_1713.field_7793 -> "pickup_all";
        };
    }

    static {
        screenHandlerFactories.put("anvil", class_1706::new);
        screenHandlerFactories.put("beacon", class_1704::new);
        screenHandlerFactories.put("blast_furnace", class_3705::new);
        screenHandlerFactories.put("brewing_stand", (syncId, playerInventory) -> new class_1708(syncId, playerInventory, (class_1263)new class_1277(5), (class_3913)new class_3919(2)));
        screenHandlerFactories.put("cartography_table", class_3910::new);
        screenHandlerFactories.put("crafting", class_1714::new);
        screenHandlerFactories.put("enchantment", class_1718::new);
        screenHandlerFactories.put("furnace", class_3858::new);
        screenHandlerFactories.put("generic_3x3", (syncId, playerInventory) -> new class_1707(class_3917.field_17328, syncId, playerInventory, (class_1263)new class_1277(9), 1));
        screenHandlerFactories.put("generic_9x1", (syncId, playerInventory) -> new class_1707(class_3917.field_18664, syncId, playerInventory, (class_1263)new class_1277(9), 1));
        screenHandlerFactories.put("generic_9x2", (syncId, playerInventory) -> new class_1707(class_3917.field_18665, syncId, playerInventory, (class_1263)new class_1277(18), 2));
        screenHandlerFactories.put("generic_9x3", (syncId, playerInventory) -> new class_1707(class_3917.field_17326, syncId, playerInventory, (class_1263)new class_1277(27), 3));
        screenHandlerFactories.put("generic_9x4", (syncId, playerInventory) -> new class_1707(class_3917.field_18666, syncId, playerInventory, (class_1263)new class_1277(36), 4));
        screenHandlerFactories.put("generic_9x5", (syncId, playerInventory) -> new class_1707(class_3917.field_18667, syncId, playerInventory, (class_1263)new class_1277(45), 5));
        screenHandlerFactories.put("generic_9x6", (syncId, playerInventory) -> new class_1707(class_3917.field_17327, syncId, playerInventory, (class_1263)new class_1277(54), 6));
        screenHandlerFactories.put("grindstone", class_3803::new);
        screenHandlerFactories.put("hopper", class_1722::new);
        screenHandlerFactories.put("lectern", (syncId, playerInventory) -> new class_3916(syncId, (class_1263)new class_1277(1), (class_3913)new class_3919(1)));
        screenHandlerFactories.put("loom", class_1726::new);
        screenHandlerFactories.put("merchant", class_1728::new);
        screenHandlerFactories.put("shulker_box", (syncId, playerInventory) -> new class_1733(syncId, playerInventory, (class_1263)new class_1277(27)));
        screenHandlerFactories.put("smithing", class_4862::new);
        screenHandlerFactories.put("smoker", class_3706::new);
        screenHandlerFactories.put("stonecutter", class_3971::new);
    }

    public static class ScreenHandlerInventory
    implements class_1263 {
        protected class_1703 screenHandler;

        public ScreenHandlerInventory(class_1703 screenHandler) {
            this.screenHandler = screenHandler;
        }

        public int method_5439() {
            return this.screenHandler.field_7761.size() + 1;
        }

        public boolean method_5442() {
            for (class_1735 slot : this.screenHandler.field_7761) {
                if (!slot.method_7681() || slot.method_7677().method_7960()) continue;
                return false;
            }
            return this.screenHandler.method_34255().method_7960();
        }

        public class_1799 method_5438(int slot) {
            if (slot == this.method_5439() - 1) {
                return this.screenHandler.method_34255();
            }
            return slot >= -1 && slot < this.method_5439() ? ((class_1735)this.screenHandler.field_7761.get(slot)).method_7677() : class_1799.field_8037;
        }

        public class_1799 method_5434(int slot, int amount) {
            class_1799 itemStack = slot == this.method_5439() - 1 ? this.screenHandler.method_34255().method_7971(amount) : ScreenHandlerInventory.splitStack((List<class_1735>)this.screenHandler.field_7761, slot, amount);
            if (!itemStack.method_7960()) {
                this.method_5431();
            }
            return itemStack;
        }

        public class_1799 method_5441(int slot) {
            class_1799 itemStack = slot == this.method_5439() - 1 ? this.screenHandler.method_34255() : ((class_1735)this.screenHandler.field_7761.get(slot)).method_7677();
            if (itemStack.method_7960()) {
                return class_1799.field_8037;
            }
            if (slot == this.method_5439() - 1) {
                this.screenHandler.method_34254(class_1799.field_8037);
            } else {
                ((class_1735)this.screenHandler.field_7761.get(slot)).method_7673(class_1799.field_8037);
            }
            return itemStack;
        }

        public void method_5447(int slot, class_1799 stack) {
            if (slot == this.method_5439() - 1) {
                this.screenHandler.method_34254(stack);
            } else {
                ((class_1735)this.screenHandler.field_7761.get(slot)).method_7673(stack);
            }
            if (!stack.method_7960() && stack.method_7947() > this.method_5444()) {
                stack.method_7939(this.method_5444());
            }
            this.method_5431();
        }

        public void method_5431() {
        }

        public boolean method_5443(class_1657 player) {
            return true;
        }

        public void method_5448() {
            for (class_1735 slot : this.screenHandler.field_7761) {
                slot.method_7673(class_1799.field_8037);
            }
            this.screenHandler.method_34254(class_1799.field_8037);
            this.method_5431();
        }

        public static class_1799 splitStack(List<class_1735> slots, int slot, int amount) {
            return slot >= 0 && slot < slots.size() && !slots.get(slot).method_7677().method_7960() && amount > 0 ? slots.get(slot).method_7677().method_7971(amount) : class_1799.field_8037;
        }
    }

    protected static interface ScarpetScreenHandlerFactory {
        public class_1703 create(int var1, class_1661 var2);
    }

    public static interface ScarpetScreenHandlerListener
    extends class_1712 {
        public boolean onSlotClick(class_3222 var1, class_1713 var2, int var3, int var4);

        public boolean onButtonClick(class_3222 var1, int var2);

        public void onClose(class_3222 var1);

        public boolean onSelectRecipe(class_3222 var1, class_8786<?> var2, boolean var3);
    }
}

