/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.script.CarpetScriptServer;
import carpet.script.Context;
import carpet.script.Fluff;
import carpet.script.LazyValue;
import carpet.script.Module;
import carpet.script.Token;
import carpet.script.Tokenizer;
import carpet.script.exception.BreakStatement;
import carpet.script.exception.ContinueStatement;
import carpet.script.exception.ExitStatement;
import carpet.script.exception.ExpressionException;
import carpet.script.exception.IntegrityException;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ResolvedException;
import carpet.script.exception.ReturnStatement;
import carpet.script.language.Arithmetic;
import carpet.script.language.ControlFlow;
import carpet.script.language.DataStructures;
import carpet.script.language.Functions;
import carpet.script.language.Loops;
import carpet.script.language.Operators;
import carpet.script.language.Sys;
import carpet.script.language.Threading;
import carpet.script.value.FunctionValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import it.unimi.dsi.fastutil.Stack;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class Expression {
    private String expression;
    private boolean allowNewlineSubstitutions = true;
    private boolean allowComments = false;
    @Nullable
    public Module module = null;
    @Nullable
    private LazyValue ast = null;
    @Nullable
    private ExpressionNode root = null;
    private final Map<String, Fluff.ILazyOperator> operators = new Object2ObjectOpenHashMap();
    private final Map<String, Fluff.ILazyFunction> functions = new Object2ObjectOpenHashMap();
    private final Map<String, String> functionalEquivalence = new Object2ObjectOpenHashMap();
    private final Map<String, String> functionalAliases = new Object2ObjectOpenHashMap();
    private final Map<String, Value> constants = Map.of("euler", Arithmetic.euler, "pi", Arithmetic.PI, "null", Value.NULL, "true", Value.TRUE, "false", Value.FALSE);
    public static final Expression none = new Expression("null");

    String getCodeString() {
        return this.expression;
    }

    public String getModuleName() {
        return this.module == null ? "system chat" : this.module.name();
    }

    public void asATextSource() {
        this.allowNewlineSubstitutions = false;
        this.allowComments = true;
    }

    public void asAModule(@Nullable Module mi) {
        this.module = mi;
    }

    public boolean isAnOperator(String opname) {
        return this.operators.containsKey(opname) || this.operators.containsKey(opname + "u");
    }

    public Set<String> getFunctionNames() {
        return this.functions.keySet();
    }

    private void addFunctionalEquivalence(String operator, String function) {
        assert (this.operators.containsKey(operator));
        assert (this.functions.containsKey(function));
        this.functionalEquivalence.put(operator, function);
        this.functionalAliases.put(operator, function);
    }

    private void addFunctionalAlias(String operator, String function) {
        assert (this.operators.containsKey(operator));
        assert (this.functions.containsKey(function));
        this.functionalAliases.put(operator, function);
    }

    protected Value getConstantFor(String surface) {
        return this.constants.get(surface);
    }

    public List<String> getExpressionSnippet(Token token) {
        String code = this.getCodeString();
        ArrayList<String> output = new ArrayList<String>(Expression.getExpressionSnippetLeftContext(token, code, 1));
        List<String> context = Expression.getExpressionSnippetContext(token, code);
        output.add(context.get(0) + " HERE>> " + context.get(1));
        output.addAll(Expression.getExpressionSnippetRightContext(token, code, 1));
        return output;
    }

    private static List<String> getExpressionSnippetLeftContext(Token token, String expr, int contextsize) {
        ArrayList<String> output = new ArrayList<String>();
        String[] lines = expr.split("\n");
        if (lines.length == 1) {
            return output;
        }
        for (int lno = token.lineno - 1; lno >= 0 && output.size() < contextsize; --lno) {
            output.add(lines[lno]);
        }
        Collections.reverse(output);
        return output;
    }

    private static List<String> getExpressionSnippetContext(Token token, String expr) {
        ArrayList<String> output = new ArrayList<String>();
        String[] lines = expr.split("\n");
        if (lines.length > 1) {
            output.add(lines[token.lineno].substring(0, token.linepos));
            output.add(lines[token.lineno].substring(token.linepos));
        } else {
            output.add(expr.substring(Math.max(0, token.pos - 40), token.pos));
            output.add(expr.substring(token.pos, Math.min(token.pos + 1 + 40, expr.length())));
        }
        return output;
    }

    private static List<String> getExpressionSnippetRightContext(Token token, String expr, int contextsize) {
        ArrayList<String> output = new ArrayList<String>();
        String[] lines = expr.split("\n");
        if (lines.length == 1) {
            return output;
        }
        for (int lno = token.lineno + 1; lno < lines.length && output.size() < contextsize; ++lno) {
            output.add(lines[lno]);
        }
        return output;
    }

    public void addLazyUnaryOperator(String surface, String function, int precedence, boolean leftAssoc, final boolean pure, final Function<Context.Type, Context.Type> staticTyper, final Fluff.TriFunction<Context, Context.Type, LazyValue, LazyValue> lazyfun) {
        this.operators.put(surface + "u", new Fluff.AbstractLazyOperator(this, precedence, leftAssoc){

            @Override
            public boolean pure() {
                return pure;
            }

            @Override
            public boolean transitive() {
                return false;
            }

            @Override
            public Context.Type staticType(Context.Type outerType) {
                return (Context.Type)((Object)staticTyper.apply(outerType));
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type t, Expression e, Token token, LazyValue v, LazyValue v2) {
                try {
                    return (LazyValue)lazyfun.apply(c, t, v);
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, token);
                }
            }
        });
        this.functions.put(function, new Fluff.AbstractLazyFunction(this, 1, function){

            @Override
            public boolean pure() {
                return pure;
            }

            @Override
            public boolean transitive() {
                return false;
            }

            @Override
            public Context.Type staticType(Context.Type outerType) {
                return (Context.Type)((Object)staticTyper.apply(outerType));
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type t, Expression e, Token token, List<LazyValue> v) {
                try {
                    return (LazyValue)lazyfun.apply(c, t, v.get(0));
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, token);
                }
            }
        });
        this.addFunctionalAlias(surface + "u", function);
    }

    public void addLazyBinaryOperatorWithDelegation(String surface, String function, int precedence, boolean leftAssoc, final boolean pure, final Fluff.SexFunction<Context, Context.Type, Expression, Token, LazyValue, LazyValue, LazyValue> lazyfun) {
        this.operators.put(surface, new Fluff.AbstractLazyOperator(this, precedence, leftAssoc){

            @Override
            public boolean pure() {
                return pure;
            }

            @Override
            public boolean transitive() {
                return false;
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type type, Expression e, Token t, LazyValue v1, LazyValue v2) {
                try {
                    return (LazyValue)lazyfun.apply(c, type, e, t, v1, v2);
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, t);
                }
            }
        });
        this.functions.put(function, new Fluff.AbstractLazyFunction(this, 2, function){

            @Override
            public boolean pure() {
                return pure;
            }

            @Override
            public boolean transitive() {
                return false;
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type type, Expression e, Token t, List<LazyValue> v) {
                try {
                    return (LazyValue)lazyfun.apply(c, type, e, t, v.get(0), v.get(1));
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, t);
                }
            }
        });
        this.addFunctionalAlias(surface, function);
    }

    public void addCustomFunction(String name, Fluff.ILazyFunction fun) {
        this.functions.put(name, fun);
    }

    public void addLazyFunctionWithDelegation(String name, int numpar, final boolean pure, final boolean transitive, final Fluff.QuinnFunction<Context, Context.Type, Expression, Token, List<LazyValue>, LazyValue> lazyfun) {
        this.functions.put(name, new Fluff.AbstractLazyFunction(this, numpar, name){

            @Override
            public boolean pure() {
                return pure;
            }

            @Override
            public boolean transitive() {
                return transitive;
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type type, Expression e, Token t, List<LazyValue> lv) {
                Fluff.ILazyFunction.checkInterrupts();
                try {
                    return (LazyValue)lazyfun.apply(c, type, e, t, lv);
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, t);
                }
            }
        });
    }

    public void addFunctionWithDelegation(String name, int numpar, final boolean pure, final boolean transitive, final Fluff.QuinnFunction<Context, Context.Type, Expression, Token, List<Value>, Value> fun) {
        this.functions.put(name, new Fluff.AbstractLazyFunction(this, numpar, name){

            @Override
            public boolean pure() {
                return pure;
            }

            @Override
            public boolean transitive() {
                return transitive;
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type type, Expression e, Token t, List<LazyValue> lv) {
                try {
                    Value res = (Value)fun.apply(c, type, e, t, this.unpackArgs(lv, c, Context.NONE));
                    return (cc, tt) -> res;
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, t);
                }
            }
        });
    }

    public void addLazyBinaryOperator(String surface, String function, int precedence, boolean leftAssoc, final boolean pure, final Function<Context.Type, Context.Type> typer, final Fluff.QuadFunction<Context, Context.Type, LazyValue, LazyValue, LazyValue> lazyfun, final Fluff.TriFunction<Context, Context.Type, List<LazyValue>, LazyValue> multiFun) {
        this.operators.put(surface, new Fluff.AbstractLazyOperator(this, precedence, leftAssoc){

            @Override
            public boolean pure() {
                return pure;
            }

            @Override
            public boolean transitive() {
                return false;
            }

            @Override
            public Context.Type staticType(Context.Type outerType) {
                return (Context.Type)((Object)typer.apply(outerType));
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type t, Expression e, Token token, LazyValue v1, LazyValue v2) {
                Fluff.ILazyFunction.checkInterrupts();
                try {
                    return (LazyValue)lazyfun.apply(c, t, v1, v2);
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, token);
                }
            }
        });
        this.functions.put(function, new Fluff.AbstractLazyFunction(this, -1, function){

            @Override
            public boolean pure() {
                return true;
            }

            @Override
            public boolean transitive() {
                return false;
            }

            @Override
            public Context.Type staticType(Context.Type outerType) {
                return (Context.Type)((Object)typer.apply(outerType));
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type i, Expression e, Token t, List<LazyValue> lazyParams) {
                Fluff.ILazyFunction.checkInterrupts();
                try {
                    return (LazyValue)multiFun.apply(c, i, lazyParams);
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, t);
                }
            }
        });
        this.addFunctionalEquivalence(surface, function);
    }

    public void addLazyBinaryOperator(String surface, String function, int precedence, boolean leftAssoc, final boolean pure, final Function<Context.Type, Context.Type> typer, final Fluff.QuadFunction<Context, Context.Type, LazyValue, LazyValue, LazyValue> lazyfun) {
        this.operators.put(surface, new Fluff.AbstractLazyOperator(this, precedence, leftAssoc){

            @Override
            public boolean pure() {
                return pure;
            }

            @Override
            public boolean transitive() {
                return false;
            }

            @Override
            public Context.Type staticType(Context.Type outerType) {
                return (Context.Type)((Object)typer.apply(outerType));
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type t, Expression e, Token token, LazyValue v1, LazyValue v2) {
                Fluff.ILazyFunction.checkInterrupts();
                try {
                    return (LazyValue)lazyfun.apply(c, t, v1, v2);
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, token);
                }
            }
        });
        this.functions.put(function, new Fluff.AbstractLazyFunction(this, 2, function){

            @Override
            public boolean pure() {
                return pure;
            }

            @Override
            public boolean transitive() {
                return false;
            }

            @Override
            public Context.Type staticType(Context.Type outerType) {
                return (Context.Type)((Object)typer.apply(outerType));
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type t, Expression e, Token token, List<LazyValue> v) {
                try {
                    return (LazyValue)lazyfun.apply(c, t, v.get(0), v.get(1));
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, token);
                }
            }
        });
        this.addFunctionalAlias(surface, function);
    }

    public void addBinaryContextOperator(String surface, String function, int precedence, boolean leftAssoc, final boolean pure, final boolean transitive, final Fluff.QuadFunction<Context, Context.Type, Value, Value, Value> fun) {
        this.operators.put(surface, new Fluff.AbstractLazyOperator(this, precedence, leftAssoc){

            @Override
            public boolean pure() {
                return pure;
            }

            @Override
            public boolean transitive() {
                return transitive;
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type t, Expression e, Token token, LazyValue v1, LazyValue v2) {
                try {
                    Value ret = (Value)fun.apply(c, t, v1.evalValue(c, Context.NONE), v2.evalValue(c, Context.NONE));
                    return (cc, tt) -> ret;
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, token);
                }
            }
        });
        this.functions.put(function, new Fluff.AbstractLazyFunction(this, 2, function){

            @Override
            public boolean pure() {
                return pure;
            }

            @Override
            public boolean transitive() {
                return transitive;
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type t, Expression e, Token token, List<LazyValue> v) {
                try {
                    Value ret = (Value)fun.apply(c, t, v.get(0).evalValue(c, Context.NONE), v.get(1).evalValue(c, Context.NONE));
                    return (cc, tt) -> ret;
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, token);
                }
            }
        });
        this.addFunctionalAlias(surface, function);
    }

    public static RuntimeException handleCodeException(Context c, RuntimeException exc, Expression e, Token token) {
        if (exc instanceof ExitStatement) {
            return exc;
        }
        if (exc instanceof IntegrityException) {
            return exc;
        }
        if (exc instanceof InternalExpressionException) {
            InternalExpressionException iee = (InternalExpressionException)exc;
            return iee.promote(c, e, token);
        }
        if (exc instanceof ArithmeticException) {
            return new ExpressionException(c, e, token, "Your math is wrong, " + exc.getMessage());
        }
        if (exc instanceof ResolvedException) {
            return exc;
        }
        CarpetScriptServer.LOG.error("Unexpected exception while running Scarpet code", (Throwable)exc);
        return new ExpressionException(c, e, token, "Internal error (please report this issue to Carpet) while evaluating: " + String.valueOf(exc));
    }

    public void addUnaryOperator(String surface, String function, boolean leftAssoc, final Function<Value, Value> fun) {
        this.operators.put(surface + "u", new Fluff.AbstractUnaryOperator(this, Operators.precedence.get("unary+-!..."), leftAssoc){

            @Override
            public Value evalUnary(Value v1) {
                return (Value)fun.apply(v1);
            }
        });
        this.functions.put(function, new Fluff.AbstractFunction(this, 1, function){

            @Override
            public Value eval(List<Value> v1) {
                return (Value)fun.apply(v1.get(0));
            }
        });
        this.addFunctionalAlias(surface + "u", function);
    }

    public void addBinaryOperator(String surface, String function, int precedence, boolean leftAssoc, final BiFunction<Value, Value, Value> fun, final Function<List<Value>, Value> multiFun) {
        this.operators.put(surface, new Fluff.AbstractOperator(this, precedence, leftAssoc){

            @Override
            public Value eval(Value v1, Value v2) {
                return (Value)fun.apply(v1, v2);
            }
        });
        this.functions.put(function, new Fluff.AbstractFunction(this, -1, function){

            @Override
            public Value eval(List<Value> parameters) {
                return (Value)multiFun.apply(parameters);
            }
        });
        this.addFunctionalEquivalence(surface, function);
    }

    public void addBinaryOperator(String surface, String name, int precedence, boolean leftAssoc, final BiFunction<Value, Value, Value> fun) {
        this.operators.put(surface, new Fluff.AbstractOperator(this, precedence, leftAssoc){

            @Override
            public Value eval(Value v1, Value v2) {
                return (Value)fun.apply(v1, v2);
            }
        });
        this.functions.put(name, new Fluff.AbstractFunction(this, 2, name){

            @Override
            public Value eval(List<Value> parameters) {
                return (Value)fun.apply(parameters.get(0), parameters.get(1));
            }
        });
        this.addFunctionalAlias(surface, name);
    }

    public void addUnaryFunction(String name, final Function<Value, Value> fun) {
        this.functions.put(name, new Fluff.AbstractFunction(this, 1, name){

            @Override
            public Value eval(List<Value> parameters) {
                return (Value)fun.apply(parameters.get(0));
            }
        });
    }

    public void addImpureUnaryFunction(String name, final Function<Value, Value> fun) {
        this.functions.put(name, new Fluff.AbstractFunction(this, 1, name){

            @Override
            public boolean pure() {
                return false;
            }

            @Override
            public Value eval(List<Value> parameters) {
                return (Value)fun.apply(parameters.get(0));
            }
        });
    }

    public void addBinaryFunction(String name, final BiFunction<Value, Value, Value> fun) {
        this.functions.put(name, new Fluff.AbstractFunction(this, 2, name){

            @Override
            public Value eval(List<Value> parameters) {
                return (Value)fun.apply(parameters.get(0), parameters.get(1));
            }
        });
    }

    public void addFunction(String name, final Function<List<Value>, Value> fun) {
        this.functions.put(name, new Fluff.AbstractFunction(this, -1, name){

            @Override
            public Value eval(List<Value> parameters) {
                return (Value)fun.apply(parameters);
            }
        });
    }

    public void addImpureFunction(String name, final Function<List<Value>, Value> fun) {
        this.functions.put(name, new Fluff.AbstractFunction(this, -1, name){

            @Override
            public boolean pure() {
                return false;
            }

            @Override
            public Value eval(List<Value> parameters) {
                return (Value)fun.apply(parameters);
            }
        });
    }

    public void addMathematicalUnaryFunction(String name, DoubleUnaryOperator fun) {
        this.addUnaryFunction(name, v -> new NumericValue(fun.applyAsDouble(NumericValue.asNumber(v).getDouble())));
    }

    public void addMathematicalUnaryIntFunction(String name, DoubleToLongFunction fun) {
        this.addUnaryFunction(name, v -> new NumericValue(fun.applyAsLong(NumericValue.asNumber(v).getDouble())));
    }

    public void addMathematicalBinaryIntFunction(String name, LongBinaryOperator fun) {
        this.addBinaryFunction(name, (w, v) -> new NumericValue(fun.applyAsLong(NumericValue.asNumber(w).getLong(), NumericValue.asNumber(v).getLong())));
    }

    public void addMathematicalBinaryFunction(String name, DoubleBinaryOperator fun) {
        this.addBinaryFunction(name, (w, v) -> new NumericValue(fun.applyAsDouble(NumericValue.asNumber(w).getDouble(), NumericValue.asNumber(v).getDouble())));
    }

    public void addLazyFunction(String name, int numParams, final Fluff.TriFunction<Context, Context.Type, List<LazyValue>, LazyValue> fun) {
        this.functions.put(name, new Fluff.AbstractLazyFunction(this, numParams, name){

            @Override
            public boolean pure() {
                return false;
            }

            @Override
            public boolean transitive() {
                return false;
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type i, Expression e, Token t, List<LazyValue> lazyParams) {
                Fluff.ILazyFunction.checkInterrupts();
                if (this.numParams >= 0 && lazyParams.size() != this.numParams) {
                    String string;
                    String error = "Function '" + this.name + "' requires " + this.numParams + " arguments, got " + lazyParams.size() + ". ";
                    if (fun instanceof Fluff.UsageProvider) {
                        Fluff.UsageProvider up = (Fluff.UsageProvider)((Object)fun);
                        string = up.getUsage();
                    } else {
                        string = "";
                    }
                    throw new InternalExpressionException(error + string);
                }
                try {
                    return (LazyValue)fun.apply(c, i, lazyParams);
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, t);
                }
            }
        });
    }

    public void addLazyFunction(String name, final Fluff.TriFunction<Context, Context.Type, List<LazyValue>, LazyValue> fun) {
        this.functions.put(name, new Fluff.AbstractLazyFunction(this, -1, name){

            @Override
            public boolean pure() {
                return false;
            }

            @Override
            public boolean transitive() {
                return false;
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type i, Expression e, Token t, List<LazyValue> lazyParams) {
                Fluff.ILazyFunction.checkInterrupts();
                try {
                    return (LazyValue)fun.apply(c, i, lazyParams);
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, t);
                }
            }
        });
    }

    public void addContextFunction(String name, int num_params, final Fluff.TriFunction<Context, Context.Type, List<Value>, Value> fun) {
        this.functions.put(name, new Fluff.AbstractLazyFunction(this, num_params, name){

            @Override
            public boolean pure() {
                return false;
            }

            @Override
            public boolean transitive() {
                return false;
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type i, Expression e, Token t, List<LazyValue> lazyParams) {
                Fluff.ILazyFunction.checkInterrupts();
                try {
                    Value ret = (Value)fun.apply(c, i, this.unpackArgs(lazyParams, c, Context.NONE));
                    return (cc, tt) -> ret;
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, t);
                }
            }
        });
    }

    public void addTypedContextFunction(String name, int num_params, final Context.Type reqType, final Fluff.TriFunction<Context, Context.Type, List<Value>, Value> fun) {
        this.functions.put(name, new Fluff.AbstractLazyFunction(this, num_params, name){

            @Override
            public boolean pure() {
                return true;
            }

            @Override
            public boolean transitive() {
                return false;
            }

            @Override
            public Context.Type staticType(Context.Type outerType) {
                return reqType;
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type i, Expression e, Token t, List<LazyValue> lazyParams) {
                try {
                    Value ret = (Value)fun.apply(c, i, this.unpackArgs(lazyParams, c, reqType));
                    return (cc, tt) -> ret;
                }
                catch (RuntimeException exc) {
                    throw Expression.handleCodeException(c, exc, e, t);
                }
            }
        });
    }

    public FunctionValue createUserDefinedFunction(Context context, String name, Expression expr, Token token, List<String> arguments, String varArgs, List<String> outers, LazyValue code) {
        if (this.functions.containsKey(name)) {
            throw new ExpressionException(context, expr, token, "Function " + name + " would mask a built-in function");
        }
        HashMap<String, LazyValue> contextValues = new HashMap<String, LazyValue>();
        for (String outer : outers) {
            LazyValue lv = context.getVariable(outer);
            if (lv == null) {
                throw new InternalExpressionException("Variable " + outer + " needs to be defined in outer scope to be used as outer parameter, and cannot be global");
            }
            contextValues.put(outer, lv);
        }
        if (contextValues.isEmpty()) {
            contextValues = null;
        }
        FunctionValue result = new FunctionValue(expr, token, name, code, arguments, varArgs, contextValues);
        if (!name.equals("_")) {
            context.host.addUserDefinedFunction(context, this.module, name, result);
        }
        return result;
    }

    public void alias(final String copy, String original) {
        final Fluff.ILazyFunction originalFunction = this.functions.get(original);
        this.functions.put(copy, new Fluff.ILazyFunction(){

            @Override
            public int getNumParams() {
                return originalFunction.getNumParams();
            }

            @Override
            public boolean numParamsVaries() {
                return originalFunction.numParamsVaries();
            }

            @Override
            public boolean pure() {
                return originalFunction.pure();
            }

            @Override
            public boolean transitive() {
                return originalFunction.transitive();
            }

            @Override
            public Context.Type staticType(Context.Type outerType) {
                return originalFunction.staticType(outerType);
            }

            @Override
            public LazyValue lazyEval(Context c, Context.Type type, Expression expr, Token token, List<LazyValue> lazyParams) {
                c.host.issueDeprecation(copy + "(...)");
                return originalFunction.lazyEval(c, type, expr, token, lazyParams);
            }
        });
    }

    public void setAnyVariable(Context c, String name, LazyValue lv) {
        if (name.startsWith("global_")) {
            c.host.setGlobalVariable(this.module, name, lv);
        } else {
            c.setVariable(name, lv);
        }
    }

    public LazyValue getOrSetAnyVariable(Context c, String name) {
        LazyValue variable;
        if (!name.startsWith("global_") && (variable = c.getVariable(name)) != null) {
            return variable;
        }
        variable = c.host.getGlobalVariable(this.module, name);
        if (variable != null) {
            return variable;
        }
        variable = (_c, _t) -> _c.host.strict ? Value.UNDEF.reboundedTo(name) : Value.NULL.reboundedTo(name);
        this.setAnyVariable(c, name, variable);
        return variable;
    }

    public Expression(String expression) {
        this.expression = this.stripExpression(expression);
        Operators.apply(this);
        ControlFlow.apply(this);
        Functions.apply(this);
        Arithmetic.apply(this);
        Sys.apply(this);
        Threading.apply(this);
        Loops.apply(this);
        DataStructures.apply(this);
        for (String op : this.operators.keySet()) {
            assert (this.functionalAliases.containsKey(op)) : "Missing function for operator " + op;
        }
    }

    private String stripExpression(String expression) {
        return expression.stripTrailing().replaceAll("\\r\\n?", "\n").replaceAll("\\t", "   ");
    }

    private List<Token> shuntingYard(Context c, List<Token> tokens) {
        ArrayList<Token> outputQueue = new ArrayList<Token>();
        ObjectArrayList stack = new ObjectArrayList();
        Token lastFunction = null;
        Token previousToken = null;
        for (Token token : tokens) {
            switch (token.type) {
                case STRINGPARAM: 
                case LITERAL: 
                case HEX_LITERAL: {
                    if (previousToken != null && (previousToken.type == Token.TokenType.LITERAL || previousToken.type == Token.TokenType.HEX_LITERAL || previousToken.type == Token.TokenType.STRINGPARAM)) {
                        throw new ExpressionException(c, this, token, "Missing operator");
                    }
                    outputQueue.add(token);
                    break;
                }
                case VARIABLE: {
                    outputQueue.add(token);
                    break;
                }
                case FUNCTION: {
                    stack.push((Object)token);
                    lastFunction = token;
                    break;
                }
                case COMMA: {
                    if (previousToken != null && previousToken.type == Token.TokenType.OPERATOR) {
                        throw new ExpressionException(c, this, previousToken, "Missing parameter(s) for operator ");
                    }
                    while (!stack.isEmpty() && ((Token)stack.top()).type != Token.TokenType.OPEN_PAREN) {
                        outputQueue.add((Token)stack.pop());
                    }
                    if (!stack.isEmpty()) break;
                    if (lastFunction == null) {
                        throw new ExpressionException(c, this, token, "Unexpected comma");
                    }
                    throw new ExpressionException(c, this, lastFunction, "Parse error for function");
                }
                case OPERATOR: {
                    if (previousToken != null && (previousToken.type == Token.TokenType.COMMA || previousToken.type == Token.TokenType.OPEN_PAREN)) {
                        throw new ExpressionException(c, this, token, "Missing parameter(s) for operator '" + String.valueOf(token) + "'");
                    }
                    Fluff.ILazyOperator o1 = this.operators.get(token.surface);
                    if (o1 == null) {
                        throw new ExpressionException(c, this, token, "Unknown operator '" + String.valueOf(token) + "'");
                    }
                    this.shuntOperators(outputQueue, (Stack<Token>)stack, o1);
                    stack.push((Object)token);
                    break;
                }
                case UNARY_OPERATOR: {
                    if (previousToken != null && previousToken.type != Token.TokenType.OPERATOR && previousToken.type != Token.TokenType.COMMA && previousToken.type != Token.TokenType.OPEN_PAREN) {
                        throw new ExpressionException(c, this, token, "Invalid position for unary operator " + String.valueOf(token));
                    }
                    Fluff.ILazyOperator o1 = this.operators.get(token.surface);
                    if (o1 == null) {
                        throw new ExpressionException(c, this, token, "Unknown unary operator '" + token.surface.substring(0, token.surface.length() - 1) + "'");
                    }
                    this.shuntOperators(outputQueue, (Stack<Token>)stack, o1);
                    stack.push((Object)token);
                    break;
                }
                case OPEN_PAREN: {
                    if (previousToken != null && previousToken.type == Token.TokenType.FUNCTION) {
                        outputQueue.add(token);
                    }
                    stack.push((Object)token);
                    break;
                }
                case CLOSE_PAREN: {
                    if (previousToken != null && previousToken.type == Token.TokenType.OPERATOR) {
                        throw new ExpressionException(c, this, previousToken, "Missing parameter(s) for operator " + String.valueOf(previousToken));
                    }
                    while (!stack.isEmpty() && ((Token)stack.top()).type != Token.TokenType.OPEN_PAREN) {
                        outputQueue.add((Token)stack.pop());
                    }
                    if (stack.isEmpty()) {
                        throw new ExpressionException(c, this, "Mismatched parentheses");
                    }
                    stack.pop();
                    if (stack.isEmpty() || ((Token)stack.top()).type != Token.TokenType.FUNCTION) break;
                    outputQueue.add((Token)stack.pop());
                    break;
                }
                case MARKER: {
                    if (!"$".equals(token.surface)) break;
                    StringBuilder sb = new StringBuilder(this.expression);
                    sb.setCharAt(token.pos, '\n');
                    this.expression = sb.toString();
                }
            }
            if (token.type == Token.TokenType.MARKER) continue;
            previousToken = token;
        }
        while (!stack.isEmpty()) {
            Token element = (Token)stack.pop();
            if (element.type == Token.TokenType.OPEN_PAREN || element.type == Token.TokenType.CLOSE_PAREN) {
                throw new ExpressionException(c, this, element, "Mismatched parentheses");
            }
            outputQueue.add(element);
        }
        return outputQueue;
    }

    private void shuntOperators(List<Token> outputQueue, Stack<Token> stack, Fluff.ILazyOperator o1) {
        Token nextToken;
        Token token = nextToken = stack.isEmpty() ? null : (Token)stack.top();
        while (nextToken != null && (nextToken.type == Token.TokenType.OPERATOR || nextToken.type == Token.TokenType.UNARY_OPERATOR) && (o1.isLeftAssoc() && o1.getPrecedence() <= this.operators.get(nextToken.surface).getPrecedence() || o1.getPrecedence() < this.operators.get(nextToken.surface).getPrecedence())) {
            outputQueue.add((Token)stack.pop());
            nextToken = stack.isEmpty() ? null : (Token)stack.top();
        }
    }

    public Pair<Value, ExpressionNode> executeAndEvaluate(Context c, boolean optimize, LoadOverride override, @Nullable Consumer<String> logger) {
        if (this.ast == null) {
            boolean functions = false;
            if (override != LoadOverride.DEFAULT) {
                optimize = override == LoadOverride.OPTIMIZED || override == LoadOverride.FUNCTIONAL_OPTIMIZED;
                functions = override == LoadOverride.FUNCTIONAL || override == LoadOverride.FUNCTIONAL_OPTIMIZED;
            }
            Pair<ExpressionNode, LazyValue> ret = this.getAST(c, optimize, functions, logger);
            this.ast = (LazyValue)ret.getRight();
            this.root = (ExpressionNode)ret.getLeft();
        }
        return Pair.of((Object)this.evaluatePartial(() -> this.ast, c, Context.Type.NONE), (Object)this.root);
    }

    public Value evaluatePartial(Supplier<LazyValue> exprProvider, Context c, Context.Type expectedType) {
        try {
            return exprProvider.get().evalValue(c, expectedType);
        }
        catch (BreakStatement | ContinueStatement | ReturnStatement exc) {
            throw new ExpressionException(c, this, "Control flow functions, like continue, break or return, should only be used in loops, and functions respectively.");
        }
        catch (ExitStatement exit) {
            return exit.retval == null ? Value.NULL : exit.retval;
        }
        catch (StackOverflowError ignored) {
            throw new ExpressionException(c, this, "Your thoughts are too deep");
        }
        catch (InternalExpressionException exc) {
            throw new ExpressionException(c, this, "Your expression result is incorrect: " + exc.getMessage());
        }
        catch (ArithmeticException exc) {
            throw new ExpressionException(c, this, "The final result is incorrect: " + exc.getMessage());
        }
    }

    private ExpressionNode RPNToParseTree(List<Token> tokens, Context context) {
        ObjectArrayList nodeStack = new ObjectArrayList();
        for (Token token : tokens) {
            switch (token.type) {
                case UNARY_OPERATOR: {
                    ExpressionNode newNode;
                    ExpressionNode node = (ExpressionNode)nodeStack.pop();
                    LazyValue result = (c, t) -> this.operators.get(token.surface).lazyEval(c, t, this, token, node.op, null).evalValue(c, t);
                    token.node = newNode = new ExpressionNode(result, Collections.singletonList(node), token);
                    nodeStack.push((Object)newNode);
                    break;
                }
                case OPERATOR: {
                    ExpressionNode newNode;
                    ExpressionNode v1 = (ExpressionNode)nodeStack.pop();
                    ExpressionNode v2 = (ExpressionNode)nodeStack.pop();
                    LazyValue result = (c, t) -> this.operators.get(token.surface).lazyEval(c, t, this, token, v2.op, v1.op).evalValue(c, t);
                    token.node = newNode = new ExpressionNode(result, List.of(v2, v1), token);
                    nodeStack.push((Object)newNode);
                    break;
                }
                case VARIABLE: {
                    ExpressionNode newNode;
                    Value constant = this.getConstantFor(token.surface);
                    if (constant != null) {
                        token.morph(Token.TokenType.CONSTANT, token.surface);
                        token.node = newNode = new ExpressionNode(LazyValue.ofConstant(constant), Collections.emptyList(), token);
                        nodeStack.push((Object)newNode);
                        break;
                    }
                    token.node = newNode = new ExpressionNode((c, t) -> this.getOrSetAnyVariable(c, token.surface).evalValue(c, t), Collections.emptyList(), token);
                    nodeStack.push((Object)newNode);
                    break;
                }
                case FUNCTION: {
                    ExpressionNode newNode;
                    ArrayList<ExpressionNode> p;
                    Fluff.ILazyFunction f;
                    String name = token.surface;
                    boolean isKnown = this.functions.containsKey(name);
                    if (isKnown) {
                        f = this.functions.get(name);
                        p = new ArrayList(!f.numParamsVaries() ? f.getNumParams() : 0);
                    } else {
                        f = this.functions.get("call");
                        p = new ArrayList<ExpressionNode>();
                    }
                    while (!nodeStack.isEmpty() && nodeStack.top() != ExpressionNode.PARAMS_START) {
                        p.add((ExpressionNode)nodeStack.pop());
                    }
                    if (!isKnown) {
                        p.add(ExpressionNode.ofConstant(new StringValue(name), token.morphedInto(Token.TokenType.STRINGPARAM, token.surface)));
                        token.morph(Token.TokenType.FUNCTION, "call");
                    }
                    Collections.reverse(p);
                    if (nodeStack.top() == ExpressionNode.PARAMS_START) {
                        nodeStack.pop();
                    }
                    List params = p.stream().map(n -> n.op).collect(Collectors.toList());
                    token.node = newNode = new ExpressionNode((c, t) -> f.lazyEval(c, t, this, token, params).evalValue(c, t), p, token);
                    nodeStack.push((Object)newNode);
                    break;
                }
                case OPEN_PAREN: {
                    token.node = ExpressionNode.PARAMS_START;
                    nodeStack.push((Object)ExpressionNode.PARAMS_START);
                    break;
                }
                case LITERAL: {
                    NumericValue number;
                    ExpressionNode newNode;
                    try {
                        number = new NumericValue(token.surface);
                    }
                    catch (NumberFormatException exception) {
                        throw new ExpressionException(context, this, token, "Not a number");
                    }
                    token.node = newNode = ExpressionNode.ofConstant(number, token);
                    nodeStack.push((Object)newNode);
                    break;
                }
                case STRINGPARAM: {
                    ExpressionNode newNode;
                    token.node = newNode = ExpressionNode.ofConstant(new StringValue(token.surface), token);
                    nodeStack.push((Object)newNode);
                    break;
                }
                case HEX_LITERAL: {
                    NumericValue hexNumber;
                    ExpressionNode newNode;
                    try {
                        hexNumber = new NumericValue(new BigInteger(token.surface.substring(2), 16).longValue());
                    }
                    catch (NumberFormatException exception) {
                        throw new ExpressionException(context, this, token, "Not a number");
                    }
                    token.node = newNode = ExpressionNode.ofConstant(hexNumber, token);
                    nodeStack.push((Object)newNode);
                    break;
                }
                default: {
                    throw new ExpressionException(context, this, token, "Unexpected token '" + token.surface + "'");
                }
            }
        }
        return (ExpressionNode)nodeStack.pop();
    }

    private Pair<ExpressionNode, LazyValue> getAST(Context context, boolean optimize, boolean functional, @Nullable Consumer<String> logger) {
        Tokenizer tokenizer = new Tokenizer(context, this, this.expression, this.allowComments, this.allowNewlineSubstitutions);
        List<Token> cleanedTokens = Tokenizer.postProcess(tokenizer.parseTokens());
        List<Token> rpn = this.shuntingYard(context, cleanedTokens);
        this.validate(context, rpn);
        ExpressionNode root = this.RPNToParseTree(rpn, context);
        if (!optimize && !functional) {
            return Pair.of((Object)root, (Object)root.op);
        }
        Context.ContextForErrorReporting optimizeOnlyContext = new Context.ContextForErrorReporting(context);
        this.optimizeTree(root, optimizeOnlyContext, logger, optimize, functional);
        if (!optimize) {
            return Pair.of((Object)root, (Object)root.op);
        }
        return Pair.of((Object)root, (Object)this.extractOp(optimizeOnlyContext, root, Context.Type.NONE));
    }

    private void optimizeTree(ExpressionNode root, Context optimizeOnlyContext, @Nullable Consumer<String> logger, boolean optimize, boolean toFunctional) {
        if (logger != null) {
            logger.accept("Input code size for " + this.getModuleName() + ": " + this.treeSize(root) + " nodes, " + this.treeDepth(root) + " deep");
        }
        int prevTreeSize = -1;
        int prevTreeDepth = -1;
        boolean changed = true;
        block0: while (changed) {
            boolean optimized;
            changed = false;
            while (true) {
                if (logger != null) {
                    prevTreeSize = this.treeSize(root);
                    prevTreeDepth = this.treeDepth(root);
                }
                if (!(optimized = this.compactTree(root, Context.Type.NONE, 0, logger, optimize, toFunctional))) break;
                changed = true;
                if (logger == null) continue;
                logger.accept("Compacted from " + prevTreeSize + " nodes, " + prevTreeDepth + " code depth to " + this.treeSize(root) + " nodes, " + this.treeDepth(root) + " code depth");
            }
            while (optimize) {
                if (logger != null) {
                    prevTreeSize = this.treeSize(root);
                    prevTreeDepth = this.treeDepth(root);
                }
                if (!(optimized = this.optimizeConstantsAndPureFunctions(optimizeOnlyContext, root, Context.Type.NONE, 0, logger))) continue block0;
                changed = true;
                if (logger == null) continue;
                logger.accept("Optimized from " + prevTreeSize + " nodes, " + prevTreeDepth + " code depth to " + this.treeSize(root) + " nodes, " + this.treeDepth(root) + " code depth");
            }
        }
    }

    public List<Token> explain(Context context, @Nullable String code, @Nullable String method, @Nullable String style) {
        if (code == null) {
            ExpressionNode node;
            if (method != null) {
                FunctionValue function = context.host.getFunction(method);
                if (function == null) {
                    throw new ExpressionException(context, this, "Unknown function " + method);
                }
                node = function.getToken().node;
                if (node == null) {
                    throw new ExpressionException(context, this, "Function " + method + " is not a compiled function");
                }
            } else {
                node = context.host.root;
            }
            if (node == null || node.token.type == null) {
                throw new ExpressionException(context, this, "No code to explain");
            }
            Tokenizer tokenizer = new Tokenizer(context, this, context.host.main == null ? "" : this.stripExpression(context.host.main.code()), true, true);
            List<Token> input = tokenizer.parseTokens();
            List<Token> cleanedTokens = Tokenizer.postProcess(input);
            HashMap<Pair<Integer, Integer>, List<Integer>> tokenPointers = new HashMap<Pair<Integer, Integer>, List<Integer>>();
            for (int i = 0; i < cleanedTokens.size(); ++i) {
                Token token = cleanedTokens.get(i);
                tokenPointers.computeIfAbsent((Pair<Integer, Integer>)Pair.of((Object)token.lineno, (Object)token.linepos), k -> new ArrayList()).add(i);
            }
            return node.tokensRecursive(this, cleanedTokens, tokenPointers);
        }
        if (style == null) {
            style = context.host.loadOverrides.equivalent;
        }
        Tokenizer tokenizer = new Tokenizer(context, this, this.stripExpression(code), true, true);
        List<Token> input = tokenizer.parseTokens();
        if (style.equalsIgnoreCase("raw")) {
            return input;
        }
        List<Token> cleanedTokens = Tokenizer.postProcess(input);
        if (style.equalsIgnoreCase("clean")) {
            return cleanedTokens;
        }
        List<Token> rpn = this.shuntingYard(context, cleanedTokens);
        this.validate(context, rpn);
        ExpressionNode root = this.RPNToParseTree(rpn, context);
        HashMap<Pair<Integer, Integer>, List<Integer>> tokenPointers = new HashMap<Pair<Integer, Integer>, List<Integer>>();
        for (int i = 0; i < cleanedTokens.size(); ++i) {
            Token token = cleanedTokens.get(i);
            tokenPointers.computeIfAbsent((Pair<Integer, Integer>)Pair.of((Object)token.lineno, (Object)token.linepos), k -> new ArrayList()).add(i);
        }
        List<Token> parsedTokens = root.tokensRecursive(this, cleanedTokens, tokenPointers);
        if (style.equalsIgnoreCase("canonical")) {
            return parsedTokens;
        }
        Context.ContextForErrorReporting optimizeOnlyContext = new Context.ContextForErrorReporting(context);
        this.optimizeTree(root, optimizeOnlyContext, null, style.contains("optimized"), style.contains("functional"));
        List<Token> compileTimeOptimized = root.tokensRecursive(this, cleanedTokens, tokenPointers);
        return compileTimeOptimized;
    }

    private int treeSize(ExpressionNode node) {
        return node.op instanceof LazyValue.ContextFreeLazyValue ? 1 : node.args.stream().mapToInt(this::treeSize).sum() + 1;
    }

    private int treeDepth(ExpressionNode node) {
        return node.op instanceof LazyValue.ContextFreeLazyValue ? 1 : node.args.stream().mapToInt(this::treeDepth).max().orElse(0) + 1;
    }

    /*
     * WARNING - void declaration
     */
    private boolean compactTree(ExpressionNode node, Context.Type expectedType, int indent, @Nullable Consumer<String> logger, boolean optimize, boolean toFunctional) {
        boolean optimized = false;
        Token.TokenType token = node.token.type;
        if (!token.isFunctional()) {
            return false;
        }
        if (node.op instanceof LazyValue.Constant) {
            return false;
        }
        String symbol = node.token.surface;
        Fluff.EvalNode operation = (token == Token.TokenType.FUNCTION ? this.functions : this.operators).get(symbol);
        Context.Type requestedType = operation.staticType(expectedType);
        for (ExpressionNode expressionNode : node.args) {
            if (!this.compactTree(expressionNode, requestedType, indent + 1, logger, optimize, toFunctional)) continue;
            optimized = true;
        }
        if (optimize && expectedType != Context.Type.MAPDEF && (symbol.equals("->") || symbol.equals("define")) && node.args.size() == 2) {
            void var13_18;
            String rop = node.args.get((int)1).token.surface;
            Object var13_14 = null;
            if (rop.equals(";") || rop.equals("then")) {
                List<ExpressionNode> thenArgs = node.args.get((int)1).args;
                if (thenArgs.size() > 1 && thenArgs.get((int)(thenArgs.size() - 1)).token.surface.equals("return")) {
                    ExpressionNode expressionNode = thenArgs.get(thenArgs.size() - 1);
                }
            } else if (rop.equals("return")) {
                ExpressionNode expressionNode = node.args.get(1);
            }
            if (var13_18 != null) {
                if (!var13_18.args.isEmpty()) {
                    var13_18.op = var13_18.args.get((int)0).op;
                    var13_18.token = var13_18.args.get((int)0).token;
                    var13_18.range = var13_18.args.get((int)0).range;
                    var13_18.args = var13_18.args.get((int)0).args;
                    if (logger != null) {
                        logger.accept(" - Removed unnecessary tail return of " + var13_18.token.surface + " from function body at line " + (var13_18.token.lineno + 1) + ", node depth " + indent);
                    }
                } else {
                    var13_18.op = LazyValue.ofConstant(Value.NULL);
                    var13_18.token.morph(Token.TokenType.CONSTANT, "null");
                    var13_18.args = Collections.emptyList();
                    if (logger != null) {
                        logger.accept(" - Removed unnecessary tail return from function body at line " + (var13_18.token.lineno + 1) + ", node depth " + indent);
                    }
                }
            }
        }
        for (Map.Entry entry : this.functionalEquivalence.entrySet()) {
            String operator = (String)entry.getKey();
            String function = (String)entry.getValue();
            if (!optimize || !symbol.equals(operator) && !symbol.equals(function) || node.args.isEmpty()) continue;
            boolean leftOptimizable = this.operators.get(operator).isLeftAssoc();
            ExpressionNode optimizedChild = node.args.get(leftOptimizable ? 0 : node.args.size() - 1);
            String type = optimizedChild.token.surface;
            if (!type.equals(operator) && !type.equals(function) || optimizedChild.op instanceof LazyValue.ContextFreeLazyValue) continue;
            ArrayList<ExpressionNode> newargs = new ArrayList<ExpressionNode>();
            if (leftOptimizable) {
                newargs.addAll(optimizedChild.args);
                for (int i = 1; i < node.args.size(); ++i) {
                    newargs.add(node.args.get(i));
                }
            } else {
                for (int i = 0; i < node.args.size() - 1; ++i) {
                    newargs.add(node.args.get(i));
                }
                newargs.addAll(optimizedChild.args);
            }
            if (logger != null) {
                logger.accept(" - " + symbol + "(" + node.args.size() + ") => " + function + "(" + newargs.size() + ") at line " + (node.token.lineno + 1) + ", node depth " + indent);
            }
            node.token.morph(Token.TokenType.FUNCTION, function);
            node.args = newargs;
            return true;
        }
        if (toFunctional && this.functionalAliases.containsKey(symbol) && !node.args.isEmpty()) {
            optimized = true;
            node.token.morph(Token.TokenType.FUNCTION, this.functionalAliases.get(symbol));
        }
        return optimized;
    }

    /*
     * WARNING - void declaration
     */
    private boolean optimizeConstantsAndPureFunctions(Context ctx, ExpressionNode node, Context.Type expectedType, int indent, @Nullable Consumer<String> logger) {
        void var12_19;
        boolean optimized = false;
        Token.TokenType token = node.token.type;
        if (!token.isFunctional()) {
            return false;
        }
        String symbol = node.token.surface;
        if (node.op instanceof LazyValue.Constant) {
            return false;
        }
        Fluff.EvalNode operation = (token == Token.TokenType.FUNCTION ? this.functions : this.operators).get(symbol);
        Context.Type requestedType = operation.staticType(expectedType);
        for (ExpressionNode expressionNode : node.args) {
            if (!this.optimizeConstantsAndPureFunctions(ctx, expressionNode, requestedType, indent + 1, logger)) continue;
            optimized = true;
        }
        for (ExpressionNode expressionNode : node.args) {
            if (expressionNode.token.type.isConstant() || expressionNode.op instanceof LazyValue.ContextFreeLazyValue) continue;
            return optimized;
        }
        if (!(operation.pure() || (symbol.equals("->") || symbol.equals("define")) && expectedType == Context.Type.MAPDEF)) {
            return optimized;
        }
        if (operation.pure() && symbol.equals(":") && expectedType == Context.Type.LVALUE) {
            expectedType = Context.Type.NONE;
        }
        List<LazyValue> args = new ArrayList<LazyValue>(node.args.size());
        for (ExpressionNode arg : node.args) {
            try {
                if (arg.op instanceof LazyValue.Constant) {
                    Value val = ((LazyValue.Constant)arg.op).get();
                    args.add((c, t) -> val);
                    continue;
                }
                args.add((c, t) -> arg.op.evalValue(ctx, requestedType));
            }
            catch (NullPointerException npe) {
                throw new ExpressionException(ctx, this, node.token, "Attempted to evaluate context free expression");
            }
        }
        args = Fluff.AbstractLazyFunction.lazify(Fluff.AbstractLazyFunction.unpackLazy(args, ctx, requestedType));
        if (operation instanceof Fluff.ILazyFunction) {
            Value value = ((Fluff.ILazyFunction)operation).lazyEval(ctx, expectedType, this, node.token, args).evalValue(null, expectedType);
        } else if (args.size() == 1) {
            Value value = ((Fluff.ILazyOperator)operation).lazyEval(ctx, expectedType, this, node.token, args.get(0), null).evalValue(null, expectedType);
        } else {
            Value value = ((Fluff.ILazyOperator)operation).lazyEval(ctx, expectedType, this, node.token, args.get(0), args.get(1)).evalValue(null, expectedType);
        }
        node.token.disguiseAs(null, "=> " + var12_19.getString());
        node.op = LazyValue.ofConstant((Value)var12_19);
        if (logger != null) {
            logger.accept(" - " + symbol + "(" + args.stream().map(a -> a.evalValue(null, requestedType).getString()).collect(Collectors.joining(", ")) + ") => " + var12_19.getString() + " at line " + (node.token.lineno + 1) + ", node depth " + indent);
        }
        return true;
    }

    private LazyValue extractOp(Context ctx, ExpressionNode node, Context.Type expectedType) {
        if (node.op instanceof LazyValue.Constant) {
            if (node.token.type.isConstant()) {
                Value value = ((LazyValue.Constant)node.op).get();
                return (c, t) -> value;
            }
            return node.op;
        }
        if (node.op instanceof LazyValue.ContextFreeLazyValue) {
            Value ret = ((LazyValue.ContextFreeLazyValue)node.op).evalType(expectedType);
            return (c, t) -> ret;
        }
        Token token = node.token;
        switch (token.type) {
            case UNARY_OPERATOR: {
                Fluff.ILazyOperator op = this.operators.get(token.surface);
                Context.Type requestedType = op.staticType(expectedType);
                LazyValue arg = this.extractOp(ctx, node.args.get(0), requestedType);
                return (c, t) -> op.lazyEval(c, t, this, token, arg, null).evalValue(c, t);
            }
            case OPERATOR: {
                Fluff.ILazyOperator op = this.operators.get(token.surface);
                Context.Type requestedType = op.staticType(expectedType);
                LazyValue arg = this.extractOp(ctx, node.args.get(0), requestedType);
                LazyValue arh = this.extractOp(ctx, node.args.get(1), requestedType);
                return (c, t) -> op.lazyEval(c, t, this, token, arg, arh).evalValue(c, t);
            }
            case VARIABLE: {
                return (c, t) -> this.getOrSetAnyVariable(c, token.surface).evalValue(c, t);
            }
            case FUNCTION: {
                Fluff.ILazyFunction f = this.functions.get(token.surface);
                Context.Type requestedType = f.staticType(expectedType);
                List params = node.args.stream().map(n -> this.extractOp(ctx, (ExpressionNode)n, requestedType)).collect(Collectors.toList());
                return (c, t) -> f.lazyEval(c, t, this, token, params).evalValue(c, t);
            }
            case CONSTANT: {
                return node.op;
            }
        }
        throw new ExpressionException(ctx, this, node.token, "Unexpected token '" + String.valueOf((Object)node.token.type) + " " + node.token.surface + "'");
    }

    private void validate(Context c, List<Token> rpn) {
        IntArrayList stack = new IntArrayList();
        stack.push(0);
        block6: for (Token token : rpn) {
            switch (token.type) {
                case UNARY_OPERATOR: {
                    if (stack.topInt() >= 1) continue block6;
                    throw new ExpressionException(c, this, token, "Missing parameter(s) for operator " + String.valueOf(token));
                }
                case OPERATOR: {
                    if (stack.topInt() < 2) {
                        if (token.surface.equals(";")) {
                            throw new ExpressionException(c, this, token, "Empty expression found for ';'");
                        }
                        throw new ExpressionException(c, this, token, "Missing parameter(s) for operator " + String.valueOf(token));
                    }
                    stack.set(stack.size() - 1, stack.topInt() - 2 + 1);
                    continue block6;
                }
                case FUNCTION: {
                    stack.popInt();
                    if (stack.size() <= 0) {
                        throw new ExpressionException(c, this, token, "Too many function calls, maximum scope exceeded");
                    }
                    stack.set(stack.size() - 1, stack.topInt() + 1);
                    continue block6;
                }
                case OPEN_PAREN: {
                    stack.push(0);
                    continue block6;
                }
            }
            stack.set(stack.size() - 1, stack.topInt() + 1);
        }
        if (stack.size() > 1) {
            throw new ExpressionException(c, this, "Too many unhandled function parameter lists");
        }
        if (stack.topInt() > 1) {
            throw new ExpressionException(c, this, "Too many numbers or variables");
        }
        if (stack.topInt() < 1) {
            throw new ExpressionException(c, this, "Empty expression");
        }
    }

    public static class ExpressionNode {
        public LazyValue op;
        public List<ExpressionNode> args;
        public Token token;
        public List<Token> range;
        public static final ExpressionNode PARAMS_START = new ExpressionNode(null, null, Token.NONE);

        public ExpressionNode(LazyValue op, List<ExpressionNode> args, Token token) {
            this.op = op;
            this.args = args;
            this.token = token;
            this.range = new ArrayList<Token>();
            this.range.add(token);
        }

        public static ExpressionNode ofConstant(Value val, Token token) {
            return new ExpressionNode(new LazyValue.Constant(val), Collections.emptyList(), token);
        }

        public List<Token> tokensRecursive(Expression expression, List<Token> reference, Map<Pair<Integer, Integer>, List<Integer>> referencePointers) {
            ArrayList<Token> tokens = new ArrayList<Token>();
            switch (this.token.type) {
                case FUNCTION: {
                    tokens.add(this.token);
                    tokens.add(this.findToken(this.token, Token.TokenType.OPEN_PAREN, "(", reference, referencePointers));
                    if (!this.args.isEmpty()) {
                        for (ExpressionNode arg : this.args) {
                            List<Token> argTokens = arg.tokensRecursive(expression, reference, referencePointers);
                            tokens.addAll(argTokens);
                            tokens.add(this.findToken(argTokens.getLast(), Token.TokenType.COMMA, ",", reference, referencePointers).disguiseAs(", ", null));
                        }
                        tokens.removeLast();
                    }
                    tokens.add(this.findToken((Token)tokens.getLast(), Token.TokenType.CLOSE_PAREN, ")", reference, referencePointers));
                    break;
                }
                case OPERATOR: {
                    tokens.addAll(this.createOperatorArgumentTokens(expression, this.args.get(0), reference, referencePointers));
                    tokens.add(this.token.disguiseAs(this.token.surface.equals(";") ? this.token.surface + " " : " " + this.token.surface + " ", null));
                    tokens.addAll(this.createOperatorArgumentTokens(expression, this.args.get(1), reference, referencePointers));
                    break;
                }
                case UNARY_OPERATOR: {
                    tokens.add(this.token.disguiseAs(" " + StringUtils.chop((String)this.token.surface), null));
                    tokens.addAll(this.createOperatorArgumentTokens(expression, this.args.get(0), reference, referencePointers));
                    break;
                }
                case LITERAL: 
                case HEX_LITERAL: 
                case VARIABLE: 
                case CONSTANT: {
                    tokens.add(this.token);
                    break;
                }
                case STRINGPARAM: {
                    tokens.add(this.token.disguiseAs("'" + this.token.surface + "'", null));
                    break;
                }
                default: {
                    tokens.add(this.token.disguiseAs("?" + this.token.surface + "?", null));
                }
            }
            return tokens;
        }

        public Token findToken(Token previous, Token.TokenType type, String expectedSurface, List<Token> reference, Map<Pair<Integer, Integer>, List<Integer>> referencePointers) {
            List<Integer> indices = referencePointers.get(Pair.of((Object)previous.lineno, (Object)previous.linepos));
            if (indices == null) {
                return previous.morphedInto(type, expectedSurface);
            }
            for (int index : indices) {
                if (index + 1 == reference.size()) continue;
                Token token = reference.get(index + 1);
                if (token.type != type) continue;
                return token.morphedInto(type, expectedSurface);
            }
            return previous.morphedInto(type, expectedSurface);
        }

        public List<Token> createOperatorArgumentTokens(Expression expression, ExpressionNode operand, List<Token> reference, Map<Pair<Integer, Integer>, List<Integer>> referencePointers) {
            boolean needsBrackets = false;
            Map<String, Fluff.ILazyOperator> operators = expression.operators;
            if (operators.containsKey(operand.token.surface) && operators.containsKey(this.token.surface) && operators.get(operand.token.surface).getPrecedence() < operators.get(this.token.surface).getPrecedence()) {
                needsBrackets = true;
            }
            List<Token> argumentTokens = operand.tokensRecursive(expression, reference, referencePointers);
            if (!needsBrackets) {
                return argumentTokens;
            }
            ArrayList<Token> bracketed = new ArrayList<Token>();
            bracketed.add(this.findToken(argumentTokens.getFirst(), Token.TokenType.OPEN_PAREN, "(", reference, referencePointers));
            ((Token)bracketed.get(0)).swapPlace(argumentTokens.getFirst());
            bracketed.addAll(argumentTokens);
            bracketed.add(this.findToken(argumentTokens.getLast(), Token.TokenType.CLOSE_PAREN, ")", reference, referencePointers));
            return bracketed;
        }
    }

    public static enum LoadOverride {
        DEFAULT("clean"),
        CANONICAL("canonical"),
        OPTIMIZED("optimized"),
        FUNCTIONAL("functional"),
        FUNCTIONAL_OPTIMIZED("functional_optimized");

        public String equivalent;

        private LoadOverride(String equivalent) {
            this.equivalent = equivalent;
        }
    }
}

