/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.script.CarpetScriptServer;
import carpet.script.external.Carpet;
import carpet.script.utils.ShapeDispatcher;
import carpet.script.utils.shapes.ShapeDirection;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_10444;
import net.minecraft.class_1087;
import net.minecraft.class_11352;
import net.minecraft.class_11631;
import net.minecraft.class_11658;
import net.minecraft.class_11659;
import net.minecraft.class_11954;
import net.minecraft.class_12160;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4599;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_765;
import net.minecraft.class_778;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_8942;
import net.minecraft.class_9799;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public class ShapesRenderer {
    private final Map<class_5321<class_1937>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> shapes;
    private final Map<class_5321<class_1937>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> labels;
    private final class_310 client;
    private final Map<String, BiFunction<class_310, ShapeDispatcher.ExpiringShape, RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> renderedShapes = new HashMap<String, BiFunction<class_310, ShapeDispatcher.ExpiringShape, RenderedShape<? extends ShapeDispatcher.ExpiringShape>>>(){
        {
            this.put("line", RenderedLine::new);
            this.put("box", RenderedBox::new);
            this.put("sphere", RenderedSphere::new);
            this.put("cylinder", RenderedCylinder::new);
            this.put("label", RenderedText::new);
            this.put("polygon", RenderedPolyface::new);
            this.put("block", (c, s) -> new RenderedSprite((class_310)c, (ShapeDispatcher.ExpiringShape)s, false));
            this.put("item", (c, s) -> new RenderedSprite((class_310)c, (ShapeDispatcher.ExpiringShape)s, true));
        }
    };

    public static void rotatePoseStackByShapeDirection(class_4587 poseStack, ShapeDirection shapeDirection, class_4184 camera, class_243 objectPos) {
        switch (shapeDirection) {
            case NORTH: {
                break;
            }
            case SOUTH: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
                break;
            }
            case EAST: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(270.0f));
                break;
            }
            case WEST: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(90.0f));
                break;
            }
            case UP: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(90.0f));
                break;
            }
            case DOWN: {
                poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-90.0f));
                break;
            }
            case CAMERA: {
                poseStack.method_22907((Quaternionfc)camera.method_23767());
                break;
            }
            case PLAYER: {
                class_243 vector = objectPos.method_1020(camera.method_71156());
                double x = vector.field_1352;
                double y = vector.field_1351;
                double z = vector.field_1350;
                double d = Math.sqrt(x * x + z * z);
                float rotX = (float)Math.atan2(x, z);
                float rotY = (float)Math.atan2(y, d);
                poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotation(rotX));
                poseStack.method_22907((Quaternionfc)class_7833.field_40714.rotation(-rotY));
            }
        }
    }

    public ShapesRenderer(class_310 minecraftClient) {
        this.client = minecraftClient;
        this.shapes = new HashMap<class_5321<class_1937>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>>();
        this.labels = new HashMap<class_5321<class_1937>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>>();
    }

    public void render(class_4599 renderBuffers, class_11658 cameraa, Matrix4f matrix4f, float partialTick) {
        Runnable token = Carpet.startProfilerSection("Scarpet client");
        class_4587 matrices = new class_4587();
        class_4184 camera = this.client.field_1773.method_19418();
        class_638 iWorld = this.client.field_1687;
        class_5321 dimensionType = iWorld.method_27983();
        if ((this.shapes.get(dimensionType) == null || this.shapes.get(dimensionType).isEmpty()) && (this.labels.get(dimensionType) == null || this.labels.get(dimensionType).isEmpty())) {
            return;
        }
        long currentTime = this.client.field_1687.method_75260();
        class_289 tesselator = class_289.method_1348();
        double cameraX = camera.method_71156().field_1352;
        double cameraY = camera.method_71156().field_1351;
        double cameraZ = camera.method_71156().field_1350;
        boolean entityBoxes = this.client.field_61504.method_72772(class_11631.field_61581);
        class_12160 normal = new class_12160();
        class_12160 onTop = new class_12160();
        if (!this.shapes.isEmpty()) {
            this.shapes.get(dimensionType).long2ObjectEntrySet().removeIf(entry -> ((RenderedShape)entry.getValue()).isExpired(currentTime));
            Matrix4fStack matrixStack = RenderSystem.getModelViewStack();
            matrixStack.pushMatrix();
            matrixStack.mul((Matrix4fc)matrices.method_23760().method_23761());
            this.shapes.get(dimensionType).values().forEach(s -> {
                if ((!((ShapeDispatcher.ExpiringShape)s.shape).debug || entityBoxes) && s.shouldRender((class_5321<class_1937>)dimensionType)) {
                    s.renderLines(matrices, tesselator, cameraX, cameraY, cameraZ, partialTick, cameraa, ((ShapeDispatcher.ExpiringShape)s.shape).seethrough ? onTop : normal);
                }
            });
            this.shapes.get(dimensionType).values().forEach(s -> {
                if ((!((ShapeDispatcher.ExpiringShape)s.shape).debug || entityBoxes) && s.shouldRender((class_5321<class_1937>)dimensionType)) {
                    s.renderFaces(tesselator, cameraX, cameraY, cameraZ, partialTick, ((ShapeDispatcher.ExpiringShape)s.shape).seethrough ? onTop : normal);
                }
            });
            matrixStack.popMatrix();
        }
        if (!this.labels.isEmpty()) {
            this.labels.get(dimensionType).long2ObjectEntrySet().removeIf(entry -> ((RenderedShape)entry.getValue()).isExpired(currentTime));
            this.labels.get(dimensionType).values().forEach(s -> {
                if ((!((ShapeDispatcher.ExpiringShape)s.shape).debug || entityBoxes) && s.shouldRender((class_5321<class_1937>)dimensionType)) {
                    s.renderLines(matrices, tesselator, cameraX, cameraY, cameraZ, partialTick, cameraa, ((ShapeDispatcher.ExpiringShape)s.shape).seethrough ? onTop : normal);
                }
            });
        }
        class_4597.class_4598 bufferSource = renderBuffers.method_23000();
        bufferSource.method_37104();
        normal.method_75477(matrices, (class_4597)bufferSource, cameraa.field_63082, matrix4f);
        bufferSource.method_37104();
        token.run();
    }

    public void addShapes(class_2499 tag) {
        Runnable token = Carpet.startProfilerSection("Scarpet client");
        int count = tag.size();
        for (int i = 0; i < count; ++i) {
            this.addShape((class_2487)tag.method_10602(i).orElseThrow());
        }
        token.run();
    }

    public void addShape(class_2487 tag) {
        ShapeDispatcher.ExpiringShape shape = ShapeDispatcher.fromTag(tag, (class_1937)this.client.field_1687);
        if (shape == null) {
            return;
        }
        BiFunction<class_310, ShapeDispatcher.ExpiringShape, RenderedShape<? extends ShapeDispatcher.ExpiringShape>> shapeFactory = this.renderedShapes.get(tag.method_10558("shape").orElseThrow());
        if (shapeFactory == null) {
            CarpetScriptServer.LOG.info("Unrecognized shape: " + String.valueOf(tag.method_10558("shape")));
        } else {
            RenderedShape<? extends ShapeDispatcher.ExpiringShape> rshape = shapeFactory.apply(this.client, shape);
            class_5321<class_1937> dim = shape.shapeDimension;
            long key = rshape.key();
            Map<class_5321<class_1937>, Long2ObjectOpenHashMap<RenderedShape<? extends ShapeDispatcher.ExpiringShape>>> container = rshape.stageDeux() ? this.labels : this.shapes;
            RenderedShape existing = (RenderedShape)container.computeIfAbsent(dim, d -> new Long2ObjectOpenHashMap()).get(key);
            if (existing != null) {
                existing.promoteWith(rshape);
            } else {
                container.get(dim).put(key, rshape);
            }
        }
    }

    public void reset() {
        this.shapes.values().forEach(Long2ObjectOpenHashMap::clear);
        this.labels.values().forEach(Long2ObjectOpenHashMap::clear);
    }

    public void renewShapes() {
        Runnable token = Carpet.startProfilerSection("Scarpet client");
        this.shapes.values().forEach(el -> el.values().forEach(shape -> ++shape.expiryTick));
        this.labels.values().forEach(el -> el.values().forEach(shape -> ++shape.expiryTick));
        token.run();
    }

    public static void drawBoxWireGLLines(class_12160 primitives, float x1, float y1, float z1, float x2, float y2, float z2, boolean xthick, boolean ythick, boolean zthick, int color, float width) {
        if (xthick) {
            primitives.method_75473(new class_243((double)x1, (double)y1, (double)z1), new class_243((double)x2, (double)y1, (double)z1), color, width);
            primitives.method_75473(new class_243((double)x2, (double)y2, (double)z1), new class_243((double)x1, (double)y2, (double)z1), color, width);
            primitives.method_75473(new class_243((double)x1, (double)y1, (double)z2), new class_243((double)x2, (double)y1, (double)z2), color, width);
            primitives.method_75473(new class_243((double)x1, (double)y2, (double)z2), new class_243((double)x2, (double)y2, (double)z2), color, width);
        }
        if (ythick) {
            primitives.method_75473(new class_243((double)x1, (double)y1, (double)z1), new class_243((double)x1, (double)y2, (double)z1), color, width);
            primitives.method_75473(new class_243((double)x2, (double)y1, (double)z1), new class_243((double)x2, (double)y2, (double)z1), color, width);
            primitives.method_75473(new class_243((double)x1, (double)y2, (double)z2), new class_243((double)x1, (double)y1, (double)z2), color, width);
            primitives.method_75473(new class_243((double)x2, (double)y1, (double)z2), new class_243((double)x2, (double)y2, (double)z2), color, width);
        }
        if (zthick) {
            primitives.method_75473(new class_243((double)x1, (double)y1, (double)z1), new class_243((double)x1, (double)y1, (double)z2), color, width);
            primitives.method_75473(new class_243((double)x1, (double)y2, (double)z1), new class_243((double)x1, (double)y2, (double)z2), color, width);
            primitives.method_75473(new class_243((double)x2, (double)y1, (double)z2), new class_243((double)x2, (double)y1, (double)z1), color, width);
            primitives.method_75473(new class_243((double)x2, (double)y2, (double)z1), new class_243((double)x2, (double)y2, (double)z2), color, width);
        }
    }

    public static void drawBoxFaces(class_12160 primitives, float x1, float y1, float z1, float x2, float y2, float z2, boolean xthick, boolean ythick, boolean zthick, int argb) {
        if (xthick && ythick) {
            primitives.method_75474(new class_243((double)x1, (double)y1, (double)z1), new class_243((double)x2, (double)y1, (double)z1), new class_243((double)x2, (double)y2, (double)z1), new class_243((double)x1, (double)y2, (double)z1), argb);
            if (zthick) {
                primitives.method_75474(new class_243((double)x1, (double)y1, (double)z2), new class_243((double)x1, (double)y2, (double)z2), new class_243((double)x2, (double)y2, (double)z2), new class_243((double)x2, (double)y1, (double)z2), argb);
            }
        }
        if (zthick && ythick) {
            primitives.method_75474(new class_243((double)x1, (double)y1, (double)z1), new class_243((double)x1, (double)y2, (double)z1), new class_243((double)x1, (double)y2, (double)z2), new class_243((double)x1, (double)y1, (double)z2), argb);
            if (xthick) {
                primitives.method_75474(new class_243((double)x2, (double)y1, (double)z1), new class_243((double)x2, (double)y1, (double)z2), new class_243((double)x2, (double)y2, (double)z2), new class_243((double)x2, (double)y2, (double)z1), argb);
            }
        }
        if (zthick && xthick) {
            primitives.method_75474(new class_243((double)x1, (double)y1, (double)z1), new class_243((double)x2, (double)y1, (double)z1), new class_243((double)x2, (double)y1, (double)z2), new class_243((double)x1, (double)y1, (double)z2), argb);
            if (ythick) {
                primitives.method_75474(new class_243((double)x1, (double)y2, (double)z1), new class_243((double)x1, (double)y2, (double)z2), new class_243((double)x2, (double)y2, (double)z2), new class_243((double)x2, (double)y2, (double)z1), argb);
            }
        }
    }

    public static void drawCylinderWireframe(class_12160 primitives, float cx, float cy, float cz, float r, float h, class_2350.class_2351 axis, int subd, boolean isFlat, int argb, float width) {
        block16: {
            float hstep;
            int hsteps;
            int num_steps360;
            int num_steps180;
            float step;
            block17: {
                block15: {
                    step = (float)Math.PI / (float)(subd / 2);
                    num_steps180 = (int)(Math.PI / (double)step) + 1;
                    num_steps360 = (int)(Math.PI * 2 / (double)step);
                    hsteps = 1;
                    hstep = 1.0f;
                    if (!isFlat) {
                        hsteps = (int)Math.ceil(class_3532.method_15379((float)h) / (step * r)) + 1;
                        hstep = h / (float)(hsteps - 1);
                    }
                    if (axis != class_2350.class_2351.field_11052) break block15;
                    for (int dh = 0; dh < hsteps; ++dh) {
                        float hh = (float)dh * hstep;
                        class_243 from = null;
                        for (int i = 0; i <= num_steps360 + 1; ++i) {
                            float theta = step * (float)i;
                            float x = r * class_3532.method_15362((float)theta);
                            float y = hh;
                            float z = r * class_3532.method_15374((float)theta);
                            class_243 to = new class_243((double)(x + cx), (double)(y + cy), (double)(z + cz));
                            if (from != null) {
                                primitives.method_75473(from, to, argb, width);
                            }
                            from = to;
                        }
                    }
                    if (isFlat) break block16;
                    for (int i = 0; i <= num_steps180; ++i) {
                        float theta = step * (float)i;
                        float x = r * class_3532.method_15362((float)theta);
                        float z = r * class_3532.method_15374((float)theta);
                        primitives.method_75473(new class_243((double)(cx - x), (double)(cy + 0.0f), (double)(cz + z)), new class_243((double)(cx + x), (double)(cy + 0.0f), (double)(cz - z)), argb, width);
                        primitives.method_75473(new class_243((double)(cx + x), (double)(cy + 0.0f), (double)(cz - z)), new class_243((double)(cx + x), (double)(cy + h), (double)(cz - z)), argb, width);
                        primitives.method_75473(new class_243((double)(cx + x), (double)(cy + h), (double)(cz - z)), new class_243((double)(cx - x), (double)(cy + h), (double)(cz + z)), argb, width);
                        primitives.method_75473(new class_243((double)(cx - x), (double)(cy + h), (double)(cz + z)), new class_243((double)(cx - x), (double)(cy + 0.0f), (double)(cz + z)), argb, width);
                    }
                    break block16;
                }
                if (axis != class_2350.class_2351.field_11048) break block17;
                for (int dh = 0; dh < hsteps; ++dh) {
                    float hh = (float)dh * hstep;
                    class_243 from = null;
                    for (int i = 0; i <= num_steps360; ++i) {
                        float theta = step * (float)i;
                        float z = r * class_3532.method_15362((float)theta);
                        float x = hh;
                        float y = r * class_3532.method_15374((float)theta);
                        class_243 to = new class_243((double)(x + cx), (double)(y + cy), (double)(z + cz));
                        if (from != null) {
                            primitives.method_75473(from, to, argb, width);
                        }
                        from = to;
                    }
                }
                if (isFlat) break block16;
                for (int i = 0; i <= num_steps180; ++i) {
                    float theta = step * (float)i;
                    float y = r * class_3532.method_15362((float)theta);
                    float z = r * class_3532.method_15374((float)theta);
                    primitives.method_75473(new class_243((double)(cx + 0.0f), (double)(cy - y), (double)(cz + z)), new class_243((double)(cx + 0.0f), (double)(cy + y), (double)(cz - z)), argb, width);
                    primitives.method_75473(new class_243((double)(cx + 0.0f), (double)(cy + y), (double)(cz - z)), new class_243((double)(cx + h), (double)(cy + y), (double)(cz - z)), argb, width);
                    primitives.method_75473(new class_243((double)(cx + h), (double)(cy + y), (double)(cz - z)), new class_243((double)(cx + h), (double)(cy - y), (double)(cz + z)), argb, width);
                    primitives.method_75473(new class_243((double)(cx + h), (double)(cy - y), (double)(cz + z)), new class_243((double)(cx + 0.0f), (double)(cy - y), (double)(cz + z)), argb, width);
                }
                break block16;
            }
            if (axis == class_2350.class_2351.field_11051) {
                for (int dh = 0; dh < hsteps; ++dh) {
                    float hh = (float)dh * hstep;
                    class_243 from = null;
                    for (int i = 0; i <= num_steps360; ++i) {
                        float theta = step * (float)i;
                        float y = r * class_3532.method_15362((float)theta);
                        float z = hh;
                        float x = r * class_3532.method_15374((float)theta);
                        class_243 to = new class_243((double)(x + cx), (double)(y + cy), (double)(z + cz));
                        if (from != null) {
                            primitives.method_75473(from, to, argb, width);
                        }
                        from = to;
                    }
                }
                if (!isFlat) {
                    for (int i = 0; i <= num_steps180; ++i) {
                        float theta = step * (float)i;
                        float x = r * class_3532.method_15362((float)theta);
                        float y = r * class_3532.method_15374((float)theta);
                        primitives.method_75473(new class_243((double)(cx + x), (double)(cy - y), (double)(cz + 0.0f)), new class_243((double)(cx - x), (double)(cy + y), (double)(cz + 0.0f)), argb, width);
                        primitives.method_75473(new class_243((double)(cx - x), (double)(cy + y), (double)(cz + 0.0f)), new class_243((double)(cx - x), (double)(cy + y), (double)(cz + h)), argb, width);
                        primitives.method_75473(new class_243((double)(cx - x), (double)(cy + y), (double)(cz + h)), new class_243((double)(cx + x), (double)(cy - y), (double)(cz + h)), argb, width);
                        primitives.method_75473(new class_243((double)(cx + x), (double)(cy - y), (double)(cz + h)), new class_243((double)(cx + x), (double)(cy - y), (double)(cz + 0.0f)), argb, width);
                    }
                }
            }
        }
    }

    public static void drawCylinderFaces(class_12160 primitives, float cx, float cy, float cz, float r, float h, class_2350.class_2351 axis, int subd, boolean isFlat, int argb) {
        block12: {
            int num_steps360;
            float step;
            block13: {
                float z;
                float y;
                float theta;
                int i;
                block11: {
                    float z2;
                    float x;
                    float theta2;
                    int i2;
                    step = (float)Math.PI / (float)(subd / 2);
                    num_steps360 = (int)(Math.PI * 2 / (double)step) + 1;
                    if (axis != class_2350.class_2351.field_11052) break block11;
                    class_243[] points = new class_243[num_steps360 + 2];
                    points[0] = new class_243((double)cx, (double)cy, (double)cz);
                    for (i2 = 0; i2 <= num_steps360; ++i2) {
                        theta2 = step * (float)i2;
                        x = r * class_3532.method_15362((float)theta2);
                        z2 = r * class_3532.method_15374((float)theta2);
                        points[i2 + 1] = new class_243((double)(x + cx), (double)cy, (double)(z2 + cz));
                    }
                    primitives.method_75478(points, argb);
                    if (isFlat) break block12;
                    points = new class_243[num_steps360 + 2];
                    points[0] = new class_243((double)cx, (double)(cy + h), (double)cz);
                    for (i2 = 0; i2 <= num_steps360; ++i2) {
                        theta2 = step * (float)i2;
                        x = r * class_3532.method_15362((float)theta2);
                        z2 = r * class_3532.method_15374((float)theta2);
                        points[i2 + 1] = new class_243((double)(x + cx), (double)(cy + h), (double)(z2 + cz));
                    }
                    primitives.method_75478(points, argb);
                    float xp = r * 1.0f;
                    float zp = r * 0.0f;
                    for (int i3 = 1; i3 <= num_steps360; ++i3) {
                        float theta3 = step * (float)i3;
                        float x2 = r * class_3532.method_15362((float)theta3);
                        float z3 = r * class_3532.method_15374((float)theta3);
                        primitives.method_75474(new class_243((double)(cx + xp), (double)(cy + 0.0f), (double)(cz + zp)), new class_243((double)(cx + xp), (double)(cy + h), (double)(cz + zp)), new class_243((double)(cx + x2), (double)(cy + h), (double)(cz + z3)), new class_243((double)(cx - x2), (double)(cy + h), (double)(cz + z3)), argb);
                        xp = x2;
                        zp = z3;
                    }
                    break block12;
                }
                if (axis != class_2350.class_2351.field_11048) break block13;
                class_243[] points = new class_243[num_steps360 + 2];
                points[0] = new class_243((double)cx, (double)cy, (double)cz);
                for (i = 0; i <= num_steps360; ++i) {
                    theta = step * (float)i;
                    y = r * class_3532.method_15362((float)theta);
                    z = r * class_3532.method_15374((float)theta);
                    points[i + 1] = new class_243((double)cx, (double)(cy + y), (double)(cz + z));
                }
                primitives.method_75478(points, argb);
                if (isFlat) break block12;
                points = new class_243[num_steps360 + 2];
                points[0] = new class_243((double)(cx + h), (double)cy, (double)cz);
                for (i = 0; i <= num_steps360; ++i) {
                    theta = step * (float)i;
                    y = r * class_3532.method_15362((float)theta);
                    z = r * class_3532.method_15374((float)theta);
                    points[i + 1] = new class_243((double)cx, (double)(cy + y), (double)(cz + z));
                }
                primitives.method_75478(points, argb);
                float yp = r * 1.0f;
                float zp = r * 0.0f;
                for (int i4 = 1; i4 <= num_steps360; ++i4) {
                    float theta4 = step * (float)i4;
                    float y2 = r * class_3532.method_15362((float)theta4);
                    float z4 = r * class_3532.method_15374((float)theta4);
                    primitives.method_75474(new class_243((double)(cx + 0.0f), (double)(cy + yp), (double)(cz + zp)), new class_243((double)(cx + h), (double)(cy + yp), (double)(cz + zp)), new class_243((double)(cx + h), (double)(cy + y2), (double)(cz + z4)), new class_243((double)(cx + 0.0f), (double)(cy + y2), (double)(cz + z4)), argb);
                    yp = y2;
                    zp = z4;
                }
                break block12;
            }
            if (axis == class_2350.class_2351.field_11051) {
                float y;
                float x;
                float theta;
                int i;
                class_243[] points = new class_243[num_steps360 + 2];
                points[0] = new class_243((double)cx, (double)cy, (double)cz);
                for (i = 0; i <= num_steps360; ++i) {
                    theta = step * (float)i;
                    x = r * class_3532.method_15362((float)theta);
                    y = r * class_3532.method_15374((float)theta);
                    points[i + 1] = new class_243((double)(x + cx), (double)(cy + y), (double)cz);
                }
                primitives.method_75478(points, argb);
                if (!isFlat) {
                    points = new class_243[num_steps360 + 2];
                    points[0] = new class_243((double)cx, (double)cy, (double)(cz + h));
                    for (i = 0; i <= num_steps360; ++i) {
                        theta = step * (float)i;
                        x = r * class_3532.method_15362((float)theta);
                        y = r * class_3532.method_15374((float)theta);
                        points[i + 1] = new class_243((double)(x + cx), (double)(cy + y), (double)(cz + h));
                    }
                    primitives.method_75478(points, argb);
                    float xp = r;
                    float yp = 0.0f;
                    for (int i5 = 1; i5 <= num_steps360; ++i5) {
                        float theta5 = step * (float)i5;
                        float x3 = r * class_3532.method_15362((float)theta5);
                        float y3 = r * class_3532.method_15374((float)theta5);
                        primitives.method_75474(new class_243((double)(cx + xp), (double)(cy + yp), (double)(cz + 0.0f)), new class_243((double)(cx + xp), (double)(cy + yp), (double)(cz + h)), new class_243((double)(cx + x3), (double)(cy + y3), (double)(cz + h)), new class_243((double)(cx + x3), (double)(cy + y3), (double)(cz + 0.0f)), argb);
                        xp = x3;
                        yp = y3;
                    }
                }
            }
        }
    }

    public static void drawSphereWireframe(class_12160 primitives, float cx, float cy, float cz, float r, int subd, int argb, float width) {
        class_243 to;
        float y;
        float z;
        float x;
        class_243 from;
        float step = (float)Math.PI / (float)(subd / 2);
        int num_steps180 = (int)(Math.PI / (double)step) + 1;
        int num_steps360 = (int)(Math.PI * 2 / (double)step) + 1;
        for (int i = 0; i <= num_steps360; ++i) {
            from = null;
            float theta = step * (float)i;
            for (int j = 0; j <= num_steps180; ++j) {
                float phi = step * (float)j;
                x = r * class_3532.method_15374((float)phi) * class_3532.method_15362((float)theta);
                z = r * class_3532.method_15374((float)phi) * class_3532.method_15374((float)theta);
                y = r * class_3532.method_15362((float)phi);
                to = new class_243((double)(x + cx), (double)(y + cy), (double)(z + cz));
                if (from != null) {
                    primitives.method_75473(from, to, argb, width);
                }
                from = to;
            }
        }
        for (int j = 0; j <= num_steps180; ++j) {
            from = null;
            float phi = step * (float)j;
            for (int i = 0; i <= num_steps360; ++i) {
                float theta = step * (float)i;
                x = r * class_3532.method_15374((float)phi) * class_3532.method_15362((float)theta);
                z = r * class_3532.method_15374((float)phi) * class_3532.method_15374((float)theta);
                y = r * class_3532.method_15362((float)phi);
                to = new class_243((double)(x + cx), (double)(y + cy), (double)(z + cz));
                if (from != null) {
                    primitives.method_75473(from, to, argb, width);
                }
                from = to;
            }
        }
    }

    public static void drawSphereFaces(class_12160 primitives, float cx, float cy, float cz, float r, int subd, int argb) {
        float step = (float)Math.PI / (float)(subd / 2);
        int num_steps180 = (int)(Math.PI / (double)step) + 1;
        int num_steps360 = (int)(Math.PI * 2 / (double)step);
        for (int i = 0; i <= num_steps360; ++i) {
            float theta = (float)i * step;
            float thetaprime = theta + step;
            float xb = 0.0f;
            float zb = 0.0f;
            float xbp = 0.0f;
            float zbp = 0.0f;
            float yp = r;
            for (int j = 0; j <= num_steps180; ++j) {
                float phi = (float)j * step;
                float x = r * class_3532.method_15374((float)phi) * class_3532.method_15362((float)theta);
                float z = r * class_3532.method_15374((float)phi) * class_3532.method_15374((float)theta);
                float y = r * class_3532.method_15362((float)phi);
                float xp = r * class_3532.method_15374((float)phi) * class_3532.method_15362((float)thetaprime);
                float zp = r * class_3532.method_15374((float)phi) * class_3532.method_15374((float)thetaprime);
                primitives.method_75474(new class_243((double)(xb + cx), (double)(yp + cy), (double)(zb + cz)), new class_243((double)(xbp + cx), (double)(yp + cy), (double)(zbp + cz)), new class_243((double)(xp + cx), (double)(y + cy), (double)(zp + cz)), new class_243((double)(x + cx), (double)(y + cy), (double)(z + cz)), argb);
                xb = x;
                zb = z;
                xbp = xp;
                zbp = zp;
                yp = y;
            }
        }
    }

    public static abstract class RenderedShape<T extends ShapeDispatcher.ExpiringShape> {
        protected T shape;
        protected class_310 client;
        long expiryTick;
        double renderEpsilon;

        public abstract void renderLines(class_4587 var1, class_289 var2, double var3, double var5, double var7, float var9, class_11658 var10, class_12160 var11);

        public void renderFaces(class_289 tesselator, double cx, double cy, double cz, float partialTick, class_12160 primitives) {
        }

        protected RenderedShape(class_310 client, T shape) {
            this.shape = shape;
            this.client = client;
            this.expiryTick = client.field_1687.method_75260() + (long)((ShapeDispatcher.ExpiringShape)shape).getExpiry();
            this.renderEpsilon = (3.0 + (double)this.key() / 9.223372036854776E18) / 1000.0;
        }

        public boolean isExpired(long currentTick) {
            return this.expiryTick < currentTick;
        }

        public long key() {
            return ((ShapeDispatcher.ExpiringShape)this.shape).key(this.client.field_1687.method_30349());
        }

        public boolean shouldRender(class_5321<class_1937> dim) {
            if (((ShapeDispatcher.ExpiringShape)this.shape).followEntity <= 0) {
                return true;
            }
            if (this.client.field_1687 == null) {
                return false;
            }
            if (this.client.field_1687.method_27983() != dim) {
                return false;
            }
            return this.client.field_1687.method_8469(((ShapeDispatcher.ExpiringShape)this.shape).followEntity) != null;
        }

        public boolean stageDeux() {
            return false;
        }

        public void promoteWith(RenderedShape<?> rshape) {
            this.expiryTick = rshape.expiryTick;
        }
    }

    public static class RenderedCylinder
    extends RenderedShape<ShapeDispatcher.Cylinder> {
        public RenderedCylinder(class_310 client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Cylinder)shape);
        }

        @Override
        public void renderLines(class_4587 matrices, class_289 tesselator, double cx, double cy, double cz, float partialTick, class_11658 levelRenderState, class_12160 primitives) {
            if ((double)((ShapeDispatcher.Cylinder)this.shape).a == 0.0) {
                return;
            }
            class_243 vc = ((ShapeDispatcher.Cylinder)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Cylinder)this.shape).center, partialTick);
            double dir = class_3532.method_17822((double)((ShapeDispatcher.Cylinder)this.shape).height);
            ShapesRenderer.drawCylinderWireframe(primitives, (float)(vc.field_1352 - dir * this.renderEpsilon), (float)(vc.field_1351 - dir * this.renderEpsilon), (float)(vc.field_1350 - dir * this.renderEpsilon), (float)((double)((ShapeDispatcher.Cylinder)this.shape).radius + this.renderEpsilon), (float)((double)((ShapeDispatcher.Cylinder)this.shape).height + 2.0 * dir * this.renderEpsilon), ((ShapeDispatcher.Cylinder)this.shape).axis, ((ShapeDispatcher.Cylinder)this.shape).subdivisions, ((ShapeDispatcher.Cylinder)this.shape).height == 0.0f, ((ShapeDispatcher.Cylinder)this.shape).argb, ((ShapeDispatcher.Cylinder)this.shape).lineWidth);
        }

        @Override
        public void renderFaces(class_289 tesselator, double cx, double cy, double cz, float partialTick, class_12160 primitives) {
            if ((double)((ShapeDispatcher.Cylinder)this.shape).fa == 0.0) {
                return;
            }
            class_243 vc = ((ShapeDispatcher.Cylinder)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Cylinder)this.shape).center, partialTick);
            double dir = class_3532.method_17822((double)((ShapeDispatcher.Cylinder)this.shape).height);
            ShapesRenderer.drawCylinderFaces(primitives, (float)(vc.field_1352 - dir * this.renderEpsilon), (float)(vc.field_1351 - dir * this.renderEpsilon), (float)(vc.field_1350 - dir * this.renderEpsilon), (float)((double)((ShapeDispatcher.Cylinder)this.shape).radius + this.renderEpsilon), (float)((double)((ShapeDispatcher.Cylinder)this.shape).height + 2.0 * dir * this.renderEpsilon), ((ShapeDispatcher.Cylinder)this.shape).axis, ((ShapeDispatcher.Cylinder)this.shape).subdivisions, ((ShapeDispatcher.Cylinder)this.shape).radius == 0.0f, ((ShapeDispatcher.Cylinder)this.shape).fargb);
        }
    }

    public static class RenderedSphere
    extends RenderedShape<ShapeDispatcher.Sphere> {
        public RenderedSphere(class_310 client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Sphere)shape);
        }

        @Override
        public void renderLines(class_4587 matrices, class_289 tesselator, double cx, double cy, double cz, float partialTick, class_11658 levelRenderState, class_12160 primitives) {
            if ((double)((ShapeDispatcher.Sphere)this.shape).a == 0.0) {
                return;
            }
            class_243 vc = ((ShapeDispatcher.Sphere)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Sphere)this.shape).center, partialTick);
            ShapesRenderer.drawSphereWireframe(primitives, (float)vc.field_1352, (float)vc.field_1351, (float)vc.field_1350, (float)((double)((ShapeDispatcher.Sphere)this.shape).radius + this.renderEpsilon), ((ShapeDispatcher.Sphere)this.shape).subdivisions, ((ShapeDispatcher.Sphere)this.shape).argb, ((ShapeDispatcher.Sphere)this.shape).lineWidth);
        }

        @Override
        public void renderFaces(class_289 tesselator, double cx, double cy, double cz, float partialTick, class_12160 primitives) {
            if ((double)((ShapeDispatcher.Sphere)this.shape).fa == 0.0) {
                return;
            }
            class_243 vc = ((ShapeDispatcher.Sphere)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Sphere)this.shape).center, partialTick);
            ShapesRenderer.drawSphereFaces(primitives, (float)vc.field_1352, (float)vc.field_1351, (float)vc.field_1350, (float)((double)((ShapeDispatcher.Sphere)this.shape).radius + this.renderEpsilon), ((ShapeDispatcher.Sphere)this.shape).subdivisions, ((ShapeDispatcher.Sphere)this.shape).fargb);
        }
    }

    public static class RenderedPolyface
    extends RenderedShape<ShapeDispatcher.Polyface> {
        private static final VertexFormat.class_5596[] faceIndices = new VertexFormat.class_5596[]{VertexFormat.class_5596.field_27377, VertexFormat.class_5596.field_27377, VertexFormat.class_5596.field_29344, VertexFormat.class_5596.field_29345, VertexFormat.class_5596.field_27379, VertexFormat.class_5596.field_27380, VertexFormat.class_5596.field_27381, VertexFormat.class_5596.field_27382};
        private static final class_1921[] renderTypes = new class_1921[]{class_1921.method_23594(), class_1921.method_23594(), class_1921.method_23594(), class_1921.method_23594(), class_1921.method_62278(), class_1921.method_62278(), class_1921.method_62278(), class_1921.method_49042()};

        public RenderedPolyface(class_310 client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Polyface)shape);
        }

        @Override
        public void renderFaces(class_289 tesselator, double cx, double cy, double cz, float partialTick, class_12160 primitives) {
            if (((ShapeDispatcher.Polyface)this.shape).fa == 0.0f) {
                return;
            }
            if (((ShapeDispatcher.Polyface)this.shape).doublesided) {
                // empty if block
            }
            for (int i = 0; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size(); ++i) {
                class_243 vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                if (!((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) continue;
                vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((class_1937)this.client.field_1687, vec, partialTick);
            }
        }

        @Override
        public void renderLines(class_4587 matrices, class_289 tesselator, double cx, double cy, double cz, float partialTick, class_11658 levelRenderState, class_12160 primitives) {
            if (((ShapeDispatcher.Polyface)this.shape).a == 0.0f) {
                return;
            }
            if (((ShapeDispatcher.Polyface)this.shape).mode == 6) {
                class_243 vec;
                int i;
                class_243 vec0 = null;
                for (i = 0; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size(); ++i) {
                    vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((class_1937)this.client.field_1687, vec, partialTick);
                    }
                    if (i != 0) continue;
                    vec0 = vec;
                }
                if (((ShapeDispatcher.Polyface)this.shape).inneredges) {
                    for (i = 1; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size() - 1; ++i) {
                        vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                        if (!((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) continue;
                        vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((class_1937)this.client.field_1687, vec, partialTick);
                    }
                }
                return;
            }
            if (((ShapeDispatcher.Polyface)this.shape).mode == 5) {
                int i;
                class_243 vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(1);
                if (((ShapeDispatcher.Polyface)this.shape).relative.get(1).booleanValue()) {
                    vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((class_1937)this.client.field_1687, vec, partialTick);
                }
                for (i = 0; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size(); i += 2) {
                    vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                    if (!((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) continue;
                    vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((class_1937)this.client.field_1687, vec, partialTick);
                }
                i = ((ShapeDispatcher.Polyface)this.shape).vertexList.size() - 1;
                i -= 1 - i % 2;
                while (i > 0) {
                    vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((class_1937)this.client.field_1687, vec, partialTick);
                    }
                    i -= 2;
                }
                if (((ShapeDispatcher.Polyface)this.shape).inneredges) {
                    for (i = 2; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size() - 1; ++i) {
                        vec = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                        if (!((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) continue;
                        vec = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((class_1937)this.client.field_1687, vec, partialTick);
                    }
                }
                return;
            }
            if (((ShapeDispatcher.Polyface)this.shape).mode == 4) {
                for (int i = 0; i < ((ShapeDispatcher.Polyface)this.shape).vertexList.size(); ++i) {
                    class_243 vecA = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vecA = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((class_1937)this.client.field_1687, vecA, partialTick);
                    }
                    class_243 vecB = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(++i);
                    if (((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) {
                        vecB = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((class_1937)this.client.field_1687, vecB, partialTick);
                    }
                    class_243 vecC = ((ShapeDispatcher.Polyface)this.shape).vertexList.get(++i);
                    if (!((ShapeDispatcher.Polyface)this.shape).relative.get(i).booleanValue()) continue;
                    vecC = ((ShapeDispatcher.Polyface)this.shape).relativiseRender((class_1937)this.client.field_1687, vecC, partialTick);
                }
            }
        }
    }

    public static class RenderedLine
    extends RenderedShape<ShapeDispatcher.Line> {
        public RenderedLine(class_310 client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Line)shape);
        }

        @Override
        public void renderLines(class_4587 matrices, class_289 tesselator, double cx, double cy, double cz, float partialTick, class_11658 levelRenderState, class_12160 primitives) {
            class_243 v1 = ((ShapeDispatcher.Line)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Line)this.shape).from, partialTick);
            class_243 v2 = ((ShapeDispatcher.Line)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Line)this.shape).to, partialTick);
            primitives.method_75473(new class_243(v1.field_1352 - this.renderEpsilon, v1.field_1351 - this.renderEpsilon, v1.field_1350 - this.renderEpsilon), new class_243(v2.field_1352 + this.renderEpsilon, v2.field_1351 + this.renderEpsilon, v2.field_1350 + this.renderEpsilon), ((ShapeDispatcher.Line)this.shape).argb, ((ShapeDispatcher.Line)this.shape).lineWidth);
        }
    }

    public static class RenderedBox
    extends RenderedShape<ShapeDispatcher.Box> {
        private RenderedBox(class_310 client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.Box)shape);
        }

        @Override
        public void renderLines(class_4587 matrices, class_289 tesselator, double cx, double cy, double cz, float partialTick, class_11658 levelRenderState, class_12160 primitives) {
            if ((double)((ShapeDispatcher.Box)this.shape).a == 0.0) {
                return;
            }
            class_243 v1 = ((ShapeDispatcher.Box)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Box)this.shape).from, partialTick);
            class_243 v2 = ((ShapeDispatcher.Box)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Box)this.shape).to, partialTick);
            ShapesRenderer.drawBoxWireGLLines(primitives, (float)(v1.field_1352 - this.renderEpsilon), (float)(v1.field_1351 - this.renderEpsilon), (float)(v1.field_1350 - this.renderEpsilon), (float)(v2.field_1352 + this.renderEpsilon), (float)(v2.field_1351 + this.renderEpsilon), (float)(v2.field_1350 + this.renderEpsilon), v1.field_1352 != v2.field_1352, v1.field_1351 != v2.field_1351, v1.field_1350 != v2.field_1350, ((ShapeDispatcher.Box)this.shape).argb, ((ShapeDispatcher.Box)this.shape).lineWidth);
        }

        @Override
        public void renderFaces(class_289 tesselator, double cx, double cy, double cz, float partialTick, class_12160 primitives) {
            if ((double)((ShapeDispatcher.Box)this.shape).fa == 0.0) {
                return;
            }
            class_243 v1 = ((ShapeDispatcher.Box)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Box)this.shape).from, partialTick);
            class_243 v2 = ((ShapeDispatcher.Box)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.Box)this.shape).to, partialTick);
            ShapesRenderer.drawBoxFaces(primitives, (float)(v1.field_1352 - this.renderEpsilon), (float)(v1.field_1351 - this.renderEpsilon), (float)(v1.field_1350 - this.renderEpsilon), (float)(v2.field_1352 + this.renderEpsilon), (float)(v2.field_1351 + this.renderEpsilon), (float)(v2.field_1350 + this.renderEpsilon), v1.field_1352 != v2.field_1352, v1.field_1351 != v2.field_1351, v1.field_1350 != v2.field_1350, ((ShapeDispatcher.Box)this.shape).fargb);
        }
    }

    public static class RenderedText
    extends RenderedShape<ShapeDispatcher.DisplayedText> {
        protected RenderedText(class_310 client, ShapeDispatcher.ExpiringShape shape) {
            super(client, (ShapeDispatcher.DisplayedText)shape);
        }

        @Override
        public void renderLines(class_4587 matrices, class_289 tesselator, double cx, double cy, double cz, float partialTick, class_11658 levelRenderState, class_12160 primitives) {
            if ((double)((ShapeDispatcher.DisplayedText)this.shape).a == 0.0) {
                return;
            }
            class_243 v1 = ((ShapeDispatcher.DisplayedText)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.DisplayedText)this.shape).pos, partialTick);
            class_4184 camera1 = this.client.field_1773.method_19418();
            class_327 textRenderer = this.client.field_1772;
            if (((ShapeDispatcher.DisplayedText)this.shape).doublesided) {
                // empty if block
            }
            matrices.method_22903();
            matrices.method_22904(v1.field_1352 - cx, v1.field_1351 - cy, v1.field_1350 - cz);
            ShapesRenderer.rotatePoseStackByShapeDirection(matrices, ((ShapeDispatcher.DisplayedText)this.shape).facing, camera1, v1);
            matrices.method_22905(((ShapeDispatcher.DisplayedText)this.shape).size * 0.0025f, -((ShapeDispatcher.DisplayedText)this.shape).size * 0.0025f, ((ShapeDispatcher.DisplayedText)this.shape).size * 0.0025f);
            if (((ShapeDispatcher.DisplayedText)this.shape).tilt != 0.0f) {
                matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(((ShapeDispatcher.DisplayedText)this.shape).tilt));
            }
            if (((ShapeDispatcher.DisplayedText)this.shape).lean != 0.0f) {
                matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(((ShapeDispatcher.DisplayedText)this.shape).lean));
            }
            if (((ShapeDispatcher.DisplayedText)this.shape).turn != 0.0f) {
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(((ShapeDispatcher.DisplayedText)this.shape).turn));
            }
            matrices.method_22904((double)(-10.0f * ((ShapeDispatcher.DisplayedText)this.shape).indent), (double)(-10.0f * ((ShapeDispatcher.DisplayedText)this.shape).height - 9.0f), -10.0 * this.renderEpsilon - (double)(10.0f * ((ShapeDispatcher.DisplayedText)this.shape).raise));
            matrices.method_22905(-1.0f, 1.0f, 1.0f);
            float text_x = 0.0f;
            if (((ShapeDispatcher.DisplayedText)this.shape).align == 0) {
                text_x = (float)(-textRenderer.method_1727(((ShapeDispatcher.DisplayedText)this.shape).value.getString())) / 2.0f;
            } else if (((ShapeDispatcher.DisplayedText)this.shape).align == 1) {
                text_x = -textRenderer.method_1727(((ShapeDispatcher.DisplayedText)this.shape).value.getString());
            }
            class_4597.class_4598 immediate = class_4597.method_22991((class_9799)new class_9799(1536));
            textRenderer.method_27522(((ShapeDispatcher.DisplayedText)this.shape).value, text_x, 0.0f, ((ShapeDispatcher.DisplayedText)this.shape).textcolor, false, matrices.method_23760().method_23761(), (class_4597)immediate, class_327.class_6415.field_33994, ((ShapeDispatcher.DisplayedText)this.shape).textbck, 0xF000F0);
            immediate.method_22993();
            matrices.method_22909();
        }

        @Override
        public boolean stageDeux() {
            return true;
        }

        @Override
        public void promoteWith(RenderedShape<?> rshape) {
            super.promoteWith(rshape);
            try {
                ((ShapeDispatcher.DisplayedText)this.shape).value = ((ShapeDispatcher.DisplayedText)rshape.shape).value;
            }
            catch (ClassCastException ignored) {
                CarpetScriptServer.LOG.error("shape " + String.valueOf(rshape.shape.getClass()) + " cannot cast to a Label");
            }
        }
    }

    public static class RenderedSprite
    extends RenderedShape<ShapeDispatcher.DisplayedSprite> {
        private final boolean isitem;
        private class_811 transformType = class_811.field_4315;
        private class_2338 blockPos;
        private class_2680 blockState;
        private class_2586 BlockEntity = null;

        protected RenderedSprite(class_310 client, ShapeDispatcher.ExpiringShape shape, boolean isitem) {
            super(client, (ShapeDispatcher.DisplayedSprite)shape);
            this.isitem = isitem;
            if (isitem) {
                this.transformType = class_811.valueOf((String)((ShapeDispatcher.DisplayedSprite)shape).itemTransformType.toUpperCase(Locale.ROOT));
            }
        }

        @Override
        public void renderLines(class_4587 matrices, class_289 tesselator, double cx, double cy, double cz, float partialTick, class_11658 levelRenderState, class_12160 primitives) {
            if ((double)((ShapeDispatcher.DisplayedSprite)this.shape).a == 0.0) {
                return;
            }
            class_243 v1 = ((ShapeDispatcher.DisplayedSprite)this.shape).relativiseRender((class_1937)this.client.field_1687, ((ShapeDispatcher.DisplayedSprite)this.shape).pos, partialTick);
            class_4184 camera1 = this.client.field_1773.method_19418();
            matrices.method_22903();
            if (!this.isitem) {
                matrices.method_22904(0.5, 0.5, 0.5);
            }
            matrices.method_22904(v1.field_1352 - cx, v1.field_1351 - cy, v1.field_1350 - cz);
            ShapesRenderer.rotatePoseStackByShapeDirection(matrices, ((ShapeDispatcher.DisplayedSprite)this.shape).facing, camera1, this.isitem ? v1 : v1.method_1031(0.5, 0.5, 0.5));
            if (((ShapeDispatcher.DisplayedSprite)this.shape).tilt != 0.0f) {
                matrices.method_22907((Quaternionfc)class_7833.field_40718.rotationDegrees(-((ShapeDispatcher.DisplayedSprite)this.shape).tilt));
            }
            if (((ShapeDispatcher.DisplayedSprite)this.shape).lean != 0.0f) {
                matrices.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(-((ShapeDispatcher.DisplayedSprite)this.shape).lean));
            }
            if (((ShapeDispatcher.DisplayedSprite)this.shape).turn != 0.0f) {
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(((ShapeDispatcher.DisplayedSprite)this.shape).turn));
            }
            matrices.method_22905(((ShapeDispatcher.DisplayedSprite)this.shape).scaleX, ((ShapeDispatcher.DisplayedSprite)this.shape).scaleY, ((ShapeDispatcher.DisplayedSprite)this.shape).scaleZ);
            if (!this.isitem) {
                matrices.method_22904(-0.5, -0.5, -0.5);
            } else {
                matrices.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f));
            }
            this.blockPos = class_2338.method_49638((class_2374)v1);
            int light = 0;
            if (this.client.field_1687 != null) {
                light = class_765.method_23687((int)(((ShapeDispatcher.DisplayedSprite)this.shape).blockLight < 0 ? this.client.field_1687.method_8314(class_1944.field_9282, this.blockPos) : ((ShapeDispatcher.DisplayedSprite)this.shape).blockLight), (int)(((ShapeDispatcher.DisplayedSprite)this.shape).skyLight < 0 ? this.client.field_1687.method_8314(class_1944.field_9284, this.blockPos) : ((ShapeDispatcher.DisplayedSprite)this.shape).skyLight));
            }
            this.blockState = ((ShapeDispatcher.DisplayedSprite)this.shape).blockState;
            class_4597.class_4598 immediate = this.client.method_22940().method_23000();
            if (!this.isitem) {
                class_2248 color2;
                if (this.blockState.method_26217() == class_2464.field_11458) {
                    class_1087 bakedModel = this.client.method_1541().method_3349(this.blockState);
                    int color2 = this.client.method_1505().method_1697(this.blockState, (class_1920)this.client.field_1687, this.blockPos, 0);
                    float red = (float)(color2 >> 16 & 0xFF) / 255.0f;
                    float green = (float)(color2 >> 8 & 0xFF) / 255.0f;
                    float blue = (float)(color2 & 0xFF) / 255.0f;
                    class_1921 type = this.blockState.method_26204() instanceof class_2397 && (Boolean)class_310.method_1551().field_1690.method_75334().method_41753() == false ? class_1921.method_23577() : class_4696.method_23683((class_2680)this.blockState);
                    this.client.method_1541().method_3350();
                    class_778.method_3367((class_4587.class_4665)matrices.method_23760(), (class_4588)immediate.method_73477(type), (class_1087)bakedModel, (float)red, (float)green, (float)blue, (int)light, (int)class_4608.field_21444);
                }
                if (this.BlockEntity == null && (color2 = this.blockState.method_26204()) instanceof class_2343) {
                    class_2343 eb = (class_2343)color2;
                    this.BlockEntity = eb.method_10123(this.blockPos, this.blockState);
                    if (this.BlockEntity != null) {
                        this.BlockEntity.method_31662((class_1937)this.client.field_1687);
                        if (((ShapeDispatcher.DisplayedSprite)this.shape).blockEntity != null) {
                            try (class_8942.class_11340 reporter = new class_8942.class_11340(this.BlockEntity.method_71402(), CarpetScriptServer.LOG);){
                                this.BlockEntity.method_58690(class_11352.method_71417((class_8942)reporter, (class_7225.class_7874)this.client.field_1687.method_30349(), (class_2487)((ShapeDispatcher.DisplayedSprite)this.shape).blockEntity));
                            }
                        }
                    }
                }
                if (this.BlockEntity != null) {
                    class_827 blockEntityRenderer = this.client.method_31975().method_3550(this.BlockEntity);
                    class_11954 state = this.client.method_31975().method_74348(this.BlockEntity, partialTick, null);
                    if (blockEntityRenderer != null && state != null) {
                        blockEntityRenderer.method_3569(state, matrices, (class_11659)this.client.field_1773.method_72911().method_73003(), levelRenderState.field_63082);
                    }
                }
            } else if (((ShapeDispatcher.DisplayedSprite)this.shape).item != null) {
                class_10444 itemState = new class_10444();
                this.client.method_65386().method_65598(itemState, ((ShapeDispatcher.DisplayedSprite)this.shape).item, class_811.field_4319, (class_1937)this.client.field_1687, null, 0);
                itemState.method_65604(matrices, (class_11659)this.client.field_1773.method_72911().method_73003(), light, class_4608.field_21444, 0);
            }
            matrices.method_22909();
            immediate.method_22993();
        }

        @Override
        public boolean stageDeux() {
            return true;
        }
    }
}

