/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.packrulemenus;

import fr.estecka.packrulemenus.PackRuleMod;
import fr.estecka.packrulemenus.gui.GenericWarningScreen;
import fr.estecka.packrulemenus.mixin.IMinecraftServerMixin;
import java.util.Collection;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3283;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_5375;
import net.minecraft.class_638;
import net.minecraft.class_7699;
import net.minecraft.class_7701;
import net.minecraft.class_7712;

public class DatapackHandler {
    private final class_437 parent;
    private final class_1132 server;
    private final class_3283 manager;
    private final Collection<String> rollback;
    private static final class_310 client = class_310.method_1551();

    private DatapackHandler(class_437 parent, class_1132 server) {
        this.parent = parent;
        this.server = server;
        this.manager = server.method_3836();
        this.rollback = this.manager.method_29210();
    }

    public static class_4185 CreateButton(class_437 parent, class_1132 server) {
        return class_4185.method_46430((class_2561)class_2561.method_43471((String)"selectWorld.dataPacks"), __ -> client.method_1507((class_437)new DatapackHandler(parent, server).CreateScreen())).method_46431();
    }

    public class_5375 CreateScreen() {
        return new class_5375(this.server.method_3836(), manager -> this.HandleDatapackRefresh((class_3283)manager, this.rollback), this.server.method_27050(class_5218.field_24186), (class_2561)class_2561.method_43471((String)"dataPack.title"));
    }

    private void HandleDatapackRefresh(class_3283 manager, Collection<String> rollback) {
        class_7699 oldFeatures;
        class_7699 neoFeatures = manager.method_45278();
        if (!neoFeatures.equals((Object)(oldFeatures = this.server.method_27728().method_45560()))) {
            boolean isExperimental = class_7701.method_45406((class_7699)neoFeatures);
            boolean wasVanillaRemoved = oldFeatures.method_45403(class_7701.field_40177) && !neoFeatures.method_45403(class_7701.field_40177);
            this.ShowFeatureWarning(isExperimental, wasVanillaRemoved);
        } else if (PackRuleMod.CONFIG.datapackConfirmation) {
            this.ShowConfirmationScreen();
        } else {
            this.ReloadPacks();
        }
    }

    private void ApplyFlags() {
        class_7699 features = this.manager.method_45278();
        Object featureNames = "";
        for (class_2960 id : class_7701.field_40180.method_45392(features)) {
            featureNames = (String)featureNames + id.toString() + ", ";
        }
        PackRuleMod.LOGGER.info("Reloading packs with features: {}", featureNames);
        this.server.method_27728().method_29590(new class_7712(IMinecraftServerMixin.callCreateDataPackSettings(this.manager, true), features));
    }

    private void SaveAndQuit() {
        this.ApplyFlags();
        this.server.method_3747(false);
        if (DatapackHandler.client.field_1687 != null) {
            DatapackHandler.client.field_1687.method_8525(class_638.field_61021);
        }
        client.method_72099();
        client.method_1507((class_437)new class_442());
    }

    private void ReloadPacks() {
        DatapackHandler.client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"commands.reload.success"));
        this.server.method_29439(this.manager.method_29210()).exceptionally(e -> {
            PackRuleMod.LOGGER.error("{}", e);
            DatapackHandler.client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"commands.reload.failure").method_27692(class_124.field_1061));
            return null;
        });
        client.method_1507(this.parent);
    }

    private void Rollback() {
        this.manager.method_14447(this.rollback);
        client.method_1507(this.parent);
    }

    public void ShowConfirmationScreen() {
        client.method_1507((class_437)new GenericWarningScreen((class_2561)class_2561.method_43471((String)"packrulemenus.warning.packConfirmation.title"), (class_2561)class_2561.method_43471((String)"packrulemenus.warning.packConfirmation.message"), (class_2561)class_2561.method_43471((String)"packrulemenus.warning.packConfirmation.checkbox"), false, checked -> {
            if (checked) {
                this.SaveAndQuit();
            } else {
                this.ReloadPacks();
            }
        }, this::Rollback));
    }

    public void ShowFeatureWarning(boolean isExperimental, boolean wasVanillaRemoved) {
        class_5250 msg = class_2561.method_43471((String)"packrulemenus.warning.featureflag.message");
        if (isExperimental) {
            msg.method_27693("\n\n").method_10852((class_2561)class_2561.method_43471((String)"selectWorld.experimental.message"));
        }
        client.method_1507((class_437)new GenericWarningScreen((class_2561)class_2561.method_43471((String)"packrulemenus.warning.featureflag.title"), (class_2561)msg, (class_2561)class_2561.method_43471((String)"packrulemenus.warning.featureflag.checkbox"), true, checked -> {
            if (wasVanillaRemoved) {
                this.ShowVanillaWarning();
            } else if (checked) {
                this.SaveAndQuit();
            }
        }, this::Rollback));
    }

    public void ShowVanillaWarning() {
        client.method_1507((class_437)new GenericWarningScreen((class_2561)class_2561.method_43471((String)"packrulemenus.warning.vanillapack.title"), (class_2561)class_2561.method_43471((String)"packrulemenus.warning.vanillapack.message"), (class_2561)class_2561.method_43471((String)"packrulemenus.warning.vanillapack.checkbox"), true, checked -> {
            if (checked) {
                this.SaveAndQuit();
            }
        }, this::Rollback));
    }
}

