/*
 * Decompiled with CFR 0.152.
 */
package fr.estecka.packrulemenus.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigIO {
    public static final String VERSION = "1.3";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ConfigIO");
    private final File file;

    public ConfigIO(File file) {
        this.file = file;
    }

    public ConfigIO(Path path) {
        this(path.toFile());
    }

    public ConfigIO(String fileName) {
        this(FabricLoader.getInstance().getConfigDir().resolve(fileName));
    }

    public void GetOrCreate(ICodec config) throws IOException {
        if (!this.GetIfExists(config)) {
            this.Write(config);
        }
    }

    public boolean GetIfExists(ICodec config) throws IOException {
        if (this.file.exists()) {
            Map<String, String> properties = ConfigIO.ReadFile(this.file);
            config.Decode(properties);
            return true;
        }
        return false;
    }

    public void Write(ICodec config) throws IOException {
        ConfigIO.WriteFile(this.file, config.Encode());
    }

    public static Map<String, String> ReadFile(File file) throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>();
        try (Scanner scanner = new Scanner(file);){
            int lineNo = 0;
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                int split = line.indexOf(61);
                if (!line.isEmpty() && !line.startsWith("#")) {
                    if (split < 0 || line.length() <= split + 1) {
                        String msg = String.format("Missing value at line %d\n in file %s", lineNo, file.toString());
                        LOGGER.error(msg);
                        throw new IllegalArgumentException(msg);
                    }
                    properties.put(line.substring(0, split), line.substring(split + 1, line.length()));
                }
                ++lineNo;
            }
        }
        catch (IOException e) {
            LOGGER.error("{}", (Throwable)e);
            throw e;
        }
        return properties;
    }

    public static void WriteFile(File file, Map<String, String> properties) throws IOException {
        file.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(file, false);){
            PrintWriter writer = new PrintWriter(out);
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                writer.write(entry.getKey());
                writer.write(61);
                writer.write(entry.getValue());
                writer.write(10);
                writer.flush();
            }
        }
    }

    public static interface ICodec {
        public void Decode(Map<String, String> var1);

        public Map<String, String> Encode();
    }

    public record Property<T>(Supplier<T> getter, Consumer<T> setter, Function<String, T> parser, Function<T, String> encoder) {
        public static Property<String> String(Supplier<String> getter, Consumer<String> setter) {
            return new Property<String>(getter, setter, s -> s, s -> s);
        }

        public static Property<Integer> Integer(Supplier<Integer> getter, Consumer<Integer> setter) {
            return new Property<Integer>(getter, setter, Integer::parseInt, i -> i.toString());
        }

        public static Property<Float> Float(Supplier<Float> getter, Consumer<Float> setter) {
            return new Property<Float>(getter, setter, Float::parseFloat, f -> f.toString());
        }

        public static Property<Double> Double(Supplier<Double> getter, Consumer<Double> setter) {
            return new Property<Double>(getter, setter, Double::parseDouble, f -> f.toString());
        }

        public static Property<Boolean> Boolean(Supplier<Boolean> getter, Consumer<Boolean> setter) {
            return new Property<Boolean>(getter, setter, Boolean::parseBoolean, b -> b.toString());
        }

        public void Decode(String s) {
            this.setter.accept(this.parser.apply(s));
        }

        public String Encode() {
            return this.encoder.apply(this.getter.get());
        }
    }

    public static abstract class AFixedCoded
    implements ICodec {
        public abstract Map<String, Property<?>> GetProperties();

        @Override
        public void Decode(Map<String, String> values) {
            Map<String, Property<?>> codec = this.GetProperties();
            for (String key : codec.keySet()) {
                if (!values.containsKey(key)) continue;
                String value = values.get(key);
                try {
                    codec.get(key).Decode(value);
                }
                catch (IllegalArgumentException e) {
                    String msg = String.format("Invalid value for \"%s\": \"%s\"", key, value);
                    LOGGER.error(msg);
                }
            }
        }

        @Override
        public Map<String, String> Encode() {
            LinkedHashMap<String, String> values = new LinkedHashMap<String, String>();
            for (Map.Entry<String, Property<?>> entry : this.GetProperties().entrySet()) {
                Property<?> p = entry.getValue();
                values.put(entry.getKey(), p.Encode());
            }
            return values;
        }
    }
}

