/*
 * Decompiled with CFR 0.152.
 */
package net.foxy.boers.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.foxy.boers.client.model.WrappedItemOverrides;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.NeoForgeRenderTypes;
import net.neoforged.neoforge.client.model.ExtraFaceData;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.geometry.IGeometryBakingContext;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.client.model.geometry.IUnbakedGeometry;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import org.jetbrains.annotations.Nullable;

public class BoerModel
implements IUnbakedGeometry<BoerModel> {
    @Nullable
    private ImmutableList<Material> textures;
    private final Int2ObjectMap<ExtraFaceData> layerData;
    private final Int2ObjectMap<ResourceLocation> renderTypeNames;

    private BoerModel(@Nullable ImmutableList<Material> textures, Int2ObjectMap<ExtraFaceData> layerData, Int2ObjectMap<ResourceLocation> renderTypeNames) {
        this.textures = textures;
        this.layerData = layerData;
        this.renderTypeNames = renderTypeNames;
    }

    public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides) {
        if (this.textures == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            int i = 0;
            while (context.hasMaterial("layer" + i)) {
                builder.add((Object)context.getMaterial("layer" + i));
                ++i;
            }
            this.textures = builder.build();
        }
        TextureAtlasSprite particle = spriteGetter.apply(context.hasMaterial("particle") ? context.getMaterial("particle") : (Material)this.textures.get(0));
        Transformation rootTransform = context.getRootTransform();
        if (!rootTransform.isIdentity()) {
            modelState = UnbakedGeometryHelper.composeRootTransformIntoModelState((ModelState)modelState, (Transformation)rootTransform);
        }
        Baked.Builder builder = Baked.builder(context, particle, overrides, context.getTransforms());
        return builder.build();
    }

    public static class Baked
    implements IDynamicBakedModel {
        private final boolean isAmbientOcclusion;
        private final boolean isGui3d;
        private final boolean isSideLit;
        private final TextureAtlasSprite particle;
        private final ItemOverrides overrides;
        private final ItemTransforms transforms;
        public final HashMap<ResourceLocation, BakedModel> children = new HashMap();

        public Baked(boolean isGui3d, boolean isSideLit, boolean isAmbientOcclusion, TextureAtlasSprite particle, ItemTransforms transforms, ItemOverrides overrides, ImmutableMap<String, List<BakedQuad>> children) {
            this.isAmbientOcclusion = isAmbientOcclusion;
            this.isGui3d = isGui3d;
            this.isSideLit = isSideLit;
            this.particle = particle;
            this.overrides = new WrappedItemOverrides();
            this.transforms = transforms;
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData data, @Nullable RenderType renderType) {
            return List.of();
        }

        public boolean useAmbientOcclusion() {
            return this.isAmbientOcclusion;
        }

        public boolean isGui3d() {
            return this.isGui3d;
        }

        public boolean usesBlockLight() {
            return this.isSideLit;
        }

        public boolean isCustomRenderer() {
            return false;
        }

        public TextureAtlasSprite getParticleIcon() {
            return this.particle;
        }

        public ItemOverrides getOverrides() {
            return this.overrides;
        }

        public ItemTransforms getTransforms() {
            return this.transforms;
        }

        public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
            return ChunkRenderTypeSet.of((RenderType[])new RenderType[]{NeoForgeRenderTypes.ITEM_UNSORTED_TRANSLUCENT.get()});
        }

        public List<BakedModel> getRenderPasses(ItemStack itemStack, boolean fabulous) {
            return List.of(this);
        }

        public static Builder builder(IGeometryBakingContext owner, TextureAtlasSprite particle, ItemOverrides overrides, ItemTransforms cameraTransforms) {
            return Baked.builder(owner.useAmbientOcclusion(), owner.isGui3d(), owner.useBlockLight(), particle, overrides, cameraTransforms);
        }

        public static Builder builder(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, TextureAtlasSprite particle, ItemOverrides overrides, ItemTransforms cameraTransforms) {
            return new Builder(isAmbientOcclusion, isGui3d, isSideLit, particle, overrides, cameraTransforms);
        }

        public static class Builder {
            private final boolean isAmbientOcclusion;
            private final boolean isGui3d;
            private final boolean isSideLit;
            private final Map<String, List<BakedQuad>> children = new HashMap<String, List<BakedQuad>>();
            private final ItemOverrides overrides;
            private final ItemTransforms transforms;
            private TextureAtlasSprite particle;

            private Builder(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, TextureAtlasSprite particle, ItemOverrides overrides, ItemTransforms transforms) {
                this.isAmbientOcclusion = isAmbientOcclusion;
                this.isGui3d = isGui3d;
                this.isSideLit = isSideLit;
                this.particle = particle;
                this.overrides = overrides;
                this.transforms = transforms;
            }

            public Builder setParticle(TextureAtlasSprite particleSprite) {
                this.particle = particleSprite;
                return this;
            }

            public Builder addQuads(String texture, List<BakedQuad> quadsToAdd) {
                this.children.put(texture, quadsToAdd);
                return this;
            }

            public BakedModel build() {
                ImmutableMap.Builder childrenBuilder = ImmutableMap.builder();
                ImmutableList.Builder itemPassesBuilder = ImmutableList.builder();
                boolean i = false;
                for (Map.Entry<String, List<BakedQuad>> model : this.children.entrySet()) {
                    childrenBuilder.put((Object)model.getKey(), model.getValue());
                }
                return new Baked(this.isGui3d, this.isSideLit, this.isAmbientOcclusion, this.particle, this.transforms, this.overrides, (ImmutableMap<String, List<BakedQuad>>)childrenBuilder.build());
            }
        }
    }

    public static final class Loader
    implements IGeometryLoader<BoerModel> {
        public static final Loader INSTANCE = new Loader();

        public BoerModel read(JsonObject jsonObject, JsonDeserializationContext deserializationContext) {
            Int2ObjectOpenHashMap renderTypeNames = new Int2ObjectOpenHashMap();
            if (jsonObject.has("render_types")) {
                JsonObject renderTypes = jsonObject.getAsJsonObject("render_types");
                for (Map.Entry entry : renderTypes.entrySet()) {
                    ResourceLocation renderType = ResourceLocation.parse((String)((String)entry.getKey()));
                    for (JsonElement layer : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                        if (renderTypeNames.put(layer.getAsInt(), (Object)renderType) == null) continue;
                        throw new JsonParseException("Registered duplicate render type for layer " + String.valueOf(layer));
                    }
                }
            }
            Int2ObjectArrayMap emissiveLayers = new Int2ObjectArrayMap();
            if (jsonObject.has("forge_data")) {
                throw new JsonParseException("forge_data should be replaced by neoforge_data");
            }
            if (jsonObject.has("neoforge_data")) {
                JsonObject forgeData = jsonObject.get("neoforge_data").getAsJsonObject();
                this.readLayerData(forgeData, "layers", (Int2ObjectOpenHashMap<ResourceLocation>)renderTypeNames, (Int2ObjectMap<ExtraFaceData>)emissiveLayers, false);
            }
            return new BoerModel(null, (Int2ObjectMap<ExtraFaceData>)emissiveLayers, (Int2ObjectMap<ResourceLocation>)renderTypeNames);
        }

        protected void readLayerData(JsonObject jsonObject, String name, Int2ObjectOpenHashMap<ResourceLocation> renderTypeNames, Int2ObjectMap<ExtraFaceData> layerData, boolean logWarning) {
            if (!jsonObject.has(name)) {
                return;
            }
            JsonObject fullbrightLayers = jsonObject.getAsJsonObject(name);
            for (Map.Entry entry : fullbrightLayers.entrySet()) {
                int layer = Integer.parseInt((String)entry.getKey());
                ExtraFaceData data = ExtraFaceData.read((JsonElement)((JsonElement)entry.getValue()), (ExtraFaceData)ExtraFaceData.DEFAULT);
                layerData.put(layer, (Object)data);
            }
        }
    }
}

