/*
 * Decompiled with CFR 0.152.
 */
package net.foxy.boers.client.model;

import java.util.List;
import java.util.Map;
import net.foxy.boers.base.ModDataComponents;
import net.foxy.boers.client.model.BoerModel;
import net.foxy.boers.data.BoerHead;
import net.foxy.boers.item.BoerContents;
import net.foxy.boers.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.SimpleBakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.model.geometry.UnbakedGeometryHelper;
import org.jetbrains.annotations.Nullable;

public class WrappedItemOverrides
extends ItemOverrides {
    private static final Map<Direction, List<BakedQuad>> quadsMap = Map.of(Direction.DOWN, List.of(), Direction.UP, List.of(), Direction.NORTH, List.of(), Direction.SOUTH, List.of(), Direction.WEST, List.of(), Direction.EAST, List.of());

    @Nullable
    public BakedModel resolve(BakedModel model, ItemStack bore, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        if (model instanceof BoerModel.Baked) {
            BoerHead head;
            BoerModel.Baked boerModel = (BoerModel.Baked)model;
            ItemStack stack = ((BoerContents)bore.getOrDefault(ModDataComponents.BOER_CONTENTS, (Object)BoerContents.EMPTY)).itemsCopy();
            if (stack.isEmpty()) {
                stack = bore;
            }
            ResourceLocation texture = (head = Utils.getBoer(stack)) == null ? Utils.rl("item/boer/default_boer_head_idle") : ((Boolean)bore.getOrDefault((DataComponentType)ModDataComponents.IS_USED.get(), (Object)false) == false ? head.texture().idle() : head.texture().active());
            return boerModel.children.computeIfAbsent(texture, key -> {
                if (key == null) {
                    return new SimpleBakedModel(List.of(), quadsMap, boerModel.useAmbientOcclusion(), boerModel.usesBlockLight(), boerModel.isGui3d(), boerModel.getParticleIcon(), boerModel.getTransforms(), boerModel.getOverrides());
                }
                TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(key);
                List unbaked = UnbakedGeometryHelper.createUnbakedItemElements((int)0, (TextureAtlasSprite)sprite, null);
                List quads = UnbakedGeometryHelper.bakeElements((List)unbaked, $ -> sprite, (ModelState)BlockModelRotation.X0_Y0);
                return new SimpleBakedModel(quads, quadsMap, boerModel.useAmbientOcclusion(), boerModel.usesBlockLight(), boerModel.isGui3d(), (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(texture), boerModel.getTransforms(), boerModel.getOverrides());
            });
        }
        return model;
    }
}

