/*
 * Decompiled with CFR 0.152.
 */
package net.foxy.boers.data;

import java.util.List;
import net.foxy.boers.base.ModRecipeSerializers;
import net.foxy.boers.item.BoerBaseItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class BoerColoring
extends CustomRecipe {
    public static final List<DyeColor> ALLOWED_COLORS = List.of(DyeColor.WHITE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.GRAY, DyeColor.GREEN, DyeColor.RED, DyeColor.BLACK, DyeColor.BLUE);

    public BoerColoring(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        int i = 0;
        int j = 0;
        for (int k = 0; k < input.size(); ++k) {
            ItemStack itemstack = input.getItem(k);
            if (itemstack.isEmpty()) continue;
            if (itemstack.getItem() instanceof BoerBaseItem) {
                ++i;
            } else {
                DyeItem dye;
                Item item = itemstack.getItem();
                if (!(item instanceof DyeItem) || !ALLOWED_COLORS.contains((dye = (DyeItem)item).getDyeColor())) {
                    return false;
                }
                ++j;
            }
            if (j <= 1 && i <= 1) continue;
            return false;
        }
        return i == 1 && j == 1;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        ItemStack itemstack = ItemStack.EMPTY;
        DyeColor dyecolor = DyeColor.WHITE;
        for (int i = 0; i < input.size(); ++i) {
            ItemStack itemstack1 = input.getItem(i);
            if (itemstack1.isEmpty()) continue;
            Item item = itemstack1.getItem();
            if (item instanceof BoerBaseItem) {
                itemstack = itemstack1.copy();
                continue;
            }
            DyeColor tmp = DyeColor.getColor((ItemStack)itemstack1);
            if (tmp == null) continue;
            dyecolor = tmp;
        }
        itemstack.set(DataComponents.BASE_COLOR, (Object)dyecolor);
        return itemstack;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipeSerializers.BOER_COLORING.get();
    }
}

