/*
 * Decompiled with CFR 0.152.
 */
package net.foxy.boers.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.foxy.boers.base.ModRegistries;
import net.minecraft.core.Holder;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public record BoerHead(Texture texture, float defaultMiningSpeed, int durability, List<Tool.Rule> miningRules) {
    public static final Codec<BoerHead> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Texture.CODEC.fieldOf("texture").forGetter(BoerHead::texture), (App)Codec.FLOAT.fieldOf("default_mining_speed").forGetter(BoerHead::defaultMiningSpeed), (App)Codec.INT.fieldOf("durability").forGetter(BoerHead::durability), (App)Tool.Rule.CODEC.listOf().fieldOf("mining_rules").forGetter(BoerHead::miningRules)).apply((Applicative)instance, BoerHead::new));
    public static final Codec<Holder<BoerHead>> ITEM_CODEC = RegistryFixedCodec.create(ModRegistries.BOER_HEAD);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<BoerHead>> STREAM_CODEC = ByteBufCodecs.holderRegistry(ModRegistries.BOER_HEAD);

    public BoerHead(ResourceLocation texture, float miningSpeed, int durability, TagKey<Block> miningLevel) {
        this(new Texture(ResourceLocation.fromNamespaceAndPath((String)texture.getNamespace(), (String)(texture.getPath() + "_idle")), texture), 1.0f, durability, List.of(Tool.Rule.deniesDrops(miningLevel), Tool.Rule.minesAndDrops((TagKey)BlockTags.MINEABLE_WITH_PICKAXE, (float)miningSpeed), Tool.Rule.minesAndDrops((TagKey)BlockTags.MINEABLE_WITH_SHOVEL, (float)miningSpeed)));
    }

    public float getMiningSpeed(BlockState state) {
        for (Tool.Rule tool$rule : this.miningRules) {
            if (!tool$rule.speed().isPresent() || !state.is(tool$rule.blocks())) continue;
            return ((Float)tool$rule.speed().get()).floatValue();
        }
        return this.defaultMiningSpeed;
    }

    public boolean isCorrectForDrops(BlockState state) {
        for (Tool.Rule tool$rule : this.miningRules) {
            if (!tool$rule.correctForDrops().isPresent() || !state.is(tool$rule.blocks())) continue;
            return (Boolean)tool$rule.correctForDrops().get();
        }
        return false;
    }

    public record Texture(ResourceLocation idle, ResourceLocation active) {
        public static StreamCodec<FriendlyByteBuf, Texture> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, Texture::idle, (StreamCodec)ResourceLocation.STREAM_CODEC, Texture::active, Texture::new);
        public static final Codec<Texture> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("idle").forGetter(Texture::idle), (App)ResourceLocation.CODEC.fieldOf("active").forGetter(Texture::active)).apply((Applicative)instance, Texture::new));
    }
}

