/*
 * Decompiled with CFR 0.152.
 */
package net.foxy.boers.datagen;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.foxy.boers.base.ModRegistries;
import net.foxy.boers.data.BoerHead;
import net.foxy.boers.datagen.ModBlockTagsProvider;
import net.foxy.boers.datagen.ModItemModelProvider;
import net.foxy.boers.datagen.ModItemTagsProvider;
import net.foxy.boers.datagen.ModRecipeProvider;
import net.foxy.boers.datagen.loot.ChestLootSubProvider;
import net.foxy.boers.datagen.loot.ModGLM;
import net.foxy.boers.datagen.loot.ModLootTablesProvider;
import net.foxy.boers.util.Utils;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="boers")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        event.createDatapackRegistryObjects(new RegistrySetBuilder().add(ModRegistries.BOER_HEAD, bootstrap -> {
            bootstrap.register(ModRegistries.DEFAULT, (Object)DataGenerators.create("default", 1.0f, 100, (TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL));
            bootstrap.register(ModRegistries.COPPER, (Object)DataGenerators.create("copper", 10.0f, 95, (TagKey<Block>)BlockTags.INCORRECT_FOR_STONE_TOOL));
            bootstrap.register(ModRegistries.IRON, (Object)DataGenerators.create("iron", 12.0f, 125, (TagKey<Block>)BlockTags.INCORRECT_FOR_IRON_TOOL));
            bootstrap.register(ModRegistries.DIAMOND, (Object)DataGenerators.create("diamond", 16.0f, 800, (TagKey<Block>)BlockTags.INCORRECT_FOR_DIAMOND_TOOL));
            bootstrap.register(ModRegistries.GOLDEN, (Object)DataGenerators.create("golden", 24.0f, 16, (TagKey<Block>)BlockTags.INCORRECT_FOR_GOLD_TOOL));
            bootstrap.register(ModRegistries.NETHERITE, (Object)DataGenerators.create("netherite", 18.0f, 1000, (TagKey<Block>)BlockTags.INCORRECT_FOR_NETHERITE_TOOL));
        }), conditions -> {}, Set.of("boers"));
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        ModBlockTagsProvider blockTagsProvider = (ModBlockTagsProvider)generator.addProvider(event.includeServer(), (DataProvider)new ModBlockTagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagsProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModGLM(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModLootTablesProvider(packOutput, List.of(new LootTableProvider.SubProviderEntry(ChestLootSubProvider::new, LootContextParamSets.CHEST)), lookupProvider));
    }

    private static BoerHead create(String id, float miningSpeed, int durability, TagKey<Block> canMine) {
        return new BoerHead(Utils.rl("item/boer/" + id + "_boer_head"), miningSpeed, durability, canMine);
    }
}

