/*
 * Decompiled with CFR 0.152.
 */
package net.foxy.boers.datagen;

import net.foxy.boers.base.ModItems;
import net.foxy.boers.data.BoerColoring;
import net.foxy.boers.util.Utils;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredItem;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "boers", existingFileHelper);
    }

    protected void registerModels() {
        this.entity(ModItems.BOER_BASE).transforms().transform(ItemDisplayContext.FIRST_PERSON_RIGHT_HAND).rotation(-72.5f, -16.0f, -27.0f).translation(-5.325f, 5.0f, -2.25f).end().end();
        ItemModelBuilder.OverrideBuilder override = this.tool(ModItems.BOER_BASE).override();
        ItemModelBuilder.OverrideBuilder overrideGui = this.tool("boer_base_gui", "boer_base_gui").override();
        for (int j = 0; j < 7; ++j) {
            DyeColor dyeColor = BoerColoring.ALLOWED_COLORS.get(j);
            override.predicate(Utils.rl("color"), (float)dyeColor.getId()).model((ModelFile)this.tool("boer_base_" + dyeColor.getName()));
            overrideGui.predicate(Utils.rl("color"), (float)dyeColor.getId()).model((ModelFile)this.tool("boer_base_gui_" + dyeColor.getName()));
            if (j == 6) {
                override.end();
                overrideGui.end();
                continue;
            }
            override = override.end().override();
            overrideGui = overrideGui.end().override();
        }
    }

    private ItemModelBuilder entity(DeferredItem<? extends ItemLike> item) {
        return (ItemModelBuilder)this.withExistingParent(item.getId().getPath(), Utils.rl("item/entity"));
    }

    private ItemModelBuilder simpleItem(DeferredItem<? extends ItemLike> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", Utils.rl("item/" + item.getId().getPath()));
    }

    private ItemModelBuilder simpleItem(DeferredItem<? extends ItemLike> item, String string) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer1", Utils.rl("item/" + item.getId().getPath()))).texture("layer0", Utils.rl("item/" + string));
    }

    private ItemModelBuilder tool(DeferredItem<? extends Item> item) {
        return this.tool(item, item.getId().getPath() + "_texture");
    }

    private ItemModelBuilder tool(DeferredItem<? extends Item> item, String name) {
        return this.tool(name, item.getId().getPath());
    }

    private ItemModelBuilder tool(String name) {
        return this.tool(name, name);
    }

    private ItemModelBuilder tool(String name, String texture) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, ResourceLocation.parse((String)"minecraft:item/handheld"))).texture("layer0", Utils.rl("item/" + texture))).renderType("cutout");
    }

    private ItemModelBuilder tool(DeferredItem<? extends Item> item, int layers) {
        ItemModelBuilder model = (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"minecraft:item/handheld"))).texture("layer0", Utils.rl("item/" + item.getId().getPath()));
        for (int i = 0; i < layers; ++i) {
            model.texture("layer" + (i + 1), Utils.rl("item/" + item.getId().getPath() + (i + 1)));
        }
        return model;
    }

    private ItemModelBuilder blank(DeferredItem<? extends Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", Utils.rl("item/blank"));
    }

    private ItemModelBuilder customTexture(DeferredItem<? extends Item> item, String texture) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", Utils.rl("item/" + texture));
    }

    private ItemModelBuilder simpleBlockItem(DeferredItem<? extends ItemLike> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", Utils.rl("block/" + item.getId().getPath()));
    }
}

