/*
 * Decompiled with CFR 0.152.
 */
package net.foxy.boers.datagen;

import java.util.concurrent.CompletableFuture;
import net.foxy.boers.base.ModDataComponents;
import net.foxy.boers.base.ModItems;
import net.foxy.boers.base.ModRegistries;
import net.foxy.boers.data.BoerColoring;
import net.foxy.boers.data.BoerHead;
import net.foxy.boers.data.StackSmithingTransformRecipeBuilder;
import net.foxy.boers.util.Utils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;

public class ModRecipeProvider
extends RecipeProvider {
    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput, HolderLookup.Provider lookup) {
        SpecialRecipeBuilder.special(BoerColoring::new).save(recipeOutput, Utils.rl("boer_base_coloring"));
        ModRecipeProvider.boerHead(recipeOutput, (Holder<BoerHead>)lookup.holderOrThrow(ModRegistries.COPPER), Items.COPPER_INGOT);
        ModRecipeProvider.boerHead(recipeOutput, (Holder<BoerHead>)lookup.holderOrThrow(ModRegistries.DIAMOND), Items.DIAMOND);
        ModRecipeProvider.boerHead(recipeOutput, (Holder<BoerHead>)lookup.holderOrThrow(ModRegistries.GOLDEN), Items.GOLD_INGOT);
        ModRecipeProvider.boerHead(recipeOutput, (Holder<BoerHead>)lookup.holderOrThrow(ModRegistries.IRON), Items.IRON_INGOT);
        ItemStack stack = ModItems.BOER_HEAD.toStack();
        ItemStack result = ModItems.BOER_HEAD.toStack();
        result.set(ModDataComponents.BOER, (Object)lookup.holderOrThrow(ModRegistries.NETHERITE));
        StackSmithingTransformRecipeBuilder.smithing(Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), DataComponentIngredient.of((boolean)false, (DataComponentType)((DataComponentType)ModDataComponents.BOER.get()), (Object)lookup.holderOrThrow(ModRegistries.DIAMOND), (ItemLike[])new ItemLike[]{ModItems.BOER_HEAD}), Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}), RecipeCategory.TOOLS, result).unlocks("has_boer_base", ModRecipeProvider.has(ModItems.BOER_BASE)).save(recipeOutput, Utils.rl("diamond_boer_head_smithing"));
    }

    public static void boerHead(RecipeOutput recipeOutput, Holder<BoerHead> boerHead, Item item) {
        ItemStack stack = Utils.boer(boerHead);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemStack)stack).pattern("  X").pattern("XX ").pattern("XX ").define(Character.valueOf('X'), (ItemLike)item).unlockedBy("has_boer_base", ModRecipeProvider.has(ModItems.BOER_BASE)).save(recipeOutput, Utils.rl("boer_head_" + boerHead.getKey().location().getPath()));
    }
}

