/*
 * Decompiled with CFR 0.152.
 */
package net.foxy.boers.event;

import net.foxy.boers.base.ModDataComponents;
import net.foxy.boers.base.ModEnums;
import net.foxy.boers.base.ModItems;
import net.foxy.boers.base.ModParticles;
import net.foxy.boers.client.BoerBaseRenderer;
import net.foxy.boers.client.BoerSoundInstance;
import net.foxy.boers.client.ClientBoersTooltip;
import net.foxy.boers.client.model.BoerModel;
import net.foxy.boers.item.BoerBaseItem;
import net.foxy.boers.item.BoerContents;
import net.foxy.boers.network.c2s.SetUseBoerPacket;
import net.foxy.boers.network.c2s.TickBoerPacket;
import net.foxy.boers.particle.spark.SparkParticleProvider;
import net.foxy.boers.util.ModItemProperties;
import net.foxy.boers.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.ModelEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.model.geometry.IGeometryLoader;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="boers", value={Dist.CLIENT})
public class ModClientEvents {
    private static final ResourceLocation BOER_MODEL_LOADER = Utils.rl("boer");
    public static int lastProgress = 0;
    public static int usingProgress = 0;
    public static BoerSoundInstance soundInstance = null;
    public static BoerSoundInstance idleSoundInstance = null;

    @SubscribeEvent
    public static void registerCustomModels(ModelEvent.RegisterGeometryLoaders event) {
        event.register(BOER_MODEL_LOADER, (IGeometryLoader)BoerModel.Loader.INSTANCE);
    }

    @SubscribeEvent
    public static void registerTooltip(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(BoerContents.class, ClientBoersTooltip::new);
    }

    @SubscribeEvent
    public static void registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticles.SPARK_PARTICLE.get(), SparkParticleProvider::new);
    }

    @SubscribeEvent
    public static void tickBoerProgress(ClientTickEvent.Post event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (item instanceof BoerBaseItem) {
            BoerBaseItem boer = (BoerBaseItem)item;
            lastProgress = usingProgress;
            usingProgress = Minecraft.getInstance().options.keyAttack.isDown() ? Math.min(usingProgress + 1, 10) : Math.max(usingProgress - 1, 0);
            boolean isUsed = (Boolean)stack.getOrDefault(ModDataComponents.IS_USED, (Object)false);
            if (usingProgress < 9) {
                if (isUsed) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new SetUseBoerPacket(false), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            } else {
                if (!isUsed) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new SetUseBoerPacket(true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                boer.onAttackTick(player.level(), (Player)player, stack, usingProgress);
                PacketDistributor.sendToServer((CustomPacketPayload)new TickBoerPacket(usingProgress), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void disableAttack(InputEvent.InteractionKeyMappingTriggered event) {
        LocalPlayer player;
        ItemStack stack;
        Item item;
        if (event.isAttack() && (item = (stack = (player = Minecraft.getInstance().player).getMainHandItem()).getItem()) instanceof BoerBaseItem) {
            BoerBaseItem boer = (BoerBaseItem)item;
            event.setSwingHand(false);
            if (usingProgress <= 9) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void registerItemRenderers(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){
            public static BoerBaseRenderer renderer = null;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (renderer == null) {
                    renderer = new BoerBaseRenderer(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
                }
                return renderer;
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                return (HumanoidModel.ArmPose)ModEnums.BOER_STANDING_POS.getValue();
            }
        }, new Holder[]{ModItems.BOER_BASE});
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        ModItemProperties.addModItemProperties();
    }
}

