/*
 * Decompiled with CFR 0.152.
 */
package net.foxy.boers.item;

import java.util.List;
import java.util.Optional;
import net.foxy.boers.base.ModDataComponents;
import net.foxy.boers.base.ModItems;
import net.foxy.boers.base.ModParticles;
import net.foxy.boers.base.ModSounds;
import net.foxy.boers.client.BoerSoundInstance;
import net.foxy.boers.client.BoersClientConfig;
import net.foxy.boers.data.BoerHead;
import net.foxy.boers.event.ModClientEvents;
import net.foxy.boers.item.BoerContents;
import net.foxy.boers.particle.spark.SparkParticle;
import net.foxy.boers.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BoerBaseItem
extends Item {
    public BoerBaseItem() {
        super(new Item.Properties().stacksTo(1).component(ModDataComponents.BOER_CONTENTS, (Object)BoerContents.EMPTY).component(DataComponents.BASE_COLOR, (Object)DyeColor.BLUE));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    public boolean isDamageable(ItemStack stack) {
        ItemStack boerItem = ((BoerContents)stack.get(ModDataComponents.BOER_CONTENTS)).getItemUnsafe();
        return !boerItem.isEmpty() && boerItem.isDamageableItem();
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (isSelected) {
            entity.setYBodyRot(entity.getYHeadRot() + 37.0f);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (((Boolean)stack.getOrDefault(ModDataComponents.IS_USED, (Object)false)).booleanValue()) {
                    player.attackStrengthTicker = 10;
                    player.swinging = false;
                    player.attackAnim = 0.0f;
                    player.swingTime = 0;
                }
            }
        }
        super.inventoryTick(stack, level, entity, slotId, isSelected);
    }

    public int getMaxDamage(ItemStack stack) {
        return ((BoerContents)stack.getOrDefault((DataComponentType)((DataComponentType)ModDataComponents.BOER_CONTENTS.get()), (Object)BoerContents.EMPTY)).items.getMaxDamage();
    }

    public int getDamage(ItemStack stack) {
        return ((BoerContents)stack.getOrDefault((DataComponentType)((DataComponentType)ModDataComponents.BOER_CONTENTS.get()), (Object)BoerContents.EMPTY)).items.getDamageValue();
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        super.onStopUsing(stack, entity, count);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.gameMode.handleBlockBreakAction(serverPlayer.gameMode.destroyPos, ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK, Direction.UP, entity.level().getMaxBuildHeight(), 0);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.is(newStack.getItem());
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        BoerHead tool = Utils.getBoer(((BoerContents)stack.getOrDefault(ModDataComponents.BOER_CONTENTS, (Object)BoerContents.EMPTY)).items);
        return tool != null ? tool.getMiningSpeed(state) : 1.0f;
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miningEntity) {
        BoerContents boerContents = (BoerContents)stack.get(ModDataComponents.BOER_CONTENTS);
        if (boerContents == null) {
            return false;
        }
        if (!level.isClientSide && state.getDestroySpeed((BlockGetter)level, pos) != 0.0f) {
            ItemStack boer = boerContents.getItemUnsafe();
            boer.hurtAndBreak(1, miningEntity, EquipmentSlot.MAINHAND);
            stack.set((DataComponentType)ModDataComponents.BOER_CONTENTS.get(), (Object)new BoerContents(boer));
        }
        return true;
    }

    public void onAttackTick(Level level, Player player, ItemStack stack, int used) {
        ItemStack boer = ((BoerContents)stack.getOrDefault(ModDataComponents.BOER_CONTENTS, (Object)BoerContents.EMPTY)).items;
        if (!boer.isEmpty()) {
            List<LivingEntity> targetEntities = this.getTargetEntity(player, level);
            if (!targetEntities.isEmpty()) {
                for (LivingEntity target : targetEntities) {
                    if (level.isClientSide) {
                        Vec3 hitPos = target.position().add(0.0, (double)target.getBbHeight() * 0.5, 0.0);
                        Vec3 playerEye = player.getEyePosition();
                        if (target.getType() != EntityType.IRON_GOLEM) continue;
                        this.spawnEntitySparks(level, hitPos, playerEye, target);
                        continue;
                    }
                    if (player.tickCount % 10 != 0) continue;
                    target.hurt(level.damageSources().playerAttack(player), 2.0f);
                    boer.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                    stack.set(ModDataComponents.BOER_CONTENTS, (Object)new BoerContents(boer));
                    level.playSound(null, target.blockPosition(), SoundEvents.ANVIL_LAND, SoundSource.PLAYERS, 0.3f, 1.8f);
                }
                return;
            }
            if (level.isClientSide) {
                BlockHitResult result = Item.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
                if (result.getType() == HitResult.Type.BLOCK) {
                    if (((Boolean)BoersClientConfig.CONFIG.BREAKING_SOUNDS.get()).booleanValue() && (ModClientEvents.soundInstance == null || !Minecraft.getInstance().getSoundManager().isActive((SoundInstance)ModClientEvents.soundInstance))) {
                        if (ModClientEvents.idleSoundInstance != null) {
                            ModClientEvents.idleSoundInstance.remove();
                        }
                        ModClientEvents.soundInstance = new BoerSoundInstance((SoundEvent)ModSounds.STONE.get(), SoundSource.PLAYERS, 0.25f, 1.0f, (LivingEntity)player, player.getRandom().nextLong());
                        Minecraft.getInstance().getSoundManager().play((SoundInstance)ModClientEvents.soundInstance);
                    }
                    Minecraft.getInstance().particleEngine.addBlockHitEffects(result.getBlockPos(), result);
                    this.spawnSparks(level, player, result);
                } else if (((Boolean)BoersClientConfig.CONFIG.BREAKING_SOUNDS.get()).booleanValue() && (ModClientEvents.idleSoundInstance == null || !Minecraft.getInstance().getSoundManager().isActive((SoundInstance)ModClientEvents.idleSoundInstance))) {
                    if (ModClientEvents.soundInstance != null) {
                        ModClientEvents.soundInstance.remove();
                    }
                    ModClientEvents.idleSoundInstance = new BoerSoundInstance((SoundEvent)ModSounds.AIR.get(), SoundSource.PLAYERS, 0.25f, 1.0f, (LivingEntity)player, player.getRandom().nextLong());
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)ModClientEvents.idleSoundInstance);
                }
            }
        }
    }

    private List<LivingEntity> getTargetEntity(Player player, Level level) {
        double reachDistance = 1.5;
        Vec3 eyePos = player.getEyePosition();
        Vec3 lookVec = player.getLookAngle();
        Vec3 reachVec = eyePos.add(lookVec.scale(reachDistance));
        return level.getEntitiesOfClass(LivingEntity.class, new AABB(reachVec.x, reachVec.y, reachVec.z, reachVec.x, reachVec.y, reachVec.z).inflate(1.0), entity -> !entity.isSpectator() && entity != player);
    }

    private void spawnEntitySparks(Level level, Vec3 hitPos, Vec3 playerEye, LivingEntity target) {
        int sparkCount = 5 + level.random.nextInt(6);
        for (int i = 0; i < sparkCount; ++i) {
            double spreadX = (level.random.nextDouble() - 0.5) * (double)target.getBbWidth() * 0.8;
            double spreadY = (level.random.nextDouble() - 0.5) * (double)target.getBbHeight() * 0.5;
            double spreadZ = (level.random.nextDouble() - 0.5) * (double)target.getBbWidth() * 0.8;
            Vec3 sparkPos = hitPos.add(spreadX, spreadY, spreadZ);
            Vec3 velocity = SparkParticle.generateConeVelocity(sparkPos, playerEye, 0.5f);
            level.addParticle((ParticleOptions)ModParticles.SPARK_PARTICLE.get(), sparkPos.x, sparkPos.y, sparkPos.z, velocity.x, velocity.y, velocity.z);
        }
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        return false;
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        BoerHead head = Utils.getBoer(((BoerContents)stack.getOrDefault(ModDataComponents.BOER_CONTENTS, (Object)BoerContents.EMPTY)).items);
        if (head != null) {
            return head.isCorrectForDrops(state);
        }
        return super.isCorrectToolForDrops(stack, state);
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction action, Player player) {
        if (stack.getCount() != 1 || action != ClickAction.SECONDARY) {
            return false;
        }
        BoerContents bundlecontents = (BoerContents)stack.get(ModDataComponents.BOER_CONTENTS);
        if (bundlecontents == null) {
            return false;
        }
        ItemStack itemstack = slot.getItem();
        BoerContents.Mutable bundlecontents$mutable = new BoerContents.Mutable(bundlecontents);
        if (itemstack.isEmpty()) {
            this.playRemoveOneSound((Entity)player);
            ItemStack itemstack1 = bundlecontents$mutable.removeOne();
            if (itemstack1 != null) {
                ItemStack itemstack2 = slot.safeInsert(itemstack1);
                bundlecontents$mutable.tryInsert(itemstack2);
            }
        } else if (itemstack.canFitInsideContainerItems()) {
            if (!itemstack.is(ModItems.BOER_HEAD)) {
                return false;
            }
            int i = bundlecontents$mutable.tryTransfer(slot, player);
            if (i > 0) {
                this.playInsertSound((Entity)player);
            }
        }
        stack.set(ModDataComponents.BOER_CONTENTS, (Object)bundlecontents$mutable.toImmutable());
        return true;
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (stack.getCount() != 1) {
            return false;
        }
        if (action == ClickAction.SECONDARY && slot.allowModification(player)) {
            BoerContents bundlecontents = (BoerContents)stack.get(ModDataComponents.BOER_CONTENTS);
            if (bundlecontents == null) {
                return false;
            }
            BoerContents.Mutable bundlecontents$mutable = new BoerContents.Mutable(bundlecontents);
            if (other.isEmpty()) {
                ItemStack itemstack = bundlecontents$mutable.removeOne();
                if (itemstack != null) {
                    this.playRemoveOneSound((Entity)player);
                    access.set(itemstack);
                }
            } else {
                if (!other.is(ModItems.BOER_HEAD)) {
                    return false;
                }
                ItemStack itemStack = bundlecontents$mutable.removeOne();
                int i = bundlecontents$mutable.tryInsert(other);
                if (i > 0) {
                    this.playInsertSound((Entity)player);
                }
                if (itemStack != null) {
                    access.set(itemStack);
                }
            }
            stack.set(ModDataComponents.BOER_CONTENTS, (Object)bundlecontents$mutable.toImmutable());
            return true;
        }
        return false;
    }

    public boolean isBarVisible(ItemStack stack) {
        ItemStack boer = ((BoerContents)stack.getOrDefault((DataComponentType)((DataComponentType)ModDataComponents.BOER_CONTENTS.get()), (Object)BoerContents.EMPTY)).items;
        return !boer.isEmpty() && boer.isDamaged();
    }

    public int getBarWidth(ItemStack stack) {
        return ((BoerContents)stack.getOrDefault((DataComponentType)((DataComponentType)ModDataComponents.BOER_CONTENTS.get()), (Object)BoerContents.EMPTY)).items.getBarWidth();
    }

    private static boolean dropContents(ItemStack stack, Player player) {
        BoerContents bundlecontents = (BoerContents)stack.get(ModDataComponents.BOER_CONTENTS);
        if (bundlecontents != null && !bundlecontents.isEmpty()) {
            stack.set(ModDataComponents.BOER_CONTENTS, (Object)BoerContents.EMPTY);
            if (player instanceof ServerPlayer) {
                player.drop(bundlecontents.itemsCopy(), true);
            }
            return true;
        }
        return false;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        return !stack.has(DataComponents.HIDE_TOOLTIP) && !stack.has(DataComponents.HIDE_ADDITIONAL_TOOLTIP) ? Optional.ofNullable((TooltipComponent)stack.get(ModDataComponents.BOER_CONTENTS)) : Optional.empty();
    }

    public void onDestroyed(ItemEntity itemEntity) {
        BoerContents bundlecontents = (BoerContents)itemEntity.getItem().get(ModDataComponents.BOER_CONTENTS);
        if (bundlecontents != null) {
            itemEntity.getItem().set(ModDataComponents.BOER_CONTENTS, (Object)BoerContents.EMPTY);
            ItemUtils.onContainerDestroyed((ItemEntity)itemEntity, List.of(bundlecontents.itemsCopy()));
        }
    }

    private void playRemoveOneSound(Entity entity) {
        entity.playSound((SoundEvent)ModSounds.HEAD_UNEQUIP.get(), 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.playSound((SoundEvent)ModSounds.HEAD_EQUIP.get(), 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void spawnSparks(Level level, Player player, BlockHitResult hitResult) {
        if ((double)level.getBlockState(hitResult.getBlockPos()).getDestroySpeed((BlockGetter)level, hitResult.getBlockPos()) < 1.1) {
            return;
        }
        Vec3 hitPos = hitResult.getLocation();
        Vec3 playerEye = player.getEyePosition();
        Direction blockFace = hitResult.getDirection();
        Vec3 offset = Vec3.atLowerCornerOf((Vec3i)blockFace.getNormal()).scale(0.05);
        Vec3 spawnPos = hitPos.add(offset);
        int sparkCount = 3 + level.random.nextInt(4);
        for (int i = 0; i < sparkCount; ++i) {
            double spreadX = (level.random.nextDouble() - 0.5) * 0.15;
            double spreadY = (level.random.nextDouble() - 0.5) * 0.15;
            double spreadZ = (level.random.nextDouble() - 0.5) * 0.15;
            Vec3 sparkPos = spawnPos.add(spreadX, spreadY, spreadZ);
            Vec3 velocity = SparkParticle.generateConeVelocity(hitPos, playerEye, 0.4f);
            level.addParticle((ParticleOptions)ModParticles.SPARK_PARTICLE.get(), sparkPos.x, sparkPos.y, sparkPos.z, velocity.x, velocity.y, velocity.z);
        }
    }
}

