/*
 * Decompiled with CFR 0.152.
 */
package net.foxy.boers.particle.spark;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class SparkParticle
extends TextureSheetParticle {
    private final SpriteSet spriteSet;
    private static final float BASE_SIZE = 0.1f;
    private final float initialSize;

    protected SparkParticle(ClientLevel level, double x, double y, double z, Vec3 velocity, Direction blockFace, SpriteSet spriteSet) {
        super(level, x, y, z);
        this.spriteSet = spriteSet;
        this.xd = velocity.x;
        this.yd = velocity.y;
        this.zd = velocity.z;
        this.gravity = 0.6f;
        this.friction = 0.96f;
        this.lifetime = 15 + this.random.nextInt(10);
        this.quadSize = this.initialSize = 0.1f * (0.3f + this.random.nextFloat());
        float colorVar = this.random.nextFloat() * 0.2f;
        this.rCol = 1.0f;
        this.gCol = 0.8f + colorVar;
        this.bCol = 0.3f + colorVar * 0.5f;
        this.alpha = 1.0f;
        this.pickSprite(spriteSet);
        this.hasPhysics = true;
    }

    public void tick() {
        float brightness;
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
            return;
        }
        float lifeProgress = (float)this.age / (float)this.lifetime;
        this.quadSize = this.initialSize * (1.0f - lifeProgress);
        this.alpha = 1.0f - lifeProgress * 0.9f;
        this.rCol = brightness = 1.0f - lifeProgress * 0.5f;
        this.gCol = (0.7f - lifeProgress * 0.4f) * brightness;
        this.bCol = (0.2f - lifeProgress * 0.2f) * brightness;
        this.yd -= 0.03 * (double)this.gravity;
        this.move(this.xd, this.yd, this.zd);
        this.xd *= (double)this.friction;
        this.yd *= (double)this.friction;
        this.zd *= (double)this.friction;
        if (this.onGround) {
            if (Math.abs(this.yd) > 0.01) {
                this.yd *= (double)-0.3f;
                this.xd *= (double)0.7f;
                this.zd *= (double)0.7f;
            } else {
                this.xd *= 0.5;
                this.zd *= 0.5;
            }
        }
        this.setSpriteFromAge(this.spriteSet);
    }

    public void render(VertexConsumer buffer, Camera camera, float partialTicks) {
        Vec3 toCamera;
        Vec3 cameraPos = camera.getPosition();
        float x = (float)(Mth.lerp((double)partialTicks, (double)this.xo, (double)this.x) - cameraPos.x);
        float y = (float)(Mth.lerp((double)partialTicks, (double)this.yo, (double)this.y) - cameraPos.y);
        float z = (float)(Mth.lerp((double)partialTicks, (double)this.zo, (double)this.z) - cameraPos.z);
        Vec3 velocity = new Vec3(this.xd, this.yd, this.zd);
        float speed = (float)velocity.length();
        if (speed < 0.01f) {
            super.render(buffer, camera, partialTicks);
            return;
        }
        Vec3 moveDir = velocity.normalize();
        Vec3 right = moveDir.cross(toCamera = new Vec3((double)(-x), (double)(-y), (double)(-z)).normalize());
        if (right.lengthSqr() < 0.001) {
            Vec3 altUp = Math.abs(moveDir.y) > 0.9 ? new Vec3(1.0, 0.0, 0.0) : new Vec3(0.0, 1.0, 0.0);
            right = moveDir.cross(altUp);
        }
        right = right.normalize();
        Vec3 up = right.cross(moveDir).normalize();
        float baseStretch = 2.0f;
        float speedStretch = Math.min(speed * 5.0f, 3.0f);
        float totalStretch = baseStretch + speedStretch;
        float halfWidth = this.quadSize * 0.25f;
        float halfLength = this.quadSize * totalStretch * 0.5f;
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        int light = 0xF000F0;
        Vector3f[] vertices = new Vector3f[4];
        Vec3 tail = new Vec3((double)x, (double)y, (double)z).subtract(moveDir.scale((double)halfLength));
        vertices[0] = new Vector3f((float)(tail.x - right.x * (double)halfWidth), (float)(tail.y - right.y * (double)halfWidth), (float)(tail.z - right.z * (double)halfWidth));
        vertices[1] = new Vector3f((float)(tail.x + right.x * (double)halfWidth), (float)(tail.y + right.y * (double)halfWidth), (float)(tail.z + right.z * (double)halfWidth));
        Vec3 head = new Vec3((double)x, (double)y, (double)z).add(moveDir.scale((double)halfLength));
        vertices[2] = new Vector3f((float)(head.x + right.x * (double)halfWidth), (float)(head.y + right.y * (double)halfWidth), (float)(head.z + right.z * (double)halfWidth));
        vertices[3] = new Vector3f((float)(head.x - right.x * (double)halfWidth), (float)(head.y - right.y * (double)halfWidth), (float)(head.z - right.z * (double)halfWidth));
        buffer.addVertex(vertices[0].x(), vertices[0].y(), vertices[0].z()).setUv(u0, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(light);
        buffer.addVertex(vertices[1].x(), vertices[1].y(), vertices[1].z()).setUv(u0, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(light);
        buffer.addVertex(vertices[2].x(), vertices[2].y(), vertices[2].z()).setUv(u1, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(light);
        buffer.addVertex(vertices[3].x(), vertices[3].y(), vertices[3].z()).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha).setLight(light);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    protected int getLightColor(float partialTick) {
        return 0xF000F0;
    }

    public static Vec3 generateConeVelocity(Vec3 contactPoint, Vec3 playerEye, float speed) {
        Vec3 toPlayer = playerEye.subtract(contactPoint).normalize();
        double coneAngleRad = Math.toRadians(35.0);
        double randomAngle = Math.random() * 2.0 * Math.PI;
        double randomRadius = Math.random() * Math.tan(coneAngleRad);
        Vec3 perpendicular1 = Math.abs(toPlayer.y) < 0.9 ? toPlayer.cross(new Vec3(0.0, 1.0, 0.0)).normalize() : toPlayer.cross(new Vec3(1.0, 0.0, 0.0)).normalize();
        Vec3 perpendicular2 = toPlayer.cross(perpendicular1).normalize();
        Vec3 offset = perpendicular1.scale(Math.cos(randomAngle) * randomRadius).add(perpendicular2.scale(Math.sin(randomAngle) * randomRadius));
        Vec3 finalDir = toPlayer.add(offset).normalize();
        float randomSpeed = speed * (0.4f + (float)Math.random() * 0.6f);
        return finalDir.scale((double)randomSpeed);
    }
}

