/*
 * Decompiled with CFR 0.152.
 */
package com.criticalpickle.criticalcrates.block;

import com.criticalpickle.criticalcrates.Config;
import com.criticalpickle.criticalcrates.block.GlassCrateBlock;
import com.criticalpickle.criticalcrates.block.entity.CrateBlockEntity;
import com.criticalpickle.criticalcrates.item.CrateBlockItem;
import com.criticalpickle.criticalcrates.registration.ModBlocks;
import com.criticalpickle.criticalcrates.registration.ModItems;
import com.criticalpickle.criticalcrates.util.CacheSwitchInventory;
import com.criticalpickle.criticalcrates.util.DataComponentUtils;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CrateBlock
extends BaseEntityBlock {
    public static final MapCodec<CrateBlock> CODEC = CrateBlock.simpleCodec(CrateBlock::new);
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.AXIS;
    public static final BooleanProperty SWITCH = BooleanProperty.create((String)"switch");
    public static final BooleanProperty EXPLOSION_RESIST = BooleanProperty.create((String)"explosion_resistant");
    public static final BooleanProperty LAMP_UPGRADE = BooleanProperty.create((String)"lamp_upgrade");
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty FIREPROOF = BooleanProperty.create((String)"fireproof");

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public CrateBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)Direction.Axis.Y)).setValue((Property)SWITCH, (Comparable)Boolean.valueOf(false))).setValue((Property)EXPLOSION_RESIST, (Comparable)Boolean.valueOf(false))).setValue((Property)LAMP_UPGRADE, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)FIREPROOF, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, SWITCH, EXPLOSION_RESIST, LAMP_UPGRADE, LIT, POWERED, FIREPROOF});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction.Axis axis = context.getClickedFace().getAxis();
        CustomData data = (CustomData)context.getItemInHand().get(DataComponents.CUSTOM_DATA);
        boolean resistant = false;
        boolean lamp = false;
        boolean fire = false;
        if (data != null) {
            if (data.contains("explosion_resistant")) {
                resistant = data.copyTag().getBoolean("explosion_resistant");
            }
            if (data.contains("lamp_upgrade")) {
                lamp = data.copyTag().getBoolean("lamp_upgrade");
            }
            if (data.contains("fireproof")) {
                fire = data.copyTag().getBoolean("fireproof");
            }
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)axis)).setValue((Property)SWITCH, (Comparable)Boolean.valueOf(false))).setValue((Property)EXPLOSION_RESIST, (Comparable)Boolean.valueOf(resistant))).setValue((Property)LAMP_UPGRADE, (Comparable)Boolean.valueOf(lamp))).setValue((Property)FIREPROOF, (Comparable)Boolean.valueOf(fire));
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.hasFireEffect(state);
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.hasFireEffect(state) ? 5 : 0;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.hasFireEffect(state) ? 20 : 0;
    }

    protected boolean hasFireEffect(BlockState state) {
        return !state.is((Block)ModBlocks.CRIMSON_CRATE.get()) && !state.is((Block)ModBlocks.WARPED_CRATE.get()) && (Boolean)state.getValue((Property)FIREPROOF) == false;
    }

    public float getExplosionResistance(BlockState state, BlockGetter level, BlockPos pos, Explosion explosion) {
        return (Boolean)state.getValue((Property)EXPLOSION_RESIST) != false ? 1200.0f : 2.5f;
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)LIT) != false ? 15 : 0;
    }

    protected boolean hasAnalogOutputSignal(BlockState state) {
        return (Boolean)state.getValue((Property)LAMP_UPGRADE);
    }

    protected int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Boolean)level.getBlockState(pos).getValue((Property)LIT) != false ? 15 : 0;
    }

    protected BlockState rotate(BlockState state, Rotation rotation) {
        return CrateBlock.rotatePillar(state, rotation);
    }

    public static BlockState rotatePillar(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.getValue(AXIS)) {
                    case X: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                    case Z: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                }
                return state;
            }
        }
        return state;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new CrateBlockEntity(blockPos, blockState);
    }

    @NotNull
    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        if (((Boolean)state.getValue((Property)LAMP_UPGRADE)).booleanValue() && oldState.getBlock() != state.getBlock() && level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            this.checkAndFlip(state, serverlevel, pos);
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        if (((Boolean)state.getValue((Property)LAMP_UPGRADE)).booleanValue() && level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            this.checkAndFlip(state, serverlevel, pos);
        }
    }

    public void checkAndFlip(BlockState state, ServerLevel level, BlockPos pos) {
        boolean isPowered = level.hasNeighborSignal(pos);
        if (isPowered != (Boolean)state.getValue((Property)POWERED)) {
            BlockState blockstate = state;
            if (!((Boolean)state.getValue((Property)POWERED)).booleanValue()) {
                blockstate = (BlockState)state.cycle((Property)LIT);
            }
            level.setBlockAndUpdate(pos, (BlockState)blockstate.setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered)));
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (!state.is(newState.getBlock()) && (blockEntity = level.getBlockEntity(pos)) instanceof CrateBlockEntity) {
            CrateBlockEntity blockEntity2 = (CrateBlockEntity)blockEntity;
            if (((Boolean)state.getValue((Property)SWITCH)).booleanValue()) {
                CacheSwitchInventory.cache(blockEntity2.getInventory());
            } else {
                blockEntity2.drop();
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        ItemStack stack = new ItemStack((ItemLike)this);
        CompoundTag dataTag = new CompoundTag();
        dataTag.putBoolean("explosion_resistant", ((Boolean)state.getValue((Property)EXPLOSION_RESIST)).booleanValue());
        dataTag.putBoolean("lamp_upgrade", ((Boolean)state.getValue((Property)LAMP_UPGRADE)).booleanValue());
        dataTag.putBoolean("fireproof", ((Boolean)state.getValue((Property)FIREPROOF)).booleanValue());
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)dataTag));
        if (dataTag.getBoolean("fireproof")) {
            stack.set(DataComponents.FIRE_RESISTANT, (Object)Unit.INSTANCE);
        }
        return stack;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CrateBlockEntity) {
            CrateBlockEntity blockEntity2 = (CrateBlockEntity)blockEntity;
            player.openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)blockEntity2, (Component)Component.translatable((String)"container.criticalcrates.crate")), pos);
            level.playSound(null, pos, this.getInventoryOpenSound(), SoundSource.BLOCKS, 0.5f, 1.0f);
        }
        return InteractionResult.CONSUME;
    }

    protected SoundEvent getInventoryOpenSound() {
        return SoundEvents.BARREL_OPEN;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            Item itemInStack = stack.getItem();
            CompoundTag dataTag = new CompoundTag();
            BlockEntity blockEntity = level.getBlockEntity(pos);
            SoundEvent sound = SoundEvents.ANVIL_USE;
            if (Config.ADDONS_REMOVABLE.getAsBoolean() && CrateBlock.hasUpgrades(state) && itemInStack == ModItems.PLIERS_ITEM.get()) {
                level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)EXPLOSION_RESIST, (Comparable)Boolean.valueOf(false))).setValue((Property)LAMP_UPGRADE, (Comparable)Boolean.valueOf(false))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false))).setValue((Property)FIREPROOF, (Comparable)Boolean.valueOf(false)));
                CrateBlock.spawnRemovedUpgrades(state, level, pos);
                CrateBlock.setDataTagUpgrades(dataTag, false, false, false, null);
            } else if (Config.STAINED_COLOR_REMOVABLE.getAsBoolean() && CrateBlock.hasSoap(itemInStack, state)) {
                Block crateBlock = CrateBlock.getCrateBlock("block.criticalcrates.glass_crate");
                if (crateBlock != null) {
                    stack.shrink(1);
                    blockEntity = CrateBlock.switchCrate(level, pos, state, crateBlock, dataTag);
                }
                sound = SoundEvents.DYE_USE;
            } else if (!CrateBlock.hasUpgrades(state) && itemInStack == ModItems.OBSIDIAN_REINFORCEMENT_ITEM.get()) {
                stack.shrink(1);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)EXPLOSION_RESIST, (Comparable)Boolean.valueOf(true)));
                CrateBlock.setDataTagUpgrades(dataTag, true, false, false, null);
            } else if (!CrateBlock.hasUpgrades(state) && itemInStack == ModItems.LAMP_SIMULATOR_ITEM.get()) {
                stack.shrink(1);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)LAMP_UPGRADE, (Comparable)Boolean.valueOf(true)));
                CrateBlock.setDataTagUpgrades(dataTag, false, true, false, null);
            } else if (!CrateBlock.hasUpgrades(state) && itemInStack == ModItems.FIREPROOFING_ITEM.get()) {
                stack.shrink(1);
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)FIREPROOF, (Comparable)Boolean.valueOf(true)));
                CrateBlock.setDataTagUpgrades(dataTag, false, false, true, blockEntity);
            } else if (this.validDye(state, itemInStack)) {
                String dyeColor = itemInStack.getDescriptionId().substring(itemInStack.getDescriptionId().indexOf("minecraft.") + 10, itemInStack.getDescriptionId().indexOf("_dye"));
                Block crateBlock = CrateBlock.getCrateBlock("block.criticalcrates." + dyeColor + "_stained_glass_crate");
                if (crateBlock != null) {
                    stack.shrink(1);
                    blockEntity = CrateBlock.switchCrate(level, pos, state, crateBlock, dataTag);
                }
                sound = SoundEvents.GLOW_INK_SAC_USE;
            } else if (this.validGlass(state, itemInStack)) {
                String paneName = itemInStack.getDescriptionId().substring(itemInStack.getDescriptionId().indexOf("minecraft.") + 10);
                Block crateBlock = CrateBlock.getCrateBlock("block.criticalcrates." + paneName + "_crate");
                if (crateBlock != null) {
                    stack.shrink(1);
                    blockEntity = CrateBlock.switchCrate(level, pos, state, crateBlock, dataTag);
                }
            } else {
                return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
            }
            if (blockEntity != null && !dataTag.getBoolean("fireproof")) {
                DataComponentUtils.addBlockEntityDataTag(blockEntity, dataTag);
            }
            CrateBlock.handleItemResult(level, pos, stack, player, sound);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    private static void setDataTagUpgrades(CompoundTag dataTag, boolean resistant, boolean lamp, boolean fire, BlockEntity blockEntity) {
        if (resistant) {
            dataTag.putBoolean("explosion_resistant", true);
            dataTag.putBoolean("lamp_upgrade", false);
            dataTag.putBoolean("fireproof", false);
        } else if (lamp) {
            dataTag.putBoolean("explosion_resistant", false);
            dataTag.putBoolean("lamp_upgrade", true);
            dataTag.putBoolean("fireproof", false);
        } else if (fire) {
            dataTag.putBoolean("explosion_resistant", false);
            dataTag.putBoolean("lamp_upgrade", false);
            dataTag.putBoolean("fireproof", true);
            if (blockEntity != null) {
                DataComponentUtils.addBlockEntityDataComponents(blockEntity, dataTag, (DataComponentType<Unit>)DataComponents.FIRE_RESISTANT);
            }
        } else {
            dataTag.putBoolean("explosion_resistant", false);
            dataTag.putBoolean("lamp_upgrade", false);
            dataTag.putBoolean("fireproof", false);
        }
    }

    private static void spawnRemovedUpgrades(BlockState state, Level level, BlockPos pos) {
        if (((Boolean)state.getValue((Property)EXPLOSION_RESIST)).booleanValue()) {
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), new ItemStack((ItemLike)ModItems.OBSIDIAN_REINFORCEMENT_ITEM.get())));
        } else if (((Boolean)state.getValue((Property)LAMP_UPGRADE)).booleanValue()) {
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), new ItemStack((ItemLike)ModItems.LAMP_SIMULATOR_ITEM.get())));
        } else if (((Boolean)state.getValue((Property)FIREPROOF)).booleanValue()) {
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ(), new ItemStack((ItemLike)ModItems.FIREPROOFING_ITEM.get())));
        }
    }

    private static boolean hasSoap(Item stackItem, BlockState blockState) {
        String itemName = stackItem.getName(new ItemStack((ItemLike)stackItem)).getString();
        String blockName = blockState.getBlock().getName().getString();
        return blockName.contains("Stained") && itemName.equals("Soap");
    }

    private static boolean hasUpgrades(BlockState state) {
        return (Boolean)state.getValue((Property)EXPLOSION_RESIST) != false || (Boolean)state.getValue((Property)LAMP_UPGRADE) != false || (Boolean)state.getValue((Property)FIREPROOF) != false;
    }

    private static Block getCrateBlock(String crateName) {
        Item crateItem = ModItems.findCrateItemByID(crateName);
        Block crateBlock = null;
        if (crateItem instanceof CrateBlockItem) {
            CrateBlockItem crateBlockItem = (CrateBlockItem)crateItem;
            crateBlock = crateBlockItem.getBlock();
        }
        return crateBlock;
    }

    private static BlockEntity switchCrate(Level level, BlockPos pos, BlockState state, Block crateBlock, CompoundTag dataTag) {
        if (CrateBlock.hasUpgrades(state)) {
            if (((Boolean)state.getValue((Property)EXPLOSION_RESIST)).booleanValue()) {
                boolean resistant = true;
                boolean fire = false;
                boolean lamp = false;
                CrateBlock.setDataTagUpgrades(dataTag, resistant, lamp, fire, null);
            } else if (((Boolean)state.getValue((Property)LAMP_UPGRADE)).booleanValue()) {
                boolean lamp = true;
                boolean fire = false;
                boolean resistant = false;
                CrateBlock.setDataTagUpgrades(dataTag, resistant, lamp, fire, null);
            } else if (((Boolean)state.getValue((Property)FIREPROOF)).booleanValue()) {
                boolean fire = true;
                boolean lamp = false;
                boolean resistant = false;
                CrateBlock.setDataTagUpgrades(dataTag, resistant, lamp, fire, null);
            }
        } else {
            CrateBlock.setDataTagUpgrades(dataTag, false, false, false, null);
        }
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)SWITCH, (Comparable)Boolean.valueOf(true)));
        level.setBlockAndUpdate(pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)crateBlock.defaultBlockState().setValue(AXIS, (Comparable)((Direction.Axis)state.getValue(AXIS)))).setValue((Property)SWITCH, (Comparable)Boolean.valueOf(true))).setValue((Property)EXPLOSION_RESIST, (Comparable)((Boolean)state.getValue((Property)EXPLOSION_RESIST)))).setValue((Property)LAMP_UPGRADE, (Comparable)((Boolean)state.getValue((Property)LAMP_UPGRADE)))).setValue((Property)LIT, (Comparable)((Boolean)state.getValue((Property)LIT)))).setValue((Property)POWERED, (Comparable)((Boolean)state.getValue((Property)POWERED)))).setValue((Property)FIREPROOF, (Comparable)((Boolean)state.getValue((Property)FIREPROOF))));
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (dataTag.getBoolean("fireproof") && blockEntity != null) {
            DataComponentUtils.addBlockEntityDataComponents(blockEntity, dataTag, (DataComponentType<Unit>)DataComponents.FIRE_RESISTANT);
        }
        return blockEntity;
    }

    private boolean validDye(BlockState state, Item item) {
        List<Item> dye;
        if (Config.GLASS_CRATES_DYEABLE.getAsBoolean() && state.getBlock() instanceof GlassCrateBlock && (dye = List.of(Items.WHITE_DYE, Items.LIGHT_GRAY_DYE, Items.GRAY_DYE, Items.BLACK_DYE, Items.BROWN_DYE, Items.RED_DYE, Items.ORANGE_DYE, Items.YELLOW_DYE, Items.LIME_DYE, Items.GREEN_DYE, Items.CYAN_DYE, Items.LIGHT_BLUE_DYE, Items.BLUE_DYE, Items.PURPLE_DYE, Items.MAGENTA_DYE, Items.PINK_DYE)).contains(item)) {
            String crateType = state.getBlock().getDescriptionId().substring(state.getBlock().getDescriptionId().indexOf("s.") + 2, state.getBlock().getDescriptionId().indexOf("_crate"));
            String itemColor = item.getDescriptionId().substring(item.getDescriptionId().indexOf("minecraft.") + 10, item.getDescriptionId().indexOf("_dye"));
            if (crateType.contains("_stained") && !itemColor.equals(crateType.substring(0, crateType.indexOf("_stained")))) {
                return true;
            }
            return crateType.equals("glass");
        }
        return false;
    }

    private boolean validGlass(BlockState state, Item item) {
        List<Item> glass = List.of(Items.GLASS, Items.WHITE_STAINED_GLASS, Items.LIGHT_GRAY_STAINED_GLASS, Items.GRAY_STAINED_GLASS, Items.BLACK_STAINED_GLASS, Items.BROWN_STAINED_GLASS, Items.RED_STAINED_GLASS, Items.ORANGE_STAINED_GLASS, Items.YELLOW_STAINED_GLASS, Items.LIME_STAINED_GLASS, Items.GREEN_STAINED_GLASS, Items.CYAN_STAINED_GLASS, Items.LIGHT_BLUE_STAINED_GLASS, Items.BLUE_STAINED_GLASS, Items.PURPLE_STAINED_GLASS, Items.MAGENTA_STAINED_GLASS, Items.PINK_STAINED_GLASS);
        if (glass.contains(item)) {
            if (state.getBlock() instanceof GlassCrateBlock) {
                if (!Config.GLASS_CHANGE_GLASS_CRATE.getAsBoolean()) {
                    return false;
                }
                String crateID = state.getBlock().getDescriptionId();
                String crateColor = crateID.substring(crateID.indexOf("s.") + 2, crateID.indexOf("_crate"));
                String itemID = item.getDescriptionId();
                String itemColor = itemID.substring(itemID.indexOf("minecraft.") + 10);
                if (crateColor.contains("stained") && !itemColor.equals(crateColor)) {
                    return true;
                }
                return crateColor.equals("glass") && itemID.contains("stained");
            }
            return true;
        }
        return false;
    }

    private static void handleItemResult(Level level, BlockPos pos, ItemStack stack, Player player, SoundEvent sound) {
        if (stack.getItem() == ModItems.PLIERS_ITEM.get()) {
            if (!player.isCreative()) {
                stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
            }
            if (stack.getDamageValue() < stack.getMaxDamage()) {
                level.playSound(null, pos, SoundEvents.BEEHIVE_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        } else if (sound == SoundEvents.ANVIL_USE) {
            level.playSound(null, pos, sound, SoundSource.BLOCKS, 0.5f, 1.0f);
        } else {
            level.playSound(null, pos, sound, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

