/*
 * Decompiled with CFR 0.152.
 */
package com.criticalpickle.criticalcrates.item;

import com.criticalpickle.criticalcrates.Config;
import com.criticalpickle.criticalcrates.util.EnchantmentUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public class PliersItem
extends Item {
    public PliersItem(Item.Properties properties) {
        super(properties);
    }

    public boolean isDamageable(ItemStack stack) {
        return true;
    }

    public boolean isRepairable(ItemStack stack) {
        return true;
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.is(Items.IRON_INGOT) || super.isValidRepairItem(stack, repairCandidate);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        int chanceOfDamage;
        ItemStack copiedStack = stack.copy();
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        ItemEnchantments enchants = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)copiedStack);
        int unbreakingLvl = enchants.getLevel(EnchantmentUtils.getEnchantmentHolder((ResourceKey<Enchantment>)Enchantments.UNBREAKING));
        boolean causeDamage = true;
        if (data != null && data.copyTag().getBoolean("broken")) {
            return ItemStack.EMPTY;
        }
        if (unbreakingLvl > 0 && (chanceOfDamage = RandomSource.create().nextInt(1 + unbreakingLvl)) != 0) {
            causeDamage = false;
        }
        if (causeDamage) {
            copiedStack.setDamageValue(copiedStack.getDamageValue() + 1);
            if (copiedStack.getDamageValue() >= copiedStack.getMaxDamage()) {
                copiedStack.setDamageValue(copiedStack.getDamageValue() - 1);
                CompoundTag dataTag = new CompoundTag();
                dataTag.putBoolean("broken", true);
                copiedStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)dataTag));
            }
        }
        return copiedStack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (Config.ADDONS_REMOVABLE.getAsBoolean()) {
            if (Screen.hasShiftDown()) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.pliers.shift"));
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.pliers").withStyle(ChatFormatting.GRAY));
            }
        }
    }
}

