/*
 * Decompiled with CFR 0.152.
 */
package com.criticalpickle.criticalcrates.datagen;

import com.criticalpickle.criticalcrates.registration.ModItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "criticalcrates", existingFileHelper);
    }

    protected void registerModels() {
        for (int i = 0; i < ModItems.getCrateItems().length; ++i) {
            this.blockItemWithOverrides(ModItems.getCrateItems(i));
        }
        this.basicItem((Item)ModItems.PLIERS_ITEM.get());
        this.basicItem((Item)ModItems.OBSIDIAN_REINFORCEMENT_ITEM.get());
        this.basicItem((Item)ModItems.LAMP_SIMULATOR_ITEM.get());
        this.basicItem((Item)ModItems.FIREPROOFING_ITEM.get());
    }

    private void blockItemWithOverrides(Item item) {
        String itemName = item.getDescriptionId().substring(item.getDescriptionId().indexOf("s.") + 2);
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent(itemName, this.modLoc("block/" + itemName));
        ResourceLocation resistanceResLoc = ResourceLocation.tryBuild((String)"criticalcrates", (String)"resistant");
        ResourceLocation lampResLoc = ResourceLocation.tryBuild((String)"criticalcrates", (String)"lamp");
        ResourceLocation fireResLoc = ResourceLocation.tryBuild((String)"criticalcrates", (String)"fire");
        this.withExistingParent(itemName + "_resistant", this.modLoc("block/" + itemName + "_resistant"));
        this.withExistingParent(itemName + "_lamp", this.modLoc("block/" + itemName + "_lamp"));
        this.withExistingParent(itemName + "_fireproof", this.modLoc("block/" + itemName + "_fireproof"));
        builder.override().predicate(resistanceResLoc, 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("block/" + itemName + "_resistant"))).end().override().predicate(lampResLoc, 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("block/" + itemName + "_lamp"))).end().override().predicate(fireResLoc, 1.0f).model((ModelFile)this.getExistingFile(this.modLoc("block/" + itemName + "_fireproof"))).end();
    }
}

