/*
 * Decompiled with CFR 0.152.
 */
package com.criticalpickle.criticalcrates.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class CrateBlockItem
extends BlockItem {
    public CrateBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void onCraftedBy(ItemStack stack, Level level, Player player) {
        super.onCraftedBy(stack, level, player);
        this.checkTags(stack);
    }

    private void checkTags(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        CompoundTag dataTag = new CompoundTag();
        if (data == null) {
            dataTag.putBoolean("explosion_resistant", false);
            dataTag.putBoolean("lamp_upgrade", false);
            dataTag.putBoolean("fireproof", false);
        } else if (!(data.contains("explosion_resistant") && data.contains("lamp_upgrade") && data.contains("fireproof"))) {
            if (!data.contains("explosion_resistant")) {
                dataTag.putBoolean("explosion_resistant", false);
            }
            if (!data.contains("lamp_upgrade")) {
                dataTag.putBoolean("lamp_upgrade", false);
            }
            if (!data.contains("fireproof")) {
                dataTag.putBoolean("fireproof", false);
            }
        }
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)dataTag));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        boolean resistant = false;
        boolean lamp = false;
        boolean fire = false;
        if (!stack.isEmpty() && data != null) {
            if (data.contains("explosion_resistant")) {
                resistant = data.copyTag().getBoolean("explosion_resistant");
            }
            if (data.contains("lamp_upgrade")) {
                lamp = data.copyTag().getBoolean("lamp_upgrade");
            }
            if (data.contains("fireproof")) {
                fire = data.copyTag().getBoolean("fireproof");
            }
        }
        if (resistant) {
            tooltipComponents.add((Component)Component.literal((String)"Blast Resistant").withStyle(ChatFormatting.RED));
        } else if (lamp) {
            tooltipComponents.add((Component)Component.literal((String)"Light Emissive").withStyle(ChatFormatting.YELLOW));
        } else if (fire) {
            tooltipComponents.add((Component)Component.literal((String)"Fireproof").withStyle(ChatFormatting.GOLD));
        }
    }
}

