/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.abilities;

import com.solegendary.reignofnether.ability.Ability;
import com.solegendary.reignofnether.building.production.ProductionItems;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.HudClientEvents;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.research.ResearchClient;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.UnitClientEvents;
import com.solegendary.reignofnether.unit.goals.MountGoal;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.monsters.SkeletonUnit;
import com.solegendary.reignofnether.unit.units.monsters.StrayUnit;
import com.solegendary.reignofnether.unit.units.piglins.HeadhunterUnit;
import com.solegendary.reignofnether.unit.units.piglins.HoglinUnit;
import com.solegendary.reignofnether.unit.units.villagers.PillagerUnit;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class MountHoglin
extends Ability {
    private final LivingEntity entity;

    public MountHoglin(LivingEntity entity) {
        super(UnitAction.MOUNT_HOGLIN, entity.m_9236_(), 0, 0.0f, 0.0f, true);
        this.entity = entity;
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        return new AbilityButton("Mount Hoglin", new ResourceLocation("reignofnether", "textures/mobheads/hoglin.png"), hotkey, () -> CursorClientEvents.getLeftClickAction() == UnitAction.MOUNT_HOGLIN, () -> this.entity.m_20159_() || !ResearchClient.hasResearch(ProductionItems.RESEARCH_HOGLIN_CAVALRY), () -> true, () -> CursorClientEvents.setLeftClickAction(UnitAction.MOUNT_HOGLIN), () -> UnitClientEvents.sendUnitCommand(UnitAction.MOUNT_HOGLIN), List.of(FormattedCharSequence.m_13714_((String)I18n.m_118938_((String)"abilities.reignofnether.mount_hoglin", (Object[])new Object[0]), (Style)Style.f_131099_)), this);
    }

    private MountGoal getMountGoal() {
        LivingEntity livingEntity = this.entity;
        if (livingEntity instanceof PillagerUnit) {
            PillagerUnit pillagerUnit = (PillagerUnit)livingEntity;
            return pillagerUnit.getMountGoal();
        }
        livingEntity = this.entity;
        if (livingEntity instanceof StrayUnit) {
            StrayUnit strayUnit = (StrayUnit)livingEntity;
            return strayUnit.getMountGoal();
        }
        livingEntity = this.entity;
        if (livingEntity instanceof SkeletonUnit) {
            SkeletonUnit skeletonUnit = (SkeletonUnit)livingEntity;
            return skeletonUnit.getMountGoal();
        }
        livingEntity = this.entity;
        if (livingEntity instanceof HeadhunterUnit) {
            HeadhunterUnit headhunterUnit = (HeadhunterUnit)livingEntity;
            return headhunterUnit.getMountGoal();
        }
        return null;
    }

    @Override
    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
        MountGoal mountGoal = this.getMountGoal();
        if (mountGoal != null) {
            mountGoal.autofind = true;
        }
    }

    @Override
    public void use(Level level, Unit unitUsing, LivingEntity targetEntity) {
        MountGoal mountGoal = this.getMountGoal();
        if (mountGoal != null && targetEntity instanceof HoglinUnit) {
            this.getMountGoal().setTarget(targetEntity);
        } else if (level.m_5776_()) {
            HudClientEvents.showTemporaryMessage(I18n.m_118938_((String)"abilities.reignofnether.mount_hoglin.error1", (Object[])new Object[0]));
        }
    }
}

