/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.heroAbilities.monster;

import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;

public class SoulSiphonPassive
extends HeroAbility {
    public static int RANGE = 16;
    public float souls = 0.0f;
    public float soulsPerCast = 0.0f;
    public float soulsMax = 0.0f;
    private int lastEntityKilledId = -1;

    public SoulSiphonPassive(HeroUnit hero) {
        super(hero, 3, 0, UnitAction.NONE, 0, 0.0f, 0.0f, false);
        this.autocastEnableAction = UnitAction.ENABLE_SOUL_SIPHON_PASSIVE;
        this.autocastDisableAction = UnitAction.DISBLE_SOUL_SIPHON_PASSIVE;
        this.setAutocast(true);
    }

    @Override
    public boolean rankUp() {
        if (super.rankUp()) {
            this.updateStatsForRank();
            return true;
        }
        return false;
    }

    @Override
    public void updateStatsForRank() {
        if (this.rank == 1) {
            this.soulsPerCast = 4.0f;
            this.soulsMax = 20.0f;
        } else if (this.rank == 2) {
            this.soulsPerCast = 7.0f;
            this.soulsMax = 30.0f;
        } else if (this.rank == 3) {
            this.soulsPerCast = 10.0f;
            this.soulsMax = 40.0f;
        }
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        AbilityButton button = new AbilityButton("Soul Siphon", new ResourceLocation("reignofnether", "textures/icons/blocks/portal.png"), hotkey, this::isAutocasting, () -> this.rank == 0, () -> true, () -> this.toggleAutocast(), null, this.getTooltipLines(), this);
        button.extraLabel = String.valueOf((int)this.souls);
        if ((int)this.souls <= 0) {
            button.extraLabelColour = 0xFF0000;
        } else if ((int)this.souls >= (int)this.soulsMax) {
            button.extraLabelColour = 65280;
        } else if ((int)this.souls <= (int)this.soulsPerCast) {
            button.extraLabelColour = 0xFFFF00;
        }
        return button;
    }

    @Override
    public Button getRankUpButton() {
        return super.getRankUpButtonProtected("Soul Siphon", new ResourceLocation("reignofnether", "textures/icons/blocks/portal.png"));
    }

    @Override
    public List<FormattedCharSequence> getTooltipLines() {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon", (Object[])new Object[0]) + " " + this.rankString(), true), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon.tooltip2", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon.tooltip3", (Object[])new Object[]{Float.valueOf(this.soulsPerCast), Float.valueOf(this.soulsMax)})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon.tooltip4", (Object[])new Object[0])));
    }

    @Override
    public List<FormattedCharSequence> getRankUpTooltipLines() {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.level_req", (Object[])new Object[]{this.getLevelRequirement()}), this.getLevelReqStyle()), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon.tooltip2", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon.tooltip3", (Object[])new Object[]{Float.valueOf(this.soulsPerCast), Float.valueOf(this.soulsMax)})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.can_be_toggled", (Object[])new Object[0])), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon.rank1", (Object[])new Object[0]), this.rank == 0), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon.rank2", (Object[])new Object[0]), this.rank == 1), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.soul_siphon.rank3", (Object[])new Object[0]), this.rank == 2));
    }

    public boolean consumeSouls() {
        if (this.isAutocasting() && this.souls >= this.soulsPerCast) {
            this.souls -= this.soulsPerCast;
            return true;
        }
        return false;
    }

    public void checkAndGainSouls(LivingEntity entityKilled, int splitAmount) {
        if (this.soulsMax > 0.0f && entityKilled.m_19879_() != this.lastEntityKilledId) {
            Unit unit;
            if (entityKilled instanceof Unit && !(unit = (Unit)entityKilled).getOwnerName().equals(this.hero.getOwnerName())) {
                this.souls += (float)unit.getCost().population;
            }
            this.lastEntityKilledId = entityKilled.m_19879_();
        }
        if (this.souls > this.soulsMax) {
            this.souls = this.soulsMax;
        }
        if (((LivingEntity)this.hero).m_9236_().m_5776_()) {
            this.hero.updateAbilityButtons();
        }
    }
}

