/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.heroAbilities.piglin;

import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.goals.GenericTargetedSpellGoal;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.piglins.PiglinMerchantUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class FancyFeast
extends HeroAbility {
    public static final int RANGE = 10;
    private static final int CD_MAX_SECONDS = 900;
    public static final int BASE_ITEMS = 6;
    public static final int BONUS_ITEMS_PER_100_RESOURCES = 2;
    private static final float HEALTH_PER_BREAD = 10.0f;
    private static final float HEALTH_PER_CHICKEN = 15.0f;
    private static final float HEALTH_PER_BEEF = 20.0f;

    public FancyFeast(HeroUnit hero) {
        super(hero, 3, 70, UnitAction.FANCY_FEAST, 900, 10.0f, 0.0f, false);
    }

    private ResourceLocation getIcon(int plusRank) {
        if (this.rank + plusRank == 3) {
            return new ResourceLocation("minecraft", "textures/item/cooked_beef.png");
        }
        if (this.rank + plusRank == 2) {
            return new ResourceLocation("minecraft", "textures/item/cooked_chicken.png");
        }
        return new ResourceLocation("minecraft", "textures/item/bread.png");
    }

    public Item getFoodItem() {
        if (this.rank == 3) {
            return Items.f_42580_;
        }
        if (this.rank == 2) {
            return Items.f_42582_;
        }
        return Items.f_42406_;
    }

    private float getHealAmount() {
        if (this.rank == 3) {
            return 20.0f;
        }
        if (this.rank == 2) {
            return 15.0f;
        }
        return 10.0f;
    }

    @Override
    public boolean isCasting() {
        PiglinMerchantUnit piglinMerchantUnit;
        GenericTargetedSpellGoal goal;
        HeroUnit heroUnit = this.hero;
        if (heroUnit instanceof PiglinMerchantUnit && (goal = (piglinMerchantUnit = (PiglinMerchantUnit)heroUnit).getCastFancyFeastGoal()) != null) {
            return goal.isCasting();
        }
        return false;
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        return new AbilityButton("Fancy Feast", this.getIcon(0), hotkey, () -> CursorClientEvents.getLeftClickAction() == UnitAction.FANCY_FEAST, () -> this.rank == 0, () -> true, () -> CursorClientEvents.setLeftClickAction(UnitAction.FANCY_FEAST), null, this.getTooltipLines(), this);
    }

    @Override
    public Button getRankUpButton() {
        return super.getRankUpButtonProtected("Fancy Feast", this.getIcon(1));
    }

    @Override
    public List<FormattedCharSequence> getTooltipLines() {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.fancy_feast", (Object[])new Object[0]) + " " + this.rankString(), true), MiscUtil.fcsIcons(I18n.m_118938_((String)"abilities.reignofnether.fancy_feast.stats", (Object[])new Object[]{Float.valueOf(this.getHealAmount()), 45, this.manaCost})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.fancy_feast.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.fancy_feast.tooltip2", (Object[])new Object[]{6, 2})));
    }

    @Override
    public List<FormattedCharSequence> getRankUpTooltipLines() {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.fancy_feast", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.level_req", (Object[])new Object[]{this.getLevelRequirement()}), this.getLevelReqStyle()), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.fancy_feast.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.fancy_feast.tooltip2", (Object[])new Object[]{6, 2})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.fancy_feast.rank1", (Object[])new Object[0]), this.rank == 0), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.fancy_feast.rank2", (Object[])new Object[0]), this.rank == 1), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.fancy_feast.rank3", (Object[])new Object[0]), this.rank == 2));
    }

    @Override
    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
        ((PiglinMerchantUnit)unitUsing).getCastFancyFeastGoal().setAbility(this);
        ((PiglinMerchantUnit)unitUsing).getCastFancyFeastGoal().setTarget(targetBp);
    }

    @Override
    public void use(Level level, Unit unitUsing, LivingEntity targetEntity) {
        ((PiglinMerchantUnit)unitUsing).getCastFancyFeastGoal().setAbility(this);
        ((PiglinMerchantUnit)unitUsing).getCastFancyFeastGoal().setTarget(targetEntity.m_20097_());
    }
}

