/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.heroAbilities.piglin;

import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.resources.ResourceName;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesClientEvents;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;

public class GreedIsGoodPassive
extends HeroAbility {
    public int maxResourcesPerCast = 100;

    public GreedIsGoodPassive(HeroUnit hero) {
        super(hero, 3, 0, UnitAction.NONE, 0, 0.0f, 0.0f, false);
        this.autocastEnableAction = UnitAction.ENABLE_GREED_IS_GOOD_PASSIVE;
        this.autocastDisableAction = UnitAction.DISABLE_GREED_IS_GOOD_PASSIVE;
        this.setAutocast(true);
    }

    @Override
    public boolean rankUp() {
        if (super.rankUp()) {
            this.updateStatsForRank();
            return true;
        }
        return false;
    }

    @Override
    public void updateStatsForRank() {
        if (this.rank == 1) {
            this.maxResourcesPerCast = 100;
        } else if (this.rank == 2) {
            this.maxResourcesPerCast = 200;
        } else if (this.rank == 3) {
            this.maxResourcesPerCast = 300;
        }
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        return new AbilityButton("Greed is Good", new ResourceLocation("minecraft", "textures/block/gold_block.png"), hotkey, this::isAutocasting, () -> this.rank == 0, () -> true, () -> this.toggleAutocast(), null, this.getTooltipLines(), this);
    }

    @Override
    public Button getRankUpButton() {
        return super.getRankUpButtonProtected("Greed is Good", new ResourceLocation("minecraft", "textures/block/gold_block.png"));
    }

    @Override
    public List<FormattedCharSequence> getTooltipLines() {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.greed_is_good", (Object[])new Object[0]) + " " + this.rankString(), true), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.greed_is_good.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.greed_is_good.tooltip2", (Object[])new Object[]{this.maxResourcesPerCast})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.greed_is_good.tooltip3", (Object[])new Object[0])));
    }

    @Override
    public List<FormattedCharSequence> getRankUpTooltipLines() {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.greed_is_good", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.level_req", (Object[])new Object[]{this.getLevelRequirement()}), this.getLevelReqStyle()), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.greed_is_good.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.greed_is_good.tooltip2", (Object[])new Object[]{this.maxResourcesPerCast})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.can_be_toggled", (Object[])new Object[0])), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.greed_is_good.rank1", (Object[])new Object[0]), this.rank == 0), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.greed_is_good.rank2", (Object[])new Object[0]), this.rank == 1), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.greed_is_good.rank3", (Object[])new Object[0]), this.rank == 2));
    }

    public int spendResourcesAndGet100sSpent(ResourceName resName) {
        ArrayList<Resources> resourcesList;
        int totalSpent = 0;
        String ownerName = this.hero.getOwnerName();
        boolean isClientSide = ((LivingEntity)this.hero).m_9236_().m_5776_();
        ArrayList<Resources> arrayList = resourcesList = isClientSide ? ResourcesClientEvents.resourcesList : ResourcesServerEvents.resourcesList;
        if (this.isAutocasting()) {
            for (Resources resources : resourcesList) {
                if (!resources.ownerName.equals(ownerName)) continue;
                for (int i = 0; i < this.rank; ++i) {
                    Resources resToSpend = new Resources(this.hero.getOwnerName(), 0, 0, 0);
                    if (resName == ResourceName.FOOD && resources.food >= 100) {
                        resToSpend.food -= 100;
                        totalSpent += 100;
                    } else if (resName == ResourceName.WOOD && resources.wood >= 100) {
                        resToSpend.wood -= 100;
                        totalSpent += 100;
                    } else if (resName == ResourceName.ORE && resources.ore >= 100) {
                        resToSpend.ore -= 100;
                        totalSpent += 100;
                    }
                    if (isClientSide) continue;
                    ResourcesServerEvents.addSubtractResources(resToSpend);
                }
            }
        }
        return totalSpent / 100;
    }
}

