/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.ability.heroAbilities.villager;

import com.solegendary.reignofnether.ability.HeroAbility;
import com.solegendary.reignofnether.cursor.CursorClientEvents;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.hud.Button;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.unit.UnitAction;
import com.solegendary.reignofnether.unit.goals.GenericTargetedSpellGoal;
import com.solegendary.reignofnether.unit.interfaces.HeroUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.units.villagers.RoyalGuardUnit;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class MaceSlam
extends HeroAbility {
    public static final float RADIUS = 4.0f;
    public static final float RANGE = 4.0f;
    public float damage = 10.0f;
    public int stunDuration = 40;

    public MaceSlam(HeroUnit hero) {
        super(hero, 3, 30, UnitAction.MACE_SLAM, 600, 4.0f, 0.0f, true);
    }

    @Override
    public boolean isCasting() {
        RoyalGuardUnit royalGuardUnit;
        GenericTargetedSpellGoal goal;
        HeroUnit heroUnit = this.hero;
        if (heroUnit instanceof RoyalGuardUnit && (goal = (royalGuardUnit = (RoyalGuardUnit)heroUnit).getCastMaceSlamGoal()) != null) {
            return goal.isCasting();
        }
        return false;
    }

    @Override
    public boolean rankUp() {
        if (super.rankUp()) {
            this.updateStatsForRank();
            return true;
        }
        return false;
    }

    @Override
    public void updateStatsForRank() {
        if (this.rank == 1) {
            this.damage = 10.0f;
            this.stunDuration = 40;
        } else if (this.rank == 2) {
            this.damage = 15.0f;
            this.stunDuration = 60;
        } else if (this.rank == 3) {
            this.damage = 20.0f;
            this.stunDuration = 80;
        }
    }

    @Override
    public AbilityButton getButton(Keybinding hotkey) {
        return new AbilityButton("Mace Slam", new ResourceLocation("reignofnether", "textures/icons/items/mace.png"), hotkey, () -> CursorClientEvents.getLeftClickAction() == UnitAction.MACE_SLAM, () -> this.rank == 0, () -> true, () -> CursorClientEvents.setLeftClickAction(UnitAction.MACE_SLAM), null, this.getTooltipLines(), this);
    }

    @Override
    public Button getRankUpButton() {
        return super.getRankUpButtonProtected("Mace Slam", new ResourceLocation("reignofnether", "textures/icons/items/mace.png"));
    }

    @Override
    public List<FormattedCharSequence> getTooltipLines() {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.mace_slam", (Object[])new Object[0]) + " " + this.rankString(), true), MiscUtil.fcsIcons(I18n.m_118938_((String)"abilities.reignofnether.mace_slam.stats", (Object[])new Object[]{Float.valueOf(this.damage), Float.valueOf(this.cooldownMax / 20.0f), this.manaCost})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.mace_slam.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.mace_slam.tooltip2", (Object[])new Object[]{this.stunDuration / 20})));
    }

    @Override
    public List<FormattedCharSequence> getRankUpTooltipLines() {
        return List.of(MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.mace_slam", (Object[])new Object[0]), true), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.level_req", (Object[])new Object[]{this.getLevelRequirement()}), this.getLevelReqStyle()), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.mace_slam.tooltip1", (Object[])new Object[0])), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.mace_slam.tooltip2", (Object[])new Object[]{this.stunDuration / 20})), MiscUtil.fcs(""), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.mace_slam.rank1", (Object[])new Object[0]), this.rank == 0), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.mace_slam.rank2", (Object[])new Object[0]), this.rank == 1), MiscUtil.fcs(I18n.m_118938_((String)"abilities.reignofnether.mace_slam.rank3", (Object[])new Object[0]), this.rank == 2));
    }

    @Override
    public void use(Level level, Unit unitUsing, LivingEntity targetEntity) {
        ((RoyalGuardUnit)unitUsing).getCastMaceSlamGoal().setAbility(this);
        ((RoyalGuardUnit)unitUsing).getCastMaceSlamGoal().setTarget(targetEntity);
    }

    @Override
    public void use(Level level, Unit unitUsing, BlockPos targetBp) {
        ((RoyalGuardUnit)unitUsing).getCastMaceSlamGoal().setAbility(this);
        ((RoyalGuardUnit)unitUsing).getCastMaceSlamGoal().setTarget(targetBp);
    }
}

