/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.alliance;

import com.solegendary.reignofnether.team.TeamClientEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.LivingEntity;

public class AlliancesClient {
    private static final Minecraft MC = Minecraft.m_91087_();
    private static final Map<String, Set<String>> alliances = new HashMap<String, Set<String>>();
    public static final HashSet<String> playersWithAlliedControl = new HashSet();

    public static boolean canControlAlly(LivingEntity entity) {
        Unit unit;
        return entity instanceof Unit && AlliancesClient.canControlAlly((unit = (Unit)entity).getOwnerName());
    }

    public static boolean canControlAlly(Unit unit) {
        return AlliancesClient.canControlAlly(unit.getOwnerName());
    }

    public static boolean canControlAlly(String ownerName) {
        return AlliancesClient.MC.f_91074_ != null && AlliancesClient.isAllied(AlliancesClient.MC.f_91074_.m_7755_().getString(), ownerName) && playersWithAlliedControl.contains(ownerName);
    }

    public static void addAlliance(String owner1, String owner2) {
        alliances.computeIfAbsent(owner1, k -> new HashSet()).add(owner2);
        alliances.computeIfAbsent(owner2, k -> new HashSet()).add(owner1);
    }

    public static void removeAlliance(String owner1, String owner2) {
        Set<String> alliesOfOwner2;
        Set<String> alliesOfOwner1 = alliances.get(owner1);
        if (alliesOfOwner1 != null) {
            alliesOfOwner1.remove(owner2);
            if (alliesOfOwner1.isEmpty()) {
                alliances.remove(owner1);
            }
        }
        if ((alliesOfOwner2 = alliances.get(owner2)) != null) {
            alliesOfOwner2.remove(owner1);
            if (alliesOfOwner2.isEmpty()) {
                alliances.remove(owner2);
            }
        }
    }

    public static boolean isAllied(String owner1, String owner2) {
        if (TeamClientEvents.areOnSameTeam(owner1, owner2)) {
            return true;
        }
        return alliances.getOrDefault(owner1, Collections.emptySet()).contains(owner2);
    }

    public static Set<String> getAllAllies(String owner) {
        return alliances.getOrDefault(owner, Collections.emptySet());
    }

    public static Set<String> getAllConnectedAllies(String owner) {
        HashSet<String> allAllies = new HashSet<String>();
        Set<String> teammates = TeamClientEvents.getTeammates(owner);
        allAllies.addAll(teammates);
        AlliancesClient.findAllConnectedAllies(owner, allAllies);
        return allAllies;
    }

    private static void findAllConnectedAllies(String owner, Set<String> visited) {
        if (!visited.contains(owner)) {
            visited.add(owner);
            for (String ally : AlliancesClient.getAllAllies(owner)) {
                AlliancesClient.findAllConnectedAllies(ally, visited);
            }
        }
    }

    public static void resetAllAlliances() {
        alliances.clear();
    }
}

