/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.alliance;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.alliance.AllianceClientboundAddPacket;
import com.solegendary.reignofnether.alliance.AllianceClientboundControlPacket;
import com.solegendary.reignofnether.alliance.AllianceClientboundRemovePacket;
import com.solegendary.reignofnether.registrars.PacketHandler;
import com.solegendary.reignofnether.team.TeamManager;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public class AlliancesServerEvents {
    private static final Map<String, Set<String>> alliances = new HashMap<String, Set<String>>();
    public static final HashSet<String> playersWithAlliedControl = new HashSet();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static boolean canControlAlly(String player, LivingEntity entity) {
        Unit unit;
        return entity instanceof Unit && AlliancesServerEvents.canControlAlly(player, (unit = (Unit)entity).getOwnerName());
    }

    public static boolean canControlAlly(String player, Unit unit) {
        return AlliancesServerEvents.canControlAlly(player, unit.getOwnerName());
    }

    public static boolean canControlAlly(String player, String ownerName) {
        return AlliancesServerEvents.isAllied(player, ownerName) && playersWithAlliedControl.contains(ownerName);
    }

    public static void addAlliance(String owner1, String owner2) {
        if (!owner1.equals(owner2)) {
            alliances.computeIfAbsent(owner1, k -> new HashSet()).add(owner2);
            alliances.computeIfAbsent(owner2, k -> new HashSet()).add(owner1);
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new AllianceClientboundAddPacket(owner1, owner2));
        }
    }

    public static void removeAlliance(String owner1, String owner2) {
        Set<String> alliesOfOwner2;
        Set<String> alliesOfOwner1 = alliances.get(owner1);
        if (alliesOfOwner1 != null) {
            alliesOfOwner1.remove(owner2);
            if (alliesOfOwner1.isEmpty()) {
                alliances.remove(owner1);
            }
        }
        if ((alliesOfOwner2 = alliances.get(owner2)) != null) {
            alliesOfOwner2.remove(owner1);
            if (alliesOfOwner2.isEmpty()) {
                alliances.remove(owner2);
            }
        }
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new AllianceClientboundRemovePacket(owner1, owner2));
    }

    public static boolean isAllied(String owner1, String owner2) {
        if (TeamManager.areOnSameTeam(owner1, owner2)) {
            return true;
        }
        return alliances.getOrDefault(owner1, Collections.emptySet()).contains(owner2);
    }

    public static Set<String> getAllAllies(String owner) {
        return alliances.getOrDefault(owner, Collections.emptySet());
    }

    public static Set<String> getAllConnectedAllies(String owner) {
        HashSet<String> allAllies = new HashSet<String>();
        Set<String> teammates = TeamManager.getTeammates(owner);
        allAllies.addAll(teammates);
        AlliancesServerEvents.findAllConnectedAllies(owner, allAllies);
        return allAllies;
    }

    private static void findAllConnectedAllies(String owner, Set<String> visited) {
        if (!visited.contains(owner)) {
            visited.add(owner);
            for (String ally : AlliancesServerEvents.getAllAllies(owner)) {
                AlliancesServerEvents.findAllConnectedAllies(ally, visited);
            }
        }
    }

    public static void resetAllAlliances() {
        alliances.clear();
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new AllianceClientboundRemovePacket());
    }

    public static void syncAlliances() {
        for (String player1 : alliances.keySet()) {
            for (String player2 : alliances.get(player1)) {
                PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new AllianceClientboundAddPacket(player1, player2));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        AlliancesServerEvents.syncAlliances();
        for (String playerName : playersWithAlliedControl) {
            PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new AllianceClientboundControlPacket(playerName, true));
        }
        String playerName = evt.getEntity().m_7755_().getString();
        TeamManager.syncTeamsToPlayer(playerName);
    }

    private static Path getAlliancesJsonPath(ServerLevel serverLevel) {
        return serverLevel.m_7654_().m_129843_(LevelResource.f_78182_).resolve("reignofnether").resolve("alliances.json");
    }

    public static void saveToJson(ServerLevel serverLevel) {
        try {
            Path path = AlliancesServerEvents.getAlliancesJsonPath(serverLevel);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)GSON.toJson(alliances), new OpenOption[0]);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Failed to save alliances.json", (Throwable)e);
        }
    }

    public static void loadFromJson(ServerLevel serverLevel) {
        try {
            Path path = AlliancesServerEvents.getAlliancesJsonPath(serverLevel);
            if (!Files.exists(path, new LinkOption[0])) {
                return;
            }
            String json = Files.readString(path);
            Map map = (Map)GSON.fromJson(json, new TypeToken<Map<String, Set<String>>>(){}.getType());
            alliances.clear();
            if (map != null) {
                alliances.putAll(map);
            }
            AlliancesServerEvents.syncAlliances();
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Failed to load alliances.json", (Throwable)e);
        }
    }

    public static void resetAndSave(ServerLevel serverLevel) {
        AlliancesServerEvents.resetAllAlliances();
        AlliancesServerEvents.saveToJson(serverLevel);
    }
}

