/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.api;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.api.events.ModRegistrationEvents;
import com.solegendary.reignofnether.building.BuildingRegistry;
import com.solegendary.reignofnether.building.production.dynamic.DynamicProductionRegistry;
import com.solegendary.reignofnether.faction.FactionRegistry;
import com.solegendary.reignofnether.registrars.DefaultProductionRegistrar;
import com.solegendary.reignofnether.registrars.DefaultResourceRegistrar;
import com.solegendary.reignofnether.registrars.DynamicEntityRegistrar;
import com.solegendary.reignofnether.resources.dynamic.DynamicResourceRegistry;
import com.solegendary.reignofnether.unit.UnitRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ModIntegrationManager {
    private static boolean initialized = false;
    private static boolean registrationComplete = false;

    public static void initialize() {
        if (initialized) {
            ReignOfNether.LOGGER.warn("ModIntegrationManager already initialized, skipping duplicate initialization");
            return;
        }
        ReignOfNether.LOGGER.info("Initializing mod integration system...");
        FMLJavaModLoadingContext.get().getModEventBus().register(ModIntegrationManager.class);
        initialized = true;
        ReignOfNether.LOGGER.info("Mod integration system initialized");
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ReignOfNether.LOGGER.info("Starting mod registration phase...");
            FactionRegistry.initializeDefaultFactions();
            DynamicEntityRegistrar.initialize();
            ReignOfNether.LOGGER.info("Firing faction registration event...");
            ModRegistrationEvents.RegisterFactionsEvent factionEvent = new ModRegistrationEvents.RegisterFactionsEvent();
            MinecraftForge.EVENT_BUS.post((Event)factionEvent);
            ReignOfNether.LOGGER.info("Firing unit registration event...");
            ModRegistrationEvents.RegisterUnitsEvent unitEvent = new ModRegistrationEvents.RegisterUnitsEvent();
            MinecraftForge.EVENT_BUS.post((Event)unitEvent);
            DynamicEntityRegistrar.completeRegistrations();
            ReignOfNether.LOGGER.info("Firing building registration event...");
            ModRegistrationEvents.RegisterBuildingsEvent buildingEvent = new ModRegistrationEvents.RegisterBuildingsEvent();
            MinecraftForge.EVENT_BUS.post((Event)buildingEvent);
            ReignOfNether.LOGGER.info("Registering default resources...");
            DefaultResourceRegistrar.initialize();
            ReignOfNether.LOGGER.info("Firing resource registration event...");
            DynamicResourceRegistry.ResourceRegistrationEvent resourceEvent = new DynamicResourceRegistry.ResourceRegistrationEvent();
            MinecraftForge.EVENT_BUS.post((Event)resourceEvent);
            ReignOfNether.LOGGER.info("Registering default productions...");
            DefaultProductionRegistrar.initialize();
            ReignOfNether.LOGGER.info("Firing production registration event...");
            DynamicProductionRegistry.ProductionRegistrationEvent productionEvent = new DynamicProductionRegistry.ProductionRegistrationEvent();
            MinecraftForge.EVENT_BUS.post((Event)productionEvent);
            ReignOfNether.LOGGER.info("Firing registration complete event...");
            ModRegistrationEvents.RegistrationCompleteEvent completeEvent = new ModRegistrationEvents.RegistrationCompleteEvent();
            MinecraftForge.EVENT_BUS.post((Event)completeEvent);
            registrationComplete = true;
            ReignOfNether.LOGGER.info("Mod registration phase completed");
            ModIntegrationManager.logRegistrationStatistics();
        });
    }

    public static boolean isRegistrationComplete() {
        return registrationComplete;
    }

    private static void logRegistrationStatistics() {
        int factionCount = FactionRegistry.getAllFactions().size();
        int unitCount = UnitRegistry.getAllUnits().size();
        int buildingCount = BuildingRegistry.getAllBuildings().size();
        boolean behaviorCount = false;
        int resourceCount = DynamicResourceRegistry.getAllResources().size();
        int productionCount = DynamicProductionRegistry.getAllProductions().size();
        ReignOfNether.LOGGER.info("Registration Statistics:");
        ReignOfNether.LOGGER.info("  - Factions: {}", (Object)factionCount);
        ReignOfNether.LOGGER.info("  - Units: {}", (Object)unitCount);
        ReignOfNether.LOGGER.info("  - Buildings: {}", (Object)buildingCount);
        ReignOfNether.LOGGER.info("  - Resources: {}", (Object)resourceCount);
        ReignOfNether.LOGGER.info("  - Productions: {}", (Object)productionCount);
        FactionRegistry.getAllFactions().forEach(faction -> {
            int factionUnits = UnitRegistry.getUnitsForFaction(faction).size();
            int factionBuildings = BuildingRegistry.getBuildingsForFaction(faction).size();
            boolean factionBehaviors = false;
            int factionResources = DynamicResourceRegistry.getResourcesForFaction(faction).size();
            int factionProductions = DynamicProductionRegistry.getProductionsForFaction(faction).size();
            ReignOfNether.LOGGER.info("  - Faction '{}' has {} units, {} buildings, {} resources, and {} productions", (Object)faction.getDisplayName(), (Object)factionUnits, (Object)factionBuildings, (Object)factionResources, (Object)factionProductions);
        });
    }

    public static void ensureInitialized() {
        if (!initialized) {
            ModIntegrationManager.initialize();
        }
    }
}

