/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.api;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingProperties;
import com.solegendary.reignofnether.building.BuildingRegistry;
import com.solegendary.reignofnether.building.BuildingType;
import com.solegendary.reignofnether.building.production.dynamic.DynamicProductionItem;
import com.solegendary.reignofnether.building.production.dynamic.DynamicProductionProperties;
import com.solegendary.reignofnether.building.production.dynamic.DynamicProductionRegistry;
import com.solegendary.reignofnether.building.production.dynamic.ProductionType;
import com.solegendary.reignofnether.faction.FactionProperties;
import com.solegendary.reignofnether.faction.FactionRegistry;
import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.dynamic.DynamicResourceProperties;
import com.solegendary.reignofnether.resources.dynamic.DynamicResourceRegistry;
import com.solegendary.reignofnether.resources.dynamic.DynamicResourceType;
import com.solegendary.reignofnether.resources.dynamic.ResourceCategory;
import com.solegendary.reignofnether.unit.UnitProperties;
import com.solegendary.reignofnether.unit.UnitRegistry;
import com.solegendary.reignofnether.unit.UnitType;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public final class ReignOfNetherAPI {
    private ReignOfNetherAPI() {
    }

    public static FactionType registerFaction(ResourceLocation id, String displayName, int primaryColor, int secondaryColor, FactionProperties properties) {
        FactionType faction = new FactionType(id, displayName, primaryColor, secondaryColor, properties);
        return FactionRegistry.register(faction);
    }

    public static FactionType registerFaction(ResourceLocation id, String displayName, int primaryColor, int secondaryColor) {
        return ReignOfNetherAPI.registerFaction(id, displayName, primaryColor, secondaryColor, FactionProperties.defaultProperties());
    }

    public static FactionType getFaction(ResourceLocation id) {
        return FactionRegistry.getFaction(id);
    }

    public static List<FactionType> getAllFactions() {
        return FactionRegistry.getAllFactions();
    }

    public static <T extends LivingEntity> UnitType<T> registerUnit(ResourceLocation id, String displayName, Supplier<EntityType<T>> entityTypeSupplier, FactionType faction, ResourceCost cost, UnitProperties properties, Class<T> unitClass) {
        UnitType<T> unitType = new UnitType<T>(id, displayName, entityTypeSupplier, faction, cost, properties, unitClass);
        return UnitRegistry.register(unitType);
    }

    public static <T extends LivingEntity> UnitType<T> registerUnit(ResourceLocation id, String displayName, Supplier<EntityType<T>> entityTypeSupplier, FactionType faction, ResourceCost cost, Class<T> unitClass) {
        return ReignOfNetherAPI.registerUnit(id, displayName, entityTypeSupplier, faction, cost, UnitProperties.defaultProperties(), unitClass);
    }

    public static UnitType<?> getUnit(ResourceLocation id) {
        return UnitRegistry.getUnitType(id);
    }

    public static List<UnitType<?>> getUnitsForFaction(FactionType faction) {
        return UnitRegistry.getUnitsForFaction(faction);
    }

    public static List<UnitType<?>> getAllUnits() {
        return UnitRegistry.getAllUnits();
    }

    public static <T extends Building> BuildingType<T> registerBuilding(ResourceLocation id, String displayName, Supplier<T> buildingSupplier, FactionType faction, ResourceCost cost, BuildingProperties properties, Class<T> buildingClass) {
        BuildingType<T> buildingType = new BuildingType<T>(id, displayName, buildingSupplier, faction, cost, properties, buildingClass);
        return BuildingRegistry.register(buildingType);
    }

    public static <T extends Building> BuildingType<T> registerBuilding(ResourceLocation id, String displayName, Supplier<T> buildingSupplier, FactionType faction, ResourceCost cost, Class<T> buildingClass) {
        return ReignOfNetherAPI.registerBuilding(id, displayName, buildingSupplier, faction, cost, BuildingProperties.defaultProperties(), buildingClass);
    }

    public static BuildingType<?> getBuilding(ResourceLocation id) {
        return BuildingRegistry.getBuildingType(id);
    }

    public static List<BuildingType<?>> getBuildingsForFaction(FactionType faction) {
        return BuildingRegistry.getBuildingsForFaction(faction);
    }

    public static List<BuildingType<?>> getAllBuildings() {
        return BuildingRegistry.getAllBuildings();
    }

    public static boolean isFactionRegistered(ResourceLocation id) {
        return FactionRegistry.isRegistered(id);
    }

    public static boolean isUnitRegistered(ResourceLocation id) {
        return UnitRegistry.isRegistered(id);
    }

    public static boolean isBuildingRegistered(ResourceLocation id) {
        return BuildingRegistry.isRegistered(id);
    }

    public static FactionType getFactionForEntity(LivingEntity entity) {
        return UnitRegistry.getFactionForEntity(entity);
    }

    public static FactionType getFactionForBuilding(Building building) {
        return BuildingRegistry.getFactionForBuilding(building);
    }

    public static DynamicResourceType registerResource(ResourceLocation id, String displayName, Item item, FactionType faction, ResourceCategory category, DynamicResourceProperties properties) {
        DynamicResourceType resourceType = new DynamicResourceType(id, displayName, item, faction, category, properties);
        return DynamicResourceRegistry.register(resourceType);
    }

    public static DynamicResourceType registerResource(ResourceLocation id, String displayName, Item item, FactionType faction, ResourceCategory category) {
        return ReignOfNetherAPI.registerResource(id, displayName, item, faction, category, DynamicResourceProperties.defaultProperties());
    }

    public static DynamicResourceType getResource(ResourceLocation id) {
        return DynamicResourceRegistry.getResourceType(id);
    }

    public static DynamicResourceType getResource(Item item) {
        return DynamicResourceRegistry.getResourceType(item);
    }

    public static List<DynamicResourceType> getResourcesForFaction(FactionType faction) {
        return DynamicResourceRegistry.getResourcesForFaction(faction);
    }

    public static List<DynamicResourceType> getResourcesByCategory(ResourceCategory category) {
        return DynamicResourceRegistry.getResourcesByCategory(category);
    }

    public static List<DynamicResourceType> getAllResources() {
        return DynamicResourceRegistry.getAllResources();
    }

    public static boolean isResourceRegistered(ResourceLocation id) {
        return DynamicResourceRegistry.isRegistered(id);
    }

    public static boolean isResource(Item item) {
        return DynamicResourceRegistry.isResource(item);
    }

    public static DynamicProductionItem registerProduction(ResourceLocation id, String displayName, FactionType faction, ProductionType productionType, ItemStack result, Map<DynamicResourceType, Integer> resourceCosts, DynamicProductionProperties properties, List<ResourceLocation> requirements) {
        DynamicProductionItem productionItem = new DynamicProductionItem(id, displayName, faction, productionType, result, resourceCosts, properties, requirements);
        return DynamicProductionRegistry.register(productionItem);
    }

    public static DynamicProductionItem registerProduction(ResourceLocation id, String displayName, FactionType faction, ProductionType productionType, ItemStack result, Map<DynamicResourceType, Integer> resourceCosts) {
        return ReignOfNetherAPI.registerProduction(id, displayName, faction, productionType, result, resourceCosts, DynamicProductionProperties.defaultProperties(), List.of());
    }

    public static DynamicProductionItem getProduction(ResourceLocation id) {
        return DynamicProductionRegistry.getProductionItem(id);
    }

    public static List<DynamicProductionItem> getProductionsForFaction(FactionType faction) {
        return DynamicProductionRegistry.getProductionsForFaction(faction);
    }

    public static List<DynamicProductionItem> getProductionsByType(ProductionType type) {
        return DynamicProductionRegistry.getProductionsByType(type);
    }

    public static List<DynamicProductionItem> getAllProductions() {
        return DynamicProductionRegistry.getAllProductions();
    }

    public static boolean isProductionRegistered(ResourceLocation id) {
        return DynamicProductionRegistry.isRegistered(id);
    }
}

