/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.api.events;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingProperties;
import com.solegendary.reignofnether.building.BuildingRegistry;
import com.solegendary.reignofnether.building.BuildingType;
import com.solegendary.reignofnether.faction.FactionProperties;
import com.solegendary.reignofnether.faction.FactionRegistry;
import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.unit.UnitProperties;
import com.solegendary.reignofnether.unit.UnitRegistry;
import com.solegendary.reignofnether.unit.UnitType;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.eventbus.api.Event;

public class ModRegistrationEvents {

    public static class RegistrationCompleteEvent
    extends Event {
        public FactionType getFaction(ResourceLocation id) {
            return FactionRegistry.getFaction(id);
        }

        public UnitType<?> getUnit(ResourceLocation id) {
            return UnitRegistry.getUnitType(id);
        }

        public BuildingType<?> getBuilding(ResourceLocation id) {
            return BuildingRegistry.getBuildingType(id);
        }
    }

    public static class RegisterBuildingsEvent
    extends Event {
        public <T extends Building> BuildingType<T> registerBuilding(ResourceLocation id, String displayName, Supplier<T> buildingSupplier, FactionType faction, ResourceCost cost, BuildingProperties properties, Class<T> buildingClass) {
            BuildingType<T> buildingType = new BuildingType<T>(id, displayName, buildingSupplier, faction, cost, properties, buildingClass);
            return BuildingRegistry.register(buildingType);
        }

        public <T extends Building> BuildingType<T> registerBuilding(ResourceLocation id, String displayName, Supplier<T> buildingSupplier, FactionType faction, ResourceCost cost, Class<T> buildingClass) {
            return this.registerBuilding(id, displayName, buildingSupplier, faction, cost, BuildingProperties.defaultProperties(), buildingClass);
        }
    }

    public static class RegisterUnitsEvent
    extends Event {
        public <T extends LivingEntity> UnitType<T> registerUnit(ResourceLocation id, String displayName, Supplier<EntityType<T>> entityTypeSupplier, FactionType faction, ResourceCost cost, UnitProperties properties, Class<T> unitClass) {
            UnitType<T> unitType = new UnitType<T>(id, displayName, entityTypeSupplier, faction, cost, properties, unitClass);
            return UnitRegistry.register(unitType);
        }

        public <T extends LivingEntity> UnitType<T> registerUnit(ResourceLocation id, String displayName, Supplier<EntityType<T>> entityTypeSupplier, FactionType faction, ResourceCost cost, Class<T> unitClass) {
            return this.registerUnit(id, displayName, entityTypeSupplier, faction, cost, UnitProperties.defaultProperties(), unitClass);
        }
    }

    public static class RegisterFactionsEvent
    extends Event {
        public FactionType registerFaction(ResourceLocation id, String displayName, int primaryColor, int secondaryColor, FactionProperties properties) {
            FactionType faction = new FactionType(id, displayName, primaryColor, secondaryColor, properties);
            return FactionRegistry.register(faction);
        }

        public FactionType registerFaction(ResourceLocation id, String displayName, int primaryColor, int secondaryColor) {
            return this.registerFaction(id, displayName, primaryColor, secondaryColor, FactionProperties.defaultProperties());
        }
    }
}

