/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.api.examples;

import com.solegendary.reignofnether.api.events.ModRegistrationEvents;
import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingProperties;
import com.solegendary.reignofnether.building.production.dynamic.DynamicProductionItem;
import com.solegendary.reignofnether.building.production.dynamic.DynamicProductionProperties;
import com.solegendary.reignofnether.building.production.dynamic.DynamicProductionRegistry;
import com.solegendary.reignofnether.building.production.dynamic.ProductionType;
import com.solegendary.reignofnether.faction.FactionProperties;
import com.solegendary.reignofnether.faction.FactionRegistry;
import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.hud.AbilityButton;
import com.solegendary.reignofnether.keybinds.Keybinding;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.dynamic.DynamicResourceProperties;
import com.solegendary.reignofnether.resources.dynamic.DynamicResourceRegistry;
import com.solegendary.reignofnether.resources.dynamic.DynamicResourceType;
import com.solegendary.reignofnether.resources.dynamic.ResourceCategory;
import com.solegendary.reignofnether.unit.UnitProperties;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.Faction;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ExampleModIntegration {
    private static final String MOD_ID = "examplemod";

    @SubscribeEvent
    public void onRegisterFactions(ModRegistrationEvents.RegisterFactionsEvent event) {
        FactionType customFaction = event.registerFaction(new ResourceLocation(MOD_ID, "custom_faction"), "Custom Faction", 9055202, 4915330, FactionProperties.builder().fireImmune(true).healingAmount(1.5f).damageMultiplier(1.2f).aggressive(true).build());
    }

    @SubscribeEvent
    public void onRegisterUnits(ModRegistrationEvents.RegisterUnitsEvent event) {
        FactionType customFaction = FactionRegistry.getFaction(new ResourceLocation(MOD_ID, "custom_faction"));
        if (customFaction != null) {
            event.registerUnit(new ResourceLocation(MOD_ID, "custom_worker"), "Custom Worker", () -> this.getCustomWorkerEntityType(), customFaction, ResourceCost.Unit(25, 0, 0, 0, 1), UnitProperties.builder().worker(true).populationCost(1).moveSpeedMultiplier(1.1f).build(), CustomWorkerUnit.class);
            event.registerUnit(new ResourceLocation(MOD_ID, "custom_warrior"), "Custom Warrior", () -> this.getCustomWarriorEntityType(), customFaction, ResourceCost.Unit(30, 50, 0, 0, 2), UnitProperties.builder().attacker(true).populationCost(2).buildTime(120).attackRange(8).hasSpecialAbilities(true).build(), CustomWarriorUnit.class);
        }
    }

    @SubscribeEvent
    public void onRegisterBuildings(ModRegistrationEvents.RegisterBuildingsEvent event) {
        FactionType customFaction = FactionRegistry.getFaction(new ResourceLocation(MOD_ID, "custom_faction"));
        if (customFaction != null) {
            event.registerBuilding(new ResourceLocation(MOD_ID, "custom_barracks"), "Custom Barracks", () -> new CustomBarracksBuilding("custom_barracks", ResourceCost.Building(0, 100, 75, 0), false), customFaction, ResourceCost.Building(0, 100, 75, 0), BuildingProperties.builder().productionBuilding(true).maxHealth(200).buildTime(1200).populationProvided(0).populationRequired(1).visionRange(20).build(), CustomBarracksBuilding.class);
            event.registerBuilding(new ResourceLocation(MOD_ID, "custom_mine"), "Custom Mine", () -> new CustomMineBuilding("custom_mine", ResourceCost.Building(25, 75, 0, 0), false), customFaction, ResourceCost.Building(25, 75, 0, 0), BuildingProperties.builder().resourceBuilding(true).maxHealth(150).buildTime(800).resourceProductionRate(2.0f).requiresFlat(true).build(), CustomMineBuilding.class);
        }
    }

    @SubscribeEvent
    public void onRegisterResources(DynamicResourceRegistry.ResourceRegistrationEvent event) {
        FactionType customFaction = FactionRegistry.getFaction(new ResourceLocation(MOD_ID, "custom_faction"));
        if (customFaction != null) {
            DynamicResourceType crystalResource = event.registerResource(new DynamicResourceType(new ResourceLocation(MOD_ID, "magic_crystal"), "Magic Crystal", Items.f_42696_, customFaction, ResourceCategory.SPECIAL, DynamicResourceProperties.builder().baseValue(100).tradeable(true).renewable(false).requiresWorkers(true).visibleToEnemies(true).stackSize(16).build()));
            event.registerResource(new DynamicResourceType(new ResourceLocation(MOD_ID, "arcane_energy"), "Arcane Energy", Items.f_42612_, customFaction, ResourceCategory.ENERGY, DynamicResourceProperties.builder().baseValue(75).tradeable(false).renewable(true).requiresWorkers(false).visibleToEnemies(false).stackSize(8).build()));
        }
    }

    @SubscribeEvent
    public void onRegisterProductions(DynamicProductionRegistry.ProductionRegistrationEvent event) {
        FactionType customFaction = FactionRegistry.getFaction(new ResourceLocation(MOD_ID, "custom_faction"));
        DynamicResourceType crystalResource = DynamicResourceRegistry.getResourceType(new ResourceLocation(MOD_ID, "magic_crystal"));
        DynamicResourceType arcaneEnergy = DynamicResourceRegistry.getResourceType(new ResourceLocation(MOD_ID, "arcane_energy"));
        if (customFaction != null && crystalResource != null && arcaneEnergy != null) {
            event.registerProduction(new DynamicProductionItem(new ResourceLocation(MOD_ID, "arcane_golem"), "Arcane Golem", customFaction, ProductionType.UNIT, new ItemStack((ItemLike)Items.f_254737_, 1), Map.of(crystalResource, 5, arcaneEnergy, 100), DynamicProductionProperties.builder().productionTime(3000).queueLimit(2).requiresWorkers(true).countsTowardPopulation(true).requiresFactionTech(true).build(), List.of(new ResourceLocation(MOD_ID, "golem_mastery_research"))));
            event.registerProduction(new DynamicProductionItem(new ResourceLocation(MOD_ID, "crystal_sword"), "Crystal Sword", customFaction, ProductionType.EQUIPMENT, new ItemStack((ItemLike)Items.f_42388_, 1), Map.of(crystalResource, 3, arcaneEnergy, 50), DynamicProductionProperties.builder().productionTime(1200).queueLimit(5).requiresWorkers(true).factionEfficiencyBonus(1.3f).build(), List.of()));
            event.registerProduction(new DynamicProductionItem(new ResourceLocation(MOD_ID, "crystal_mastery"), "Crystal Mastery", customFaction, ProductionType.RESEARCH, new ItemStack((ItemLike)Items.f_42690_, 1), Map.of(crystalResource, 10, arcaneEnergy, 200), DynamicProductionProperties.builder().productionTime(6000).queueLimit(1).requiresWorkers(false).visibleToEnemies(false).requiresFactionTech(true).build(), List.of()));
        }
    }

    @SubscribeEvent
    public void onRegistrationComplete(ModRegistrationEvents.RegistrationCompleteEvent event) {
        FactionType customFaction = event.getFaction(new ResourceLocation(MOD_ID, "custom_faction"));
        FactionType villagers = event.getFaction(new ResourceLocation("reignofnether", "villagers"));
        if (customFaction != null && villagers != null) {
            System.out.println("Custom faction and villagers are now allied!");
        }
        System.out.println("Custom faction registered " + DynamicResourceRegistry.getResourcesForFaction(customFaction).size() + " resources and " + DynamicProductionRegistry.getProductionsForFaction(customFaction).size() + " productions");
    }

    private EntityType<CustomWorkerUnit> getCustomWorkerEntityType() {
        return null;
    }

    private EntityType<CustomWarriorUnit> getCustomWarriorEntityType() {
        return null;
    }

    private static abstract class CustomWorkerUnit
    extends LivingEntity
    implements Unit {
        public CustomWorkerUnit(EntityType<? extends LivingEntity> entityType, Level level) {
            super(entityType, level);
        }

        @Override
        public Faction getFaction() {
            return Faction.VILLAGERS;
        }

        @Override
        public FactionType getFactionType() {
            return FactionRegistry.getFaction(new ResourceLocation(ExampleModIntegration.MOD_ID, "custom_faction"));
        }
    }

    private static abstract class CustomWarriorUnit
    extends LivingEntity
    implements Unit {
        public CustomWarriorUnit(EntityType<? extends LivingEntity> entityType, Level level) {
            super(entityType, level);
        }

        @Override
        public Faction getFaction() {
            return Faction.VILLAGERS;
        }

        @Override
        public FactionType getFactionType() {
            return FactionRegistry.getFaction(new ResourceLocation(ExampleModIntegration.MOD_ID, "custom_faction"));
        }
    }

    private static class CustomBarracksBuilding
    extends Building {
        public CustomBarracksBuilding(String structureName, ResourceCost cost, boolean isCapitol) {
            super(structureName, cost, isCapitol);
        }

        @Override
        public AbilityButton getBuildButton(Keybinding kb) {
            return null;
        }

        @Override
        public Faction getFaction() {
            return Faction.VILLAGERS;
        }
    }

    private static class CustomMineBuilding
    extends Building {
        public CustomMineBuilding(String structureName, ResourceCost cost, boolean isCapitol) {
            super(structureName, cost, isCapitol);
        }

        @Override
        public AbilityButton getBuildButton(Keybinding kb) {
            return null;
        }

        @Override
        public Faction getFaction() {
            return Faction.VILLAGERS;
        }
    }
}

