/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.attackwarnings;

import com.solegendary.reignofnether.attackwarnings.AttackWarningClientEvents;
import com.solegendary.reignofnether.registrars.PacketHandler;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class AttackWarningClientboundPacket {
    private final String attackedPlayerName;
    private final BlockPos attackPos;

    public static void sendWarning(String attackedPlayerName, BlockPos attackPos) {
        PacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new AttackWarningClientboundPacket(attackedPlayerName, attackPos));
    }

    public AttackWarningClientboundPacket(String attackedPlayerName, BlockPos attackPos) {
        this.attackedPlayerName = attackedPlayerName;
        this.attackPos = attackPos;
    }

    public AttackWarningClientboundPacket(FriendlyByteBuf buffer) {
        this.attackedPlayerName = buffer.m_130277_();
        this.attackPos = buffer.m_130135_();
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.attackedPlayerName);
        buffer.m_130064_(this.attackPos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        AtomicBoolean success = new AtomicBoolean(false);
        ctx.get().enqueueWork(() -> {
            AttackWarningClientEvents.checkAndTriggerAttackWarning(this.attackedPlayerName, this.attackPos);
            success.set(true);
        });
        ctx.get().setPacketHandled(true);
        return success.get();
    }
}

