/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.bot;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.bot.BotDifficulty;
import com.solegendary.reignofnether.bot.command.BotCommandInterface;
import com.solegendary.reignofnether.bot.controllers.AIStrategicController;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.player.RTSPlayer;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.util.Faction;
import net.minecraft.server.level.ServerLevel;

public class AIBotPlayer {
    private final RTSPlayer rtsPlayer;
    private final BotDifficulty difficulty;
    private final AIStrategicController strategicController;
    private final BotCommandInterface commandInterface;
    private int ticksSinceLastDecision = 0;
    private int nextDecisionDelay;
    private boolean isActive = true;
    private long gameStartTime;
    private int totalDecisionsMade = 0;
    private int successfulActions = 0;
    private long totalThinkingTime = 0L;

    public AIBotPlayer(String name, Faction faction, BotDifficulty difficulty) {
        ReignOfNether.LOGGER.info("DEBUG: AIBotPlayer constructor starting for '{}'", (Object)name);
        ReignOfNether.LOGGER.info("DEBUG: Creating RTS Player...");
        this.rtsPlayer = RTSPlayer.getNewBot(name, faction);
        ReignOfNether.LOGGER.info("DEBUG: RTS Player created: {}", (Object)(this.rtsPlayer != null ? "SUCCESS" : "FAILED"));
        ReignOfNether.LOGGER.info("DEBUG: Setting difficulty...");
        this.difficulty = difficulty;
        ReignOfNether.LOGGER.info("DEBUG: Creating BotCommandInterface...");
        this.commandInterface = new BotCommandInterface(this);
        ReignOfNether.LOGGER.info("DEBUG: BotCommandInterface created: {}", (Object)(this.commandInterface != null ? "SUCCESS" : "FAILED"));
        ReignOfNether.LOGGER.info("DEBUG: Creating AIStrategicController...");
        this.strategicController = new AIStrategicController(this);
        ReignOfNether.LOGGER.info("DEBUG: AIStrategicController created: {}", (Object)(this.strategicController != null ? "SUCCESS" : "FAILED"));
        ReignOfNether.LOGGER.info("DEBUG: Setting up timing variables...");
        this.nextDecisionDelay = difficulty.getRandomReactionTime();
        this.gameStartTime = System.currentTimeMillis();
        ReignOfNether.LOGGER.info("DEBUG: AIBotPlayer constructor completed successfully for '{}'", (Object)name);
        ReignOfNether.LOGGER.info("Created AI bot '{}' with faction {} at difficulty {}", (Object)name, (Object)faction.name(), (Object)difficulty.getDisplayName());
    }

    public AIBotPlayer(RTSPlayer rtsPlayer, BotDifficulty difficulty) {
        ReignOfNether.LOGGER.info("DEBUG: AIBotPlayer wrapper constructor starting for '{}'", (Object)rtsPlayer.name);
        ReignOfNether.LOGGER.info("DEBUG: Using existing RTS Player with ID: {}", (Object)rtsPlayer.id);
        this.rtsPlayer = rtsPlayer;
        ReignOfNether.LOGGER.info("DEBUG: Setting difficulty...");
        this.difficulty = difficulty;
        ReignOfNether.LOGGER.info("DEBUG: Creating BotCommandInterface...");
        this.commandInterface = new BotCommandInterface(this);
        ReignOfNether.LOGGER.info("DEBUG: BotCommandInterface created: {}", (Object)(this.commandInterface != null ? "SUCCESS" : "FAILED"));
        ReignOfNether.LOGGER.info("DEBUG: Creating AIStrategicController...");
        this.strategicController = new AIStrategicController(this);
        ReignOfNether.LOGGER.info("DEBUG: AIStrategicController created: {}", (Object)(this.strategicController != null ? "SUCCESS" : "FAILED"));
        ReignOfNether.LOGGER.info("DEBUG: Setting up timing variables...");
        this.nextDecisionDelay = difficulty.getRandomReactionTime();
        this.gameStartTime = System.currentTimeMillis();
        ReignOfNether.LOGGER.info("DEBUG: AIBotPlayer wrapper constructor completed successfully for '{}'", (Object)rtsPlayer.name);
        ReignOfNether.LOGGER.info("Created AI bot '{}' with faction {} at difficulty {}", (Object)rtsPlayer.name, (Object)rtsPlayer.faction.name(), (Object)difficulty.getDisplayName());
    }

    public void tick(ServerLevel level) {
        if (!this.isActive) {
            return;
        }
        this.rtsPlayer.tick();
        ++this.ticksSinceLastDecision;
        if (this.ticksSinceLastDecision >= this.nextDecisionDelay) {
            this.makeDecision(level);
            this.ticksSinceLastDecision = 0;
            this.nextDecisionDelay = this.difficulty.getRandomReactionTime();
        }
        this.strategicController.tick(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeDecision(ServerLevel level) {
        long startTime = System.currentTimeMillis();
        try {
            this.strategicController.makeStrategicDecision(level);
            ++this.totalDecisionsMade;
            ++this.successfulActions;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error in AI decision making for bot '{}': {}", (Object)this.getName(), (Object)e.getMessage());
        }
        finally {
            long endTime = System.currentTimeMillis();
            this.totalThinkingTime += endTime - startTime;
        }
    }

    public RTSPlayer getRTSPlayer() {
        return this.rtsPlayer;
    }

    public String getName() {
        return this.rtsPlayer.name;
    }

    public int getId() {
        return this.rtsPlayer.id;
    }

    public Faction getFaction() {
        return this.rtsPlayer.faction;
    }

    public BotDifficulty getDifficulty() {
        return this.difficulty;
    }

    public AIStrategicController getStrategicController() {
        return this.strategicController;
    }

    public BotCommandInterface getCommandInterface() {
        return this.commandInterface;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
        if (!active) {
            ReignOfNether.LOGGER.info("AI bot '{}' has been deactivated", (Object)this.getName());
        }
    }

    public boolean isDefeated() {
        try {
            String botPlayerName = this.getName();
            boolean hasBuildings = BuildingServerEvents.getBuildings().stream().anyMatch(building -> botPlayerName.equals(building.ownerName));
            boolean hasUnits = UnitServerEvents.getAllUnits().stream().filter(unit -> unit instanceof Unit).anyMatch(unit -> botPlayerName.equals(((Unit)unit).getOwnerName()));
            Resources resources = null;
            for (Resources r : ResourcesServerEvents.resourcesList) {
                if (!r.ownerName.equals(botPlayerName)) continue;
                resources = r;
                break;
            }
            boolean hasResources = resources != null && resources.getTotalValue() > 100;
            return !hasBuildings && !hasUnits && !hasResources;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error checking if bot '{}' is defeated: {}", (Object)this.getName(), (Object)e.getMessage());
            return false;
        }
    }

    public BotStatistics getStatistics() {
        long gameTime = System.currentTimeMillis() - this.gameStartTime;
        double avgDecisionTime = this.totalDecisionsMade > 0 ? (double)this.totalThinkingTime / (double)this.totalDecisionsMade : 0.0;
        double successRate = this.totalDecisionsMade > 0 ? (double)this.successfulActions / (double)this.totalDecisionsMade : 0.0;
        return new BotStatistics(this.getName(), this.difficulty, gameTime, this.totalDecisionsMade, avgDecisionTime, successRate);
    }

    public long getGameStartTime() {
        return this.gameStartTime;
    }

    public void resetForNewGame() {
        this.ticksSinceLastDecision = 0;
        this.nextDecisionDelay = this.difficulty.getRandomReactionTime();
        this.totalDecisionsMade = 0;
        this.successfulActions = 0;
        this.totalThinkingTime = 0L;
        this.gameStartTime = System.currentTimeMillis();
        this.isActive = true;
        this.strategicController.reset();
        ReignOfNether.LOGGER.info("Reset AI bot '{}' for new game", (Object)this.getName());
    }

    public static class BotStatistics {
        public final String botName;
        public final BotDifficulty difficulty;
        public final long gameTimeMs;
        public final int totalDecisions;
        public final double avgDecisionTimeMs;
        public final double successRate;

        public BotStatistics(String botName, BotDifficulty difficulty, long gameTimeMs, int totalDecisions, double avgDecisionTimeMs, double successRate) {
            this.botName = botName;
            this.difficulty = difficulty;
            this.gameTimeMs = gameTimeMs;
            this.totalDecisions = totalDecisions;
            this.avgDecisionTimeMs = avgDecisionTimeMs;
            this.successRate = successRate;
        }

        public String toString() {
            return String.format("Bot '%s' [%s]: %d decisions in %.1fs (%.1fms avg), %.1f%% success", this.botName, this.difficulty.getDisplayName(), this.totalDecisions, (double)this.gameTimeMs / 1000.0, this.avgDecisionTimeMs, this.successRate * 100.0);
        }
    }
}

