/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.bot;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.bot.AIBotPlayer;
import com.solegendary.reignofnether.bot.BotDifficulty;
import com.solegendary.reignofnether.bot.ml.GameMetrics;
import com.solegendary.reignofnether.bot.ml.MLFramework;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.player.PlayerServerEvents;
import com.solegendary.reignofnether.player.RTSPlayer;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import com.solegendary.reignofnether.util.Faction;
import com.solegendary.reignofnether.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class BotManager {
    private static final Map<Integer, AIBotPlayer> activeBots = new ConcurrentHashMap<Integer, AIBotPlayer>();
    private static final Random random = new Random();
    private static String currentGameSessionId;
    private static boolean mlFrameworkInitialized;
    private static final String[] BOT_NAME_PREFIXES;
    private static final String[] BOT_NAME_SUFFIXES;
    private static int botCounter;

    private static Vec3 findBotSpawnLocation() {
        if (PlayerServerEvents.players.isEmpty()) {
            return null;
        }
        ServerPlayer firstPlayer = PlayerServerEvents.players.get(0);
        Vec3 playerPos = firstPlayer.m_20182_();
        ServerLevel level = firstPlayer.m_284548_();
        for (int attempt = 0; attempt < 10; ++attempt) {
            double z;
            double angle = Math.random() * 2.0 * Math.PI;
            double distance = 100.0 + Math.random() * 200.0;
            double x = playerPos.f_82479_ + Math.cos(angle) * distance;
            BlockPos testPos = new BlockPos((int)x, 64, (int)(z = playerPos.f_82481_ + Math.sin(angle) * distance));
            if (!BotManager.isGoodBotSpawnLocation(level, testPos)) continue;
            Vec3 spawnPos = new Vec3(x, 64.0, z);
            ReignOfNether.LOGGER.info("DEBUG: Found suitable bot spawn position: {} (Player at: {}, Distance: {:.1f}, Angle: {:.1f}\u00b0, Attempt: {})", (Object)spawnPos, (Object)playerPos, (Object)distance, (Object)Math.toDegrees(angle), (Object)(attempt + 1));
            return spawnPos;
        }
        double angle = Math.random() * 2.0 * Math.PI;
        double distance = 150.0 + Math.random() * 100.0;
        double x = playerPos.f_82479_ + Math.cos(angle) * distance;
        double z = playerPos.f_82481_ + Math.sin(angle) * distance;
        Vec3 fallbackPos = new Vec3(x, 64.0, z);
        ReignOfNether.LOGGER.warn("DEBUG: Using fallback bot spawn position (no ideal location found): {} (Player at: {})", (Object)fallbackPos, (Object)playerPos);
        return fallbackPos;
    }

    private static boolean isGoodBotSpawnLocation(ServerLevel level, BlockPos centerPos) {
        try {
            boolean isGoodLocation;
            int radius = 7;
            int waterBlocks = 0;
            int lavaBlocks = 0;
            int treeBlocks = 0;
            int validGroundBlocks = 0;
            int totalBlocks = 0;
            BlockPos groundCenter = MiscUtil.getHighestNonAirBlock((Level)level, centerPos);
            int baseHeight = groundCenter.m_123342_();
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos checkPos = centerPos.m_7918_(x, 0, z);
                    BlockPos groundPos = MiscUtil.getHighestNonAirBlock((Level)level, checkPos);
                    ++totalBlocks;
                    int heightDiff = Math.abs(groundPos.m_123342_() - baseHeight);
                    if (heightDiff > 4) continue;
                    BlockState groundState = level.m_8055_(groundPos);
                    BlockState aboveState = level.m_8055_(groundPos.m_7494_());
                    Block groundBlock = groundState.m_60734_();
                    if (groundBlock instanceof LiquidBlock) {
                        if (groundBlock instanceof LiquidBlock && groundState.m_60819_().m_76152_() == Fluids.f_76193_) {
                            ++waterBlocks;
                            continue;
                        }
                        if (!(groundBlock instanceof LiquidBlock) || groundState.m_60819_().m_76152_() != Fluids.f_76195_) continue;
                        ++lavaBlocks;
                        continue;
                    }
                    if (groundBlock == Blocks.f_49990_ || groundState.m_60819_().m_76152_() == Fluids.f_76193_) {
                        ++waterBlocks;
                        continue;
                    }
                    if (groundBlock == Blocks.f_49991_ || groundState.m_60819_().m_76152_() == Fluids.f_76195_) {
                        ++lavaBlocks;
                        continue;
                    }
                    Block aboveBlock = aboveState.m_60734_();
                    Block above2Block = level.m_8055_(groundPos.m_6630_(2)).m_60734_();
                    Block above3Block = level.m_8055_(groundPos.m_6630_(3)).m_60734_();
                    if (BotManager.isWoodBlock(aboveBlock) || BotManager.isWoodBlock(above2Block) || BotManager.isWoodBlock(above3Block)) {
                        ++treeBlocks;
                        continue;
                    }
                    if (!groundState.m_60804_((BlockGetter)level, groundPos) || !groundState.m_60819_().m_76178_() || !aboveState.m_60795_()) continue;
                    ++validGroundBlocks;
                }
            }
            double validGroundPercentage = (double)validGroundBlocks / (double)totalBlocks;
            double waterPercentage = (double)waterBlocks / (double)totalBlocks;
            double lavaPercentage = (double)lavaBlocks / (double)totalBlocks;
            double treePercentage = (double)treeBlocks / (double)totalBlocks;
            boolean bl = isGoodLocation = validGroundPercentage >= 0.6 && waterPercentage <= 0.2 && lavaPercentage <= 0.05 && treePercentage <= 0.3;
            if (isGoodLocation) {
                ReignOfNether.LOGGER.debug("DEBUG: Spawn location {} SUITABLE - Ground: {:.1f}%, Water: {:.1f}%, Lava: {:.1f}%, Trees: {:.1f}%", (Object)centerPos, (Object)(validGroundPercentage * 100.0), (Object)(waterPercentage * 100.0), (Object)(lavaPercentage * 100.0), (Object)(treePercentage * 100.0));
            } else {
                ReignOfNether.LOGGER.debug("DEBUG: Spawn location {} NOT SUITABLE - Ground: {:.1f}%, Water: {:.1f}%, Lava: {:.1f}%, Trees: {:.1f}%", (Object)centerPos, (Object)(validGroundPercentage * 100.0), (Object)(waterPercentage * 100.0), (Object)(lavaPercentage * 100.0), (Object)(treePercentage * 100.0));
            }
            return isGoodLocation;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error checking spawn location suitability: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static boolean isWoodBlock(Block block) {
        return block == Blocks.f_49999_ || block == Blocks.f_50001_ || block == Blocks.f_50000_ || block == Blocks.f_50002_ || block == Blocks.f_50003_ || block == Blocks.f_50004_ || block == Blocks.f_220832_ || block == Blocks.f_271170_ || block == Blocks.f_50010_ || block == Blocks.f_50006_ || block == Blocks.f_50005_ || block == Blocks.f_50007_ || block == Blocks.f_50008_ || block == Blocks.f_50009_ || block == Blocks.f_220835_ || block == Blocks.f_271326_ || block == Blocks.f_50011_ || block == Blocks.f_50013_ || block == Blocks.f_50012_ || block == Blocks.f_50014_ || block == Blocks.f_50015_ || block == Blocks.f_50043_ || block == Blocks.f_220836_ || block == Blocks.f_271348_;
    }

    private static void initializeMLFramework() {
        if (!mlFrameworkInitialized) {
            try {
                MLFramework.getInstance().initialize();
                mlFrameworkInitialized = true;
                ReignOfNether.LOGGER.info("ML Framework initialized for AI bot system");
            }
            catch (Exception e) {
                ReignOfNether.LOGGER.error("Failed to initialize ML Framework: {}", (Object)e.getMessage());
                ReignOfNether.LOGGER.info("Continuing with rule-based AI only (ML features disabled)");
                mlFrameworkInitialized = false;
            }
        }
    }

    public static AIBotPlayer createBot(String name, Faction faction, BotDifficulty difficulty) {
        ReignOfNether.LOGGER.info("DEBUG: Starting bot creation for '{}' with faction {} and difficulty {}", (Object)name, (Object)faction, (Object)difficulty);
        ReignOfNether.LOGGER.info("DEBUG: Skipping ML framework initialization during bot creation to prevent hanging");
        ReignOfNether.LOGGER.info("DEBUG: Finding spawn location for bot...");
        Vec3 spawnPos = BotManager.findBotSpawnLocation();
        if (spawnPos == null) {
            ReignOfNether.LOGGER.error("Failed to find spawn location for bot '{}' - no players in game", (Object)name);
            return null;
        }
        ReignOfNether.LOGGER.info("DEBUG: Spawning bot '{}' in world at position {}", (Object)name, (Object)spawnPos);
        int rtsPlayersSizeBefore = PlayerServerEvents.rtsPlayers.size();
        PlayerServerEvents.startRTSBot(name, spawnPos, faction);
        int rtsPlayersSizeAfter = PlayerServerEvents.rtsPlayers.size();
        ReignOfNether.LOGGER.info("DEBUG: startRTSBot completed. RTS players count: {} -> {}", (Object)rtsPlayersSizeBefore, (Object)rtsPlayersSizeAfter);
        ReignOfNether.LOGGER.info("DEBUG: Finding RTSPlayer created by startRTSBot...");
        RTSPlayer rtsPlayer = null;
        for (RTSPlayer player : PlayerServerEvents.rtsPlayers) {
            if (!player.name.equals(name) || !player.isBot()) continue;
            rtsPlayer = player;
            break;
        }
        if (rtsPlayer == null) {
            ReignOfNether.LOGGER.error("Failed to find RTSPlayer created by startRTSBot for bot '{}'", (Object)name);
            return null;
        }
        ReignOfNether.LOGGER.info("DEBUG: Found RTSPlayer with ID: {} for bot '{}'", (Object)rtsPlayer.id, (Object)name);
        ReignOfNether.LOGGER.info("DEBUG: Creating AIBotPlayer wrapper...");
        AIBotPlayer bot = new AIBotPlayer(rtsPlayer, difficulty);
        ReignOfNether.LOGGER.info("DEBUG: AIBotPlayer created successfully with ID: {}", (Object)bot.getId());
        ReignOfNether.LOGGER.info("DEBUG: Adding bot to active bots map...");
        activeBots.put(bot.getId(), bot);
        ReignOfNether.LOGGER.info("DEBUG: Bot added to active bots. Total active bots: {}", (Object)activeBots.size());
        ReignOfNether.LOGGER.info("Created AI bot: {}", (Object)bot.getStatistics().toString());
        return bot;
    }

    public static AIBotPlayer createBot(Faction faction, BotDifficulty difficulty) {
        String name = BotManager.generateBotName();
        return BotManager.createBot(name, faction, difficulty);
    }

    public static List<AIBotPlayer> createBots(int count, BotDifficulty difficulty) {
        ArrayList<AIBotPlayer> bots = new ArrayList<AIBotPlayer>();
        Faction[] factions = Faction.values();
        for (int i = 0; i < count; ++i) {
            Faction faction = factions[i % (factions.length - 1)];
            if (faction == Faction.NONE) {
                faction = factions[(i + 1) % (factions.length - 1)];
            }
            AIBotPlayer bot = BotManager.createBot(faction, difficulty);
            bots.add(bot);
        }
        ReignOfNether.LOGGER.info("Created {} AI bots at {} difficulty", (Object)count, (Object)difficulty.getDisplayName());
        return bots;
    }

    private static String generateBotName() {
        String prefix = BOT_NAME_PREFIXES[random.nextInt(BOT_NAME_PREFIXES.length)];
        String suffix = BOT_NAME_SUFFIXES[random.nextInt(BOT_NAME_SUFFIXES.length)];
        ++botCounter;
        String name = prefix + " " + suffix;
        if (BotManager.getBotByName(name) != null) {
            name = name + " " + botCounter % 100;
        }
        return name;
    }

    public static AIBotPlayer getBot(int botId) {
        return activeBots.get(botId);
    }

    public static AIBotPlayer getBotByName(String name) {
        return activeBots.values().stream().filter(bot -> bot.getName().equals(name)).findFirst().orElse(null);
    }

    public static Collection<AIBotPlayer> getAllBots() {
        return new ArrayList<AIBotPlayer>(activeBots.values());
    }

    public static List<AIBotPlayer> getBotsByFaction(Faction faction) {
        return activeBots.values().stream().filter(bot -> bot.getFaction() == faction).toList();
    }

    public static int getActiveBotCount() {
        return (int)activeBots.values().stream().filter(AIBotPlayer::isActive).count();
    }

    public static void tickAllBots(ServerLevel level) {
        ArrayList<AIBotPlayer> botsToRemove = new ArrayList<AIBotPlayer>();
        for (AIBotPlayer bot : activeBots.values()) {
            if (!bot.isActive()) continue;
            try {
                bot.tick(level);
                if (!bot.isDefeated()) continue;
                bot.setActive(false);
                botsToRemove.add(bot);
            }
            catch (Exception e) {
                ReignOfNether.LOGGER.error("Error ticking bot '{}': {}", (Object)bot.getName(), (Object)e.getMessage());
                bot.setActive(false);
                botsToRemove.add(bot);
            }
        }
        for (AIBotPlayer bot : botsToRemove) {
            BotManager.removeBot(bot.getId());
        }
    }

    public static void removeBot(int botId) {
        AIBotPlayer bot = activeBots.remove(botId);
        if (bot != null) {
            PlayerServerEvents.rtsPlayers.removeIf(player -> player.id == botId);
            ReignOfNether.LOGGER.info("Removed AI bot '{}' from game. Final stats: {}", (Object)bot.getName(), (Object)bot.getStatistics().toString());
        }
    }

    public static void removeAllBots() {
        ArrayList<Integer> botIds = new ArrayList<Integer>(activeBots.keySet());
        Iterator iterator = botIds.iterator();
        while (iterator.hasNext()) {
            int botId = (Integer)iterator.next();
            BotManager.removeBot(botId);
        }
        ReignOfNether.LOGGER.info("Removed all AI bots from game");
    }

    public static void resetAllBots() {
        for (AIBotPlayer bot : activeBots.values()) {
            bot.resetForNewGame();
        }
        ReignOfNether.LOGGER.info("Reset {} AI bots for new game", (Object)activeBots.size());
    }

    public static List<AIBotPlayer.BotStatistics> getAllBotStatistics() {
        return activeBots.values().stream().map(AIBotPlayer::getStatistics).toList();
    }

    public static void logAllBotStatistics() {
        ReignOfNether.LOGGER.info("=== AI Bot Performance Statistics ===");
        for (AIBotPlayer bot : activeBots.values()) {
            ReignOfNether.LOGGER.info(bot.getStatistics().toString());
        }
        ReignOfNether.LOGGER.info("=== End Bot Statistics ===");
    }

    public static boolean hasAnyBots() {
        return !activeBots.isEmpty();
    }

    public static boolean hasActiveBots() {
        return activeBots.values().stream().anyMatch(AIBotPlayer::isActive);
    }

    public static void startMLGameSession(String sessionId, List<String> playerNames, String gameMode) {
        BotManager.initializeMLFramework();
        currentGameSessionId = sessionId;
        List<String> botNames = activeBots.values().stream().map(AIBotPlayer::getName).toList();
        if (mlFrameworkInitialized) {
            MLFramework.getInstance().startGameSession(sessionId, playerNames, botNames, gameMode, new HashMap<String, String>());
        }
        for (AIBotPlayer bot : activeBots.values()) {
            bot.getStrategicController().startGameSession(sessionId, playerNames, botNames, gameMode);
        }
        ReignOfNether.LOGGER.info("Started ML game session '{}' with {} bots and {} players", (Object)sessionId, (Object)botNames.size(), (Object)playerNames.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void endMLGameSession(Map<String, Boolean> results, String endReason) {
        if (currentGameSessionId == null) {
            return;
        }
        try {
            GameMetrics gameMetrics = BotManager.calculateGameMetrics();
            if (mlFrameworkInitialized) {
                MLFramework.getInstance().endGameSession(currentGameSessionId, results, gameMetrics, endReason);
                for (Map.Entry entry : results.entrySet()) {
                    String playerName = (String)entry.getKey();
                    boolean playerWon = (Boolean)entry.getValue();
                    if (BotManager.getBotByName(playerName) != null) continue;
                    for (AIBotPlayer bot : activeBots.values()) {
                        if (!results.containsKey(bot.getName())) continue;
                        boolean botWon = results.get(bot.getName());
                        MLFramework.getInstance().recordGameOutcome(playerName, bot.getName(), playerWon, gameMetrics);
                    }
                }
            }
            for (AIBotPlayer aIBotPlayer : activeBots.values()) {
                Boolean botResult = results.get(aIBotPlayer.getName());
                boolean wonGame = botResult != null && botResult != false;
                aIBotPlayer.getStrategicController().endGameSession(wonGame, gameMetrics, endReason);
            }
            ReignOfNether.LOGGER.info("Ended ML game session '{}': {}", (Object)currentGameSessionId, (Object)endReason);
        }
        finally {
            currentGameSessionId = null;
        }
    }

    private static GameMetrics calculateGameMetrics() {
        long gameDuration = 600000L;
        int totalScore = 0;
        double avgSuccessRate = 0.0;
        double avgDecisionTime = 0.0;
        int botCount = activeBots.size();
        if (botCount > 0) {
            for (AIBotPlayer bot : activeBots.values()) {
                AIBotPlayer.BotStatistics stats = bot.getStatistics();
                totalScore += stats.totalDecisions;
                avgSuccessRate += stats.successRate;
                avgDecisionTime += stats.avgDecisionTimeMs;
                gameDuration = Math.max(gameDuration, stats.gameTimeMs);
            }
            avgSuccessRate /= (double)botCount;
            avgDecisionTime /= (double)botCount;
        }
        double economicEfficiency = avgSuccessRate * (1.0 - Math.min(avgDecisionTime / 10000.0, 0.5));
        double militaryEfficiency = avgSuccessRate * 0.8;
        int totalUnitsProduced = 0;
        int totalBuildingsConstructed = 0;
        int totalResourcesGathered = 0;
        int totalEnemyKills = 0;
        int totalLosses = 0;
        for (AIBotPlayer bot : activeBots.values()) {
            String botName = bot.getName();
            totalUnitsProduced += BotManager.calculateTotalUnitsProduced(botName);
            totalBuildingsConstructed += BotManager.calculateTotalBuildingsConstructed(botName);
            totalResourcesGathered += BotManager.calculateTotalResourcesGathered(botName);
            totalEnemyKills += BotManager.calculateTotalEnemyKills(botName, avgSuccessRate);
            totalLosses += BotManager.calculateTotalLosses(botName);
        }
        return new GameMetrics(gameDuration, totalScore, economicEfficiency, militaryEfficiency, totalUnitsProduced, totalBuildingsConstructed, totalResourcesGathered, totalEnemyKills, totalLosses);
    }

    public static Map<BotDifficulty, Integer> getDifficultyDistribution() {
        EnumMap<BotDifficulty, Integer> distribution = new EnumMap<BotDifficulty, Integer>(BotDifficulty.class);
        for (BotDifficulty difficulty : BotDifficulty.values()) {
            distribution.put(difficulty, 0);
        }
        for (AIBotPlayer bot : activeBots.values()) {
            BotDifficulty difficulty = bot.getDifficulty();
            distribution.put(difficulty, (Integer)distribution.get((Object)difficulty) + 1);
        }
        return distribution;
    }

    private static int calculateTotalUnitsProduced(String botName) {
        try {
            long currentUnits = UnitServerEvents.getAllUnits().stream().filter(unit -> unit instanceof Unit).filter(unit -> botName.equals(((Unit)unit).getOwnerName())).count();
            return (int)((double)currentUnits * 2.5);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error calculating units produced for bot '{}': {}", (Object)botName, (Object)e.getMessage());
            return 15;
        }
    }

    private static int calculateTotalBuildingsConstructed(String botName) {
        try {
            long currentBuildings = BuildingServerEvents.getBuildings().stream().filter(building -> botName.equals(building.ownerName)).count();
            return (int)((double)currentBuildings * 1.3);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error calculating buildings constructed for bot '{}': {}", (Object)botName, (Object)e.getMessage());
            return 8;
        }
    }

    private static int calculateTotalResourcesGathered(String botName) {
        try {
            for (Resources resources : ResourcesServerEvents.resourcesList) {
                if (!resources.ownerName.equals(botName)) continue;
                int currentTotal = resources.getTotalValue();
                return currentTotal * 4;
            }
            return 2000;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error calculating resources gathered for bot '{}': {}", (Object)botName, (Object)e.getMessage());
            return 2000;
        }
    }

    private static int calculateTotalEnemyKills(String botName, double avgSuccessRate) {
        try {
            long militaryUnits = UnitServerEvents.getAllUnits().stream().filter(unit -> unit instanceof Unit).filter(unit -> botName.equals(((Unit)unit).getOwnerName())).filter(unit -> !(unit instanceof WorkerUnit)).count();
            return (int)((double)militaryUnits * avgSuccessRate * 2.5);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error calculating enemy kills for bot '{}': {}", (Object)botName, (Object)e.getMessage());
            return 5;
        }
    }

    private static int calculateTotalLosses(String botName) {
        try {
            long currentUnits = UnitServerEvents.getAllUnits().stream().filter(unit -> unit instanceof Unit).filter(unit -> botName.equals(((Unit)unit).getOwnerName())).count();
            return (int)((double)currentUnits * 0.8);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error calculating losses for bot '{}': {}", (Object)botName, (Object)e.getMessage());
            return 3;
        }
    }

    static {
        mlFrameworkInitialized = false;
        BOT_NAME_PREFIXES = new String[]{"Commander", "General", "Admiral", "Captain", "Major", "Colonel", "Chief", "Master", "Elite", "Prime", "Alpha", "Omega"};
        BOT_NAME_SUFFIXES = new String[]{"Striker", "Hunter", "Guardian", "Defender", "Crusher", "Destroyer", "Builder", "Tactician", "Strategist", "Warrior", "Sentinel", "Vanguard"};
        botCounter = 0;
    }
}

