/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.bot;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.bot.BotManager;
import com.solegendary.reignofnether.gamemode.GameMode;
import com.solegendary.reignofnether.gamemode.GameModeServerEvents;
import net.minecraft.server.level.ServerLevel;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="reignofnether", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BotServerEvents {
    private static boolean botsInitialized = false;
    private static int tickCounter = 0;
    private static final int BOT_TICK_INTERVAL = 5;

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        if (!botsInitialized) {
            ReignOfNether.LOGGER.info("Initializing AI bot system...");
            botsInitialized = true;
            ReignOfNether.LOGGER.info("AI bot system initialized successfully");
        }
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        if (botsInitialized) {
            ReignOfNether.LOGGER.info("Shutting down AI bot system...");
            BotManager.logAllBotStatistics();
            BotManager.removeAllBots();
            botsInitialized = false;
            tickCounter = 0;
            ReignOfNether.LOGGER.info("AI bot system shut down successfully");
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || !botsInitialized) {
            return;
        }
        if (++tickCounter % 5 == 0) {
            BotServerEvents.tickBots(event.getServer().m_129880_(ServerLevel.f_46428_));
        }
        if (tickCounter % 600 == 0) {
            BotServerEvents.performPeriodicMaintenance();
        }
    }

    private static void tickBots(ServerLevel level) {
        if (level == null || !BotManager.hasActiveBots()) {
            return;
        }
        try {
            GameMode currentMode = GameModeServerEvents.getGameMode();
            if (currentMode == GameMode.CLASSIC) {
                BotManager.tickAllBots(level);
            }
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error ticking AI bots: {}", (Object)e.getMessage());
        }
    }

    private static void performPeriodicMaintenance() {
        try {
            int activeBots = BotManager.getActiveBotCount();
            if (activeBots > 0) {
                ReignOfNether.LOGGER.debug("AI Bot Status: {} active bots", (Object)activeBots);
                if (tickCounter % 6000 == 0) {
                    BotManager.logAllBotStatistics();
                }
            }
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error in bot maintenance: {}", (Object)e.getMessage());
        }
    }

    public static boolean isInitialized() {
        return botsInitialized;
    }

    public static int getTickCounter() {
        return tickCounter;
    }

    public static void resetTickCounter() {
        tickCounter = 0;
    }
}

