/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.bot.controllers;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.bot.AIBotPlayer;
import com.solegendary.reignofnether.bot.controllers.managers.BaseManager;
import com.solegendary.reignofnether.bot.controllers.managers.EconomicManager;
import com.solegendary.reignofnether.bot.controllers.managers.MilitaryManager;
import com.solegendary.reignofnether.bot.controllers.managers.TechnologyManager;
import com.solegendary.reignofnether.bot.ml.ActionType;
import com.solegendary.reignofnether.bot.ml.GameMetrics;
import com.solegendary.reignofnether.bot.ml.GameState;
import com.solegendary.reignofnether.bot.ml.GameStateExtractor;
import com.solegendary.reignofnether.bot.ml.MLDecision;
import com.solegendary.reignofnether.bot.ml.MLFramework;
import com.solegendary.reignofnether.bot.ml.PlayerAction;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerLevel;

public class AIStrategicController {
    private final AIBotPlayer botPlayer;
    private final EconomicManager economicManager;
    private final MilitaryManager militaryManager;
    private final BaseManager baseManager;
    private final TechnologyManager technologyManager;
    private GamePhase currentPhase = GamePhase.EARLY_GAME;
    private StrategicPriority primaryPriority = StrategicPriority.ECONOMY;
    private int ticksSincePhaseChange = 0;
    private int ticksSincePriorityChange = 0;
    private final int PRIORITY_CHANGE_COOLDOWN = 600;
    private String currentGameSessionId;
    private MLDecision lastMLDecision;
    private long lastDecisionTime = 0L;
    private int decisionsThisSession = 0;
    private final ArrayList<MLDecision> recentDecisions = new ArrayList();

    public AIStrategicController(AIBotPlayer botPlayer) {
        ReignOfNether.LOGGER.info("DEBUG: AIStrategicController constructor starting for bot '{}'", (Object)botPlayer.getName());
        this.botPlayer = botPlayer;
        ReignOfNether.LOGGER.info("DEBUG: Creating EconomicManager...");
        this.economicManager = new EconomicManager(this);
        ReignOfNether.LOGGER.info("DEBUG: Creating MilitaryManager...");
        this.militaryManager = new MilitaryManager(this);
        ReignOfNether.LOGGER.info("DEBUG: Creating BaseManager...");
        this.baseManager = new BaseManager(this);
        ReignOfNether.LOGGER.info("DEBUG: Creating TechnologyManager...");
        this.technologyManager = new TechnologyManager(this);
        ReignOfNether.LOGGER.info("DEBUG: AIStrategicController constructor completed for bot '{}'", (Object)botPlayer.getName());
        ReignOfNether.LOGGER.debug("Initialized AI strategic controller for bot '{}'", (Object)botPlayer.getName());
    }

    public void tick(ServerLevel level) {
        this.updateGamePhase(level);
        this.updateStrategicPriority(level);
        this.economicManager.tick(level);
        this.militaryManager.tick(level);
        this.baseManager.tick(level);
        this.technologyManager.tick(level);
        ++this.ticksSincePhaseChange;
        ++this.ticksSincePriorityChange;
    }

    public void makeStrategicDecision(ServerLevel level) {
        try {
            GameState gameState = this.analyzeGameState(level);
            MLDecision mlDecision = this.getMLDecision(gameState);
            if (mlDecision != null && mlDecision.isTrusted(0.6)) {
                this.executeMLDecision(mlDecision, gameState, level);
                this.lastMLDecision = mlDecision;
            } else {
                this.makeRuleBasedDecision(level);
                this.lastMLDecision = null;
            }
            this.lastDecisionTime = System.currentTimeMillis();
            ++this.decisionsThisSession;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error in strategic decision making for bot '{}': {}", (Object)this.getBotPlayer().getName(), (Object)e.getMessage());
        }
    }

    private void makeRuleBasedDecision(ServerLevel level) {
        switch (this.primaryPriority) {
            case ECONOMY: {
                this.economicManager.makeEconomicDecision(level);
                break;
            }
            case MILITARY: {
                this.militaryManager.makeMilitaryDecision(level);
                break;
            }
            case EXPANSION: {
                this.baseManager.makeExpansionDecision(level);
                break;
            }
            case TECHNOLOGY: {
                this.technologyManager.makeTechnologyDecision(level);
                break;
            }
            case DEFENSE: {
                this.militaryManager.makeDefensiveDecision(level);
                this.baseManager.makeDefenseDecision(level);
            }
        }
    }

    private MLDecision getMLDecision(GameState gameState) {
        try {
            MLFramework framework = MLFramework.getInstance();
            if (framework.isReady()) {
                return framework.getStrategicDecision(gameState, this.botPlayer.getName());
            }
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.debug("Error getting ML decision for bot '{}': {}", (Object)this.botPlayer.getName(), (Object)e.getMessage());
        }
        return null;
    }

    private void executeMLDecision(MLDecision decision, GameState gameState, ServerLevel level) {
        ReignOfNether.LOGGER.debug("Bot '{}' executing ML decision: {} (confidence: {:.2f})", (Object)this.botPlayer.getName(), (Object)decision.getDecisionType(), (Object)decision.getConfidence());
        if (this.currentGameSessionId != null) {
            MLFramework.getInstance().recordBotDecision(this.currentGameSessionId, this.botPlayer.getName(), gameState, decision, 1.0, "ML decision executed");
        }
        this.recentDecisions.add(decision);
        if (this.recentDecisions.size() > 10) {
            this.recentDecisions.remove(0);
        }
        switch (decision.getDecisionType()) {
            case FOCUS_ON_ECONOMY: {
                this.setPriorityWithCooldown(StrategicPriority.ECONOMY);
                this.economicManager.makeEconomicDecision(level);
                break;
            }
            case FOCUS_ON_MILITARY: {
                this.setPriorityWithCooldown(StrategicPriority.MILITARY);
                this.militaryManager.makeMilitaryDecision(level);
                break;
            }
            case PRODUCE_WORKERS: {
                this.economicManager.makeEconomicDecision(level);
                break;
            }
            case PRODUCE_MILITARY_UNITS: {
                this.militaryManager.makeMilitaryDecision(level);
                break;
            }
            case BUILD_ECONOMIC_BUILDINGS: {
                this.setPriorityWithCooldown(StrategicPriority.ECONOMY);
                this.economicManager.makeEconomicDecision(level);
                break;
            }
            case BUILD_MILITARY_BUILDINGS: {
                this.setPriorityWithCooldown(StrategicPriority.MILITARY);
                this.militaryManager.makeMilitaryDecision(level);
                break;
            }
            case ATTACK_ENEMY: {
                this.setPriorityWithCooldown(StrategicPriority.MILITARY);
                this.militaryManager.makeMilitaryDecision(level);
                break;
            }
            case DEFEND_BASE: {
                this.setPriorityWithCooldown(StrategicPriority.DEFENSE);
                this.militaryManager.makeDefensiveDecision(level);
                this.baseManager.makeDefenseDecision(level);
                break;
            }
            case EXPAND_TERRITORY: {
                this.setPriorityWithCooldown(StrategicPriority.EXPANSION);
                this.baseManager.makeExpansionDecision(level);
                break;
            }
            case RESEARCH_TECHNOLOGY: {
                this.setPriorityWithCooldown(StrategicPriority.TECHNOLOGY);
                this.technologyManager.makeTechnologyDecision(level);
                break;
            }
            default: {
                this.makeRuleBasedDecision(level);
            }
        }
    }

    private PlayerAction convertMLDecisionToPlayerAction(MLDecision decision) {
        ActionType actionType = switch (decision.getDecisionType()) {
            case MLDecision.DecisionType.FOCUS_ON_ECONOMY, MLDecision.DecisionType.PRODUCE_WORKERS, MLDecision.DecisionType.BUILD_ECONOMIC_BUILDINGS -> ActionType.GATHER_RESOURCES;
            case MLDecision.DecisionType.FOCUS_ON_MILITARY, MLDecision.DecisionType.PRODUCE_MILITARY_UNITS -> ActionType.PRODUCE_MILITARY;
            case MLDecision.DecisionType.BUILD_MILITARY_BUILDINGS -> ActionType.BUILD_MILITARY;
            case MLDecision.DecisionType.ATTACK_ENEMY -> ActionType.ATTACK;
            case MLDecision.DecisionType.DEFEND_BASE -> ActionType.DEFEND;
            case MLDecision.DecisionType.EXPAND_TERRITORY -> ActionType.EXPAND;
            case MLDecision.DecisionType.RESEARCH_TECHNOLOGY -> ActionType.RESEARCH;
            default -> ActionType.NONE;
        };
        return new PlayerAction(actionType, decision.getParameters(), null, this.botPlayer.getName());
    }

    private ActionType convertMLDecisionToActionType(MLDecision decision) {
        return switch (decision.getDecisionType()) {
            case MLDecision.DecisionType.FOCUS_ON_ECONOMY -> ActionType.ECONOMIC_DECISION;
            case MLDecision.DecisionType.FOCUS_ON_MILITARY -> ActionType.MILITARY_DECISION;
            case MLDecision.DecisionType.PRODUCE_WORKERS -> ActionType.PRODUCE_WORKERS;
            case MLDecision.DecisionType.PRODUCE_MILITARY_UNITS -> ActionType.PRODUCE_MILITARY;
            case MLDecision.DecisionType.BUILD_ECONOMIC_BUILDINGS -> ActionType.BUILD_ECONOMIC;
            case MLDecision.DecisionType.BUILD_MILITARY_BUILDINGS -> ActionType.BUILD_MILITARY;
            case MLDecision.DecisionType.ATTACK_ENEMY -> ActionType.ATTACK;
            case MLDecision.DecisionType.DEFEND_BASE -> ActionType.DEFEND;
            case MLDecision.DecisionType.EXPAND_TERRITORY -> ActionType.EXPAND;
            case MLDecision.DecisionType.RESEARCH_TECHNOLOGY -> ActionType.RESEARCH;
            default -> ActionType.STRATEGIC_DECISION;
        };
    }

    private GameState analyzeGameState(ServerLevel level) {
        try {
            GameState gameState = GameStateExtractor.extractGameState(this.botPlayer.getName(), level);
            gameState.gamePhase = this.convertToMLGamePhase(this.currentPhase);
            gameState.currentPriority = this.convertToMLPriority(this.primaryPriority);
            gameState.isInCombat = this.militaryManager.isUnderAttack();
            gameState.isUnderAttack = this.militaryManager.isUnderAttack();
            gameState.threatLevel = gameState.isUnderAttack ? 0.8 : 0.2;
            gameState.economicPreference = this.primaryPriority == StrategicPriority.ECONOMY ? 0.8 : 0.4;
            gameState.militaryPreference = this.primaryPriority == StrategicPriority.MILITARY ? 0.8 : 0.4;
            gameState.expansionPreference = this.primaryPriority == StrategicPriority.EXPANSION ? 0.8 : 0.4;
            double d = gameState.technologyPreference = this.primaryPriority == StrategicPriority.TECHNOLOGY ? 0.8 : 0.4;
            if (!this.recentDecisions.isEmpty()) {
                gameState.recentActions = new ArrayList<ActionType>();
                for (MLDecision decision : this.recentDecisions) {
                    ActionType actionType = this.convertMLDecisionToActionType(decision);
                    gameState.recentActions.add(actionType);
                }
            }
            return gameState;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error analyzing game state for bot '{}': {}", (Object)this.botPlayer.getName(), (Object)e.getMessage());
            return new GameState();
        }
    }

    private Resources getBotResources() {
        String botName = this.botPlayer.getName();
        for (Resources resources : ResourcesServerEvents.resourcesList) {
            if (!resources.ownerName.equals(botName)) continue;
            return resources;
        }
        return null;
    }

    private com.solegendary.reignofnether.bot.ml.GamePhase convertToMLGamePhase(GamePhase phase) {
        return switch (phase) {
            default -> throw new IncompatibleClassChangeError();
            case GamePhase.EARLY_GAME -> com.solegendary.reignofnether.bot.ml.GamePhase.EARLY_GAME;
            case GamePhase.MID_GAME -> com.solegendary.reignofnether.bot.ml.GamePhase.MID_GAME;
            case GamePhase.LATE_GAME -> com.solegendary.reignofnether.bot.ml.GamePhase.LATE_GAME;
        };
    }

    private com.solegendary.reignofnether.bot.ml.StrategicPriority convertToMLPriority(StrategicPriority priority) {
        return switch (priority) {
            default -> throw new IncompatibleClassChangeError();
            case StrategicPriority.ECONOMY -> com.solegendary.reignofnether.bot.ml.StrategicPriority.ECONOMY;
            case StrategicPriority.MILITARY -> com.solegendary.reignofnether.bot.ml.StrategicPriority.MILITARY;
            case StrategicPriority.EXPANSION -> com.solegendary.reignofnether.bot.ml.StrategicPriority.EXPANSION;
            case StrategicPriority.TECHNOLOGY -> com.solegendary.reignofnether.bot.ml.StrategicPriority.TECHNOLOGY;
            case StrategicPriority.DEFENSE -> com.solegendary.reignofnether.bot.ml.StrategicPriority.DEFENSE;
        };
    }

    private void updateGamePhase(ServerLevel level) {
        long botLifetime = System.currentTimeMillis() - this.botPlayer.getGameStartTime();
        GamePhase newPhase = this.currentPhase;
        newPhase = botLifetime < 300000L ? GamePhase.EARLY_GAME : (botLifetime < 900000L ? GamePhase.MID_GAME : GamePhase.LATE_GAME);
        if (newPhase != this.currentPhase) {
            this.currentPhase = newPhase;
            this.ticksSincePhaseChange = 0;
            ReignOfNether.LOGGER.debug("Bot '{}' entered {} phase", (Object)this.getBotPlayer().getName(), (Object)newPhase);
        }
    }

    private void updateStrategicPriority(ServerLevel level) {
        if (this.ticksSincePriorityChange < 600) {
            return;
        }
        StrategicPriority newPriority = this.primaryPriority;
        switch (this.currentPhase) {
            case EARLY_GAME: {
                if (this.ticksSincePhaseChange < 400) {
                    newPriority = StrategicPriority.ECONOMY;
                    break;
                }
                newPriority = Math.random() < 0.8 ? StrategicPriority.ECONOMY : StrategicPriority.MILITARY;
                break;
            }
            case MID_GAME: {
                double rand = Math.random();
                if (rand < 0.4) {
                    newPriority = StrategicPriority.ECONOMY;
                    break;
                }
                if (rand < 0.7) {
                    newPriority = StrategicPriority.MILITARY;
                    break;
                }
                if (rand < 0.85) {
                    newPriority = StrategicPriority.EXPANSION;
                    break;
                }
                newPriority = StrategicPriority.TECHNOLOGY;
                break;
            }
            case LATE_GAME: {
                StrategicPriority strategicPriority = newPriority = Math.random() < 0.6 ? StrategicPriority.MILITARY : StrategicPriority.TECHNOLOGY;
            }
        }
        if (!this.getBotPlayer().getDifficulty().shouldMakeOptimalDecision() && Math.random() < 0.3) {
            StrategicPriority[] priorities = StrategicPriority.values();
            newPriority = priorities[(int)(Math.random() * (double)priorities.length)];
        }
        if (newPriority != this.primaryPriority) {
            this.primaryPriority = newPriority;
            this.ticksSincePriorityChange = 0;
            ReignOfNether.LOGGER.debug("Bot '{}' switched priority to {} (after {} ticks)", (Object)this.getBotPlayer().getName(), (Object)newPriority, (Object)this.ticksSincePriorityChange);
        }
    }

    private void setPriorityWithCooldown(StrategicPriority newPriority) {
        if (this.ticksSincePriorityChange >= 600 && newPriority != this.primaryPriority) {
            this.primaryPriority = newPriority;
            this.ticksSincePriorityChange = 0;
            ReignOfNether.LOGGER.debug("Bot '{}' switched priority to {} (after {} ticks)", (Object)this.getBotPlayer().getName(), (Object)newPriority, (Object)this.ticksSincePriorityChange);
        }
    }

    public void startGameSession(String sessionId, List<String> playerNames, List<String> botNames, String gameMode) {
        this.currentGameSessionId = sessionId;
        this.decisionsThisSession = 0;
        ConcurrentHashMap<String, String> gameParams = new ConcurrentHashMap<String, String>();
        gameParams.put("botDifficulty", this.botPlayer.getDifficulty().toString());
        gameParams.put("botFaction", this.botPlayer.getFaction().toString());
        MLFramework.getInstance().startGameSession(sessionId, playerNames, botNames, gameMode, gameParams);
        ReignOfNether.LOGGER.info("Bot '{}' started ML game session '{}'", (Object)this.botPlayer.getName(), (Object)sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endGameSession(boolean wonGame, GameMetrics gameMetrics, String endReason) {
        if (this.currentGameSessionId == null) {
            return;
        }
        try {
            ConcurrentHashMap<String, Boolean> results = new ConcurrentHashMap<String, Boolean>();
            results.put(this.botPlayer.getName(), wonGame);
            MLFramework.getInstance().endGameSession(this.currentGameSessionId, results, gameMetrics, endReason);
            ReignOfNether.LOGGER.info("Bot '{}' ended ML game session '{}' - Won: {}, Decisions: {}", (Object)this.botPlayer.getName(), (Object)this.currentGameSessionId, (Object)wonGame, (Object)this.decisionsThisSession);
        }
        finally {
            this.currentGameSessionId = null;
            this.lastMLDecision = null;
            this.lastDecisionTime = 0L;
            this.decisionsThisSession = 0;
        }
    }

    public void recordDecisionOutcome(double outcomeScore, String context) {
        if (this.lastMLDecision != null && this.currentGameSessionId != null) {
            GameState currentState = null;
            MLFramework.getInstance().recordDecisionOutcome(this.botPlayer.getName(), currentState, this.lastMLDecision, outcomeScore, context);
        }
    }

    public void reset() {
        if (this.currentGameSessionId != null) {
            this.endGameSession(false, new GameMetrics(0L, 0, 0.0, 0.0, 0, 0, 0, 0, 0), "Game reset");
        }
        this.currentPhase = GamePhase.EARLY_GAME;
        this.primaryPriority = StrategicPriority.ECONOMY;
        this.ticksSincePhaseChange = 0;
        this.economicManager.reset();
        this.militaryManager.reset();
        this.baseManager.reset();
        this.technologyManager.reset();
        ReignOfNether.LOGGER.debug("Reset strategic controller for bot '{}'", (Object)this.getBotPlayer().getName());
    }

    public AIBotPlayer getBotPlayer() {
        return this.botPlayer;
    }

    public EconomicManager getEconomicManager() {
        return this.economicManager;
    }

    public MilitaryManager getMilitaryManager() {
        return this.militaryManager;
    }

    public BaseManager getBaseManager() {
        return this.baseManager;
    }

    public TechnologyManager getTechnologyManager() {
        return this.technologyManager;
    }

    public GamePhase getCurrentPhase() {
        return this.currentPhase;
    }

    public StrategicPriority getPrimaryPriority() {
        return this.primaryPriority;
    }

    public int getTicksSincePhaseChange() {
        return this.ticksSincePhaseChange;
    }

    public static enum GamePhase {
        EARLY_GAME,
        MID_GAME,
        LATE_GAME;

    }

    public static enum StrategicPriority {
        ECONOMY,
        MILITARY,
        EXPANSION,
        TECHNOLOGY,
        DEFENSE;

    }
}

