/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.bot.controllers.managers;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.bot.BotDifficulty;
import com.solegendary.reignofnether.bot.command.BotCommandInterface;
import com.solegendary.reignofnether.bot.controllers.AIStrategicController;
import com.solegendary.reignofnether.bot.controllers.managers.MilitaryManager;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.util.Faction;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;

public class BaseManager {
    private final AIStrategicController strategicController;
    private BaseLayout currentLayout = BaseLayout.COMPACT;
    private int numberOfBases = 1;
    private final Queue<BuildingPlan> buildingQueue = new LinkedList<BuildingPlan>();
    private boolean shouldExpand = false;
    private int ticksSinceLastExpansion = 0;
    private final int EXPANSION_COOLDOWN = 6000;

    public BaseManager(AIStrategicController strategicController) {
        this.strategicController = strategicController;
    }

    public void tick(ServerLevel level) {
        this.updateBaseState(level);
        this.processExpansionPlanning(level);
        this.processBuildingQueue(level);
    }

    public void makeExpansionDecision(ServerLevel level) {
        try {
            Resources resources = this.getPlayerResources();
            if (resources == null) {
                return;
            }
            if (this.shouldExpandToNewBase(resources)) {
                this.planBaseExpansion(level);
            }
            if (this.shouldExpandCurrentBase(resources)) {
                this.planBaseExpansionBuildings(resources);
            }
            ReignOfNether.LOGGER.debug("Bot '{}' made expansion decision: {} bases, layout: {}", (Object)this.getBotName(), (Object)this.numberOfBases, (Object)this.currentLayout);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error in expansion decision making for bot '{}': {}", (Object)this.getBotName(), (Object)e.getMessage());
        }
    }

    public void makeDefenseDecision(ServerLevel level) {
        try {
            Resources resources = this.getPlayerResources();
            if (resources == null) {
                return;
            }
            if (this.shouldBuildDefenses(resources)) {
                this.planDefensiveStructures();
            }
            if (this.shouldUpgradeDefenses(resources)) {
                this.planDefenseUpgrades();
            }
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error in defense decision making for bot '{}': {}", (Object)this.getBotName(), (Object)e.getMessage());
        }
    }

    private void updateBaseState(ServerLevel level) {
        ++this.ticksSinceLastExpansion;
        switch (this.strategicController.getCurrentPhase()) {
            case EARLY_GAME: {
                this.currentLayout = BaseLayout.COMPACT;
                break;
            }
            case MID_GAME: {
                this.currentLayout = BaseLayout.DEFENSIVE;
                break;
            }
            case LATE_GAME: {
                this.currentLayout = BaseLayout.FORTRESS;
            }
        }
    }

    private void processExpansionPlanning(ServerLevel level) {
        Resources resources;
        if (this.ticksSinceLastExpansion > 6000) {
            this.shouldExpand = true;
        }
        if ((resources = this.getPlayerResources()) != null && this.shouldExpand) {
            int expansionThreshold = this.calculateExpansionThreshold();
            this.shouldExpand = resources.getTotalValue() > expansionThreshold;
        }
    }

    private void processBuildingQueue(ServerLevel level) {
        Resources resources;
        if (this.buildingQueue.isEmpty()) {
            return;
        }
        BuildingPlan plan = this.buildingQueue.peek();
        if (plan.shouldConstruct(this.strategicController.getBotPlayer().getDifficulty()) && (resources = this.getPlayerResources()) != null && plan.canAfford(resources)) {
            this.executeBuildingPlan(plan, level);
            this.buildingQueue.poll();
        }
    }

    private boolean shouldExpandToNewBase(Resources resources) {
        return this.shouldExpand && this.numberOfBases < 3 && resources.getTotalValue() > 800 && this.ticksSinceLastExpansion > 6000;
    }

    private boolean shouldExpandCurrentBase(Resources resources) {
        return resources.wood >= 200 && resources.ore >= 100;
    }

    private boolean shouldBuildDefenses(Resources resources) {
        return resources.wood >= 150 && (this.strategicController.getMilitaryManager().getCurrentStance() == MilitaryManager.MilitaryStance.DEFENSIVE || this.strategicController.getMilitaryManager().isUnderAttack());
    }

    private boolean shouldUpgradeDefenses(Resources resources) {
        return resources.ore >= 200 && this.strategicController.getCurrentPhase() == AIStrategicController.GamePhase.LATE_GAME;
    }

    private void planBaseExpansion(ServerLevel level) {
        ReignOfNether.LOGGER.debug("Bot '{}' planning base expansion", (Object)this.getBotName());
        ++this.numberOfBases;
        this.ticksSinceLastExpansion = 0;
        this.shouldExpand = false;
        this.queueBuilding(new BuildingPlan(BuildingType.CAPITOL, 1.0));
        this.queueBuilding(new BuildingPlan(BuildingType.STOCKPILE, 0.8));
    }

    private void planBaseExpansionBuildings(Resources resources) {
        ReignOfNether.LOGGER.debug("Bot '{}' planning base expansion buildings", (Object)this.getBotName());
        switch (this.strategicController.getPrimaryPriority()) {
            case ECONOMY: {
                this.queueBuilding(new BuildingPlan(BuildingType.FARM, 0.7));
                this.queueBuilding(new BuildingPlan(BuildingType.STOCKPILE, 0.6));
                break;
            }
            case MILITARY: {
                this.queueBuilding(new BuildingPlan(BuildingType.BARRACKS, 0.8));
                this.queueBuilding(new BuildingPlan(BuildingType.ARCHERY_RANGE, 0.6));
                break;
            }
            case TECHNOLOGY: {
                this.queueBuilding(new BuildingPlan(BuildingType.LIBRARY, 0.7));
            }
        }
    }

    private void planDefensiveStructures() {
        ReignOfNether.LOGGER.debug("Bot '{}' planning defensive structures", (Object)this.getBotName());
        this.queueBuilding(new BuildingPlan(BuildingType.WATCHTOWER, 0.8));
        this.queueBuilding(new BuildingPlan(BuildingType.WALL, 0.6));
    }

    private void planDefenseUpgrades() {
        ReignOfNether.LOGGER.debug("Bot '{}' planning defense upgrades", (Object)this.getBotName());
    }

    private void queueBuilding(BuildingPlan plan) {
        this.buildingQueue.offer(plan);
    }

    private void executeBuildingPlan(BuildingPlan plan, ServerLevel level) {
        ReignOfNether.LOGGER.debug("Bot '{}' executing building plan: {}", (Object)this.getBotName(), (Object)plan.getBuildingType());
        try {
            BotCommandInterface commandInterface = this.strategicController.getBotPlayer().getCommandInterface();
            BlockPos buildLocation = this.findBuildLocation(null, plan.getBuildingType(), level);
            if (buildLocation == null) {
                ReignOfNether.LOGGER.debug("Bot '{}' could not find suitable build location for {}", (Object)this.getBotName(), (Object)plan.getBuildingType());
                return;
            }
            List<LivingEntity> workers = commandInterface.getOwnedWorkers(level);
            if (workers.isEmpty()) {
                ReignOfNether.LOGGER.debug("Bot '{}' has no workers available for building {}", (Object)this.getBotName(), (Object)plan.getBuildingType());
                return;
            }
            String buildingName = this.getBuildingNameForFaction(plan.getBuildingType(), this.strategicController.getBotPlayer().getFaction());
            if (buildingName != null) {
                boolean success = commandInterface.placeBuilding(buildingName, buildLocation);
                if (success) {
                    ReignOfNether.LOGGER.info("Bot '{}' successfully placed {} at {}", (Object)this.getBotName(), (Object)buildingName, (Object)buildLocation);
                } else {
                    ReignOfNether.LOGGER.debug("Bot '{}' failed to place {} at {} (insufficient resources?)", (Object)this.getBotName(), (Object)buildingName, (Object)buildLocation);
                }
            } else {
                ReignOfNether.LOGGER.debug("Bot '{}' could not determine building name for {} and faction {}", (Object)this.getBotName(), (Object)plan.getBuildingType(), (Object)this.strategicController.getBotPlayer().getFaction());
            }
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error executing building plan for bot '{}': {}", (Object)this.getBotName(), (Object)e.getMessage());
        }
    }

    private Resources getPlayerResources() {
        String botName = this.getBotName();
        for (Resources resources : ResourcesServerEvents.resourcesList) {
            if (!resources.ownerName.equals(botName)) continue;
            return resources;
        }
        return null;
    }

    private String getBotName() {
        return this.strategicController.getBotPlayer().getName();
    }

    private int calculateExpansionThreshold() {
        int baseThreshold = switch (this.strategicController.getCurrentPhase()) {
            default -> throw new IncompatibleClassChangeError();
            case AIStrategicController.GamePhase.EARLY_GAME -> 400;
            case AIStrategicController.GamePhase.MID_GAME -> 600;
            case AIStrategicController.GamePhase.LATE_GAME -> 800;
        };
        float difficultyMod = this.strategicController.getBotPlayer().getDifficulty().getSkillMultiplier();
        return (int)((float)baseThreshold * (0.8f + difficultyMod * 0.4f));
    }

    private static ResourceCost getBuildingCostByType(BuildingType buildingType) {
        return switch (buildingType) {
            case BuildingType.CAPITOL -> ResourceCost.Building(0, 200, 100, 5);
            case BuildingType.WATCHTOWER, BuildingType.WALL, BuildingType.GATE -> ResourceCost.Building(0, 120, 80, 0);
            case BuildingType.STOCKPILE, BuildingType.FARM -> ResourceCost.Building(0, 100, 50, 0);
            case BuildingType.BARRACKS, BuildingType.ARCHERY_RANGE, BuildingType.STABLE -> ResourceCost.Building(50, 150, 60, 0);
            case BuildingType.LIBRARY, BuildingType.BLACKSMITH -> ResourceCost.Building(0, 80, 120, 0);
            case BuildingType.BRIDGE -> ResourceCost.Building(0, 60, 20, 0);
            case BuildingType.BEACON, BuildingType.PORTAL -> ResourceCost.Building(0, 150, 200, 0);
            default -> ResourceCost.Building(0, 80, 40, 0);
        };
    }

    private BlockPos findBuildLocation(BlockPos preferredPos, BuildingType buildingType, ServerLevel level) {
        try {
            BotCommandInterface commandInterface = this.strategicController.getBotPlayer().getCommandInterface();
            if (preferredPos != null && commandInterface.isLocationSuitableForBuilding(preferredPos)) {
                return preferredPos;
            }
            List<BuildingPlacement> ownBuildings = commandInterface.getOwnedBuildings();
            if (!ownBuildings.isEmpty()) {
                BlockPos baseCenter = ownBuildings.get((int)0).originPos;
                return commandInterface.findNearestBuildableLand(baseCenter, 16);
            }
            List<LivingEntity> workers = commandInterface.getOwnedWorkers(level);
            if (!workers.isEmpty()) {
                BlockPos workerPos = workers.get(0).m_20183_();
                return commandInterface.findNearestBuildableLand(workerPos, 16);
            }
            return null;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error finding build location for bot '{}': {}", (Object)this.getBotName(), (Object)e.getMessage());
            return null;
        }
    }

    private String getBuildingNameForFaction(BuildingType buildingType, Faction faction) {
        return switch (faction) {
            case Faction.VILLAGERS -> {
                switch (buildingType) {
                    case CAPITOL: {
                        yield "Town Centre";
                    }
                    case STOCKPILE: {
                        yield "Oak Stockpile";
                    }
                    case FARM: {
                        yield "Wheat Farm";
                    }
                    case BARRACKS: {
                        yield "Barracks";
                    }
                    case ARCHERY_RANGE: {
                        yield "Archery Range";
                    }
                    case LIBRARY: {
                        yield "Library";
                    }
                    case BLACKSMITH: {
                        yield "Blacksmith";
                    }
                    case WATCHTOWER: {
                        yield "Watchtower";
                    }
                    case BRIDGE: {
                        yield "Oak Bridge";
                    }
                }
                yield null;
            }
            case Faction.MONSTERS -> {
                switch (buildingType) {
                    case CAPITOL: {
                        yield "Mausoleum";
                    }
                    case STOCKPILE: {
                        yield "Spruce Stockpile";
                    }
                    case FARM: {
                        yield "Pumpkin Farm";
                    }
                    case BARRACKS: {
                        yield "Dungeon";
                    }
                    case ARCHERY_RANGE: {
                        yield "Graveyard";
                    }
                    case LIBRARY: {
                        yield "Laboratory";
                    }
                    case BLACKSMITH: {
                        yield "Haunted House";
                    }
                    case WATCHTOWER: {
                        yield "Dark Watchtower";
                    }
                    case BRIDGE: {
                        yield "Spruce Bridge";
                    }
                }
                yield null;
            }
            case Faction.PIGLINS -> {
                switch (buildingType) {
                    case CAPITOL: {
                        yield "Central Portal";
                    }
                    case STOCKPILE: {
                        yield "Basalt Springs";
                    }
                    case FARM: {
                        yield "Netherwart Farm";
                    }
                    case BARRACKS: {
                        yield "Fortress";
                    }
                    case ARCHERY_RANGE: {
                        yield "Flame Sanctuary";
                    }
                    case LIBRARY: {
                        yield "Wither Shrine";
                    }
                    case BLACKSMITH: {
                        yield "Hoglin Stables";
                    }
                    case WATCHTOWER: {
                        yield "Fortress";
                    }
                    case BRIDGE: {
                        yield "Blackstone Bridge";
                    }
                }
                yield null;
            }
            default -> null;
        };
    }

    public void reset() {
        this.currentLayout = BaseLayout.COMPACT;
        this.numberOfBases = 1;
        this.shouldExpand = false;
        this.ticksSinceLastExpansion = 0;
        this.buildingQueue.clear();
    }

    public BaseLayout getCurrentLayout() {
        return this.currentLayout;
    }

    public int getNumberOfBases() {
        return this.numberOfBases;
    }

    public boolean shouldExpand() {
        return this.shouldExpand;
    }

    public int getBuildingQueueSize() {
        return this.buildingQueue.size();
    }

    public static enum BaseLayout {
        COMPACT,
        DEFENSIVE,
        FORTRESS,
        ECONOMIC;

    }

    public static class BuildingPlan {
        private final BuildingType buildingType;
        private final double priority;
        private final long createdTime;

        public BuildingPlan(BuildingType buildingType, double priority) {
            this.buildingType = buildingType;
            this.priority = priority;
            this.createdTime = System.currentTimeMillis();
        }

        public boolean shouldConstruct(BotDifficulty difficulty) {
            return Math.random() < this.priority * (double)difficulty.getSkillMultiplier();
        }

        public boolean canAfford(Resources resources) {
            ResourceCost cost = BaseManager.getBuildingCostByType(this.buildingType);
            return resources.food >= cost.food && resources.wood >= cost.wood && resources.ore >= cost.ore;
        }

        public BuildingType getBuildingType() {
            return this.buildingType;
        }

        public double getPriority() {
            return this.priority;
        }
    }

    public static enum BuildingType {
        CAPITOL,
        STOCKPILE,
        FARM,
        BRIDGE,
        BARRACKS,
        ARCHERY_RANGE,
        STABLE,
        WATCHTOWER,
        WALL,
        GATE,
        LIBRARY,
        BLACKSMITH,
        BEACON,
        PORTAL;

    }
}

