/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.bot.controllers.managers;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.bot.BotDifficulty;
import com.solegendary.reignofnether.bot.controllers.AIStrategicController;
import com.solegendary.reignofnether.resources.ResourceCost;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;

public class TechnologyManager {
    private final AIStrategicController strategicController;
    private TechPriority currentPriority = TechPriority.ECONOMIC;
    private final Set<ResearchType> completedResearch = EnumSet.noneOf(ResearchType.class);
    private final Queue<ResearchPlan> researchQueue = new LinkedList<ResearchPlan>();
    private TechTier currentTechTier = TechTier.TIER_1;
    private int researchPoints = 0;

    public TechnologyManager(AIStrategicController strategicController) {
        this.strategicController = strategicController;
    }

    public void tick(ServerLevel level) {
        this.updateTechnologyState(level);
        this.processResearchQueue(level);
        this.assessTechPriorities(level);
    }

    public void makeTechnologyDecision(ServerLevel level) {
        try {
            Resources resources = this.getPlayerResources();
            if (resources == null) {
                return;
            }
            if (this.shouldBuildResearchBuildings(resources)) {
                this.planResearchBuildings();
            }
            if (this.shouldStartResearch(resources)) {
                this.planResearchProjects(resources);
            }
            if (this.shouldUpgradeTechnology(resources)) {
                this.planTechnologyUpgrades();
            }
            ReignOfNether.LOGGER.debug("Bot '{}' made technology decision: tier {}, priority: {}, {} research completed", (Object)this.getBotName(), (Object)this.currentTechTier, (Object)this.currentPriority, (Object)this.completedResearch.size());
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error in technology decision making for bot '{}': {}", (Object)this.getBotName(), (Object)e.getMessage());
        }
    }

    private void updateTechnologyState(ServerLevel level) {
        this.currentTechTier = this.completedResearch.size() >= 8 ? TechTier.TIER_3 : (this.completedResearch.size() >= 4 ? TechTier.TIER_2 : TechTier.TIER_1);
        ++this.researchPoints;
    }

    private void processResearchQueue(ServerLevel level) {
        Resources resources;
        if (this.researchQueue.isEmpty()) {
            return;
        }
        ResearchPlan research = this.researchQueue.peek();
        if (research.shouldStart(this.strategicController.getBotPlayer().getDifficulty()) && (resources = this.getPlayerResources()) != null && research.canAfford(resources)) {
            this.executeResearch(research, level);
            this.researchQueue.poll();
        }
    }

    private void assessTechPriorities(ServerLevel level) {
        TechPriority newPriority = this.currentPriority;
        block0 : switch (this.strategicController.getPrimaryPriority()) {
            case ECONOMY: {
                newPriority = TechPriority.ECONOMIC;
                break;
            }
            case MILITARY: {
                newPriority = TechPriority.MILITARY;
                break;
            }
            case TECHNOLOGY: {
                switch (this.strategicController.getBotPlayer().getFaction()) {
                    case VILLAGERS: {
                        newPriority = TechPriority.DEFENSIVE;
                        break block0;
                    }
                    case MONSTERS: {
                        newPriority = TechPriority.DARK_MAGIC;
                        break block0;
                    }
                    case PIGLINS: {
                        newPriority = TechPriority.FIRE_MAGIC;
                        break block0;
                    }
                }
                newPriority = TechPriority.BALANCED;
                break;
            }
            default: {
                newPriority = TechPriority.BALANCED;
            }
        }
        if (!this.strategicController.getBotPlayer().getDifficulty().shouldMakeOptimalDecision()) {
            TechPriority[] priorities = TechPriority.values();
            newPriority = priorities[(int)(Math.random() * (double)priorities.length)];
        }
        if (newPriority != this.currentPriority) {
            this.currentPriority = newPriority;
            ReignOfNether.LOGGER.debug("Bot '{}' changed tech priority to {}", (Object)this.getBotName(), (Object)newPriority);
        }
    }

    private boolean shouldBuildResearchBuildings(Resources resources) {
        return resources.wood >= 200 && resources.ore >= 100 && this.currentTechTier == TechTier.TIER_1;
    }

    private boolean shouldStartResearch(Resources resources) {
        return resources.ore >= 75 && this.researchQueue.size() < 3 && !this.completedResearch.containsAll(Arrays.asList(ResearchType.values()));
    }

    private boolean shouldUpgradeTechnology(Resources resources) {
        return resources.ore >= 150 && this.currentTechTier.ordinal() >= 1 && Math.random() < 0.3;
    }

    private void planResearchBuildings() {
        ReignOfNether.LOGGER.debug("Bot '{}' planning research buildings", (Object)this.getBotName());
    }

    private void planResearchProjects(Resources resources) {
        ReignOfNether.LOGGER.debug("Bot '{}' planning research projects: {}", (Object)this.getBotName(), (Object)this.currentPriority);
        List<ResearchType> availableResearch = this.getAvailableResearch();
        List<ResearchType> priorityResearch = availableResearch.stream().filter(research -> research.matchesPriority(this.currentPriority)).toList();
        if (!priorityResearch.isEmpty()) {
            ResearchType chosen = priorityResearch.get((int)(Math.random() * (double)priorityResearch.size()));
            this.queueResearch(new ResearchPlan(chosen, 0.8));
        } else if (!availableResearch.isEmpty()) {
            ResearchType chosen = availableResearch.get((int)(Math.random() * (double)availableResearch.size()));
            this.queueResearch(new ResearchPlan(chosen, 0.5));
        }
    }

    private void planTechnologyUpgrades() {
        ReignOfNether.LOGGER.debug("Bot '{}' planning technology upgrades", (Object)this.getBotName());
    }

    private List<ResearchType> getAvailableResearch() {
        ArrayList<ResearchType> available = new ArrayList<ResearchType>();
        for (ResearchType research : ResearchType.values()) {
            if (this.completedResearch.contains((Object)research) || !research.isAvailableAt(this.currentTechTier) || !research.prerequisitesMet(this.completedResearch)) continue;
            available.add(research);
        }
        return available;
    }

    private void queueResearch(ResearchPlan plan) {
        this.researchQueue.offer(plan);
    }

    private void executeResearch(ResearchPlan plan, ServerLevel level) {
        ReignOfNether.LOGGER.debug("Bot '{}' starting research: {}", (Object)this.getBotName(), (Object)plan.getResearchType());
        this.completedResearch.add(plan.getResearchType());
    }

    private Resources getPlayerResources() {
        String botName = this.getBotName();
        for (Resources resources : ResourcesServerEvents.resourcesList) {
            if (!resources.ownerName.equals(botName)) continue;
            return resources;
        }
        return null;
    }

    private String getBotName() {
        return this.strategicController.getBotPlayer().getName();
    }

    public void reset() {
        this.currentPriority = TechPriority.ECONOMIC;
        this.currentTechTier = TechTier.TIER_1;
        this.researchPoints = 0;
        this.completedResearch.clear();
        this.researchQueue.clear();
    }

    public TechPriority getCurrentPriority() {
        return this.currentPriority;
    }

    public TechTier getCurrentTechTier() {
        return this.currentTechTier;
    }

    public Set<ResearchType> getCompletedResearch() {
        return EnumSet.copyOf(this.completedResearch);
    }

    public int getResearchPoints() {
        return this.researchPoints;
    }

    public int getResearchQueueSize() {
        return this.researchQueue.size();
    }

    private static ResourceCost getResearchCostByType(ResearchType researchType) {
        return switch (researchType.getTier()) {
            case TechTier.TIER_1 -> ResourceCost.Research(0, 50, 100, 30);
            case TechTier.TIER_2 -> ResourceCost.Research(20, 80, 160, 45);
            case TechTier.TIER_3 -> ResourceCost.Research(50, 120, 240, 60);
            default -> ResourceCost.Research(0, 60, 120, 30);
        };
    }

    public static enum TechPriority {
        ECONOMIC,
        MILITARY,
        DEFENSIVE,
        DARK_MAGIC,
        FIRE_MAGIC,
        BALANCED;

    }

    public static enum ResearchType {
        IMPROVED_FARMING(TechTier.TIER_1, TechPriority.ECONOMIC),
        RESOURCE_EFFICIENCY(TechTier.TIER_2, TechPriority.ECONOMIC),
        ADVANCED_STORAGE(TechTier.TIER_2, TechPriority.ECONOMIC),
        WEAPON_UPGRADES(TechTier.TIER_1, TechPriority.MILITARY),
        ARMOR_UPGRADES(TechTier.TIER_1, TechPriority.MILITARY),
        ADVANCED_TACTICS(TechTier.TIER_2, TechPriority.MILITARY),
        ELITE_TRAINING(TechTier.TIER_3, TechPriority.MILITARY),
        FORTIFICATIONS(TechTier.TIER_1, TechPriority.DEFENSIVE),
        ADVANCED_WALLS(TechTier.TIER_2, TechPriority.DEFENSIVE),
        SIEGE_DEFENSE(TechTier.TIER_3, TechPriority.DEFENSIVE),
        DARK_RITUALS(TechTier.TIER_2, TechPriority.DARK_MAGIC),
        NECROMANCY(TechTier.TIER_3, TechPriority.DARK_MAGIC),
        FIRE_MASTERY(TechTier.TIER_2, TechPriority.FIRE_MAGIC),
        INFERNAL_POWER(TechTier.TIER_3, TechPriority.FIRE_MAGIC);

        private final TechTier requiredTier;
        private final TechPriority priority;

        private ResearchType(TechTier requiredTier, TechPriority priority) {
            this.requiredTier = requiredTier;
            this.priority = priority;
        }

        public TechTier getTier() {
            return this.requiredTier;
        }

        public boolean isAvailableAt(TechTier currentTier) {
            return currentTier.ordinal() >= this.requiredTier.ordinal();
        }

        public boolean matchesPriority(TechPriority currentPriority) {
            return this.priority == currentPriority || currentPriority == TechPriority.BALANCED;
        }

        public boolean prerequisitesMet(Set<ResearchType> completed) {
            switch (this) {
                case RESOURCE_EFFICIENCY: {
                    return completed.contains((Object)IMPROVED_FARMING);
                }
                case ADVANCED_TACTICS: {
                    return completed.contains((Object)WEAPON_UPGRADES) && completed.contains((Object)ARMOR_UPGRADES);
                }
                case ELITE_TRAINING: {
                    return completed.contains((Object)ADVANCED_TACTICS);
                }
                case NECROMANCY: {
                    return completed.contains((Object)DARK_RITUALS);
                }
                case INFERNAL_POWER: {
                    return completed.contains((Object)FIRE_MASTERY);
                }
            }
            return true;
        }
    }

    public static enum TechTier {
        TIER_1,
        TIER_2,
        TIER_3;

    }

    public static class ResearchPlan {
        private final ResearchType researchType;
        private final double priority;
        private final long createdTime;

        public ResearchPlan(ResearchType researchType, double priority) {
            this.researchType = researchType;
            this.priority = priority;
            this.createdTime = System.currentTimeMillis();
        }

        public boolean shouldStart(BotDifficulty difficulty) {
            return Math.random() < this.priority * (double)difficulty.getSkillMultiplier();
        }

        public boolean canAfford(Resources resources) {
            ResourceCost cost = TechnologyManager.getResearchCostByType(this.researchType);
            return resources.food >= cost.food && resources.wood >= cost.wood && resources.ore >= cost.ore;
        }

        public ResearchType getResearchType() {
            return this.researchType;
        }

        public double getPriority() {
            return this.priority;
        }
    }
}

