/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.bot.ml;

import java.util.HashMap;
import java.util.Map;

public class GameMetrics {
    public final long gameLength;
    public final int finalScore;
    public final double economicEfficiency;
    public final double militaryEfficiency;
    public final int unitsProduced;
    public final int buildingsConstructed;
    public final int resourcesGathered;
    public final int enemyUnitsKilled;
    public final int ownUnitsLost;
    public final Map<String, Double> customMetrics;

    public GameMetrics(long gameLength, int finalScore, double economicEfficiency, double militaryEfficiency, int unitsProduced, int buildingsConstructed, int resourcesGathered, int enemyUnitsKilled, int ownUnitsLost) {
        this.gameLength = gameLength;
        this.finalScore = finalScore;
        this.economicEfficiency = economicEfficiency;
        this.militaryEfficiency = militaryEfficiency;
        this.unitsProduced = unitsProduced;
        this.buildingsConstructed = buildingsConstructed;
        this.resourcesGathered = resourcesGathered;
        this.enemyUnitsKilled = enemyUnitsKilled;
        this.ownUnitsLost = ownUnitsLost;
        this.customMetrics = new HashMap<String, Double>();
    }

    public void addCustomMetric(String key, double value) {
        this.customMetrics.put(key, value);
    }

    public double getCustomMetric(String key, double defaultValue) {
        return this.customMetrics.getOrDefault(key, defaultValue);
    }

    public double getOverallPerformanceScore() {
        double economicWeight = 0.3;
        double militaryWeight = 0.4;
        double efficiencyWeight = 0.3;
        double normalizedEconomic = Math.min(1.0, (double)this.resourcesGathered / 10000.0);
        double normalizedMilitary = Math.min(1.0, (double)this.enemyUnitsKilled / 100.0);
        double normalizedEfficiency = (this.economicEfficiency + this.militaryEfficiency) / 2.0;
        return economicWeight * normalizedEconomic + militaryWeight * normalizedMilitary + efficiencyWeight * normalizedEfficiency;
    }

    public double getKillDeathRatio() {
        return this.ownUnitsLost > 0 ? (double)this.enemyUnitsKilled / (double)this.ownUnitsLost : (double)this.enemyUnitsKilled;
    }

    public double getResourcesPerMinute() {
        long gameMinutes = Math.max(1L, this.gameLength / 60000L);
        return (double)this.resourcesGathered / (double)gameMinutes;
    }

    public double getMilitaryProductionRate() {
        long gameMinutes = Math.max(1L, this.gameLength / 60000L);
        return (double)this.unitsProduced / (double)gameMinutes;
    }

    public String toString() {
        return String.format("GameMetrics{duration=%dms, score=%d, econ=%.2f, military=%.2f, units=%d, buildings=%d, resources=%d, kills=%d, losses=%d}", this.gameLength, this.finalScore, this.economicEfficiency, this.militaryEfficiency, this.unitsProduced, this.buildingsConstructed, this.resourcesGathered, this.enemyUnitsKilled, this.ownUnitsLost);
    }
}

