/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.bot.ml;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.bot.ml.GamePhase;
import com.solegendary.reignofnether.bot.ml.GameState;
import com.solegendary.reignofnether.bot.ml.StrategicPriority;
import com.solegendary.reignofnether.building.BuildingPlacement;
import com.solegendary.reignofnether.building.BuildingServerEvents;
import com.solegendary.reignofnether.resources.Resources;
import com.solegendary.reignofnether.resources.ResourcesServerEvents;
import com.solegendary.reignofnether.unit.UnitServerEvents;
import com.solegendary.reignofnether.unit.interfaces.AttackerUnit;
import com.solegendary.reignofnether.unit.interfaces.Unit;
import com.solegendary.reignofnether.unit.interfaces.WorkerUnit;
import java.util.ArrayList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;

public class GameStateExtractor {
    public static GameState extractGameState(String playerName, ServerLevel level) {
        try {
            GameState gameState = new GameState();
            GameStateExtractor.extractPlayerState(gameState, playerName, level, true);
            GameStateExtractor.estimateEnemyState(gameState, playerName, level);
            GameStateExtractor.calculateStrategicMetrics(gameState);
            GameStateExtractor.setGameTiming(gameState, level);
            return gameState;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error extracting game state for player '{}': {}", (Object)playerName, (Object)e.getMessage());
            return new GameState();
        }
    }

    private static void extractPlayerState(GameState gameState, String playerName, ServerLevel level, boolean isOwnPlayer) {
        try {
            GameState.ResourceState resourceState = GameStateExtractor.extractResources(playerName);
            if (isOwnPlayer) {
                gameState.selfResources = resourceState;
            } else {
                gameState.enemyResourcesEstimate = resourceState;
            }
            GameState.UnitState unitState = GameStateExtractor.extractUnits(playerName);
            if (isOwnPlayer) {
                gameState.selfUnits = unitState;
            } else {
                gameState.enemyUnitsEstimate = unitState;
            }
            GameState.BuildingState buildingState = GameStateExtractor.extractBuildings(playerName);
            if (isOwnPlayer) {
                gameState.selfBuildings = buildingState;
            } else {
                gameState.enemyBuildingsEstimate = buildingState;
            }
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error extracting player state for '{}': {}", (Object)playerName, (Object)e.getMessage());
        }
    }

    private static GameState.ResourceState extractResources(String playerName) {
        GameState.ResourceState resourceState = new GameState.ResourceState();
        try {
            for (Resources resources : ResourcesServerEvents.resourcesList) {
                if (!resources.ownerName.equals(playerName)) continue;
                resourceState.food = resources.food;
                resourceState.wood = resources.wood;
                resourceState.ore = resources.ore;
                break;
            }
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error extracting resources for player '{}': {}", (Object)playerName, (Object)e.getMessage());
        }
        return resourceState;
    }

    private static GameState.UnitState extractUnits(String playerName) {
        GameState.UnitState unitState = new GameState.UnitState();
        try {
            ArrayList<LivingEntity> allUnits = UnitServerEvents.getAllUnits();
            for (LivingEntity entity : allUnits) {
                Unit unit;
                if (!(entity instanceof Unit) || !playerName.equals((unit = (Unit)entity).getOwnerName())) continue;
                String unitClassName = entity.getClass().getSimpleName().toLowerCase();
                if (entity instanceof WorkerUnit) {
                    ++unitState.workers;
                } else if (entity instanceof AttackerUnit) {
                    ++unitState.militaryUnits;
                    if (unitClassName.contains("archer") || unitClassName.contains("crossbow") || unitClassName.contains("pillager")) {
                        ++unitState.rangedUnits;
                    } else {
                        ++unitState.meleeUnits;
                    }
                }
                if (!unitClassName.contains("hero") && !unitClassName.contains("champion")) continue;
                ++unitState.heroUnits;
            }
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error extracting units for player '{}': {}", (Object)playerName, (Object)e.getMessage());
        }
        return unitState;
    }

    private static GameState.BuildingState extractBuildings(String playerName) {
        GameState.BuildingState buildingState = new GameState.BuildingState();
        try {
            ArrayList<BuildingPlacement> buildings = BuildingServerEvents.getBuildings();
            for (BuildingPlacement building : buildings) {
                if (!playerName.equals(building.ownerName)) continue;
                String buildingName = building.getBuilding().name.toLowerCase();
                if (buildingName.contains("town") || buildingName.contains("capitol") || buildingName.contains("centre") || buildingName.contains("stronghold")) {
                    ++buildingState.capitols;
                    continue;
                }
                if (buildingName.contains("farm") || buildingName.contains("stockpile") || buildingName.contains("springs")) {
                    ++buildingState.economicBuildings;
                    continue;
                }
                if (buildingName.contains("barracks") || buildingName.contains("stables") || buildingName.contains("dungeon") || buildingName.contains("lair")) {
                    ++buildingState.militaryBuildings;
                    continue;
                }
                if (buildingName.contains("tower") || buildingName.contains("wall") || buildingName.contains("fortress")) {
                    ++buildingState.defensiveBuildings;
                    continue;
                }
                if (buildingName.contains("library") || buildingName.contains("laboratory") || buildingName.contains("arcane")) {
                    ++buildingState.techBuildings;
                    continue;
                }
                ++buildingState.economicBuildings;
            }
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error extracting buildings for player '{}': {}", (Object)playerName, (Object)e.getMessage());
        }
        return buildingState;
    }

    private static void estimateEnemyState(GameState gameState, String playerName, ServerLevel level) {
        try {
            ArrayList<String> enemyPlayers = new ArrayList<String>();
            ArrayList<LivingEntity> allUnits = UnitServerEvents.getAllUnits();
            for (LivingEntity entity : allUnits) {
                Unit unit;
                String ownerName;
                if (!(entity instanceof Unit) || playerName.equals(ownerName = (unit = (Unit)entity).getOwnerName()) || enemyPlayers.contains(ownerName)) continue;
                enemyPlayers.add(ownerName);
            }
            GameState.ResourceState enemyResources = new GameState.ResourceState();
            GameState.UnitState enemyUnits = new GameState.UnitState();
            GameState.BuildingState enemyBuildings = new GameState.BuildingState();
            for (String enemyPlayer : enemyPlayers) {
                GameState.ResourceState enemyPlayerResources = GameStateExtractor.extractResources(enemyPlayer);
                GameState.UnitState enemyPlayerUnits = GameStateExtractor.extractUnits(enemyPlayer);
                GameState.BuildingState enemyPlayerBuildings = GameStateExtractor.extractBuildings(enemyPlayer);
                enemyResources.food += enemyPlayerResources.food;
                enemyResources.wood += enemyPlayerResources.wood;
                enemyResources.ore += enemyPlayerResources.ore;
                enemyUnits.workers += enemyPlayerUnits.workers;
                enemyUnits.militaryUnits += enemyPlayerUnits.militaryUnits;
                enemyUnits.rangedUnits += enemyPlayerUnits.rangedUnits;
                enemyUnits.meleeUnits += enemyPlayerUnits.meleeUnits;
                enemyUnits.specialUnits += enemyPlayerUnits.specialUnits;
                enemyUnits.heroUnits += enemyPlayerUnits.heroUnits;
                enemyBuildings.capitols += enemyPlayerBuildings.capitols;
                enemyBuildings.economicBuildings += enemyPlayerBuildings.economicBuildings;
                enemyBuildings.militaryBuildings += enemyPlayerBuildings.militaryBuildings;
                enemyBuildings.defensiveBuildings += enemyPlayerBuildings.defensiveBuildings;
                enemyBuildings.techBuildings += enemyPlayerBuildings.techBuildings;
            }
            gameState.enemyResourcesEstimate = enemyResources;
            gameState.enemyUnitsEstimate = enemyUnits;
            gameState.enemyBuildingsEstimate = enemyBuildings;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error estimating enemy state for player '{}': {}", (Object)playerName, (Object)e.getMessage());
        }
    }

    private static void calculateStrategicMetrics(GameState gameState) {
        try {
            int selfTotalResources = gameState.selfResources.food + gameState.selfResources.wood + gameState.selfResources.ore;
            int enemyTotalResources = gameState.enemyResourcesEstimate.food + gameState.enemyResourcesEstimate.wood + gameState.enemyResourcesEstimate.ore;
            gameState.resourceAdvantage = enemyTotalResources > 0 ? (double)selfTotalResources / (double)enemyTotalResources : (selfTotalResources > 0 ? 2.0 : 1.0);
            int selfMilitary = gameState.selfUnits.militaryUnits;
            int enemyMilitary = gameState.enemyUnitsEstimate.militaryUnits;
            gameState.militaryAdvantage = enemyMilitary > 0 ? (double)selfMilitary / (double)enemyMilitary : (selfMilitary > 0 ? 2.0 : 1.0);
            gameState.economicStrength = gameState.selfUnits.workers + gameState.selfBuildings.economicBuildings;
            int selfTech = gameState.selfBuildings.techBuildings;
            int enemyTech = gameState.enemyBuildingsEstimate.techBuildings;
            gameState.technologyAdvantage = enemyTech > 0 ? (double)selfTech / (double)enemyTech : (selfTech > 0 ? 2.0 : 1.0);
            gameState.threatLevel = Math.min(1.0, (double)enemyMilitary / Math.max(1.0, (double)selfMilitary));
            gameState.defensiveStrength = (double)gameState.selfBuildings.defensiveBuildings + (double)gameState.selfBuildings.militaryBuildings * 0.5;
            gameState.offensiveCapability = (double)gameState.selfUnits.militaryUnits + (double)gameState.selfUnits.heroUnits * 2.0;
            gameState.currentPriority = gameState.threatLevel > 0.7 ? StrategicPriority.DEFENSE : (gameState.militaryAdvantage > 1.5 ? StrategicPriority.MILITARY : (gameState.economicStrength < 5.0 ? StrategicPriority.ECONOMY : StrategicPriority.EXPANSION));
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error calculating strategic metrics: {}", (Object)e.getMessage());
        }
    }

    private static void setGameTiming(GameState gameState, ServerLevel level) {
        try {
            gameState.gameTime = level.m_46467_();
            long gameTimeMinutes = gameState.gameTime / 1200L;
            int totalBuildings = gameState.selfBuildings.capitols + gameState.selfBuildings.economicBuildings + gameState.selfBuildings.militaryBuildings + gameState.selfBuildings.defensiveBuildings + gameState.selfBuildings.techBuildings;
            gameState.gamePhase = gameTimeMinutes < 10L || totalBuildings < 3 ? GamePhase.EARLY_GAME : (gameTimeMinutes < 30L || totalBuildings < 8 ? GamePhase.MID_GAME : GamePhase.LATE_GAME);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error setting game timing: {}", (Object)e.getMessage());
        }
    }
}

