/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.bot.ml;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.bot.ml.AdaptiveDifficultyManager;
import com.solegendary.reignofnether.bot.ml.DataCollectionManager;
import com.solegendary.reignofnether.bot.ml.GameMetrics;
import com.solegendary.reignofnether.bot.ml.GameState;
import com.solegendary.reignofnether.bot.ml.GameStateVectorizer;
import com.solegendary.reignofnether.bot.ml.LearningPipeline;
import com.solegendary.reignofnether.bot.ml.MLDecision;
import com.solegendary.reignofnether.bot.ml.MockNeuralNetworkManager;
import com.solegendary.reignofnether.bot.ml.NeuralNetworkManager;
import com.solegendary.reignofnether.bot.ml.OnlineLearningManager;
import com.solegendary.reignofnether.bot.ml.PlayerAction;
import com.solegendary.reignofnether.bot.ml.PlayerBehaviorAnalyzer;
import com.solegendary.reignofnether.bot.ml.TrainingDataManager;
import java.util.List;
import java.util.Map;

public class MLFramework {
    private static MLFramework instance;
    private boolean initialized = false;
    private boolean mlEnabled = true;
    private GameStateVectorizer vectorizer;
    private NeuralNetworkManager networkManager;
    private MockNeuralNetworkManager mockNetworkManager;
    private boolean usingMockNetwork = false;
    private TrainingDataManager dataManager;
    private LearningPipeline learningPipeline;
    private AdaptiveDifficultyManager difficultyManager;
    private OnlineLearningManager onlineLearningManager;
    private PlayerBehaviorAnalyzer behaviorAnalyzer;
    private DataCollectionManager dataCollectionManager;

    private MLFramework() {
    }

    public static MLFramework getInstance() {
        if (instance == null) {
            instance = new MLFramework();
        }
        return instance;
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        ReignOfNether.LOGGER.info("Initializing ML framework for adaptive AI...");
        try {
            this.vectorizer = new GameStateVectorizer();
            this.dataManager = new TrainingDataManager();
            this.difficultyManager = new AdaptiveDifficultyManager();
            this.behaviorAnalyzer = new PlayerBehaviorAnalyzer();
            this.dataCollectionManager = new DataCollectionManager();
            try {
                ReignOfNether.LOGGER.debug("Attempting to initialize DeepLearning4J neural networks...");
                this.networkManager = new NeuralNetworkManager();
                this.networkManager.initialize();
                this.usingMockNetwork = false;
                ReignOfNether.LOGGER.info("DeepLearning4J neural networks initialized successfully");
            }
            catch (Exception neuralException) {
                ReignOfNether.LOGGER.warn("Failed to initialize DeepLearning4J neural networks: {}", (Object)neuralException.getMessage());
                ReignOfNether.LOGGER.info("Falling back to mock neural network manager (rule-based decisions)");
                this.mockNetworkManager = new MockNeuralNetworkManager();
                this.mockNetworkManager.initialize();
                this.networkManager = null;
                this.usingMockNetwork = true;
                ReignOfNether.LOGGER.info("Mock neural network manager initialized successfully");
            }
            this.onlineLearningManager = new OnlineLearningManager();
            this.learningPipeline = new LearningPipeline();
            this.dataManager.initialize();
            this.dataCollectionManager.initialize(this.behaviorAnalyzer, this.dataManager);
            if (!this.usingMockNetwork) {
                this.onlineLearningManager.initialize(this.networkManager, this.dataManager, this.difficultyManager);
                this.learningPipeline.initialize(this.networkManager, this.dataManager);
            } else {
                ReignOfNether.LOGGER.info("Skipping OnlineLearningManager and LearningPipeline initialization (using mock network)");
            }
            this.initialized = true;
            this.mlEnabled = true;
            String networkType = this.usingMockNetwork ? "mock (rule-based)" : "DeepLearning4J";
            ReignOfNether.LOGGER.info("ML framework initialized successfully with {} neural networks", (Object)networkType);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Failed to initialize ML framework completely: {}", (Object)e.getMessage());
            ReignOfNether.LOGGER.error("ML framework initialization error details: ", (Throwable)e);
            this.mlEnabled = false;
            this.initialized = false;
            ReignOfNether.LOGGER.info("ML framework disabled - AI bots will use basic rule-based decision making only");
        }
    }

    public void shutdown() {
        if (!this.initialized) {
            return;
        }
        try {
            ReignOfNether.LOGGER.info("Shutting down ML framework...");
            if (this.usingMockNetwork && this.mockNetworkManager != null) {
                this.mockNetworkManager.saveAllModels();
            } else if (this.networkManager != null) {
                this.networkManager.saveAllModels();
            }
            if (this.dataManager != null) {
                this.dataManager.saveData();
            }
            if (this.learningPipeline != null) {
                this.learningPipeline.shutdown();
            }
            if (this.onlineLearningManager != null) {
                this.onlineLearningManager.shutdown();
            }
            if (this.dataCollectionManager != null) {
                this.dataCollectionManager.shutdown();
            }
            this.initialized = false;
            ReignOfNether.LOGGER.info("ML framework shutdown complete");
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error during ML framework shutdown: {}", (Object)e.getMessage());
        }
    }

    public boolean isReady() {
        return this.initialized && this.mlEnabled;
    }

    public void setMLEnabled(boolean enabled) {
        this.mlEnabled = enabled;
        ReignOfNether.LOGGER.info("ML framework {}", (Object)(enabled ? "enabled" : "disabled"));
    }

    public MLDecision getStrategicDecision(GameState gameState, String botName) {
        if (!this.isReady()) {
            return null;
        }
        try {
            double[] stateVector = this.vectorizer.vectorizeGameState(gameState);
            MLDecision decision = this.usingMockNetwork ? this.mockNetworkManager.predictDecision(stateVector, botName) : this.networkManager.predictDecision(stateVector, botName);
            this.dataManager.recordDecision(gameState, decision, botName);
            return decision;
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error getting ML decision for bot '{}': {}", (Object)botName, (Object)e.getMessage());
            return null;
        }
    }

    public void recordGameOutcome(String playerName, String botName, boolean playerWon, GameMetrics metrics) {
        if (!this.isReady()) {
            return;
        }
        try {
            this.dataManager.recordGameOutcome(botName, !playerWon, metrics);
            this.difficultyManager.recordGameOutcome(playerName, botName, playerWon, metrics);
            if (this.dataManager.shouldTriggerLearning() && this.learningPipeline != null) {
                this.learningPipeline.triggerTraining();
            }
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error recording game outcome for bot '{}': {}", (Object)botName, (Object)e.getMessage());
        }
    }

    public void recordHumanAction(GameState gameState, PlayerAction action, String playerName) {
        if (!this.isReady()) {
            return;
        }
        try {
            this.dataManager.recordHumanAction(gameState, action, playerName);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error recording human action for player '{}': {}", (Object)playerName, (Object)e.getMessage());
        }
    }

    public void recordDecisionOutcome(String botName, GameState gameState, MLDecision decision, double actualOutcome, String outcomeContext) {
        if (!this.isReady()) {
            return;
        }
        try {
            if (this.onlineLearningManager != null) {
                this.onlineLearningManager.queueOnlineLearning(botName, gameState, decision, actualOutcome, outcomeContext);
            }
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error recording decision outcome for bot '{}': {}", (Object)botName, (Object)e.getMessage());
        }
    }

    public AdaptiveDifficultyManager.DifficultyAdjustment getDifficultyAdjustment(String playerName, String botName) {
        if (!this.isReady()) {
            return null;
        }
        return this.difficultyManager.getDifficultyAdjustment(playerName, botName);
    }

    public void setOnlineLearningEnabled(boolean enabled) {
        if (this.onlineLearningManager != null) {
            this.onlineLearningManager.setOnlineLearningEnabled(enabled);
        }
    }

    public void startGameSession(String sessionId, List<String> playerNames, List<String> botNames, String gameMode, Map<String, String> gameParameters) {
        if (!this.isReady()) {
            return;
        }
        try {
            this.dataCollectionManager.startGameSession(sessionId, playerNames, botNames, gameMode, gameParameters);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error starting game session '{}': {}", (Object)sessionId, (Object)e.getMessage());
        }
    }

    public void recordPlayerAction(String sessionId, String playerName, GameState gameState, PlayerAction action, PlayerBehaviorAnalyzer.ActionOutcome outcome) {
        if (!this.isReady()) {
            return;
        }
        try {
            this.dataCollectionManager.recordPlayerAction(sessionId, playerName, gameState, action, outcome);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error recording player action: {}", (Object)e.getMessage());
        }
    }

    public void recordBotDecision(String sessionId, String botName, GameState gameState, MLDecision decision, double actualOutcome, String outcomeContext) {
        if (!this.isReady()) {
            return;
        }
        try {
            this.dataCollectionManager.recordBotDecision(sessionId, botName, gameState, decision, actualOutcome, outcomeContext);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error recording bot decision: {}", (Object)e.getMessage());
        }
    }

    public void endGameSession(String sessionId, Map<String, Boolean> playerResults, GameMetrics gameMetrics, String endReason) {
        if (!this.isReady()) {
            return;
        }
        try {
            this.dataCollectionManager.endGameSession(sessionId, playerResults, gameMetrics, endReason);
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error ending game session '{}': {}", (Object)sessionId, (Object)e.getMessage());
        }
    }

    public PlayerBehaviorAnalyzer.BehaviorAnalysis getPlayerBehaviorAnalysis(String playerName) {
        if (!this.isReady()) {
            return null;
        }
        return this.behaviorAnalyzer.analyzeBehavior(playerName);
    }

    public DataCollectionManager.DataCollectionStatistics getDataCollectionStatistics() {
        if (!this.isReady()) {
            return null;
        }
        return this.dataCollectionManager.getStatistics();
    }

    public void setDataCollectionEnabled(boolean enabled) {
        if (this.dataCollectionManager != null) {
            this.dataCollectionManager.setCollectionEnabled(enabled);
        }
    }

    public String getPerformanceStats(String playerName, String botName) {
        if (!this.isReady()) {
            return "ML Framework not initialized";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("ML Framework Performance Report:\n");
        sb.append(this.difficultyManager.getPerformanceStats(playerName, botName)).append("\n");
        if (this.onlineLearningManager != null) {
            sb.append(this.onlineLearningManager.getComprehensiveStats()).append("\n");
        } else {
            sb.append("Online Learning: Disabled (using mock network)\n");
        }
        sb.append(this.dataCollectionManager.getStatistics().toString()).append("\n");
        sb.append(this.getStatistics().toString());
        return sb.toString();
    }

    public MLStatistics getStatistics() {
        double averageAccuracy;
        int trainingIterations;
        if (!this.isReady()) {
            return new MLStatistics(false, 0, 0, 0, 0.0);
        }
        if (this.usingMockNetwork) {
            trainingIterations = this.mockNetworkManager.getTrainingIterations();
            averageAccuracy = this.mockNetworkManager.getAverageAccuracy();
        } else {
            trainingIterations = this.networkManager.getTrainingIterations();
            averageAccuracy = this.networkManager.getAverageAccuracy();
        }
        return new MLStatistics(true, this.dataManager.getTrainingExamples(), this.dataManager.getGameCount(), trainingIterations, averageAccuracy);
    }

    GameStateVectorizer getVectorizer() {
        return this.vectorizer;
    }

    NeuralNetworkManager getNetworkManager() {
        return this.networkManager;
    }

    MockNeuralNetworkManager getMockNetworkManager() {
        return this.mockNetworkManager;
    }

    boolean isUsingMockNetwork() {
        return this.usingMockNetwork;
    }

    TrainingDataManager getDataManager() {
        return this.dataManager;
    }

    LearningPipeline getLearningPipeline() {
        return this.learningPipeline;
    }

    AdaptiveDifficultyManager getDifficultyManager() {
        return this.difficultyManager;
    }

    OnlineLearningManager getOnlineLearningManager() {
        return this.onlineLearningManager;
    }

    PlayerBehaviorAnalyzer getBehaviorAnalyzer() {
        return this.behaviorAnalyzer;
    }

    DataCollectionManager getDataCollectionManager() {
        return this.dataCollectionManager;
    }

    public static class MLStatistics {
        public final boolean enabled;
        public final int trainingExamples;
        public final int gamesAnalyzed;
        public final int trainingIterations;
        public final double averageAccuracy;

        public MLStatistics(boolean enabled, int trainingExamples, int gamesAnalyzed, int trainingIterations, double averageAccuracy) {
            this.enabled = enabled;
            this.trainingExamples = trainingExamples;
            this.gamesAnalyzed = gamesAnalyzed;
            this.trainingIterations = trainingIterations;
            this.averageAccuracy = averageAccuracy;
        }

        public String toString() {
            if (!this.enabled) {
                return "ML Framework: Disabled";
            }
            return String.format("ML Framework: %d training examples, %d games analyzed, %d iterations, %.2f%% accuracy", this.trainingExamples, this.gamesAnalyzed, this.trainingIterations, this.averageAccuracy * 100.0);
        }
    }
}

