/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.bot.ml;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.bot.ml.MLDecision;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nd4j.linalg.dataset.DataSet;

public class MockNeuralNetworkManager {
    private final Map<String, Integer> botTrainingCounts = new ConcurrentHashMap<String, Integer>();
    private boolean initialized = false;

    public void initialize() {
        try {
            ReignOfNether.LOGGER.info("Initializing Mock Neural Network Manager (rule-based fallback)...");
            this.initialized = true;
            ReignOfNether.LOGGER.info("Mock Neural Network Manager initialized successfully");
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Failed to initialize Mock Neural Network Manager: {}", (Object)e.getMessage());
            throw new RuntimeException("Mock neural network initialization failed", e);
        }
    }

    public MLDecision predictDecision(double[] stateVector, String botName) {
        if (!this.initialized) {
            return new MLDecision(MLDecision.DecisionType.FALLBACK_TO_RULES, 0.0);
        }
        try {
            double confidence;
            MLDecision.DecisionType decisionType;
            double threatLevel;
            double foodRatio = stateVector.length > 0 ? stateVector[0] : 0.5;
            double woodRatio = stateVector.length > 1 ? stateVector[1] : 0.5;
            double oreRatio = stateVector.length > 2 ? stateVector[2] : 0.5;
            double workerRatio = stateVector.length > 8 ? stateVector[8] : 0.3;
            double militaryRatio = stateVector.length > 9 ? stateVector[9] : 0.3;
            double d = threatLevel = stateVector.length > 32 ? stateVector[32] : 0.3;
            if (threatLevel > 0.7) {
                decisionType = militaryRatio < 0.4 ? MLDecision.DecisionType.PRODUCE_MILITARY_UNITS : MLDecision.DecisionType.DEFEND_BASE;
                confidence = 0.8;
            } else if (workerRatio < 0.3) {
                decisionType = MLDecision.DecisionType.PRODUCE_WORKERS;
                confidence = 0.7;
            } else if (foodRatio < 0.3 || woodRatio < 0.3 || oreRatio < 0.3) {
                decisionType = MLDecision.DecisionType.FOCUS_ON_ECONOMY;
                confidence = 0.6;
            } else if (militaryRatio < 0.5) {
                decisionType = MLDecision.DecisionType.FOCUS_ON_MILITARY;
                confidence = 0.5;
            } else {
                decisionType = MLDecision.DecisionType.FOCUS_ON_ECONOMY;
                confidence = 0.4;
            }
            if (Math.random() < 0.2) {
                MLDecision.DecisionType[] alternatives = new MLDecision.DecisionType[]{MLDecision.DecisionType.RESEARCH_TECHNOLOGY, MLDecision.DecisionType.EXPAND_TERRITORY, MLDecision.DecisionType.BUILD_ECONOMIC_BUILDINGS};
                decisionType = alternatives[(int)(Math.random() * (double)alternatives.length)];
                confidence = 0.3 + Math.random() * 0.3;
            }
            return new MLDecision(decisionType, confidence, this.extractMockParameters(), "Mock neural network (rule-based)");
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Error making mock ML prediction for bot '{}': {}", (Object)botName, (Object)e.getMessage());
            return new MLDecision(MLDecision.DecisionType.FALLBACK_TO_RULES, 0.0);
        }
    }

    public void trainNetwork(String botName, DataSet trainingData) {
        if (!this.initialized) {
            return;
        }
        this.botTrainingCounts.merge(botName, 1, Integer::sum);
        if (this.botTrainingCounts.get(botName) % 10 == 0) {
            ReignOfNether.LOGGER.debug("Mock training for bot '{}': {} sessions completed", (Object)botName, (Object)this.botTrainingCounts.get(botName));
        }
    }

    public void performOnlineTraining(String botName, DataSet onlineData, double adaptiveLearningRate) {
        if (!this.initialized) {
            return;
        }
        this.botTrainingCounts.merge(botName, 1, Integer::sum);
        ReignOfNether.LOGGER.debug("Mock online training for bot '{}' with learning rate {:.4f}", (Object)botName, (Object)adaptiveLearningRate);
    }

    public void saveAllModels() {
        if (!this.initialized) {
            return;
        }
        ReignOfNether.LOGGER.debug("Mock saving {} bot models", (Object)this.botTrainingCounts.size());
    }

    public int getTrainingIterations() {
        return this.botTrainingCounts.values().stream().mapToInt(Integer::intValue).sum();
    }

    public double getAverageAccuracy() {
        return 0.6 + Math.random() * 0.2;
    }

    public int getActiveNetworkCount() {
        return this.botTrainingCounts.size();
    }

    public void resetBotNetwork(String botName) {
        this.botTrainingCounts.remove(botName);
        ReignOfNether.LOGGER.info("Reset mock neural network for bot '{}'", (Object)botName);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private Map<String, Double> extractMockParameters() {
        ConcurrentHashMap<String, Double> parameters = new ConcurrentHashMap<String, Double>();
        for (MLDecision.DecisionType type : MLDecision.DecisionType.values()) {
            parameters.put(type.name() + "_confidence", Math.random() * 0.5);
        }
        parameters.put("decision_entropy", Math.random() * 2.0);
        return parameters;
    }
}

