/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.ReignOfNether;
import com.solegendary.reignofnether.building.BuildingBlock;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class BuildingBlockData {
    public static ArrayList<BuildingBlock> getBuildingBlocksFromNbt(String structureName, LevelAccessor level) {
        Minecraft mc;
        IntegratedServer integrated;
        ResourceManager resourceManager = level.m_5776_() ? ((integrated = (mc = Minecraft.m_91087_()).m_91092_()) != null ? integrated.m_177941_() : mc.m_91098_()) : level.m_7654_().m_177941_();
        CompoundTag nbt = null;
        try {
            ResourceLocation id;
            ResourceLocation resourceLocation = id = structureName.contains(":") ? ResourceLocation.m_135820_((String)structureName) : new ResourceLocation("reignofnether", structureName);
            if (id != null) {
                if (level instanceof ServerLevel) {
                    ServerLevel sLevel = (ServerLevel)level;
                    StructureTemplateManager stm = sLevel.m_215082_();
                    Optional opt = stm.m_230407_(id);
                    if (opt.isPresent()) {
                        nbt = ((StructureTemplate)opt.get()).m_74618_(new CompoundTag());
                    }
                } else {
                    StructureTemplateManager stm;
                    Optional opt;
                    Minecraft mc2 = Minecraft.m_91087_();
                    IntegratedServer integrated2 = mc2.m_91092_();
                    if (integrated2 != null && (opt = (stm = integrated2.m_236738_()).m_230407_(id)).isPresent()) {
                        nbt = ((StructureTemplate)opt.get()).m_74618_(new CompoundTag());
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (nbt == null) {
            nbt = BuildingBlockData.getBuildingNbt(structureName, resourceManager);
        }
        if (nbt == null) {
            ReignOfNether.LOGGER.error("Structure '{}' could not be loaded from datapacks. Building will not be placed.", (Object)structureName);
            return new ArrayList<BuildingBlock>();
        }
        return BuildingBlockData.getBuildingBlocksFromNbt(nbt, level);
    }

    public static ArrayList<BuildingBlock> getBuildingBlocksFromNbt(CompoundTag nbt) {
        ArrayList<BuildingBlock> blocks = new ArrayList<BuildingBlock>();
        ListTag blocksNbt = nbt.m_128437_("blocks", 10);
        ArrayList<BlockState> palette = BuildingBlockData.getBuildingPalette(nbt);
        for (int i = 0; i < blocksNbt.size(); ++i) {
            CompoundTag blockNbt = blocksNbt.m_128728_(i);
            ListTag blockPosNbt = blockNbt.m_128437_("pos", 3);
            BlockPos bp = new BlockPos(blockPosNbt.m_128763_(0), blockPosNbt.m_128763_(1), blockPosNbt.m_128763_(2));
            BlockState bs = palette.get(blockNbt.m_128451_("state"));
            if (bs.m_60734_() == Blocks.f_49990_ && !bs.m_60819_().m_76170_()) continue;
            blocks.add(new BuildingBlock(bp, bs));
        }
        return blocks;
    }

    public static ArrayList<BuildingBlock> getBuildingBlocksFromNbt(CompoundTag nbt, LevelAccessor level) {
        ArrayList<BuildingBlock> blocks = new ArrayList<BuildingBlock>();
        ListTag blocksNbt = nbt.m_128437_("blocks", 10);
        ArrayList<BlockState> palette = BuildingBlockData.getBuildingPalette(nbt, level);
        for (int i = 0; i < blocksNbt.size(); ++i) {
            CompoundTag blockNbt = blocksNbt.m_128728_(i);
            ListTag blockPosNbt = blockNbt.m_128437_("pos", 3);
            BlockPos bp = new BlockPos(blockPosNbt.m_128763_(0), blockPosNbt.m_128763_(1), blockPosNbt.m_128763_(2));
            BlockState bs = palette.get(blockNbt.m_128451_("state"));
            if (bs.m_60734_() == Blocks.f_49990_ && !bs.m_60819_().m_76170_()) continue;
            blocks.add(new BuildingBlock(bp, bs));
        }
        return blocks;
    }

    public static ArrayList<BuildingBlock> getBuildingBlocksFromWorld(Level level, BlockPos originPos, BlockPos structurePos, Vec3i structureSize) {
        ArrayList<BuildingBlock> blocks = new ArrayList<BuildingBlock>();
        IntStream.range(originPos.m_123341_() + structurePos.m_123341_(), originPos.m_123341_() + structurePos.m_123341_() + structureSize.m_123341_()).forEachOrdered(x -> IntStream.range(originPos.m_123342_() + structurePos.m_123342_(), originPos.m_123342_() + structurePos.m_123342_() + structureSize.m_123342_()).forEachOrdered(y -> IntStream.range(originPos.m_123343_() + structurePos.m_123343_(), originPos.m_123343_() + structurePos.m_123343_() + structureSize.m_123343_()).forEachOrdered(z -> {
            BlockPos bp = new BlockPos(x, y, z);
            BlockState bs = level.m_8055_(bp);
            if (bs.m_60734_() != Blocks.f_49990_ || bs.m_60819_().m_76170_()) {
                blocks.add(new BuildingBlock(bp, bs));
            }
        })));
        return blocks;
    }

    public static CompoundTag getBuildingNbt(String structureName, ResourceManager resManager) {
        try {
            ResourceLocation id;
            ResourceLocation resourceLocation = id = structureName.contains(":") ? ResourceLocation.m_135820_((String)structureName) : new ResourceLocation("reignofnether", structureName);
            if (id == null) {
                ReignOfNether.LOGGER.error("Invalid structure name '{}'", (Object)structureName);
                return null;
            }
            ResourceLocation rl = new ResourceLocation(id.m_135827_(), "structures/" + id.m_135815_() + ".nbt");
            Optional rs = resManager.m_213713_(rl);
            if (rs.isEmpty()) {
                ReignOfNether.LOGGER.error("Structure NBT not found at {}. Ensure the file exists at data/{}/structures/{}.nbt in an active datapack.", (Object)rl, (Object)id.m_135827_(), (Object)id.m_135815_());
                return null;
            }
            return NbtIo.m_128939_((InputStream)((Resource)rs.get()).m_215507_());
        }
        catch (Exception e) {
            ReignOfNether.LOGGER.error("Failed reading structure NBT '{}': {}", (Object)structureName, (Object)e.toString());
            return null;
        }
    }

    public static ArrayList<BlockState> getBuildingPalette(CompoundTag nbt) {
        ArrayList<BlockState> palette = new ArrayList<BlockState>();
        ListTag paletteNbt = nbt.m_128437_("palette", 10);
        HolderLookup.RegistryLookup lookup = BuiltInRegistries.f_256975_.m_255303_();
        for (int i = 0; i < paletteNbt.size(); ++i) {
            palette.add(NbtUtils.m_247651_((HolderGetter)lookup, (CompoundTag)paletteNbt.m_128728_(i)));
        }
        return palette;
    }

    public static ArrayList<BlockState> getBuildingPalette(CompoundTag nbt, LevelAccessor level) {
        HolderLookup.RegistryLookup lookup;
        ArrayList<BlockState> palette = new ArrayList<BlockState>();
        ListTag paletteNbt = nbt.m_128437_("palette", 10);
        if (level instanceof Level) {
            Level lvl = (Level)level;
            lookup = lvl.m_9598_().m_255025_(Registries.f_256747_);
        } else {
            lookup = BuiltInRegistries.f_256975_.m_255303_();
        }
        for (int i = 0; i < paletteNbt.size(); ++i) {
            palette.add(NbtUtils.m_247651_((HolderGetter)lookup, (CompoundTag)paletteNbt.m_128728_(i)));
        }
        return palette;
    }

    public static BuildingBlock getBuildingBlockByPos(ArrayList<BuildingBlock> blocks, BlockPos bp) {
        List<BuildingBlock> results = blocks.stream().filter(b -> b.getBlockPos().equals((Object)bp)).toList();
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }
}

