/*
 * Decompiled with CFR 0.152.
 */
package com.solegendary.reignofnether.building;

import com.solegendary.reignofnether.building.Building;
import com.solegendary.reignofnether.building.BuildingProperties;
import com.solegendary.reignofnether.faction.FactionType;
import com.solegendary.reignofnether.resources.ResourceCost;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public class BuildingType<T extends Building> {
    private final ResourceLocation id;
    private final String displayName;
    private final Supplier<T> buildingSupplier;
    private final FactionType faction;
    private final ResourceCost cost;
    private final BuildingProperties properties;
    private final Class<T> buildingClass;
    private final int uiOrder;
    private final String uiHotkey;

    public BuildingType(ResourceLocation id, String displayName, Supplier<T> buildingSupplier, FactionType faction, ResourceCost cost, BuildingProperties properties, Class<T> buildingClass) {
        this.id = id;
        this.displayName = displayName;
        this.buildingSupplier = buildingSupplier;
        this.faction = faction;
        this.cost = cost;
        this.properties = properties != null ? properties : BuildingProperties.defaultProperties();
        this.buildingClass = buildingClass;
        this.uiOrder = Integer.MAX_VALUE;
        this.uiHotkey = null;
    }

    public BuildingType(ResourceLocation id, String displayName, Supplier<T> buildingSupplier, FactionType faction, ResourceCost cost, Class<T> buildingClass) {
        this(id, displayName, buildingSupplier, faction, cost, BuildingProperties.defaultProperties(), buildingClass);
    }

    public BuildingType(ResourceLocation id, String displayName, Supplier<T> buildingSupplier, FactionType faction, ResourceCost cost, BuildingProperties properties, Class<T> buildingClass, int uiOrder, String uiHotkey) {
        this.id = id;
        this.displayName = displayName;
        this.buildingSupplier = buildingSupplier;
        this.faction = faction;
        this.cost = cost;
        this.properties = properties != null ? properties : BuildingProperties.defaultProperties();
        this.buildingClass = buildingClass;
        this.uiOrder = uiOrder;
        this.uiHotkey = uiHotkey != null && !uiHotkey.isBlank() ? uiHotkey.toUpperCase() : null;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public T createBuilding() {
        return (T)((Building)this.buildingSupplier.get());
    }

    public FactionType getFaction() {
        return this.faction;
    }

    public ResourceCost getCost() {
        return this.cost;
    }

    public BuildingProperties getProperties() {
        return this.properties;
    }

    public Class<T> getBuildingClass() {
        return this.buildingClass;
    }

    public int getUiOrder() {
        return this.uiOrder;
    }

    public String getUiHotkey() {
        return this.uiHotkey;
    }

    public boolean matches(Building building) {
        return this.buildingClass.isInstance(building);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BuildingType that = (BuildingType)obj;
        return Objects.equals(this.id, that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "BuildingType{id=" + String.valueOf(this.id) + ", displayName='" + this.displayName + "', faction=" + (this.faction != null ? this.faction.getDisplayName() : "null") + "}";
    }
}

